/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui.deploywizard;

import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.compliance.ui.deploywizard.DeployWizardStateBean;
import com.mcafee.epo.compliance.ui.util.EpoHostList;
import com.mcafee.epo.compliance.ui.util.SubnetInfo;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.util.BeanUtil;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MarkHostsBean
extends ActionBeanBase {
    private DeployWizardStateBean m_state;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        this.m_state = (DeployWizardStateBean)httpServletRequest.getSession().getAttribute("deployWizBean");
        if (this.m_state != null) {
            BeanUtil.initBean((HttpServletRequest)httpServletRequest, (Object)this.m_state);
        }
        if (this.m_state == null) {
            String string = Resource.getString("deploysensorsbean_no_state_bean", this.m_lang);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_action_failed", this.m_lang), (String)string, (String)"displaysubnets.do");
            return "actiontaken.jsp";
        }
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        Integer n = this.m_state.getSensorDeploySubnetDetailsIndex();
        if (n == null || n <= -1) {
            throw new InvalidParameterException("Error: MarkHostsBean - missing subnet index.");
        }
        if (SessionUtil.atLeastOneStartsWith((HttpServletRequest)httpServletRequest, (String)"machineId")) {
            return null;
        }
        String string2 = Resource.getString("markhostsbean_missing_selection", string);
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", string), (String)string2, (String)"displaysensordeploydetails.do");
        return "actiontaken.jsp";
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = this.m_state.getSensorDeploySubnetDetailsIndex();
        EpoHostList epoHostList = this.m_state.getHostList();
        SubnetInfo subnetInfo = epoHostList.getAt(n);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("machineId") != 0) continue;
            string = string.substring("machineId".length(), string.length());
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1, string.length());
            subnetInfo.addHost(string2, string3);
        }
        return "deploywizard.do";
    }
}

