/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.util.thread;

public abstract class WorkerThread
implements Runnable {
    private Thread m_thread = null;
    private boolean m_bShouldStop = false;
    private long m_threadSleepTime = 0L;

    protected abstract String threadName();

    protected abstract void doTask();

    public void setSleepTime(long l) {
        this.m_threadSleepTime = l;
    }

    public synchronized void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, this.threadName());
            this.m_thread.setDaemon(true);
            this.m_bShouldStop = false;
            this.m_thread.start();
        }
    }

    public void stop(boolean bl) {
        block3: {
            Thread thread = this.m_thread;
            if (thread == null) break block3;
            this.m_bShouldStop = true;
            thread.interrupt();
            if (bl) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void run() {
        while (!this.m_bShouldStop) {
            try {
                this.doTask();
                if (this.m_threadSleepTime <= 0L) continue;
                Thread.sleep(this.m_threadSleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyThreadDeath();
    }

    public void stop() {
        this.stop(true);
    }

    public void wakeupThread() {
        this.m_thread.interrupt();
    }

    private void notifyThreadDeath() {
        this.m_thread = null;
    }
}

