var SECTION_SCHEDULE			= "Schedule";
var SECTION_SETTINGS			= "Settings";

// Common schedule settings
var START_DATE_TIME				= "StartDateTime";
var STOP_DATE_TIME				= "StopDateTime";
var STOP_DATE_VALID				= "StopDateValid";
var TASK_REPEATABLE				= "TaskRepeatable";
var REPEAT_OPTION				= "RepeatOption";
var REPEAT_INTERVAL				= "RepeatInterval";
var UNTIL_OPTION				= "UntilOption";
var UNTIL_TIME					= "UntilTime";
var UNTIL_DURATION				= "UntilDuration";
var START_TIME_AMPM				= "StartTimeAMPM";
var GMT_TIME					= "GMTTime";
var RANDOMIZATION_ENABLED		= "RandomizationEnabled";
var RANDOMIZATION_WND_MINS		= "RandomizationWndMins";
var RUN_IF_MISSED				= "RunIfMissed";
var RUN_IF_MISSED_DELAY_MINS		= "RunIfMissedDelayMins";
var STOP_AFTER_MINS				= "StopAfterMinutes";

var TASK_TYPE					= "Type";
var TASK_ENABLED				= "Enabled";

// Hourly
var REPEAT_HOURS				= "RepeatHours";

// Daily
var REPEAT_DAYS					= "RepeatDays";

// Weekly
var REPEAT_WEEKS				= "RepeatWeeks";
var MASK_DAYS_OF_WEEK			= "MaskDaysOfWeek";

// Monthly
var MONTH_OPTION				= "MonthOption";
var DAY_NUM_OF_MONTH			= "DayNumOfMonth";
var WEEK_NUM_OF_MONTH			= "WeekNumOfMonth";
var DAY_OF_WEEK					= "DayOfWeek";
var MASK_MONTHS_OF_YEAR			= "MaskMonthsOfYear";

// Once
var ONCE_EVERY_NUM_OF_DAYS		= "OnceEveryNumOfDays";


// Schedule type values
var TASK_TYPE_DAILY			= "0";
var TASK_TYPE_WEEKLY		= "1";
var TASK_TYPE_MONTHLY		= "2";
var TASK_TYPE_ONCE			= "3";
var TASK_TYPE_IMMEDIATELY	= "7";
var TASK_TYPE_HOURLY		= "9";

var g_bLastStopTaskValue	= false;


function enableField(fld)
{
	fld.className			= "clsInputText";
	fld.disabled			= false;
}

function disableField(fld)
{
	fld.className			= "clsInputTextDisabled";
	fld.disabled			= true;
}

function fnLoadResources()
{
	btnNext.szCaption						= nrc_sz_TaskSave;
	btnCancel.szCaption						= nrc_sz_TaskCancel;
	btnHelp.szCaption						= nrc_sz_TaskHelp;

	labelID_TaskSettings.innerHTML			= nrc_sz_TaskSettings;
	labelID_AdditionalSettings.innerHTML	= nrc_sz_AdditionalSettings;
	labelID_TaskName.innerHTML				= nrc_sz_TaskName;
	labelID_TaskType.innerHTML				= nrc_sz_TaskType;

	lableID_EnableYes.innerHTML				= nrc_sz_Yes;
	lableID_EnableNo.innerHTML				= nrc_sz_No;
	
	labelID_TaskEnable.innerHTML			= nrc_sz_TaskEnable;
	
	labelID_ScheduleType.innerHTML			= nrc_sz_ScheduleType;
	
	labelID_StartTime.innerText				= nrc_sz_StartTime;
	labelID_StartDate.innerText				= nrc_sz_StartDate;
	labelID_StopTime.innerText				= nrc_sz_StopTime;
	labelID_StopDate.innerText				= nrc_sz_StopDate;
	
	labelID_RunMissedTask.innerHTML			= nrc_sz_RunMissedTask;
	labelID_DelayMissedTaskBy.innerHTML		= nrc_sz_DelayMissedTaskBy;
	
	labelID_RunMissedMinutes.innerHTML		= nrc_sz_Minutes;
	
	labelID_StopHours.innerHTML				= nrc_sz_Hours;
	labelID_StopMinutes.innerHTML			= nrc_sz_Minutes;
	
	labelID_StopTask.innerHTML				= nrc_sz_StopTask;
	
	// Load schedule type names.
	ScheduleType.options[0]					= new Option(nrc_sz_TaskTypeHourly,			TASK_TYPE_HOURLY);
	ScheduleType.options[1]					= new Option(nrc_sz_TaskTypeDaily,			TASK_TYPE_DAILY);
	ScheduleType.options[2]					= new Option(nrc_sz_TaskTypeWeekly,			TASK_TYPE_WEEKLY);
	ScheduleType.options[3]					= new Option(nrc_sz_TaskTypeMonthly,		TASK_TYPE_MONTHLY);
	ScheduleType.options[4]					= new Option(nrc_sz_TaskTypeOnce,			TASK_TYPE_ONCE);
	ScheduleType.options[5]					= new Option(nrc_sz_TaskTypeImmediately,	TASK_TYPE_IMMEDIATELY);
	
	labelID_HourlyEvery.innerHTML			= nrc_sz_HourlyEvery;
	labelID_HourlyHours.innerHTML			= nrc_sz_HourlyHours;
	
	labelID_DailyEvery.innerHTML			= nrc_sz_DailyEvery;
	labelID_DailyDays.innerHTML				= nrc_sz_DailyDays;
	
	labelID_WeeklyEvery.innerHTML			= nrc_sz_WeeklyEvery;
	labelID_WeeklyWeeksOn.innerHTML			= nrc_sz_WeeklyWeeksOn;
	
	labelID_MonthlyDayOfMonth.innerHTML		= nrc_sz_MonthlyDayOfMonth;
	labelID_MonthlyWeekdayOfMonth.innerHTML	= nrc_sz_MonthlyWeekdayOfMonth;
	labelID_MonthlyExtraString.innerHTML	= nrc_sz_MonthlyExtraString;
	
	labelID_RunImmediateInfo.innerHTML		= nrc_sz_ImmediateInfo;
	
	// Generate month name checkboxes
	spanID_MonthCheckboxes.innerHTML		= fnMakeMonthNameCheckboxes();
	
	// Generate day name checkboxes
	spanID_DayCheckboxes.innerHTML			= fnMakeDayNameCheckboxes();
	
	// load the monthly "day of the week" drop down
	for (var i = 0; i < nrc_DayNames.length; i++)
	{
		Monthly_DayOfTheWeek.options[i]		= new Option(nrc_DayNames[i], (i+1).toString());
	}
	
	Monthly_WeekOfTheMonth.options[0]		= new Option(nrc_sz_MonthlyFirst, "1");
	Monthly_WeekOfTheMonth.options[1]		= new Option(nrc_sz_MonthlySecond, "2");
	Monthly_WeekOfTheMonth.options[2]		= new Option(nrc_sz_MonthlyThird, "3");
	Monthly_WeekOfTheMonth.options[3]		= new Option(nrc_sz_MonthlyFourth, "4");
	Monthly_WeekOfTheMonth.options[4]		= new Option(nrc_sz_MonthlyLast, "5");
}

function TaskEdit_OnLoad()
{
	fnLoadResources();
	
	var nMask = 0;
	var strTemp;
	
	g_nTaskID = window.external.Task_GetID();
	
	window.external.Task_WriteTaskTypes( document, TaskType );
	
	if ( g_nTaskID == 0 )
	{	
		
		/// Set appropriate Title
		labelID_Title.innerHTML = nrc_sz_NewTask;
	
		// Set initial states for the various controls
		fnSetRunMissedUIState(true);
		fnSetStopMissedTaskUIState(true);
		fnToggleStopDate(true);
		fnMonthlyOptionClick();
		
		if( window.external.Task_GetReload() )
		{
			TaskEdit_LoadSetting();
		}
		else
		{
			displayOption(TASK_TYPE_HOURLY);
		}
	}
	else 
	{
		/// Set appropriate Title
		labelID_Title.innerHTML = nrc_sz_ModifyTask;
		TaskEdit_LoadSetting();
	}
	
	TaskName.focus();
}


function TaskEdit_LoadSetting()
{
	var strTemp		= "";
	var oDateTime	= new fnCreateDateTimeObject();

	// Task name and type
	TaskName.value	= window.external.Task_GetName();
	TaskType.value	= window.external.Task_GetType();
	
	// block the user from changing the task type of existing tasks
	if( g_nTaskID != 0 )
		TaskType.disabled = true;
		
	if (window.external.Task_GetEnabled() == 1)
		EnableTask[0].checked = true;
	else
		EnableTask[1].checked = true;
	

	// START DATE/TIME
	
	var szTemp = window.external.Task_GetValue(SECTION_SCHEDULE, START_DATE_TIME);
	
	fnUnFormatDateTime(szTemp, oDateTime);
	
	htcID_StartDate.month		= oDateTime.szMonth;
	htcID_StartDate.day			= oDateTime.szDay;
	htcID_StartDate.year		= oDateTime.szYear;
	
	htcID_StartTime.hours		= oDateTime.szHours;
	htcID_StartTime.minutes		= oDateTime.szMinutes;


	// STOP DATE/TIME	
	
	bID_StopDate.checked = (window.external.Task_GetValue(SECTION_SCHEDULE, STOP_DATE_VALID) == "1");
	g_bLastStopTaskValue = bID_StopDate.checked;

	if (bID_StopDate.checked)
	{
		var szTemp = window.external.Task_GetValue(SECTION_SCHEDULE, STOP_DATE_TIME);
		fnUnFormatDateTime(szTemp, oDateTime);
			
		htcID_StopDate.month		= oDateTime.szMonth;
		htcID_StopDate.day			= oDateTime.szDay;
		htcID_StopDate.year			= oDateTime.szYear;
		
		htcID_StopTime.hours		= oDateTime.szHours;
		htcID_StopTime.minutes		= oDateTime.szMinutes;
	}


	// "Run missed task" settings
	
	if ( window.external.Task_GetValue(SECTION_SCHEDULE, RUN_IF_MISSED) == "1" )
	{
		bID_RunMissedTask.checked = true;
		fnSetRunMissedUIState(false);
	}
	else
	{
		bID_RunMissedTask.checked = false;
		fnSetRunMissedUIState(true);
	}

	RunIfMissedDelayMinutes.value = window.external.Task_GetValue(SECTION_SCHEDULE, RUN_IF_MISSED_DELAY_MINS);


	// "Stop task if execution time exceeds" settings
	
	var szTemp = window.external.Task_GetValue(SECTION_SETTINGS, STOP_AFTER_MINS);
	
	if(szTemp != "0")
	{
		var dwTotalMinutes = parseInt( szTemp, 10 );
		
		var dwHour = Math.floor( dwTotalMinutes / 60 );
		var dwMinutes = dwTotalMinutes % 60;

		szID_StopHours.value = dwHour.toString();
		szID_StopMinutes.value = dwMinutes.toString();
		
		bID_StopTask.checked = true;
		fnSetStopMissedTaskUIState(false);
	}
	else
	{
		szID_StopHours.value	= "0";
		szID_StopMinutes.value	= "0";
		
		bID_StopTask.checked = false;
		fnSetStopMissedTaskUIState(true);
	}


	// Schedule Type (Monthly, Daily, At logon, etc)
	ScheduleType.value = window.external.Task_GetValue(SECTION_SCHEDULE, TASK_TYPE);
	displayOption(ScheduleType.value);

	// Retrieve the settings specific to the current schedule type
	switch (ScheduleType.value)
	{
		case TASK_TYPE_DAILY:
			Daily_EveryNumDays.value = window.external.Task_GetValue(SECTION_SCHEDULE, REPEAT_DAYS);
			break;

		case TASK_TYPE_WEEKLY:
			Weekly_RepeatWeeks.value = window.external.Task_GetValue(SECTION_SCHEDULE, REPEAT_WEEKS);

			var nMask = parseInt( window.external.Task_GetValue(SECTION_SCHEDULE, MASK_DAYS_OF_WEEK), 10 );
	
			Weekly_ChBox0.checked = (nMask & 0x1);
			Weekly_ChBox1.checked = (nMask & 0x2);
			Weekly_ChBox2.checked = (nMask & 0x4);
			Weekly_ChBox3.checked = (nMask & 0x8);
			Weekly_ChBox4.checked = (nMask & 0x10);
			Weekly_ChBox5.checked = (nMask & 0x20);
			Weekly_ChBox6.checked = (nMask & 0x40);
			
			break;

		case TASK_TYPE_MONTHLY:
		
			strTemp = window.external.Task_GetValue(SECTION_SCHEDULE, MONTH_OPTION);		
			
			if (strTemp == "0")
			{
				Monthly_RadioDayOfTheMonth.checked	= true;	 // if the schedule is indicated by numeric day
				Monthly_DayOfTheMonth.value			= window.external.Task_GetValue(SECTION_SCHEDULE, DAY_NUM_OF_MONTH);
			}
			else // if the schedule is indictate in terms of a day of a week of the months.
			{
				Monthly_RadioWeeklyDayOfTheMonth.checked	= true;	 
				Monthly_WeekOfTheMonth.selectedIndex		= parseInt(window.external.Task_GetValue(SECTION_SCHEDULE, WEEK_NUM_OF_MONTH), 10) - 1;
				Monthly_DayOfTheWeek.selectedIndex			= parseInt(window.external.Task_GetValue(SECTION_SCHEDULE, DAY_OF_WEEK), 10) - 1;
			}

			var nMask		= parseInt( window.external.Task_GetValue(SECTION_SCHEDULE, MASK_MONTHS_OF_YEAR), 10 );

			Monthly_ChBox0.checked = (nMask & 0x1);
			Monthly_ChBox1.checked = (nMask & 0x2);
			Monthly_ChBox2.checked = (nMask & 0x4);
			Monthly_ChBox3.checked = (nMask & 0x8);
			Monthly_ChBox4.checked = (nMask & 0x10);
			Monthly_ChBox5.checked = (nMask & 0x20);
			Monthly_ChBox6.checked = (nMask & 0x40);
			Monthly_ChBox7.checked = (nMask & 0x80);
			Monthly_ChBox8.checked = (nMask & 0x100);
			Monthly_ChBox9.checked = (nMask & 0x200); 
			Monthly_ChBox10.checked = (nMask & 0x400);
			Monthly_ChBox11.checked = (nMask & 0x800);

			fnMonthlyOptionClick();

			break;

		case TASK_TYPE_ONCE:

			// Run once uses the common start date/time value.		

			break;

		case TASK_TYPE_IMMEDIATELY:
			// Run Immediately currently has no specific settings
			break;
			
		case TASK_TYPE_HOURLY:
			Hourly_EveryNumHours.value = window.external.Task_GetValue(SECTION_SCHEDULE, REPEAT_HOURS);
			break;
	}
}

function fnMonthlyOptionClick()
{
	var bRadioDay = Monthly_RadioDayOfTheMonth.checked;
	
	Monthly_WeekOfTheMonth.disabled = bRadioDay;
	Monthly_DayOfTheWeek.disabled	= bRadioDay;
	
	if (bRadioDay)
		enableField(Monthly_DayOfTheMonth);
	else
		disableField(Monthly_DayOfTheMonth);	
}

function fnCreateDateTimeObject()
{
	this.szYear		= "2000";
	this.szMonth	= "01";
	this.szDay		= "01";
	this.szHours	= "01";
	this.szMinutes	= "00";
	this.szSeconds	= "00";
}


function fnUnFormatDateTime(szStartDateTime, objDateTime)
{
	objDateTime.szYear		= szStartDateTime.substring(0, 4);
	objDateTime.szMonth		= szStartDateTime.substring(4, 6);
	objDateTime.szDay		= szStartDateTime.substring(6, 8);
	objDateTime.szHours		= szStartDateTime.substring(8, 10);
	objDateTime.szMinutes	= szStartDateTime.substring(10, 12);
	objDateTime.szSeconds	= szStartDateTime.substring(12, 14);
}

function fnFormatDateTime(szYear, szMonth, szDay, szHours, szMinutes, szSeconds)
{
	var szStartDateTime = "";
	
	szStartDateTime = "" + szYear + szMonth + szDay + szHours + szMinutes + szSeconds;
	
	return szStartDateTime;
}


// the current Task ID (will be zero if it is a new task)
var		g_nTaskID;


/******************************************************************************
// Name			:: OnlyNumeric
// Arguments	:: 
// Description  :: This function should vbe called from OnKeyDown Event.
				   All the non-Numeric key are eaten
******************************************************************************/

function OnlyNumeric( )
{
   
	character = String.fromCharCode(window.event.keyCode);

	if ( ( window.event.keyCode >= 96 ) && ( window.event.keyCode <= 105 ) ) 	
	{
		return;
	}
	
	if  ( ( character >= "0" ) && ( character <= "9"  ) && ( window.event.shiftKey == false ) )
	{
		return;
	}
	
	if  ( ( window.event.keyCode == 46 ) ||			//delete
		  ( window.event.keyCode == 9  ) ||			//tab
		  ( window.event.keyCode == 8  ) || 		//backspace
		  ( window.event.keyCode == 36 ) ||			//home key
		  ( window.event.keyCode == 35 ) ||			//end key
		  ( window.event.keyCode == 39 ) ||			//--> right
		  ( window.event.keyCode == 37 ) ||			//<-- Key
		  ( window.event.keyCode == 45 ) )			//insert key
	{
		return;		  
	}
		
	event.returnValue = false;
}

function OnlyNumericWithDecimal( )
{
	character = String.fromCharCode(window.event.keyCode);

	if(window.event.keyCode == 190)
		return;

	if ( ( window.event.keyCode >= 96 ) && ( window.event.keyCode <= 105 ) ) 	
	{
		return;
	}
	
	if(character == ".")
		return;
	
	if  ( ( character >= "0" ) && ( character <= "9"  ) && ( window.event.shiftKey == false ) )
	{
		return;
	}
	
	if  ( ( window.event.keyCode == 46 ) ||			//delete
		  ( window.event.keyCode == 9  ) ||			//tab
		  ( window.event.keyCode == 8  ) || 		//backspace
		  ( window.event.keyCode == 36 ) ||			//home key
		  ( window.event.keyCode == 35 ) ||			//end key
		  ( window.event.keyCode == 39 ) ||			//--> right
		  ( window.event.keyCode == 37 ) ||			//<-- Key
		  ( window.event.keyCode == 45 ) )			//insert key
	{
		return;		  
	}
		
	event.returnValue = false;
}

function fnSetRndUIState(bState)
{
	labelID_RandomMinutes.disabled		= bState;
	labelID_MaxDelay.disabled			= bState;
	if (bState)
		disableField(RndMinutes);
	else
		enableField(RndMinutes);
}

function fnSetRunMissedUIState(bState)
{
	labelID_RunMissedMinutes.disabled	= bState;
	labelID_DelayMissedTaskBy.disabled				= bState;
	if (bState)
		disableField(RunIfMissedDelayMinutes);
	else
		enableField(RunIfMissedDelayMinutes);
}


function fnSetStopMissedTaskUIState(bState)
{
	labelID_StopMinutes.disabled		= bState;
	labelID_StopHours.disabled			= bState;
	
	if (bState)
	{
		disableField(szID_StopHours);
		disableField(szID_StopMinutes);
	}
	else
	{
		enableField(szID_StopHours);
		enableField(szID_StopMinutes);
	}
}





function SaveSettings()
{
	var TempMask = 0;
	
	window.external.Task_SetName( TaskName.value );
	window.external.Task_SetType( TaskType.value );
	
	if( EnableTask[0].checked )
	{
		window.external.Task_SetEnabled( 1 );
		window.external.Task_SetValue(SECTION_SETTINGS, TASK_ENABLED, "1");
	}
	else
	{
		window.external.Task_SetEnabled( 0 );
		window.external.Task_SetValue(SECTION_SETTINGS, TASK_ENABLED, "0");
	}
	
	if( bID_StopTask.checked )
	{
		var dwMinutes = (Math.abs(szID_StopHours.value)) * 60 + Math.abs(szID_StopMinutes.value);
		window.external.Task_SetValue(SECTION_SETTINGS, STOP_AFTER_MINS, dwMinutes.toString());
	}
	else
	{
		window.external.Task_SetValue(SECTION_SETTINGS, STOP_AFTER_MINS, "0");
	}

	// Schedule Type (Monthly, Daily, At logon, etc)
	window.external.Task_SetValue(SECTION_SCHEDULE, TASK_TYPE, ScheduleType.value);
	
	if (bID_RunMissedTask.checked)
		window.external.Task_SetValue(SECTION_SCHEDULE, RUN_IF_MISSED, "1");
	else
		window.external.Task_SetValue(SECTION_SCHEDULE, RUN_IF_MISSED, "0");
		
	if ( RunIfMissedDelayMinutes.value == "" )
		window.external.Task_SetValue(SECTION_SCHEDULE, RUN_IF_MISSED_DELAY_MINS, "0");
	else
		window.external.Task_SetValue(SECTION_SCHEDULE, RUN_IF_MISSED_DELAY_MINS, RunIfMissedDelayMinutes.value);

	var szStartDateTime		= fnFormatDateTime(htcID_StartDate.year, htcID_StartDate.sz_month, htcID_StartDate.sz_day, htcID_StartTime.sz_hours, htcID_StartTime.sz_minutes, "00");
	var szStopDateTime		= fnFormatDateTime(htcID_StopDate.year, htcID_StopDate.sz_month, htcID_StopDate.sz_day, htcID_StopTime.sz_hours, htcID_StopTime.sz_minutes, "00");
	var szStopdateValid		= bID_StopDate.checked ? "1" : "0";
	
	window.external.Task_SetValue(SECTION_SCHEDULE, START_DATE_TIME,	szStartDateTime);
	window.external.Task_SetValue(SECTION_SCHEDULE, STOP_DATE_VALID,	szStopdateValid);
	window.external.Task_SetValue(SECTION_SCHEDULE, STOP_DATE_TIME,		szStopDateTime);
	
	// Save the settings specific to the current schedule type
	switch (ScheduleType.value)
	{
		case TASK_TYPE_DAILY:
			window.external.Task_SetValue(SECTION_SCHEDULE, REPEAT_DAYS, Daily_EveryNumDays.value);
			break;

		case TASK_TYPE_WEEKLY:
			window.external.Task_SetValue(SECTION_SCHEDULE, REPEAT_WEEKS, Weekly_RepeatWeeks.value);

			TempMask	= 0;
			if (Weekly_ChBox0.checked)	TempMask |= 1<<0;
			if (Weekly_ChBox1.checked)	TempMask |= 1<<1;
			if (Weekly_ChBox2.checked)	TempMask |= 1<<2;
			if (Weekly_ChBox3.checked)	TempMask |= 1<<3;
			if (Weekly_ChBox4.checked)	TempMask |= 1<<4;
			if (Weekly_ChBox5.checked)	TempMask |= 1<<5;
			if (Weekly_ChBox6.checked)	TempMask |= 1<<6;
			
			window.external.Task_SetValue(SECTION_SCHEDULE, MASK_DAYS_OF_WEEK, TempMask.toString());
			break;

		case TASK_TYPE_MONTHLY:		
			if (Monthly_RadioDayOfTheMonth.checked) // if the schedule is indicated by numeric day
			{
				window.external.Task_SetValue(SECTION_SCHEDULE, MONTH_OPTION, "0");		
				window.external.Task_SetValue(SECTION_SCHEDULE, DAY_NUM_OF_MONTH, Monthly_DayOfTheMonth.value);
			}
			else // if the schedule is indictate in terms of a day of a week of the months.
			{
				window.external.Task_SetValue(SECTION_SCHEDULE, MONTH_OPTION, "1");
				window.external.Task_SetValue(SECTION_SCHEDULE, WEEK_NUM_OF_MONTH, Monthly_WeekOfTheMonth.value);
				window.external.Task_SetValue(SECTION_SCHEDULE, DAY_OF_WEEK, Monthly_DayOfTheWeek.value);
			}

			TempMask=0;
			
			if (Monthly_ChBox0.checked)		TempMask |= 1<<0;
			if (Monthly_ChBox1.checked)		TempMask |= 1<<1;
			if (Monthly_ChBox2.checked)		TempMask |= 1<<2;
			if (Monthly_ChBox3.checked)		TempMask |= 1<<3;
			if (Monthly_ChBox4.checked)		TempMask |= 1<<4;
			if (Monthly_ChBox5.checked)		TempMask |= 1<<5;
			if (Monthly_ChBox6.checked)		TempMask |= 1<<6;
			if (Monthly_ChBox7.checked)		TempMask |= 1<<7;
			if (Monthly_ChBox8.checked)		TempMask |= 1<<8;
			if (Monthly_ChBox9.checked)		TempMask |= 1<<9;
			if (Monthly_ChBox10.checked)	TempMask |= 1<<10;
			if (Monthly_ChBox11.checked)	TempMask |= 1<<11;
			
			window.external.Task_SetValue(SECTION_SCHEDULE, MASK_MONTHS_OF_YEAR, TempMask.toString());
			break;

		case TASK_TYPE_ONCE:
			// Run once uses the common start date/time value.	
			break;

		case TASK_TYPE_IMMEDIATELY:
			// Run Immediately currently has no specific settings
			break;
			
		case TASK_TYPE_HOURLY:
			window.external.Task_SetValue(SECTION_SCHEDULE, REPEAT_HOURS, Hourly_EveryNumHours.value);
			break;
	}
}

/// Validate that data fields are entered correctly 
///
function Validate()
{

	/// Validate Name
	str = TaskName.value;	
	if ( str.length == 0 )
	{
		alert(nrc_sz_errNoTaskName);
		return false;
	}

	var szBadChars = "=,:;[]*?/|<>";
	
	for (var i = 0; i < szBadChars.length; i++)
	{
		if ( TaskName.value.indexOf( szBadChars.charAt(i) ) != -1)
		{
			alert(nrc_sz_errBadCharactersInName);
			return false;
		}
	}

	var AllSpaces = 1;

	for (var i2 = 0; i2 < str.length; i2++)
	{
		if (( str.charAt(i2) ) != ' ')
		{
			AllSpaces = 0;
		}
	}


	if (AllSpaces == 1)
	{
		alert(nrc_sz_errNoTaskName);
		return false;
	}



	if ( bID_StopDate.checked && !bID_StopDate.disabled )
	{
		var szStartDateTime		= fnFormatDateTime(htcID_StartDate.year, htcID_StartDate.sz_month, htcID_StartDate.sz_day, htcID_StartTime.sz_hours, htcID_StartTime.sz_minutes, "00");
		var szStopDateTime		= fnFormatDateTime(htcID_StopDate.year, htcID_StopDate.sz_month, htcID_StopDate.sz_day, htcID_StopTime.sz_hours, htcID_StopTime.sz_minutes, "00");
		
		if ( szStartDateTime > szStopDateTime )
		{
			alert(nrc_sz_errStopDateBeforeStartDate);
			return false;
		}
	}


	/////////// Task-type specific validation ///////////

	switch (ScheduleType.value)
	{
		case TASK_TYPE_DAILY:
				if ( !checkBounds(Daily_EveryNumDays.value, 1, 9999) )
				{
					alert(nrc_errDaily_InvalidDays);
					return false;
				}
			break;

		case TASK_TYPE_WEEKLY:

				if ( !checkBounds(Weekly_RepeatWeeks.value, 1, 9999) )
				{
					alert(nrc_errWeekly_InvalidWeeks);
					return false;
				}

				var bChecked = false;
				for (var i = 0; i < 7; i++)
				{
					bChecked = bChecked || document.all["Weekly_ChBox" + i].checked;
				}

				if ( !bChecked )
				{
					alert(nrc_errWeekly_NoDaySelected);
					return false;
				}
			break;

		case TASK_TYPE_MONTHLY:
		
				var dwMaxDays = 31;
				
				// use 29 for Feb. since we have to allow for leap year.
				var DaysPerMonth = new Array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
		
				var bChecked = false;
				for (var i = 0; i < 12; i++)
				{
					if( document.all["Monthly_ChBox" + i].checked )
					{
						if (dwMaxDays > DaysPerMonth[i])
							dwMaxDays = DaysPerMonth[i];
							
						bChecked = true;
					}
				}
				
				if ( !bChecked )
				{
					alert(nrc_errMonthy_NoMonthSelected);
					return false;
				}
				
				if ( Monthly_RadioDayOfTheMonth.checked && !checkBounds(Monthly_DayOfTheMonth.value, 1, dwMaxDays))
				{
					var sError = nrc_errMonthly_InvalidDay.replace("%s", dwMaxDays);
					alert(sError);
					return false;
				} 
				
			break;

		case TASK_TYPE_ONCE://"Once":
		
				// Verify that the target date is not in the past.
		
				var oCurrentDate = new Date();
				var oStartDate	= new Date();
				
				oStartDate.setFullYear(htcID_StartDate.year, parseInt(htcID_StartDate.sz_month, 10) - 1, htcID_StartDate.sz_day);
				oStartDate.setMinutes(htcID_StartTime.sz_minutes);
				oStartDate.setHours(htcID_StartTime.sz_hours);
				
				if (oStartDate < oCurrentDate)
				{
					alert(nrc_errOnce_DateHasPassed);
					return false;
				}
	
			break;

		case TASK_TYPE_IMMEDIATELY:
			break;
			
		case TASK_TYPE_HOURLY:
				if ( !checkBoundsWithFloat(Hourly_EveryNumHours.value, 0.01, 23) )
				{
					alert(nrc_errHourly_InvalidHours);
					return false;
				}
			break;
			
		default:
			break;
	}

	/////////////////////////////////////////////////////


	if ( ( bID_RunMissedTask.checked ) && ( !checkBounds(RunIfMissedDelayMinutes.value, 0, 9999) ) )
	{
		alert(nrc_sz_errInvalidRunMissedValue);
		return false;
	}
	
	if ( bID_StopTask.checked )
	{
		if ( !checkBounds(szID_StopHours.value, 0, 9999) )
		{
			alert(nrc_sz_errInvalidStopHours);
			return false;
		}
		
		if ( !checkBounds(szID_StopMinutes.value, 0, 59) )
		{
			alert(nrc_sz_errInvalidStopMinutes);
			return false;
		}
		
		if ( ( szID_StopHours.value == "0" ) && ( szID_StopMinutes.value == "0" ) )
		{
			alert(nrc_sz_errInvalidStopTime);
			return false;
		}
	}

	return true;
}


// Verify that a given numeric value is within specified bounds.
function checkBounds(iValue, min, max)
{	
	if ( isNaN( iValue ) )
		return false;

	if (  isNaN( parseInt(iValue, 10) )  )
		return false;

	if ( (parseInt(iValue, 10) < min ) || (parseInt(iValue, 10) > max ) )
		return false;

	return true;
}

// Verify that a given numeric value is within specified bounds.
function checkBoundsWithFloat(iValue, min, max)
{	
	if ( isNaN( iValue ) )
		return false;

	if (  isNaN( parseInt(iValue, 10) )  )
		return false;

	if ( (Math.abs(iValue, 10) < min ) || (Math.abs(iValue, 10) > max ) )
		return false;

	return true;
}

function fnToggleStopDate(bState)
{
	g_bLastStopTaskValue = bID_StopDate.checked;
	htcID_StopDate.disabled = bState;
	htcID_StopTime.disabled = bState;
}


/// Write the task to database 
///
function OnContinue()
{
	if( !Validate() )
		return;

	if ( g_nTaskID == 0 )
	{
		/// Initialize NewTask Object
		window.external.NewTask_Init(	
			g_nTaskID);			// ID (0 for new task)
	}

	/// Write task settings
	SaveSettings();	

	/// Display advanced settings
	window.external.Task_Continue();
}


///////////////////////////////////////////////////
///  
///
function displayOption(SelectIndex) 
{
	id_OptionHourly.style.display	= "none";
	id_OptionDaily.style.display	= "none";
	id_OptionWeekly.style.display	= "none";
	id_OptionMonthly.style.display	= "none";
	id_OptionOnce.style.display		= "none";
	id_OptionImmediate.style.display	= "none";
	
	
	htcID_StartTime.disabled = false;
	htcID_StartDate.disabled = false;
	
	// restore the last known setting for the "stop date" checkbox value
	bID_StopDate.checked = g_bLastStopTaskValue;
	bID_StopDate.disabled = false;
	
	htcID_StopDate.disabled = !bID_StopDate.checked;
	htcID_StopTime.disabled = !bID_StopDate.checked;
	
	
	var szScheduleType = "";
	
	switch (SelectIndex)
	{
	case TASK_TYPE_DAILY://"Daily":
		szScheduleType = nrc_sz_TaskTypeDaily;
		id_OptionDaily.style.display	= "";
		break;
		
	case TASK_TYPE_WEEKLY://"Weekly":
		szScheduleType = nrc_sz_TaskTypeWeekly;
		id_OptionWeekly.style.display	= "";
		break;

	case TASK_TYPE_MONTHLY://"Monthly":
		szScheduleType = nrc_sz_TaskTypeMonthly;
		id_OptionMonthly.style.display	= "";
		break;

	case TASK_TYPE_ONCE://"Once":
		szScheduleType = nrc_sz_TaskTypeOnce;
		id_OptionOnce.style.display		= "";
		
		// stop date is not applicable to a task that runs only once.
		bID_StopDate.checked = false;
		htcID_StopDate.disabled = true;
		bID_StopDate.disabled = true;
		htcID_StopTime.disabled = true;
		
		break;

	case TASK_TYPE_IMMEDIATELY://"Run Immediately":
		szScheduleType = nrc_sz_TaskTypeImmediately;
		id_OptionImmediate.style.display	= "";

		// none of these settings are applicable to a task that will run immediately.
		MissedTaskRow.disabled		= true;
		htcID_StartTime.disabled = true;
		htcID_StartDate.disabled = true;
		htcID_StopDate.disabled = true;
		htcID_StopTime.disabled = true;
		bID_StopDate.disabled = true;
		bID_StopDate.checked = false;
		break;
		
	case TASK_TYPE_HOURLY://"Run Hourly":
		szScheduleType = nrc_sz_TaskTypeHourly;
		id_OptionHourly.style.display	= "";
		break;

	default:
		//TaskDetail1.innerHTML="";
		
	}

	titleID_ScheduleType.innerText				= szScheduleType;

}


function Task_DisplayHelp()
{
	window.external.DisplayHelp("Server_task_edit_window.html");
}


function fnToggleAdvancedScheduleOptions()
{

	if (spanID_AdvancedScheduleOptions.style.display == "")
	{
		imgID_ScheduleToggle.src = "plus.gif";
		spanID_AdvancedScheduleOptions.style.display = "none";
	}
	else
	{
		imgID_ScheduleToggle.src = "minus.gif";
		spanID_AdvancedScheduleOptions.style.display = "";
	}
}


function fnMakeMonthNameCheckboxes()
{
	szHTML = '<table width="100%"><tr>';
	
	for (var i = 0; i < nrc_MonthNames.length; i++)
	{
		szHTML += "<td>" + fnMakeMonthNameCheckbox(i) + "</td>";
		if ((i+1) % 3 == 0)
			szHTML += "</tr><tr>";
	}
	szHTML += "</tr></table>";
	
	return szHTML;
}

function fnMakeMonthNameCheckbox(iMonthNumber)
{
	var szHTML  = "";
	var szID	= "Monthly_ChBox" + iMonthNumber;
	
	szHTML = '<input type="checkbox" id="' + szID + '"><label for="' + szID + '" class="swd-standard">' + nrc_MonthNames[iMonthNumber] + '</label>';

	return szHTML;
}

function fnMakeDayNameCheckboxes()
{
	szHTML = '<table width="100%"><tr>';
	
	for (var i = 0; i < nrc_DayNames.length; i++)
	{
		szHTML += "<td>" + fnMakeDayNameCheckbox(i) + "</td>";
		if ((i+1) % 3 == 0)
			szHTML += "</tr><tr>";
	}
	szHTML += "</tr></table>";
	
	return szHTML;
}

function fnMakeDayNameCheckbox(iDayNumber)
{
	var szHTML  = "";
	var szID	= "Weekly_ChBox" + iDayNumber;
	
	szHTML = '<input type="checkbox" id="' + szID + '"><label for="' + szID + '" class="swd-standard">' + nrc_DayNames[iDayNumber] + '</label>';

	return szHTML;
}