-------------------------------
-- epo3.5 patch5 bz244131: alter memeory fields to store more than 2**32


-- ============================================================================
-- BEGIN EPOPolicySlot modification to enforce types at the slot level.

-- Alter policy slot table, adding policy type code, allowing nulls temporarily
ALTER TABLE EPOPolicySlot
	ADD TypeID int NULL;
GO

-- set default slot type id values
UPDATE EPOPolicySlot SET EPOPolicySlot.TypeID = EPOPOlicyObjects.TypeID
	FROM EPOPolicyObjects INNER JOIN EPOPolicyAssignment
	ON EPOPolicyObjects.PolicyObjectID = EPOPOlicyAssignment.PolicyObjectID
	WHERE EPOPolicySlot.SlotID = EPOPolicyAssignment.SlotID

-- remove potential bogus slots that were not being used
DELETE FROM EPOPolicySlot
	WHERE TypeID IS NULL;

-- reenable non-null constraint for typeid
ALTER TABLE EPOPolicySlot
	ALTER COLUMN TypeID int NOT NULL;
GO

-- update slot creation code to require a typeid
ALTER  PROCEDURE dbo.EPOPolicy_AddPolicySlot
(
	@UserID int,
	@ProductCode nvarchar(128),
	@TypeID int,
	@SlotID int output
)
AS
	-- squelch client-rowcount messages
	SET NOCOUNT ON;

	-- init output parameters
	SET @SlotID = NULL;

	-- add new record
	INSERT INTO EPOPolicySlot (ProductCode, TypeID)
	VALUES (@ProductCode, @TypeID);

	-- remember last inserted record
	SET @SlotID = SCOPE_IDENTITY();

	-- return error condition
	RETURN @@ERROR;
GO


-- update policy assignment retrieval to use slot-based type info
ALTER PROCEDURE dbo.EPOPolicy_GetNodePolicyAssignmentsEx
(
	@NodeID int,
	@NodeType smallint,
	@ProductCode nvarchar(128) = NULL
)
AS
	-- squelch client callbacks
	SET NOCOUNT ON;

	-- get parent identifier
	DECLARE @ParentID int;
	DECLARE @ParentType smallint;
	SET @ParentType = NULL;
	SET @ParentID = NULL;

	-- walk node inheritance tree, returning a recordset for each
	IF (@NodeType IN (1, 2, 24))
	BEGIN
		SELECT @ParentID = ParentID FROM LeafNode WHERE AutoID = @NodeID;
	END
	ELSE
	BEGIN
		-- else this is a branch node, so use the node id itself
		SELECT @ParentID = ParentID FROM BranchNode WHERE AutoID = @NodeID;
	END

	-- if this is not the global root.
	IF ((NOT @ParentID IS NULL) AND (@ParentID <> 0))
	BEGIN
		-- regardless, the type comes from the parent node directly
		SELECT @ParentType = Type FROM BranchNode WHERE AutoID = @ParentID;

		-- execute recursively on the parent of the current node.
		EXEC EPOPolicy_GetNodePolicyAssignmentsEx @ParentID, @ParentType, @ProductCode;
	END

	-- if the product code is null, then find all assignments
	-- for this node, otherwise find all for that product code.
	IF (@ProductCode IS NULL)
	BEGIN
		-- now run the query
		SELECT EPOPolicyAssignment.AssignmentID AS AssignmentID,
		EPOPolicyAssignment.NodeID AS NodeID,
		EPOPolicyAssignment.NodeType AS NodeType,
		EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
		EPOPolicySlot.TypeID AS PolicyTypeID,
		EPOPolicyAssignment.SlotID AS SlotID,
		EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
		EPOPolicyAssignment.Hidden AS Hidden,
		EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
		EPOPolicySlot.ProductCode AS ProductCode
		FROM (EPOPolicySlot INNER JOIN EPOPOlicyAssignment ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
		WHERE ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType))
		ORDER BY EPOPolicySlot.TypeID ASC, EPOPolicyAssignment.SlotID ASC;
	END
	ELSE
	BEGIN
		-- this monster is to filter based on product code, which is
		--  derived from the policy objects in the assignment table,
		--  based on their types as related to the product code in the
		--  product-to-types table (whew).
		SELECT EPOPolicyAssignment.AssignmentID AS AssignmentID,
		EPOPolicyAssignment.NodeID AS NodeID,
		EPOPolicyAssignment.NodeType AS NodeType,
		EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
		EPOPolicySlot.TypeID AS PolicyTypeID,
		EPOPolicyAssignment.SlotID AS SlotID,
		EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
		EPOPolicyAssignment.Hidden AS Hidden,
		EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
		@ProductCode AS ProductCode
		FROM (EPOPolicyAssignment INNER JOIN EPOPolicySlot ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
		WHERE (EPOPolicySlot.ProductCode = @ProductCode)
		AND ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType))
		ORDER BY EPOPolicySlot.TypeID ASC, EPOPolicyAssignment.SlotID ASC;
	END
	RETURN @@ERROR;
GO

ALTER PROCEDURE dbo.EPOPolicy_GetNodePolicyAssignmentBySlotID
(
	@NodeID int,
	@NodeType smallint,
	@SlotID int
)
AS
	-- squelch client-callbacks
	SET NOCOUNT ON;

	SELECT EPOPolicyAssignment.NodeID AS NodeID,
	EPOPolicyAssignment.NodeType AS NodeType,
	EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
	EPOPolicySlot.TypeID AS PolicyTypeID,
	EPOPolicyAssignment.SlotID AS SlotID,
	EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
	EPOPolicyAssignment.Hidden AS Hidden,
	EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
	EPOPolicySlot.ProductCode AS ProductCode
	FROM (EPOPolicySlot INNER JOIN EPOPOlicyAssignment ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
	WHERE ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType)
	AND EPOPolicyAssignment.SlotID = @SlotID)

GO

ALTER PROCEDURE dbo.EPOPolicy_GetNodeBrokenInheritancePolicyAssignments
(
	@NodeID int,
	@NodeType smallint,
	@SlotID int
)
AS
	SET NOCOUNT ON;

	-- return all leaf node and child branch node policy assignments with the same SlotID
	SELECT EPOPolicyAssignment.NodeID AS NodeID,
	EPOPolicyAssignment.NodeType AS NodeType,
	EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
	EPOPolicySlot.TypeID AS PolicyTypeID,
	@SlotID AS SlotID,
	EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
	EPOPolicyAssignment.Hidden AS Hidden,
	EPOPolicyAssignment.TheTimestamp AS TheTimestamp
	FROM (EPOPolicyAssignment INNER JOIN EPOPolicySlot
	ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
	WHERE ( (EPOPolicyAssignment.SlotID = @SlotID)
		AND
		(
			(	-- child branch nodes
				EPOPolicyAssignment.NodeType NOT IN (1,2,24)
				AND EPOPolicyAssignment.NodeID IN (SELECT EndAutoID FROM BranchNodeEnum WHERE StartAutoID=@NodeID)
			)

			OR
			(	-- leaf nodes
				EPOPolicyAssignment.NodeType IN (1, 2, 24)
				AND EPOPolicyAssignment.NodeID IN (SELECT AutoID FROM LeafNode WHERE (ParentID=@NodeID) OR (ParentID in
					(SELECT EndAutoID FROM BranchNodeEnum WHERE StartAutoID=@NodeID)))
			)
		)
	)
	ORDER BY EPOPolicyAssignment.NodeID ASC

		-- ideally the output should be ordered by node depth
	RETURN @@ERROR;
GO

-- END EPOPolicySlot modification to enforce types at the slot level.
-- ============================================================================


-- Alter columns to make into bigint (values > 4G)
ALTER TABLE [dbo].[ComputerProperties] DROP
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] ,
	CONSTRAINT [DF_ComputerProperties_FreeMemory]
GO

-- using numeric instead of bigint for sql 7 compatibility
ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
TotalPhysicalMemory nvarchar(64) null
go 

ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
FreeMemory nvarchar(64) null
go

ALTER TABLE [dbo].[ComputerProperties] ADD
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] DEFAULT ('0') FOR [TotalPhysicalMemory],
	CONSTRAINT [DF_ComputerProperties_FreeMemory] DEFAULT ('0') FOR [FreeMemory]
GO

--end

----------------------------------------------------------------
-- epo3.5p5 bz239604: add new default policies directly to DB to avoid user having to check in a 
--	nap file in order to get the fix.
begin

declare @id int

select @id = autoid 
from policy
where
parenttype =7
and productcode = 'EPOAGENT3000'

if not exists (select parentid from policysettings
where sectionname = 'BranchSelection' and parentid = @id)
begin

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'NumberOfItems', '4')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_0', 'VSCANDAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_0', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_1', 'VSCANENG1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_1', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_2', 'EXTRADAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_2', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_3', 'SUPERDAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_3', 'Current')

end
end
GO
--end



-- bz246340 epo3.5 patch5
---------------------------------------------------------
ALTER PROCEDURE dbo.AVISP_FilterUpgradeEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




	-- initiator types
	Declare @InitiatorType1 varchar(50)	
	Declare @InitiatorType2 varchar(50)	
	Declare @InitiatorType3 varchar(50)	
	Declare @InitiatorType4 varchar(50)	
	Declare @InitiatorType5 varchar(50)	

		Set @InitiatorType1 ='Automatic'	
		Set @InitiatorType2 ='Task'	
		Set @InitiatorType3 ='Remediation'	
		Set @InitiatorType4 ='On Demand'	
		Set @InitiatorType5 ='Rollback'	

	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		-- initiator type
		Select 	@InitiatorType1 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type1'
		Select 	@InitiatorType2 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type2'
		Select 	@InitiatorType3 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type3'
		Select 	@InitiatorType4 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type4'
		Select 	@InitiatorType5 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type5'
	End


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(AVIView_Software.SoftwareName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE AVIView_Software.SoftwareVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
   		,cast(ReportFullPathNodeID.FullPathShortName as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,ProductEvents.Type as Type
		,Version as Version
		,ProductEvents.Sitename as Sitename
		,InitiatorID as InitiatorID
--		,InitiatorType as InitiatorType
		,case 
			when InitiatorType= 'Automatic' then @InitiatorType1
			when InitiatorType= 'Task' then @InitiatorType2
			when InitiatorType= 'Remediation' then @InitiatorType3
			when InitiatorType= 'OnDemand' then @InitiatorType4
			when InitiatorType= 'OnDemandRollback' then @InitiatorType5
			when InitiatorType= 'DeploymentTask' then @InitiatorType2
			when InitiatorType= 'UpdateTask' then @InitiatorType2
			when InitiatorType= 'RemediationRollback' then @InitiatorType5
			else InitiatorType
		end as InitiatorType
		,Error as ErrorID

-- postepo3 33379 - join to ReportUpdateEventDesc and return error desc if its available 
--		,cast(Error as nvarchar(128)) as ErrorDesc
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM
		ProductEvents 
		Join leafnode on (ProductEvents.NodeID = leafnode.autoID			/* regular join tieing events to nodes */
			and ProductEvents.NodeID = @NodeID	)
		Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID)
		Join aviview_software on (ProductEvents.productcode = aviview_software.productcode)
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
--	FROM ProductEvents, ReportComputerSummary, ReportUpdateEventDesc
	WHERE 
  	(
   		@FilterID = 0 OR
    		leafnode.parentid = @FilterID OR
  		leafnode.parentid in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	and ProductEvents.Type > ''



	UNION


 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
			as EventDateTime
    		,CAST(Events.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(UserName AS varchar(32)) AS UserName
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
    		,TVDEventID
    		,CAST(FileName As varchar(255)) As FileName 
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion 
    		,CAST(DATVersion as varchar(16)) As DATVersion 
    		,ScanTime
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END
    		,TVDSeverity
   		,VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END
    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
   		,cast('' as varchar(256)) AS NodeName
   		,'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		,cast(EventFilterDescFast.name as nvarchar(256)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		-- bz246340 epo3.5 patch5: must use @szFullLang (4 digit lang code) instead of @szLang (2 digit)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szFullLang) 

  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
	and Events.NodeID = @NodeID	



RETURN @@rowcount
END

GO


-- bz240142 epo3.5 patch5 
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_UpdateProdPropFromEvents]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [EPOSP_UpdateProdPropFromEvents]
GO

-- Patch3 Update
CREATE PROCEDURE dbo.EPOSP_UpdateProdPropFromEvents
 @AgentGUID  uniqueidentifier,			-- matches leafnode.agentGUID
 @MACAddress NVARCHAR(50) = NULL,
 @ProductCode nvarchar(50),	-- matches productproperties.productcode
 @Type nvarchar(50),
 @Version nvarchar(50),
 -- epo3.5 >patch4 bz240142: Check error parm and dont update if update event fails
 @Error int = 0

AS
BEGIN
	SET XACT_ABORT ON
	SET NOCOUNT ON

	DECLARE @LeafNodeID INT
	DECLARE @ProdPropID INT
	DECLARE @c CHAR

	SELECT TOP 1 @LeafNodeID = AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID

	if ((@LeafNodeID IS NULL) AND (@MACAddress IS NOT NULL)  AND (@MACAddress<>''))
	BEGIN
		SET @c=LEFT(@MACAddress,1)
		if ( ((@c>='0') AND (@c<='9')) OR ((@c>='A') AND (@c<='F')) OR ((@c>='a') AND (@c<='f')) )
		BEGIN
			SELECT TOP 1 @LeafNodeID = l.Autoid from leafnode as l inner join computerproperties as c on l.autoid=c.parentid where c.netaddress=@MACAddress
		END
	END

 	-- epo3.5 patch5 bz240142: Check error parm and dont update if update event fails
	IF (@LeafNodeID IS NOT NULL and (@Error = 0 or @Error = 1) )
	BEGIN
		SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode

		IF (@ProdPropID IS NULL)
		BEGIN
			--Create prodprop entry
			INSERT INTO ProductProperties 
				(ParentID,ProductCode)
			VALUES
				(@LeafNodeID, @ProductCode)

			SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode
		END

		IF (@ProdPropID IS NOT NULL)
		BEGIN
			if upper(@type) = 'INSTALL'
			begin
				UPDATE ProductProperties 
					SET ProductVersion=@Version 
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szProductVer',
					'General',
					@Version
			end
			if upper(@type) = 'HOTFIX'
			begin
				UPDATE ProductProperties 
					set Hotfix=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szHotfixVersion',
					'General',
					@Version
			end
			if upper(@type) = 'SERVICEPACK'
			begin
				UPDATE ProductProperties 
					set Servicepack=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szServicePackVersion',
					'General',
					@Version
			end
			if upper(@type) = 'DAT'
			begin
				UPDATE ProductProperties 
					set DATVer=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szDATVersion',
					'General',
					@Version
			end
			if upper(@type) = 'ENGINE'
			begin
				UPDATE ProductProperties 
					set EngineVer=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szEngineVersion',
					'General',
					@Version
			end
			if upper(@type) = 'EXTRADAT'
			begin
				UPDATE ProductProperties 
					set ExtraDatNames=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szExtraDATNames',
					'General',
					@Version
			end
		END
	END
END
 

GO

----------------------------------------------------------------------------------------------------
-- BEGIN: BZ 254016 - add Notifications support for Host Intrusion Prevention events
----------------------------------------------------------------------------------------------------
if not exists( select * from AlertFamily where [Name] = 'HIP' )
BEGIN
    declare @hip int;
    insert into AlertFamily ([Name]) values('HIP');
    select @hip = @@IDENTITY;

    insert into [AlertAliasMapping] values(@hip, 'Aliases.EnterceptAgentEvent.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'EnterceptAgentEvent', '');
    insert into [AlertAliasMapping] values(@hip, 'Aliases.FirewallKevlarQuarentineCheck.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'FirewallKevlarQuarentineCheck', '');
    insert into [AlertAliasMapping] values(@hip, 'Aliases.FirewallKevlarBlockedApplication.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'FirewallKevlarBlockedApplicationEvent', '');

    declare @application_blocked int;
    declare @host_intrusion_detected_and_handled int;
    declare @network_intrusion_detected_and_handled int;
    declare @computer_quarantine_mode int;   -- must retrieve via select statement
    declare @unknown_category int;           -- must retrieve via select statement

    insert into EventCategory ([Name], [AssociateThreat]) values('APPLICATION_BLOCKED', 1);
    select @application_blocked = @@IDENTITY;
    insert into EventCategory ([Name], [AssociateThreat]) values('HOST_INTRUSION_DETECTED_AND_HANDLED', 1);
    select @host_intrusion_detected_and_handled = @@IDENTITY;
    insert into EventCategory ([Name], [AssociateThreat]) values('NETWORK_INTRUSION_DETECTED_AND_HANDLED', 1);
    select @network_intrusion_detected_and_handled = @@IDENTITY;
    select @unknown_category = [EventCategoryId] from [EventCategory] where [Name] = 'UNKNOWN_CATEGORY';
    select @computer_quarantine_mode = [EventCategoryId] from [EventCategory] where [Name] = 'COMPUTER_QUARANTINE_MODE';

    insert into AFToCatMapping values(@hip, @unknown_category);
    insert into AFToCatMapping values(@hip, @application_blocked);
    insert into AFToCatMapping values(@hip, @computer_quarantine_mode);
    insert into AFToCatMapping values(@hip, @host_intrusion_detected_and_handled);
    insert into AFToCatMapping values(@hip, @network_intrusion_detected_and_handled);

    declare @unknown_product int;  -- pre-existing
    select @unknown_product = [AlertFamilyId] from [AlertFamily] where [Name] = 'UNKNOWN_PRODUCT';
    insert into AFToCatMapping values(@unknown_product, @application_blocked);
    insert into AFToCatMapping values(@unknown_product, @host_intrusion_detected_and_handled);
    insert into AFToCatMapping values(@unknown_product, @network_intrusion_detected_and_handled);

    IF exists(select [EventID] from [EventFilter] where EventID=18000)
        update [EventFilter] set [EventCategory]=@host_intrusion_detected_and_handled, HideInFilterTab=0 where EventID=18000;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18000, 0x4000001, null, null, @host_intrusion_detected_and_handled, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18001)
        update [EventFilter] set [EventCategory]=@network_intrusion_detected_and_handled, HideInFilterTab=0 where EventID=18001;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18001, 0x4000001, null, null, @network_intrusion_detected_and_handled, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18002)
        update [EventFilter] set EventCategory=@application_blocked, HideInFilterTab=0 where EventID=18002;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18002, 0x4000001, null, null, @application_blocked, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18003)
        update [EventFilter] set EventCategory=@computer_quarantine_mode, HideInFilterTab=0 where EventID=18003;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18003, 0x4000001, null, null, @computer_quarantine_mode, 0);
END
GO
----------------------------------------------------------------------------------------------------
-- END: BZ 254016 - add Notifications support for Host Intrusion Prevention events
----------------------------------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- ePO 3.5 patch 5
-- BEGIN: fix for BZ 236173:  Fix involves changing certain columns
-- from char and varchar types to nchar and nvarchar types,
-- respectively.  As explained in the MSDN documentation for the
-- ALTER TABLE command, ALTER COLUMN cannot be used to change the column
-- types.  Tables must be recreated with the new column types.
------------------------------------------------------------------------
------------------------------------------------------------------------

IF EXISTS (select systypes.name
      from sysobjects, syscolumns, systypes
      where sysobjects.xtype = 'U' and
      sysobjects.name = 'Hosts' and
      sysobjects.id = syscolumns.id and
      syscolumns.name = 'MAC' and
      syscolumns.xtype = systypes.xtype and
      systypes.name = 'char' )
BEGIN
    ------------------------------------------------------------------------
    -- changes to the Hosts table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Hosts
        DROP CONSTRAINT FK_Hosts_Networks


    CREATE TABLE dbo.Tmp_Hosts
        (
        HostID int NOT NULL IDENTITY (1, 1),
        MAC nchar(12) NOT NULL,
        OUI nchar(6) NULL,
        NetworkAddress nvarchar(50) NOT NULL,
        NetworkProtocolID int NOT NULL,
        NetbiosName nvarchar(16) NOT NULL,
        DnsName nvarchar(255) NOT NULL,
        LastDetectTime datetime NULL,
        NetworkID int NULL,
        [Exception] bit NOT NULL,
        EpoIndex int NULL,
        Comments nvarchar(255) NOT NULL,
        OSPlatform nvarchar(25) NOT NULL,
        OSFamily nvarchar(128) NOT NULL,
        OSVersion nvarchar(128) NOT NULL,
        NetBiosComment nvarchar(100) NOT NULL,
        Deleted bit NOT NULL,
        FirstDetectTime datetime NULL,
        Users nvarchar(128) NOT NULL,
        [Domain] nvarchar(16) NOT NULL,
        SID nvarchar(48) NOT NULL,
        FirstRogueTime datetime NULL,
        RogueType int NOT NULL,
        LastAgentCom datetime NULL,
        IpAddressNum int NOT NULL,
        FriendlyName nvarchar(255) NOT NULL,
        MarkedForAction bit NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Hosts ON

    IF EXISTS(SELECT * FROM dbo.Hosts)
         EXEC('INSERT INTO dbo.Tmp_Hosts (HostID, MAC, OUI, NetworkAddress, NetworkProtocolID, NetbiosName, DnsName, LastDetectTime, NetworkID, [Exception], EpoIndex, Comments, OSPlatform, OSFamily, OSVersion, NetBiosComment, Deleted, FirstDetectTime, Users, [Domain], SID, FirstRogueTime, RogueType, LastAgentCom, IpAddressNum, FriendlyName, MarkedForAction)
            SELECT HostID, MAC, OUI, NetworkAddress, NetworkProtocolID, NetbiosName, DnsName, LastDetectTime, NetworkID, [Exception], EpoIndex, Comments, OSPlatform, OSFamily, OSVersion, NetBiosComment, Deleted, FirstDetectTime, Users, [Domain], SID, FirstRogueTime, RogueType, LastAgentCom, IpAddressNum, FriendlyName, MarkedForAction FROM dbo.Hosts TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Hosts OFF

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Hosts

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Hosts

    DROP TABLE dbo.Hosts

    EXECUTE sp_rename N'dbo.Tmp_Hosts', N'Hosts', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Hosts_MAC ON dbo.Hosts
        (
        MAC
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OUI ON dbo.Hosts
        (
        OUI
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_NetbiosName ON dbo.Hosts
        (
        NetbiosName
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_DnsName ON dbo.Hosts
        (
        DnsName
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_LastDetectTime ON dbo.Hosts
        (
        LastDetectTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Comments ON dbo.Hosts
        (
        Comments
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSPlatform ON dbo.Hosts
        (
        OSPlatform
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSFamily ON dbo.Hosts
        (
        OSFamily
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSVersion ON dbo.Hosts
        (
        OSVersion
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_NetBiosComment ON dbo.Hosts
        (
        NetBiosComment
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FirstDetectTime ON dbo.Hosts
        (
        FirstDetectTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Users ON dbo.Hosts
        (
        Users
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Domain ON dbo.Hosts
        (
        [Domain]
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FirstRogueTime ON dbo.Hosts
        (
        FirstRogueTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_RogueType ON dbo.Hosts
        (
        RogueType
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_LastAgentCom ON dbo.Hosts
        (
        LastAgentCom
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_IpAddressNum ON dbo.Hosts
        (
        IpAddressNum
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FriendlyName ON dbo.Hosts
        (
        FriendlyName
        ) ON [PRIMARY]

    ALTER TABLE dbo.Hosts ADD CONSTRAINT
        PK_Hosts PRIMARY KEY NONCLUSTERED
        (
        HostID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Hosts WITH NOCHECK ADD CONSTRAINT
        FK_Hosts_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )

    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Hosts FOREIGN KEY
        (
        SourceHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Hosts FOREIGN KEY
        (
        TargetHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )


    ------------------------------------------------------------------------
    -- changes to the OUIs table as a result of Bugzilla 236173
    ------------------------------------------------------------------------

    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    CREATE TABLE dbo.Tmp_OUIs
        (
        OrgName nvarchar(255) NOT NULL,
        OUI nchar(6) NOT NULL
        )  ON [PRIMARY]

    IF EXISTS(SELECT * FROM dbo.OUIs)
         EXEC('INSERT INTO dbo.Tmp_OUIs (OrgName, OUI)
            SELECT OrgName, OUI FROM dbo.OUIs TABLOCKX')

    DROP TABLE dbo.OUIs

    EXECUTE sp_rename N'dbo.Tmp_OUIs', N'OUIs', 'OBJECT'

    ALTER TABLE dbo.OUIs ADD CONSTRAINT
        PK_OUI PRIMARY KEY CLUSTERED
        (
        OUI
        ) ON [PRIMARY]


    ------------------------------------------------------------------------
    -- changes to the Networks table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Networks
        DROP CONSTRAINT DF_Networks_Covered

    CREATE TABLE dbo.Tmp_Networks
        (
        NetworkID int NOT NULL IDENTITY (1, 1),
        NetworkName nvarchar(255) NOT NULL,
        SubnetMask nvarchar(25) NOT NULL,
        NetworkAddress nvarchar(25) NOT NULL,
        Covered int NOT NULL,
        NetworkAddressNum int NOT NULL
        )  ON [PRIMARY]

    ALTER TABLE dbo.Tmp_Networks ADD CONSTRAINT
        DF_Networks_Covered DEFAULT (1) FOR Covered

    SET IDENTITY_INSERT dbo.Tmp_Networks ON

    IF EXISTS(SELECT * FROM dbo.Networks)
         EXEC('INSERT INTO dbo.Tmp_Networks (NetworkID, NetworkName, SubnetMask, NetworkAddress, Covered, NetworkAddressNum)
            SELECT NetworkID, NetworkName, SubnetMask, NetworkAddress, Covered, NetworkAddressNum FROM dbo.Networks TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Networks OFF

    ALTER TABLE dbo.Sensors
        DROP CONSTRAINT FK_Sensors_Networks

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Networks

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Networks

    ALTER TABLE dbo.Hosts
        DROP CONSTRAINT FK_Hosts_Networks

    DROP TABLE dbo.Networks

    EXECUTE sp_rename N'dbo.Tmp_Networks', N'Networks', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Networks ON dbo.Networks
        (
        NetworkAddress,
        SubnetMask
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Networks_NetworkAddressNum ON dbo.Networks
        (
        NetworkAddressNum
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Networks_NetworkName ON dbo.Networks
        (
        NetworkName
        ) ON [PRIMARY]

    ALTER TABLE dbo.Networks ADD CONSTRAINT
        PK_Networks PRIMARY KEY NONCLUSTERED
        (
        NetworkID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Hosts WITH NOCHECK ADD CONSTRAINT
        FK_Hosts_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Networks FOREIGN KEY
        (
        SourceNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Networks FOREIGN KEY
        (
        TargetNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.Sensors WITH NOCHECK ADD CONSTRAINT
        FK_Sensors_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ------------------------------------------------------------------------
    -- changes to the Sensors table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Sensors
        DROP CONSTRAINT FK_Sensors_Networks


    CREATE TABLE dbo.Tmp_Sensors
        (
        SensorID int NOT NULL IDENTITY (1, 1),
        NetworkID int NOT NULL,
        MAC nchar(12) NOT NULL,
        SensorName nvarchar(255) NOT NULL,
        IPAddress varchar(50) NOT NULL,
        OSPlatform nvarchar(25) NOT NULL,
        OSFamily nvarchar(25) NOT NULL,
        OSVersion nvarchar(25) NOT NULL,
        LastCommunicationTime datetime NOT NULL,
        [Domain] nvarchar(16) NOT NULL,
        SID nvarchar(48) NOT NULL,
        AgentGUID nchar(36) NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Sensors ON

    IF EXISTS(SELECT * FROM dbo.Sensors)
         EXEC('INSERT INTO dbo.Tmp_Sensors (SensorID, NetworkID, MAC, SensorName, IPAddress, OSPlatform, OSFamily, OSVersion, LastCommunicationTime, [Domain], SID, AgentGUID)
            SELECT SensorID, NetworkID, MAC, SensorName, IPAddress, OSPlatform, OSFamily, OSVersion, LastCommunicationTime, [Domain], SID, AgentGUID FROM dbo.Sensors TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Sensors OFF

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Sensors

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Sensors

    DROP TABLE dbo.Sensors

    EXECUTE sp_rename N'dbo.Tmp_Sensors', N'Sensors', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Sensors ON dbo.Sensors
        (
        MAC
        ) ON [PRIMARY]

    ALTER TABLE dbo.Sensors ADD CONSTRAINT
        PK_Sensors PRIMARY KEY NONCLUSTERED
        (
        SensorID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Sensors WITH NOCHECK ADD CONSTRAINT
        FK_Sensors_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Sensors FOREIGN KEY
        (
        SourceSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Sensors FOREIGN KEY
        (
        TargetSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )


    ------------------------------------------------------------------------
    -- changes to the Actions table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Actions
        DROP CONSTRAINT FK_Actions_Responses


    CREATE TABLE dbo.Tmp_Actions
        (
        ActionID int NOT NULL IDENTITY (1, 1),
        ResponseID int NOT NULL,
        Type nvarchar(50) NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Actions ON

    IF EXISTS(SELECT * FROM dbo.Actions)
         EXEC('INSERT INTO dbo.Tmp_Actions (ActionID, ResponseID, Type)
            SELECT ActionID, ResponseID, Type FROM dbo.Actions TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Actions OFF

    ALTER TABLE dbo.ActionSettings
        DROP CONSTRAINT FK_ActionSettings

    DROP TABLE dbo.Actions

    EXECUTE sp_rename N'dbo.Tmp_Actions', N'Actions', 'OBJECT'

    ALTER TABLE dbo.Actions ADD CONSTRAINT
        PK_Actions PRIMARY KEY CLUSTERED
        (
        ActionID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Actions WITH NOCHECK ADD CONSTRAINT
        FK_Actions_Responses FOREIGN KEY
        (
        ResponseID
        ) REFERENCES dbo.Responses
        (
        ResponseID
        )


    ALTER TABLE dbo.ActionSettings WITH NOCHECK ADD CONSTRAINT
        FK_ActionSettings FOREIGN KEY
        (
        ActionID
        ) REFERENCES dbo.Actions
        (
        ActionID
        )


    ------------------------------------------------------------------------
    -- changes to the ActionStatus table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Sensors


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Networks


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Hosts


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT DF_ActionStatus_Status

    CREATE TABLE dbo.Tmp_ActionStatus
        (
        ActionStatusID int NOT NULL IDENTITY (1, 1),
        EventLogId int NOT NULL,
        TargetHostId int NULL,
        TargetNetworkId int NULL,
        TargetSensorId int NULL,
        Type nvarchar(128) NOT NULL,
        Status int NULL,
        StartTime datetime NULL,
        EndTime datetime NULL,
        Endkey nvarchar(128) NULL,
        Archive bit NULL,
        ActionOutput image NULL,
        ActionDetail nvarchar(512) NULL
        )  ON [PRIMARY]
         TEXTIMAGE_ON [PRIMARY]

    ALTER TABLE dbo.Tmp_ActionStatus ADD CONSTRAINT
        DF_ActionStatus_Status DEFAULT ((-1)) FOR Status

    SET IDENTITY_INSERT dbo.Tmp_ActionStatus ON

    IF EXISTS(SELECT * FROM dbo.ActionStatus)
         EXEC('INSERT INTO dbo.Tmp_ActionStatus (ActionStatusID, EventLogId, TargetHostId, TargetNetworkId, TargetSensorId, Type, Status, StartTime, EndTime, Endkey, Archive, ActionOutput, ActionDetail)
            SELECT ActionStatusID, EventLogId, TargetHostId, TargetNetworkId, TargetSensorId, Type, Status, StartTime, EndTime, Endkey, Archive, ActionOutput, ActionDetail FROM dbo.ActionStatus TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_ActionStatus OFF

    DROP TABLE dbo.ActionStatus

    EXECUTE sp_rename N'dbo.Tmp_ActionStatus', N'ActionStatus', 'OBJECT'

    CREATE CLUSTERED INDEX IX_ActionStatus ON dbo.ActionStatus
        (
        Endkey
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_Type ON dbo.ActionStatus
        (
        Type
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_Status ON dbo.ActionStatus
        (
        Status
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_StartTime ON dbo.ActionStatus
        (
        StartTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_EndTime ON dbo.ActionStatus
        (
        EndTime
        ) ON [PRIMARY]

    ALTER TABLE dbo.ActionStatus ADD CONSTRAINT
        PK_ActionStatus PRIMARY KEY NONCLUSTERED
        (
        ActionStatusID
        ) ON [PRIMARY]


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Hosts FOREIGN KEY
        (
        TargetHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Networks FOREIGN KEY
        (
        TargetNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Sensors FOREIGN KEY
        (
        TargetSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 236173
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 239762
------------------------------------------------------------------------
------------------------------------------------------------------------
IF NOT EXISTS( select * from [AlertFamily] where [Name] = 'VSNETAPP' )
BEGIN
    declare @vsnetapp int;

    insert into AlertFamily ([Name]) values('VSNETAPP');
    select @vsnetapp = @@IDENTITY;

    insert into [AlertAliasMapping] values(@vsnetapp, 'Aliases.Default.ini.properties', 'com.nai.Mead.RuleEngine.Messages.IniFixture', 'VirusScanNetApp','')

    declare @access_protection_violation_blocked int;
    declare @access_protection_violation_not_blocked int;
    declare @heuristic_detection_not_removed int;
    declare @heuristic_detection_removed int;
    declare @normal_operation int;
    declare @on_access_disabled int;
    declare @scan_canceled int;
    declare @software_failure_or_error int;
    declare @unknown_category int;
    declare @unwanted_program_not_removed int;
    declare @unwanted_program_removed int;
    declare @update_failed int;
    declare @update_succeeded int;
    declare @virus_detected_not_removed int;
    declare @virus_detected_removed int;

    select @access_protection_violation_blocked     = EventCategoryId from [EventCategory] where [Name]='ACCESS_PROTECTION_VIOLATION_BLOCKED' and [AssociateThreat]=0;
    select @access_protection_violation_not_blocked = EventCategoryId from [EventCategory] where [Name]='ACCESS_PROTECTION_VIOLATION_NOT_BLOCKED' and [AssociateThreat]=0;
    select @heuristic_detection_not_removed         = EventCategoryId from [EventCategory] where [Name]='HEURISTIC_DETECTION_NOT_REMOVED' and [AssociateThreat]=1;
    select @heuristic_detection_removed             = EventCategoryId from [EventCategory] where [Name]='HEURISTIC_DETECTION_REMOVED' and [AssociateThreat]=1;
    select @normal_operation                        = EventCategoryId from [EventCategory] where [Name]='NORMAL_OPERATION' and [AssociateThreat]=0;
    select @normal_operation                        = EventCategoryId from [EventCategory] where [Name]='NORMAL_OPERATION' and [AssociateThreat]=1;
    select @on_access_disabled                      = EventCategoryId from [EventCategory] where [Name]='ON_ACCESS_DISABLED' and [AssociateThreat]=0;
    select @scan_canceled                           = EventCategoryId from [EventCategory] where [Name]='SCAN_CANCELED' and [AssociateThreat]=0;
    select @software_failure_or_error               = EventCategoryId from [EventCategory] where [Name]='SOFTWARE_FAILURE_OR_ERROR' and [AssociateThreat]=0;
    select @unknown_category                        = EventCategoryId from [EventCategory] where [Name]='UNKNOWN_CATEGORY' and [AssociateThreat]=0;
    select @unwanted_program_not_removed            = EventCategoryId from [EventCategory] where [Name]='UNWANTED_PROGRAM_NOT_REMOVED' and [AssociateThreat]=1;
    select @unwanted_program_removed                = EventCategoryId from [EventCategory] where [Name]='UNWANTED_PROGRAM_REMOVED' and [AssociateThreat]=1;
    select @update_failed                           = EventCategoryId from [EventCategory] where [Name]='UPDATE_FAILED' and [AssociateThreat]=0;
    select @update_succeeded                        = EventCategoryId from [EventCategory] where [Name]='UPDATE_SUCCEEDED' and [AssociateThreat]=0;
    select @virus_detected_not_removed              = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_NOT_REMOVED' and [AssociateThreat]=0;
    select @virus_detected_not_removed              = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_NOT_REMOVED' and [AssociateThreat]=1;
    select @virus_detected_removed                  = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_REMOVED' and [AssociateThreat]=0;
    select @virus_detected_removed                  = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_REMOVED' and [AssociateThreat]=1;

    insert into AFToCatMapping values(@vsnetapp, @access_protection_violation_blocked);
    insert into AFToCatMapping values(@vsnetapp, @access_protection_violation_not_blocked);
    insert into AFToCatMapping values(@vsnetapp, @heuristic_detection_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @heuristic_detection_removed);
    insert into AFToCatMapping values(@vsnetapp, @normal_operation);
    insert into AFToCatMapping values(@vsnetapp, @on_access_disabled);
    insert into AFToCatMapping values(@vsnetapp, @scan_canceled);
    insert into AFToCatMapping values(@vsnetapp, @software_failure_or_error);
    insert into AFToCatMapping values(@vsnetapp, @unknown_category);
    insert into AFToCatMapping values(@vsnetapp, @unwanted_program_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @unwanted_program_removed);
    insert into AFToCatMapping values(@vsnetapp, @update_failed);
    insert into AFToCatMapping values(@vsnetapp, @update_succeeded);
    insert into AFToCatMapping values(@vsnetapp, @virus_detected_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @virus_detected_removed);
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 239762
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 250439
------------------------------------------------------------------------
------------------------------------------------------------------------
IF NOT EXISTS( select * from [AlertAliasMapping] where [FirstMarker] = 'VirusScan PDA' )
BEGIN
    declare @vspda int;
    select @vspda = [AlertFamilyId] from [AlertFamily] where [Name] = 'VSPDA'

    insert into [AlertAliasMapping] values(@vspda,
        'Aliases.Default.ini.properties', 'com.nai.Mead.RuleEngine.Messages.IniFixture', 'VirusScan PDA','')
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 250439
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 248853: 32-bit subnets should not be considered valid
------------------------------------------------------------------------
--   Validate an Address (i.e. IP Address).  Returns 1=valid, 0=invalid.
------------------------------------------------------------------------
------------------------------------------------------------------------

if exists (select * from sysobjects where id = object_id(N'[dbo].[sp_IsValidAddress]'))
drop procedure [dbo].[sp_IsValidAddress]

GO

CREATE PROCEDURE dbo.sp_IsValidAddress
(
 @Address NVARCHAR(255),
 @out INT OUTPUT
)
AS
BEGIN

IF (@Address IS NULL)
BEGIN
	SET @out=0
	RETURN
END

IF (LEN(@Address)<7)
BEGIN
	SET @out=0
	RETURN
END


IF (@Address='0.0.0.0')
BEGIN
	SET @out=0
	RETURN
END

-- BZ 248853: 32-bit subnets should not be considered valid
IF (@Address='255.255.255.255')
BEGIN
	SET @out=0
	RETURN
END

-- validate addr
DECLARE @iter INT
DECLARE @i INT
DECLARE @j INT

SET @iter=0
SET @i=1
WHILE (@iter<3)
BEGIN
	SET @j=CHARINDEX('.',@Address,@i)
	if (@j=0)
	BEGIN
		SET @out=0
		RETURN
	END

	SET @i=@j+1
	SET @iter = @iter+1
END -- end while

SET @out=1
RETURN

END -- end fn

GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 248853
------------------------------------------------------------------------
------------------------------------------------------------------------