var g_bModifyExistingUser = false;
var g_szSiteList = "";
var g_szProductList = "";
var g_szSelectedSites = "";
var g_szSelectedProducts = "";
var g_iCurrentUserRole = 0;
var g_iSelectedUserIndex = 0;
var GLOBAL_ADMIN = 1;
var CurrenList = new Array();

function fnInitialize()
{
	g_iCurrentUserRole = window.external.GetUserRole();
	fnLoadRoleListbox();
	fnLoadResources()
	fnLoadValues();
	fnLoadPasswordOptions();
	fnLoadExistingList();
	radioID_EPOUser.click();
}

function fnLoadExistingList()
{
	var szUserListData = window.external.Users_GetList();
	var UserArray = szUserListData.split("|");

	// Users are listed like this: "Name|Role|Site|Name|Role|Site|Name ..."		
	for(var i = 0; i < (UserArray.length / 3); i++)
		CurrenList[i] = UserArray[i * 3];
}

function fnLoadPasswordOptions()
{
	if(g_bModifyExistingUser)
	{
		rowID_ChangePassword.style.display	= "";
		ChangePassword_onClick(true);
	}
}
	
function ChangePassword_onClick(bState)
{
	labelID_Password.disabled = bState;
	labelID_ConfirmPassword.disabled = bState;
	Password.disabled = bState;
	ConfirmPassword.disabled = bState;	
	
	if(bState)
	{
		Password.value = "          ";
		ConfirmPassword.value = "          ";				
	}
	else
	{
		Password.value = "";
		ConfirmPassword.value = "";
	}			
}

function fnLoadRoleListbox()
{
	UserType.length = 0;
	UserType.options[0] = new Option(szRole_Admin, 1);
	UserType.options[1] = new Option(szRole_Reviewer, 0);
	UserType.options[2] = new Option(szRole_SiteAdmin, 1);
	UserType.options[3] = new Option(szRole_SiteReviewer, 0);
}

// Enable the list of sites if a site related role is selected.
// Called when settings are loaded, and by the onChange event of the "UserType" select box.
function fnToggleSiteListState(iIndex)
{
	// 0 and 1 are not site related roles, 2 and 3 ARE..
	
	if(iIndex > 1)
	{
	    if(g_szSiteList == "")
	    {
	        alert(nrc_sz_InfoNoSites);
	        UserType.selectedIndex = g_iSelectedUserIndex;
	        return;
	    }
	    
		SiteLabel.disabled = false;
		spanID_ProductPermissions.disabled = false;
		spanID_SiteSelection.disabled = false;
		spanID_ProductSelection.disabled = false;
		inputcheckboxID_AllSites.disabled = false;
		inputcheckboxID_AllSites.checked = false;

		fnToggleSites(false);
		
		if( (iIndex == 2) || (iIndex == 3) )
		{
			inputcheckboxID_AllProducts.disabled = false;
			inputcheckboxID_AllProducts.checked = false;
			fnToggleProductPermissions(false);
		}
		else
		{
			inputcheckboxID_AllProducts.disabled = true;
			inputcheckboxID_AllProducts.checked = true;
			fnToggleProductPermissions(true);
		}
	}
	else
	{
		SiteLabel.disabled = true; 
		spanID_ProductPermissions.disabled = true;
		spanID_SiteSelection.disabled = true;
		spanID_ProductSelection.disabled = true;
		inputcheckboxID_AllSites.disabled = true;
		inputcheckboxID_AllSites.checked = true;
		inputcheckboxID_AllProducts.disabled = true;
		inputcheckboxID_AllProducts.checked = true;
		fnToggleSites(true);
		fnToggleProductPermissions(true);
	}
	
	g_iSelectedUserIndex = UserType.selectedIndex;
}

function fnToggleSites(bState)
{
    var bOK = (g_szSiteList != "");
    
    tableID_Sites.disabled = bState;
    
    if(bOK)
    {
        var uiNumRows = tableID_Sites.rows.length;

        for(var uiRow=0; uiRow<uiNumRows; uiRow++)
			tableID_Sites.rows(uiRow).cells(0).firstChild.checked = bState;
    }
}

function fnToggleProductPermissions(bState)
{
    var bOK = (g_szProductList != "");
    
    if(bOK)
    {
        var uiNumRows = tableID_Products.rows.length;

        for(var uiRow=0; uiRow<uiNumRows; uiRow++)
        {
			if(tableID_Products.rows(uiRow).cells(0).szRowType == "CHILD_ROW")
			{
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).firstChild.checked = bState;
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).firstChild.disabled = bState;
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(2).firstChild.disabled = bState;
			}
			else if(tableID_Products.rows(uiRow).cells(0).szRowType == "PARENT_ROW")
			{
				tableID_Products.rows(uiRow).cells(0).firstChild.checked = bState;
				tableID_Products.rows(uiRow).cells(0).firstChild.disabled = bState;
			}
			else
			{
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(0).firstChild.checked = bState;
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(0).firstChild.disabled = bState;
				tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).firstChild.disabled = bState;
			}
        }
    }
}

function fnLoadSiteList()
{
	if(g_szSiteList.length == 0)
	{
		var elRow = tableID_Sites.insertRow();
		var elCol = elRow.insertCell();

        elCol.align = "center";
        elCol.disabled = true;		
		elCol.innerText = nrc_sz_NoSites;
		
		return;
	}
		
	// SiteList is an array of site name and ID pairs seperated by commas.
	var SiteList = g_szSiteList.split("|");
		
	// loop to the length minus 1 because of the extra pipe at the end of the list..
	for(var i = 0; i < (SiteList.length - 1); i++)
	{
	    var arraySite =  SiteList[i].split(",");
    	var elRow = tableID_Sites.insertRow();
		var elCol1 = elRow.insertCell();
		var elCol2 = elRow.insertCell();
        var elCheckBox = document.createElement('<input type="checkbox" id="inputcheckboxID_' + arraySite[1] + '" />');
		var elLabel = document.createElement('<label for="inputcheckboxID_' + arraySite[1] + '" />');

		// add site to the list.
		elCol1.iSiteID = arraySite[1];
		elCol1.appendChild(elCheckBox);
		elLabel.innerText = arraySite[0];
		elCol2.appendChild(elLabel);
	}
}

function fnLoadProductList(szUserName)
{
	var g_szSelectedProducts = window.external.Users_GetProductPermissions();
	var bOK = (g_szProductList != "");
	var bSkipUnSelectedProducts = (szUserName != "" ) && (UserType.selectedIndex > 1) && (g_iCurrentUserRole != GLOBAL_ADMIN);

	if(bSkipUnSelectedProducts && g_szSelectedProducts == "")
		bOK = false;

	if(!bOK)
	{
		var elRow = tableID_Products.insertRow();
		var elCol = elRow.insertCell();

        elCol.align = "center";
        elCol.disabled = true;		
		elCol.innerText = nrc_NoProducts;
	}
	
	if(bOK)
	{
		var arrayProducts = g_szProductList.split("|");
		bOK = (arrayProducts.length > 0);
	}
	
	if(bOK)
	{
		for(var uiProduct=0; uiProduct<arrayProducts.length; uiProduct++)
		{
			var arrayProductFeatures = arrayProducts[uiProduct].split(";");
			
			for(var uiProductFeature=0; uiProductFeature<arrayProductFeatures.length; uiProductFeature++)
			{
				var arrayNames = arrayProductFeatures[uiProductFeature].split(",");
				
    			if(bSkipUnSelectedProducts)
    			{
    				var iFound = g_szSelectedProducts.indexOf(arrayNames[0]);
    				
    				if(iFound == -1)
    					continue;
    			}
    			
    			var elRow = tableID_Products.insertRow();
				var elCol1 = elRow.insertCell();
				
				if(uiProductFeature == 0)
				{
					elCol1.szProductID = arrayNames[0];
					
					if(arrayProductFeatures.length > 1)
					{
						var elCheckBox = document.createElement('<mfe:3state_checkbox id="inputcheckboxID_Product' + arrayNames[0] + '" label="' + arrayNames[1] + '" />');

						elCol1.szRowType = "PARENT_ROW";
						elCheckBox.on3statecheckboxclick = fnOnProductClick;
						elCol1.appendChild(elCheckBox);
					}
					else
					{
						var elProductTable = document.createElement("table");
						var elProductRow = elProductTable.insertRow();
						var elProductCol1 = elProductRow.insertCell();
						var elProductCol2 = elProductRow.insertCell();
						var elCheckBox = document.createElement('<input type="checkbox" disabled id="inputcheckboxID_Product' + arrayNames[0] + '" />');
						var elLabel = document.createElement('<label disabled for="inputcheckboxID_Product' + arrayNames[0] + '" />');

						elCol1.szRowType = "ROW_WITH_NO_CHILDREN";
						elProductTable.style.marginLeft = "-2px";
						elProductTable.cellPadding = "0";
						elProductTable.cellSpacing = "0";
						elProductCol1.szProductID = arrayNames[0];
						elProductCol1.appendChild(elCheckBox);
						elLabel.innerText = arrayNames[1];
						elProductCol2.appendChild(elLabel);
						elCol1.appendChild(elProductTable);
					}
				}
				else
				{
					var elTable = document.createElement("table");
					elCol1.appendChild(elTable);
					var elFeatureRow = elTable.insertRow();
					var elIndent = elFeatureRow.insertCell();
					var elFeatureCol1 = elFeatureRow.insertCell();
					var elFeatureCol2 = elFeatureRow.insertCell();
					var elCheckBox = document.createElement('<input type="checkbox" disabled onclick="fnOnFeatureClick()" id="inputcheckboxID_Product' + arrayNames[0] + '" />');
					var elLabel = document.createElement('<label disabled for="inputcheckboxID_Product' + arrayNames[0] + '" />');

					
					elCol1.szRowType = "CHILD_ROW";
					elTable.cellPadding = "0";
					elTable.cellSpacing = "0";
					elIndent.width = "15px";
					elFeatureCol1.szProductID = arrayNames[0];
					elFeatureCol1.appendChild(elCheckBox);
					elLabel.innerText = arrayNames[1];
					elFeatureCol2.appendChild(elLabel);
					
				}
			}
		}
	}
}

function fnOnProductClick()
{
	var uiRowIndex = event.srcElement.parentNode.parentNode.rowIndex + 1;
	var bOK = (uiRowIndex < tableID_Products.rows.length);

	if(bOK)
	{
		var bState = !event.srcElement.checked;
		bOK = tableID_Products.rows(uiRowIndex).cells(0).firstChild.hasChildNodes();
	}
	
	if(bOK)
	{
		for(var uiRow=uiRowIndex; uiRow<tableID_Products.rows.length; uiRow++)
		{
			if(tableID_Products.rows(uiRow).cells(0).firstChild.hasChildNodes())
			{
				var elSubTable = tableID_Products.rows(uiRow).cells(0).firstChild;
				
				if(elSubTable != null)
					elSubTable.rows(0).cells(1).firstChild.checked = event.srcElement.checked;
			}
			else
				break;
		}
	}
}

// Populate the UI if existing data is available.
function fnLoadValues()
{
	var szCurrentUserName = window.external.GetUserName();
	var iCurrentUserRole = window.external.GetUserRole();
	var szUserName = window.external.Users_GetUsername();

	g_szSiteList = window.external.Users_GetSiteList();	// the sitelist. "name,id|name,id|..."
	g_szProductList = window.external.Users_GetProductFeatureList();
	//g_szProductList = "P1,TP1;P1F1,TP1F1|P2,TP2|P3,TP3;P3F1,TP3F1;P3F2,TP3F2|P4,TP4";
    fnLoadSiteList();
    
    fnToggleSiteListState(UserType.selectedIndex);

	if(szUserName == "")
	{
		// New user
		g_bModifyExistingUser = false;
		labelID_Title.innerHTML = szTitleNew;
		fnLoadProductList(szUserName);
	}
	else
	{
		// Existing user
		tableID_NTUser.disabled = true;
		tableID_ePOUser.disabled = true;
		g_bModifyExistingUser = true;
		labelID_Title.innerHTML = szTitleModify;			
		
		DomainName.readOnly = true;
		DomainName.style.backgroundColor = "lightgrey";

		UserName.readOnly = true;
		UserName.style.backgroundColor = "lightgrey";
		
		if(window.external.Users_GetNTUser())
		{
			var arrayUserDomain = szUserName.split("\\");
			DomainName.value = arrayUserDomain[0];
			UserName.value = arrayUserDomain[1];
			radioID_NTUser.checked = true;
		}
		else
		{
			UserName.value = szUserName;
			radioID_EPOUser.checked = true;
		}
		
		fnUserTypeChange();
			
		if((iCurrentUserRole != 1 ) || ( szCurrentUserName.toLowerCase() == szUserName.toLowerCase()))
		{
			tableID_NTUser.disabled = true;
			tableID_ePOUser.disabled = true;
			UserType.readOnly = true;
			UserType.disabled = true;
			UserType.style.backgroundColor = "lightgrey";
			SiteLabel.disabled = true;
			spanID_ProductPermissions.disabled = true;
			spanID_SiteSelection.disabled = true;
			spanID_ProductSelection.disabled = true;
			fnToggleSites(true);
			fnToggleProductPermissions(true);
		}
			
		Password.value = window.external.Users_GetPassword();
		ConfirmPassword.value = Password.value;

		// Retrieve user data and site list
		bWriteAccess = window.external.Users_GetAccess(); 	// is the user an Admin?
		g_szSelectedSites = window.external.Users_GetRootNodes();	// if applicable, the root node id for the user
		//g_szSelectedSites = "Site1";

		if(g_szSelectedSites == "")
		{
			// Global users have no SiteName value
			if (bWriteAccess)
				UserType.selectedIndex = 0;
			else		
				UserType.selectedIndex = 1;
		}
		else
		{
			if(bWriteAccess)
				UserType.selectedIndex = 2;
			else		
				UserType.selectedIndex = 3;
		}

		fnLoadProductList(szUserName);
		
		// Update the site list dropdown state if the user is an admin
		if(iCurrentUserRole == 1)
			fnToggleSiteListState(UserType.selectedIndex);
        
        if(UserType.selectedIndex > 1)
        {
			inputcheckboxID_AllSites.checked = window.external.Users_GetAnySiteFlag();
			inputcheckboxID_AllProducts.checked = window.external.Users_GetAnyProductFlag();
			fnSetSelectSites();
			fnSetSelectProducts();
			
			if(inputcheckboxID_AllSites.checked)
				fnToggleSites(true);
			
			if(inputcheckboxID_AllProducts.checked)
				fnToggleProductPermissions(true);
		}
	}
}

function fnSetSelectSites()
{
    var arraySiteID = g_szSelectedSites.split(",");

    for(var uiSite=0; uiSite<arraySiteID.length; uiSite++)
    {
        var elCheckBox = document.getElementById("inputcheckboxID_" + arraySiteID[uiSite]);
        
        if(elCheckBox != null)
			elCheckBox.checked = true;
	}

}

function fnSetSelectProducts()
{
	var g_szSelectedProducts = window.external.Users_GetProductPermissions();
	//var szSelectedProducts = "P1;P1F1|P2|P3;P3F2";
    var bOK = (g_szSelectedProducts != "");

    if(bOK)
    {
        var arrayProductID = g_szSelectedProducts.split("|");
        bOK = (arrayProductID.length > 0);
    }
    
    if(bOK)
    {
		for(var i=0; i<arrayProductID.length; i++)
		{
			var arrayProductFeatureID = arrayProductID[i].split(";");
			
			for(var j=0; j<arrayProductFeatureID.length; j++)
			{
				var elCheckBox = document.getElementById("inputcheckboxID_Product" + arrayProductFeatureID[j]);
		        
				if(elCheckBox != null)
					elCheckBox.checked = true;
			}
		}
    }
    
    if(bOK)
    {
		var collCheckBox = document.all.urns("User.Edit.3State.CheckBox");
		
		for(var uiCheckBox=0; uiCheckBox<collCheckBox.length; uiCheckBox++)
		{
			var uiRowIndex = collCheckBox.item(uiCheckBox).parentNode.parentNode.rowIndex + 1;
			var uiNumChilren = 0;
			var uiNumSelected = 0;
			
			for(var uiRow=uiRowIndex; uiRow<tableID_Products.rows.length; uiRow++)
			{
				if(tableID_Products.rows(uiRow).cells(0).szRowType == "CHILD_ROW")
				{
					if(tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).firstChild.checked)
						uiNumSelected++;
					
					uiNumChilren++;
				}
				else
					break;
			}

			if(uiNumSelected && uiNumSelected < uiNumChilren)
				collCheckBox.item(uiCheckBox).szState = "NEUTRAL";
		}
    }
}

// Called before values are saved.
function fnValidateInput()
{
	// Verify username is valid
	if(UserName.value == "")
	{
		alert(sz_errMissingUsername);
		return false;
	}
			
	// Verify that the value is not all spaces.
	var iSpaceCount = 0;
	
	for(var i = 0; i < UserName.value.length; i++)
	{
		if(UserName.value.charAt(i) == " ")
			iSpaceCount++;
	}
	
	if(iSpaceCount == UserName.value.length)
	{
		alert(sz_errNameIsAllSpaces);
		return false;
	}
					  
	var szBadChars = ":\\\"`!@#$%^&*/=;,<>?|";
		
	for(var i = 0; i < szBadChars.length; i++)
	{
		if(UserName.value.indexOf( szBadChars.charAt(i) ) != -1)
		{
			alert(sz_errBadCharactersInUsername);
			return false;
		}
	}

	if(!g_bModifyExistingUser)
	{
		for(var i = 0; i < CurrenList.length; i++)
		{
			if(radioID_NTUser.checked)
				var szUser = DomainName.value.toLowerCase() + "\\" + UserName.value.toLowerCase();
			else
				var szUser = UserName.value.toLowerCase();
			
			if(CurrenList[i].toLowerCase() == szUser)
			{
				alert(sz_errUsernameAlreadyExists);
				return false;
			}
		}
	}
	
	if((bID_ChangePassword.checked || !g_bModifyExistingUser) && radioID_EPOUser.checked)
	{
		// Verify that the passwords match.
		if (Password.value != ConfirmPassword.value)
		{
			alert(sz_errMismatchedPasswords);
			return false;
		}
		// Verify that the passwords are not blank
		if(Password.value == "")
		{
			alert(sz_errBlankPassword);
			return false;
		}
		
		// Spaces are now allowed - bz 190431
		/*
		// Verify that the password does not contain spaces.
		if (Password.value.indexOf(" ") != -1)
			{
				alert(sz_errNoSpacesInPassword);
				return false;
			}
		*/

		// Verify that the password is not "admin"
		if(Password.value.toLowerCase() == "admin")
		{
			alert(sz_errCantUseAdminPassword);
			return false;
		}
	}
	
	if(UserType.selectedIndex > 1 && fnGetSelectedSites() == "")
	{
	    alert(nrc_sz_NoSelectedSites);
	    return false;
	}
			
	return true;
}

// Called from the onClick event of the save button.
function Save_OnClick()
{
	// return if validation fails.
	if(!fnValidateInput())
		return;

	if(g_iCurrentUserRole == GLOBAL_ADMIN)
	{ 
		if(!g_bModifyExistingUser)
		{
			if(radioID_EPOUser.checked)
			{
				window.external.Users_SetNTUser(false);
				window.external.Users_SetUsername(UserName.value);
			}
			else
			{
				window.external.Users_SetNTUser(true);
				window.external.Users_SetUsername(DomainName.value + "\\" + UserName.value);
			}
		}
		
		window.external.Users_SetAccess(UserType.value);
		
		if(UserType.selectedIndex > 1)
		{
			if(inputcheckboxID_AllSites.checked)
				window.external.Users_SetAnySiteFlag(true);
			else
			{
				window.external.Users_SetAnySiteFlag(false);
				window.external.Users_SetRootNodes(fnGetSelectedSites());
			}
			
			if(inputcheckboxID_AllProducts.checked)
				window.external.Users_SetAnyProductFlag(true);
			else
			{
				window.external.Users_SetAnyProductFlag(false);
				window.external.Users_SetProductPermissions(fnGetSelectedProducts());
			}
		}
		else
			window.external.Users_SetRootNodes("");
	}
		
	if(bID_ChangePassword.checked || !g_bModifyExistingUser)
	{
		if(radioID_EPOUser.checked)
			window.external.Users_SetPassword(Password.value);
		else
			window.external.Users_SetPassword("");
	}
	
	if(g_bModifyExistingUser)
	{
		// Users_Update should not be called by non-admins if the password doesn't change.
		if(g_iCurrentUserRole == GLOBAL_ADMIN)
			window.external.Users_Update();
		else if(bID_ChangePassword.checked)
			window.external.Users_Update();
		else
			window.external.Task_Cancel();
	}
	else
		window.external.Users_Save();
}

function fnGetSelectedSites()
{
    var szSelectedSites = "";
    
    for(var uiRow=0; uiRow<tableID_Sites.rows.length; uiRow++)
    {
        if(tableID_Sites.rows(uiRow).cells(0).firstChild.checked)
        {
            if(szSelectedSites.length > 0)
                szSelectedSites += ",";
            
            szSelectedSites += tableID_Sites.rows(uiRow).cells(0).iSiteID;
        }
    }

    return szSelectedSites;
}

function fnGetSelectedProducts()
{
	var szSelectedProducts = "";

    for(var uiRow=0; uiRow<tableID_Products.rows.length; uiRow++)
    {
        if(tableID_Products.rows(uiRow).cells(0).szRowType == "CHILD_ROW")
        {
			if(tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).firstChild.checked)
			{
				if(szSelectedProducts.length > 0)
					szSelectedProducts += ";";
				
				szSelectedProducts += tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(1).szProductID;
			}
		}
		else if(tableID_Products.rows(uiRow).cells(0).szRowType == "PARENT_ROW")
		{
			if(tableID_Products.rows(uiRow).cells(0).firstChild.checked)
			{
				if(szSelectedProducts.length > 0)
					szSelectedProducts += "|";
				
				szSelectedProducts += tableID_Products.rows(uiRow).cells(0).szProductID;
			}
		}
		else
		{
			if(tableID_Products.rows(uiRow).cells(0).firstChild.rows(0).cells(0).firstChild.checked)
			{
				if(szSelectedProducts.length > 0)
					szSelectedProducts += "|";
				
				szSelectedProducts += tableID_Products.rows(uiRow).cells(0).szProductID;
			}
        }
    }

	return szSelectedProducts;
}

function Users_DisplayHelp()
{
	if(g_bModifyExistingUser)
		window.external.DisplayHelp("Edit_Account_Information_window.html");
	else
		window.external.DisplayHelp("Add_Administrator_window.html");
}

function fnLoadResources()
{
	UserNameLabel.innerHTML = nrc_sz_UserName;
	UserTypeLabel.innerHTML = nrc_sz_UserRole;
	SiteLabel.innerHTML = nrc_sz_UserSite;
	spanID_SiteSelection.innerText = nrc_sz_AnySites;
	spanID_ProductSelection.innerText = nrc_sz_AnyProducts;
	labelID_Password.innerHTML = nrc_sz_UserPassword;
	labelID_ConfirmPassword.innerHTML = nrc_sz_UserConfirmPassword;
	labelID_UserDetails.innerHTML = nrc_sz_UserDetails;
	labelID_ChangePassword.innerHTML = nrc_sz_ChangePassword;
	btnSave.szCaption = nrc_sz_UserSave;
	btnCancel.szCaption = nrc_sz_UserCancel;
	btnHelp.szCaption = nrc_sz_UserHelp;
	spanID_ProductPermissions.innerText = nrc_ProductPermissions;
	labelID_NTAuth.innerText = nrc_NTAuth;
	btnID_Verify.value = nrc_Verify;
	labelID_ePOAuth.innerText = nrc_ePOAuth;
	DomainNameLabel.innerText = nrc_Domain;
	
	spanID_ProductSelection.innerText = nrc_sz_AnyProductCheckbox;
	spanID_SiteSelection.innerText = nrc_sz_AnySitesCheckbox;
}

function fnToggleProductScroll()
{
	if(event.srcElement.checked)
	{
		divID_Products.style.height = "100%";
		divID_Products.style.overflowY = "hidden";
	}
	else
	{
		divID_Products.style.height = "120px";
		divID_Products.style.overflowY = "auto";
	}
}

function fnUserTypeChange()
{
	var bState = radioID_NTUser.checked;

	btnID_Verify.disabled = !bState;
	DomainNameLabel.disabled = !bState;
	DomainName.disabled = !bState;
	labelID_Password.disabled = bState;
	Password.disabled = bState;
	labelID_ConfirmPassword.disabled = bState;
	ConfirmPassword.disabled = bState;
	bID_ChangePassword.disabled = bState;
	labelID_ChangePassword.disabled = bState;
}

function fnVerify()
{
	var arrayArgument = new Array();
	
	arrayArgument[0] = DomainName.value;
	arrayArgument[1] = UserName.value;
	arrayArgument[3] = "";
	
	var dwError = showModalDialog("EPO360_VerifyNTUser.htm", arrayArgument, "dialogHeight:140px;dialogWidth:300px;help:no;status:no");
	var bOK = (dwError == 0);
	
	if(bOK)
	{
		bOK = window.external.Users_NTVerify(DomainName.value, UserName.value, arrayArgument[3]);

		if(bOK)
			alert(nrc_VerifySuccess);
		else
			alert(nrc_VerifyFail);
	}
}

function fnOnFeatureClick()
{
	var uiUpperRowIndex = event.srcElement.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.rowIndex - 1;
	var uiLowerRowIndex = event.srcElement.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.rowIndex + 1;
	var bAllUpperSelected = true;
	var bAllLowerSelected = true;
	var bPartialUpperSelected = event.srcElement.checked;
	var bPartialLowerSelected = event.srcElement.checked;

	for(var uiRow=uiUpperRowIndex; uiRow >= 0; uiRow--)
	{
		if(tableID_Products.rows(uiRow).cells(0).szRowType == "CHILD_ROW")
		{
			var elSubTable = tableID_Products.rows(uiRow).cells(0).firstChild;
			
			if(!elSubTable.rows(0).cells(1).firstChild.checked)
				bAllUpperSelected =  false;
			else
				bPartialUpperSelected = true;
		}
		else
		{
			var el3StateCheckBox = tableID_Products.rows(uiRow).cells(0).firstChild;
			break;
		}
	}

	for(var uiRow=uiLowerRowIndex; uiRow < tableID_Products.rows.length; uiRow++)
	{
		if(tableID_Products.rows(uiRow).cells(0).szRowType == "CHILD_ROW")
		{
			var elSubTable = tableID_Products.rows(uiRow).cells(0).firstChild;
			
			if(!elSubTable.rows(0).cells(1).firstChild.checked)
				bAllLowerSelected =  false;
			else
				bPartialLowerSelected = true;
		}
		else
			break;
	}
	
	if(bAllUpperSelected && bAllLowerSelected && event.srcElement.checked)
	{
		el3StateCheckBox.checked = true;
		el3StateCheckBox.szState = "ON";
	}
	else if(bPartialUpperSelected || bPartialLowerSelected || event.srcElement.checked)
	{
		el3StateCheckBox.checked = true;
		el3StateCheckBox.szState = "NEUTRAL";
	}
	else
	{
		el3StateCheckBox.checked = false;
		el3StateCheckBox.szState = "OFF";
	}
}