/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.action.concrete;

import com.mcafee.epo.common.db.epo.EpoHost;
import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionEnvironment;
import com.mcafee.epo.compliance.action.ActionImplBase;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.db.Parameterizer.ParamPropertyException;
import com.mcafee.epo.compliance.db.epo.EpoHostUtil;
import com.mcafee.epo.compliance.db.epo.EpoTask;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DeploySensorAction
extends ActionImplBase {
    private Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$action$concrete$DeploySensorAction == null ? (class$com$mcafee$epo$compliance$action$concrete$DeploySensorAction = DeploySensorAction.class$("com.mcafee.epo.compliance.action.concrete.DeploySensorAction")) : class$com$mcafee$epo$compliance$action$concrete$DeploySensorAction));
    static /* synthetic */ Class class$com$mcafee$epo$compliance$action$concrete$DeploySensorAction;

    public boolean showInActionList() {
        return true;
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        this.m_log.debug((Object)"Invoking DeploySensorAction.");
        Connection connection = null;
        ActionEnvironment actionEnvironment = ActionEnvironment.instance();
        try {
            try {
                this.m_log.debug((Object)"Getting compliance and ePO database connections.");
                connection = actionEnvironment.getEPODbConnection();
                Configuration configuration = actionEnvironment.getConfiguration();
                this.m_log.debug((Object)"Creating the ePO task.");
                EpoTask epoTask = new EpoTask(Server.getLocalHostName(), Server.getTomcatPort(), configuration.getSensorInstallDir());
                Integer n = (Integer)actionContext.getParamProperty("EPOLeafNodeId");
                String string = (String)actionContext.getParamProperty("EPOHostName");
                if (n == null || string == null) {
                    throw new ActionInvocationException("No leafnode ID or hostname.");
                }
                actionStatus.setActionDetail(string);
                this.m_log.debug((Object)("Setting the target leafNode for the task to host: " + string));
                epoTask.setLeafNodeID(n);
                this.pushSensor(connection, epoTask, actionStatus);
            }
            catch (SQLException sQLException) {
                throw new ActionInvocationException(sQLException);
            }
            catch (ParamPropertyException paramPropertyException) {
                throw new ActionInvocationException(paramPropertyException);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return -1;
    }

    private void pushSensor(Connection connection, EpoTask epoTask, ActionStatus actionStatus) throws SQLException {
        String string = "";
        this.m_log.debug((Object)"Setting up the push sensor task.");
        epoTask.add(connection);
        connection.commit();
        EpoHost epoHost = EpoHostUtil.getByLeafNodeID(connection, epoTask.getLeafNodeID());
        string = epoHost.getAgentGUID();
        actionStatus.setEndKey(string);
    }

    public String getType() {
        return "deploy_sensor";
    }

    public int getNumProperties() {
        return 0;
    }

    public String getPropertyName(int n) {
        return null;
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_sensor_install";
    }

    public boolean appliesToStatus(int n) {
        switch (n) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

