/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.content.certificates;

import com.mcafee.epo.common.policy.db.PolicyObject;
import com.mcafee.epo.common.policy.db.PolicySettingValues;
import com.mcafee.epo.common.policy.db.PolicySettings;
import com.mcafee.epo.compliance.db.policymgt.ClientDefaultPolicy;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CertificateValidator {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$content$certificates$CertificateValidator == null ? (class$com$mcafee$epo$compliance$content$certificates$CertificateValidator = CertificateValidator.class$("com.mcafee.epo.compliance.content.certificates.CertificateValidator")) : class$com$mcafee$epo$compliance$content$certificates$CertificateValidator));
    public static final String DEFAULT_ROOT_CERT_NAME = "root.pem";
    public static final String DEFAULT_KEY_CERT_NAME = "key.pem";
    public static final String DEFAULT_SENSOR_CERT_NAME = "sensor.pem";
    public static final String DEFAULT_POLICY_NAME = "SSLCertsPolicy";
    String m_rootCert;
    String m_keyCert;
    String m_sensorCert;
    private static final CertificateValidator m_singleton = new CertificateValidator();
    static /* synthetic */ Class class$com$mcafee$epo$compliance$content$certificates$CertificateValidator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncCertificates(Database database, String string, String string2, boolean bl) throws IOException, SQLException {
        CertificateValidator certificateValidator = m_singleton;
        synchronized (certificateValidator) {
            Connection connection = null;
            try {
                connection = database.getConnection();
                m_singleton.loadFromBasePath(string);
                m_singleton.doChecks(connection, string2, bl);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
        }
    }

    public CertificateValidator() {
    }

    public CertificateValidator(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        this.m_rootCert = stringBuffer.toString();
        this.m_keyCert = stringBuffer2.toString();
        this.m_sensorCert = stringBuffer3.toString();
    }

    private void loadFromBasePath(String string) throws IOException {
        if (!string.endsWith("\\")) {
            string = string + "\\";
        }
        String string2 = string + DEFAULT_ROOT_CERT_NAME;
        String string3 = string + DEFAULT_KEY_CERT_NAME;
        String string4 = string + DEFAULT_SENSOR_CERT_NAME;
        this.loadFiles(string2, string3, string4);
    }

    public CertificateValidator(String string) throws IOException {
        this.loadFromBasePath(string);
    }

    public CertificateValidator(String string, String string2, String string3, String string4) throws IOException {
        if (!string.endsWith("\\")) {
            string = string + "\\";
        }
        String string5 = string + string2;
        String string6 = string + string3;
        String string7 = string + string4;
        this.loadFiles(string5, string6, string7);
    }

    public CertificateValidator(String string, String string2, String string3) throws IOException {
        this.loadFiles(string, string2, string3);
    }

    private void loadFiles(String string, String string2, String string3) throws IOException {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Loading certificate files from disk: " + string + ", " + string2 + ", " + string3));
        }
        FileReader fileReader = new FileReader(string);
        FileReader fileReader2 = new FileReader(string2);
        FileReader fileReader3 = new FileReader(string3);
        this.m_rootCert = this.readIn(fileReader);
        this.m_keyCert = this.readIn(fileReader2);
        this.m_sensorCert = this.readIn(fileReader3);
    }

    private String readIn(FileReader fileReader) throws IOException {
        int n = 0;
        int n2 = 512;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while ((n = fileReader.read(cArray, 0, n2)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public void doChecks(Connection connection, String string, boolean bl) throws SQLException {
        m_log.debug((Object)("Validating certificates on disk against the database for software ID:" + string));
        ClientDefaultPolicy clientDefaultPolicy = ClientDefaultPolicy.getDefaultPolicy(connection, string, DEFAULT_POLICY_NAME, bl);
        if (clientDefaultPolicy == null) {
            throw new SQLException("Failed to find the default policy for software ID: " + string);
        }
        if (!this.validate(clientDefaultPolicy.getAllSettingValues(connection))) {
            m_log.debug((Object)("The certificates in the DB did not match those on disk.  Updating the policy settings for: " + string));
            this.update(clientDefaultPolicy, connection);
        }
    }

    public final boolean validate(PolicySettingValues[] policySettingValuesArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < policySettingValuesArray.length) {
            String string = policySettingValuesArray[n].getSectionName();
            if (string.equals("Security")) {
                String string2 = policySettingValuesArray[n].getSettingName();
                String string3 = policySettingValuesArray[n].getSettingValue();
                if (string2.equalsIgnoreCase("RootCert")) {
                    bl = string3.equals(this.m_rootCert);
                    m_log.debug((Object)("RootCert match: " + bl));
                } else if (string2.equalsIgnoreCase("SensorCert")) {
                    bl2 = string3.equals(this.m_sensorCert);
                    m_log.debug((Object)("SensorCert match: " + bl2));
                } else if (string2.equalsIgnoreCase("PrivateKey")) {
                    bl3 = string3.equals(this.m_keyCert);
                    m_log.debug((Object)("KeyCert match: " + bl3));
                }
            }
            ++n;
        }
        return bl && bl2 && bl3;
    }

    public void update(ClientDefaultPolicy clientDefaultPolicy, Connection connection) throws SQLException {
        PolicySettings policySettings;
        m_log.debug((Object)"Updating the certificate values in the DB.");
        PolicySettings[] policySettingsArray = clientDefaultPolicy.getPolicySettings(connection, null, null);
        m_log.debug((Object)("Found " + policySettingsArray.length + " policy settings objects."));
        if (policySettingsArray.length > 1) {
            throw new SQLException("Too many policy settings found.");
        }
        if (policySettingsArray.length == 0) {
            m_log.debug((Object)"No policy settings found, creating a policy settings object.");
            policySettings = new PolicySettings();
            policySettings.setName("GloablDefault");
            policySettings.setParamInt(null);
            policySettings.setParamStr(null);
            policySettings.setTypeID(clientDefaultPolicy.getTypeID());
            policySettings.add(connection, 0);
            policySettings.assignToPolicyObject(connection, (PolicyObject)clientDefaultPolicy, 0);
        } else {
            policySettings = policySettingsArray[0];
        }
        policySettings.addSettingValue(connection, 0, "Security", "RootCert", this.m_rootCert);
        policySettings.addSettingValue(connection, 0, "Security", "SensorCert", this.m_sensorCert);
        policySettings.addSettingValue(connection, 0, "Security", "PrivateKey", this.m_keyCert);
        m_log.debug((Object)"Certificate settings added.");
        connection.commit();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

