/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.event;

import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.event.EventImplBase;
import com.mcafee.epo.compliance.event.concrete.NewRogueHostEvent;
import com.mcafee.epo.compliance.event.concrete.SubnetUncoveredEvent;
import com.mcafee.epo.compliance.event.concrete.UserRequestEvent;
import java.sql.Connection;
import java.sql.SQLException;

public class EventFactory {
    public static SubnetUncoveredEvent createSubnetUncoveredEvent(Network network) {
        return new SubnetUncoveredEvent(network);
    }

    public static SubnetUncoveredEvent createSubnetUncoveredEvent(Connection connection, Network network) throws SQLException {
        SubnetUncoveredEvent subnetUncoveredEvent = new SubnetUncoveredEvent(network);
        EventFactory.addEventToDb(connection, subnetUncoveredEvent);
        return subnetUncoveredEvent;
    }

    public static NewRogueHostEvent createNewRogueHostEvent(Host host, Network network, Sensor sensor) {
        NewRogueHostEvent newRogueHostEvent = new NewRogueHostEvent();
        newRogueHostEvent.setHNS(host, network, sensor);
        return newRogueHostEvent;
    }

    public static NewRogueHostEvent createNewRogueHostEvent(Connection connection, Host host, Network network, Sensor sensor) throws SQLException {
        NewRogueHostEvent newRogueHostEvent = new NewRogueHostEvent();
        newRogueHostEvent.setHNS(host, network, sensor);
        EventFactory.addEventToDb(connection, newRogueHostEvent);
        return newRogueHostEvent;
    }

    public static UserRequestEvent createUserRequestEvent(Host host, Network network, Sensor sensor) {
        UserRequestEvent userRequestEvent = new UserRequestEvent();
        userRequestEvent.setHNS(host, network, sensor);
        return userRequestEvent;
    }

    public static UserRequestEvent createUserRequestEvent(Connection connection, Host host, Network network, Sensor sensor) throws SQLException {
        UserRequestEvent userRequestEvent = new UserRequestEvent();
        userRequestEvent.setHNS(host, network, sensor);
        EventFactory.addEventToDb(connection, userRequestEvent);
        return userRequestEvent;
    }

    public static UserRequestEvent createUserRequestEvent(Connection connection) throws SQLException {
        return EventFactory.createUserRequestEvent(connection, null, null, null);
    }

    private static void addEventToDb(Connection connection, EventImplBase eventImplBase) throws SQLException {
        eventImplBase.add(connection, true);
        connection.commit();
    }
}

