/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.message;

import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.message.HostDetectedMessage;
import com.mcafee.epo.compliance.message.MessageParserException;
import com.mcafee.epo.compliance.util.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageParser {
    public static final int VALIDATION_LAX = 1;
    public static final int VALIDATION_NORMAL = 2;

    public static HostDetectedMessage parseEvent(InputStream inputStream, int n) throws SAXException, IOException, ParserConfigurationException, MessageParserException {
        HostDetectedMessage hostDetectedMessage = new HostDetectedMessage();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.newSAXParser().parse(inputStream, (DefaultHandler)hostDetectedMessage);
        if (n != 1) {
            MessageParser.validateData(hostDetectedMessage);
        }
        return hostDetectedMessage;
    }

    public static HostDetectedMessage parseEvent(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, MessageParserException {
        return MessageParser.parseEvent(inputStream, 2);
    }

    public static void validateData(HostDetectedMessage hostDetectedMessage) throws MessageParserException {
        Sensor sensor = hostDetectedMessage.getSensor();
        Network network = hostDetectedMessage.getNetwork();
        if (sensor.getLastCommunicationTime() == null) {
            throw new MessageParserException(Resource.getString("messageparser_missing_comm_time"));
        }
        if (network.getNetworkAddress().length() == 0) {
            throw new MessageParserException(Resource.getString("messageparser_missing_sensor_address"));
        }
        if (network.getSubnetMask().length() == 0) {
            throw new MessageParserException(Resource.getString("messageparser_missing_sensor_subnet_mask"));
        }
        if (sensor.isMacDefault()) {
            throw new MessageParserException(Resource.getString("messageparser_missing_sensor_mac"));
        }
        if (sensor.getIpAddress().length() == 0) {
            throw new MessageParserException(Resource.getString("messageparser_missing_sensor_ip"));
        }
        if (sensor.getSensorName().length() == 0) {
            throw new MessageParserException(Resource.getString("messageparser_missing_sensor_hostname"));
        }
    }

    public static HostDetectedMessage parseEvent(String string) throws SAXException, IOException, ParserConfigurationException, MessageParserException {
        return MessageParser.parseEvent(new ByteArrayInputStream(string.getBytes()));
    }

    public static HostDetectedMessage parseEvent(String string, int n) throws SAXException, IOException, ParserConfigurationException, MessageParserException {
        return MessageParser.parseEvent(new ByteArrayInputStream(string.getBytes()), n);
    }
}

