/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.server;

import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.QueryUtil;
import com.mcafee.epo.compliance.event.EventDispatcher;
import com.mcafee.epo.compliance.event.EventFactory;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.compliance.util.thread.PeriodicTask;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class SubnetEventGenerator
extends PeriodicTask {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$server$SubnetEventGenerator == null ? (class$com$mcafee$epo$compliance$server$SubnetEventGenerator = SubnetEventGenerator.class$("com.mcafee.epo.compliance.server.SubnetEventGenerator")) : class$com$mcafee$epo$compliance$server$SubnetEventGenerator).getName());
    private long m_sensorTimeoutInMilli = 0L;
    private EventDispatcher m_eventDispatcher = null;
    private Database m_db = null;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$server$SubnetEventGenerator;

    public String name() {
        return "Uncovered Subnet Event Generator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTask() {
        Connection connection = null;
        try {
            try {
                String string = "select * from Networks as N " + QueryUtil.makeSubnetWhereClause(4, this.getSensorTimeoutInMilliSecs()) + " and Covered=1 ";
                connection = this.m_db.getConnection();
                Network[] networkArray = Network.getByQuery(connection, string);
                int n = 0;
                while (n < networkArray.length) {
                    Network.updateCoveredStatus(connection, networkArray[n].getId(), false);
                    connection.commit();
                    if (this.m_eventDispatcher != null) {
                        this.m_eventDispatcher.addEvent(EventFactory.createSubnetUncoveredEvent(connection, networkArray[n]));
                    }
                    m_log.info((Object)Resource.formatString("subnet_event_gen__create_event", networkArray[n].getAddressAndMask()));
                    ++n;
                }
            }
            catch (Exception exception) {
                DatabaseUtil.rollback(connection);
                m_log.error((Object)Resource.getString("subnet_event_gen__create_event_error"));
                m_log.error((Object)exception);
                Object var6_7 = null;
                DatabaseUtil.close(connection);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public synchronized void setServerInfo(long l, EventDispatcher eventDispatcher, Database database) {
        this.m_sensorTimeoutInMilli = l;
        this.m_eventDispatcher = eventDispatcher;
        this.m_db = database;
    }

    public synchronized long getSensorTimeoutInMilliSecs() {
        return this.m_sensorTimeoutInMilli;
    }

    public synchronized void setSensorTimeoutInMilliSecs(long l) {
        this.m_sensorTimeoutInMilli = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

