/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui.util;

import com.mcafee.epo.compliance.util.Resource;
import java.util.ArrayList;
import java.util.Arrays;

public class NagBean {
    private int m_rogueCount = 0;
    private int m_roguePercent = 0;
    private int m_exceptionCount = 0;
    private int m_exceptionPercent = 0;
    private int m_managedCount = 0;
    private int m_managedPercent = 0;
    private int m_inactiveCount = 0;
    private int m_inactivePercent = 0;
    private int m_coveredSubnetCount = 0;
    private int m_coveredSubnetPercent = 0;
    private int m_uncoveredSubnetCount = 0;
    private int m_uncoveredSubnetPercent = 0;
    private String m_languageId = null;

    public void setLanguageId(String string) {
        this.m_languageId = string;
    }

    public String getLanguageId() {
        return this.m_languageId;
    }

    public int getRogueCount() {
        return this.m_rogueCount;
    }

    public void setRogueCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_rouge_count", this.m_languageId));
        }
        this.m_rogueCount = n;
        this.calcMachinePercentages();
    }

    public int getExceptionCount() {
        return this.m_exceptionCount;
    }

    public void setExceptionCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_exception_count", this.m_languageId));
        }
        this.m_exceptionCount = n;
        this.calcMachinePercentages();
    }

    public int getManagedCount() {
        return this.m_managedCount;
    }

    public void setManagedCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_managed_count", this.m_languageId));
        }
        this.m_managedCount = n;
        this.calcMachinePercentages();
    }

    public int getInactiveCount() {
        return this.m_inactiveCount;
    }

    public void setInactiveCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_inactive_count", this.m_languageId));
        }
        this.m_inactiveCount = n;
        this.calcMachinePercentages();
    }

    public int getCoveredSubnetCount() {
        return this.m_coveredSubnetCount;
    }

    public void setCoveredSubnetCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_covered_count", this.m_languageId));
        }
        this.m_coveredSubnetCount = n;
        this.calcSubnetPercentages();
    }

    public int getUncoveredSubnetCount() {
        return this.m_uncoveredSubnetCount;
    }

    public void setUncoveredSubnetCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_uncovered_count", this.m_languageId));
        }
        this.m_uncoveredSubnetCount = n;
        this.calcSubnetPercentages();
    }

    public int getRoguePercent() {
        return this.m_roguePercent;
    }

    public int getExceptionPercent() {
        return this.m_exceptionPercent;
    }

    public int getManagedPercent() {
        return this.m_managedPercent;
    }

    public int getInactivePercent() {
        return this.m_inactivePercent;
    }

    public int getTotalMachineCount() {
        return this.m_rogueCount + this.m_exceptionCount + this.m_managedCount + this.m_inactiveCount;
    }

    public int getCoveredSubnetPercent() {
        return this.m_coveredSubnetPercent;
    }

    public int getUncoveredSubnetPercent() {
        return this.m_uncoveredSubnetPercent;
    }

    public int getTotalSubnetCount() {
        return this.m_coveredSubnetCount + this.m_uncoveredSubnetCount;
    }

    private void calcMachinePercentages() {
        double d = 0.0;
        double d2 = this.m_rogueCount + this.m_exceptionCount + this.m_managedCount + this.m_inactiveCount;
        this.m_inactivePercent = 0;
        this.m_managedPercent = 0;
        this.m_exceptionPercent = 0;
        this.m_roguePercent = 0;
        double d3 = d2 != 0.0 ? (double)(this.m_rogueCount * 100) / d2 : 0.0;
        double d4 = d2 != 0.0 ? (double)(this.m_exceptionCount * 100) / d2 : 0.0;
        double d5 = d2 != 0.0 ? (double)(this.m_inactiveCount * 100) / d2 : 0.0;
        double d6 = d2 != 0.0 ? (double)(this.m_managedCount * 100) / d2 : 0.0;
        PercentManager percentManager = new PercentManager(2, (int)d3);
        PercentManager percentManager2 = new PercentManager(0, (int)d4);
        PercentManager percentManager3 = new PercentManager(1, (int)d5);
        PercentManager percentManager4 = new PercentManager(3, (int)d6);
        d = d3 - (double)percentManager.value();
        d += d4 - (double)percentManager2.value();
        d += d5 - (double)percentManager3.value();
        d += d6 - (double)percentManager4.value();
        ArrayList<PercentManager> arrayList = new ArrayList<PercentManager>();
        if (percentManager.value() != 0) {
            arrayList.add(percentManager);
        }
        if (percentManager2.value() != 0) {
            arrayList.add(percentManager2);
        }
        if (percentManager3.value() != 0) {
            arrayList.add(percentManager3);
        }
        if (percentManager4.value() != 0) {
            arrayList.add(percentManager4);
        }
        Object[] objectArray = this.recalcWithRound(arrayList, d);
        int n = 0;
        while (n < objectArray.length) {
            PercentManager percentManager5 = (PercentManager)objectArray[n];
            switch (percentManager5.getStatus()) {
                case 2: {
                    this.m_roguePercent = percentManager5.value();
                    break;
                }
                case 0: {
                    this.m_exceptionPercent = percentManager5.value();
                    break;
                }
                case 1: {
                    this.m_inactivePercent = percentManager5.value();
                    break;
                }
                case 3: {
                    this.m_managedPercent = percentManager5.value();
                }
            }
            ++n;
        }
    }

    private Object[] recalcWithRound(ArrayList arrayList, double d) {
        int n = (int)Math.round(d);
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        if (n >= 1) {
            int n2 = objectArray.length;
            while (n > 0) {
                ((PercentManager)objectArray[--n2]).increment();
                --n;
                if (n2 != 0) continue;
                n2 = objectArray.length;
            }
        }
        return objectArray;
    }

    private void calcSubnetPercentages() {
        double d = 0.0;
        double d2 = this.m_coveredSubnetCount + this.m_uncoveredSubnetCount;
        this.m_uncoveredSubnetPercent = 0;
        this.m_coveredSubnetPercent = 0;
        double d3 = d2 != 0.0 ? (double)(this.m_uncoveredSubnetCount * 100) / d2 : 0.0;
        double d4 = d2 != 0.0 ? (double)(this.m_coveredSubnetCount * 100) / d2 : 0.0;
        PercentManager percentManager = new PercentManager(1, (int)d3);
        PercentManager percentManager2 = new PercentManager(0, (int)d4);
        d = d3 - (double)percentManager.value();
        d += d4 - (double)percentManager2.value();
        ArrayList<PercentManager> arrayList = new ArrayList<PercentManager>();
        if (percentManager.value() != 0) {
            arrayList.add(percentManager);
        }
        if (percentManager2.value() != 0) {
            arrayList.add(percentManager2);
        }
        Object[] objectArray = this.recalcWithRound(arrayList, d);
        int n = 0;
        while (n < objectArray.length) {
            PercentManager percentManager3 = (PercentManager)objectArray[n];
            switch (percentManager3.getStatus()) {
                case 1: {
                    this.m_uncoveredSubnetPercent = percentManager3.value();
                    break;
                }
                case 0: {
                    this.m_coveredSubnetPercent = percentManager3.value();
                }
            }
            ++n;
        }
    }

    private class PercentManager
    implements Comparable {
        private int m_value;
        private int m_status;

        public PercentManager(int n, int n2) {
            this.m_status = n;
            this.m_value = n2;
        }

        public int compareTo(Object object) {
            PercentManager percentManager = (PercentManager)object;
            return this.m_value - percentManager.m_value;
        }

        public int value() {
            return this.m_value;
        }

        public void increment() {
            ++this.m_value;
        }

        public int getStatus() {
            return this.m_status;
        }

        public String toString() {
            return Integer.toString(this.m_value);
        }
    }
}

