/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.db;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SettingsTable
extends DatabaseObject {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$common$db$SettingsTable == null ? (class$com$mcafee$epo$common$db$SettingsTable = SettingsTable.class$("com.mcafee.epo.common.db.SettingsTable")) : class$com$mcafee$epo$common$db$SettingsTable));
    public static final int BASE_NUM_COLUMNS = 2;
    private HashMap m_settings = new HashMap();
    protected Iterator m_addIterator;
    static /* synthetic */ Class class$com$mcafee$epo$common$db$SettingsTable;

    protected abstract String getTable();

    protected abstract String getClearSql();

    public abstract String[] getPropertyNames();

    public abstract void setAdditionalValues(ResultSet var1) throws SQLException;

    public abstract int getNameCol();

    public abstract int getValueCol();

    public abstract int getNameColLength();

    public abstract int getValueColLength();

    public SettingsTable() {
        this.setupPropertyNames();
    }

    protected void setupPropertyNames() {
        String[] stringArray = this.getPropertyNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.m_settings.put(stringArray[n], null);
                ++n;
            }
        }
    }

    protected void initDefaultValues(String[] stringArray) {
        String[] stringArray2 = this.getPropertyNames();
        int n = 0;
        while (n < stringArray2.length) {
            this.setProperty(stringArray2[n], stringArray[n]);
            ++n;
        }
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        do {
            String string = resultSet.getString(this.getNameCol());
            String string2 = resultSet.getString(this.getValueCol());
            m_log.debug((Object)("Found setting: " + string + " value: " + string2));
            if (string != null) {
                this.m_settings.put(string, string2);
            }
            this.setAdditionalValues(resultSet);
        } while (resultSet.next());
    }

    public String getInsertSql() {
        return "insert into " + this.getTable() + " values(?, ?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        Map.Entry entry = (Map.Entry)this.m_addIterator.next();
        DatabaseObject.setParam(preparedStatement, 1, (String)entry.getKey(), this.getNameColLength());
        DatabaseObject.setParam(preparedStatement, 2, (String)entry.getValue(), this.getValueColLength());
    }

    public String getUpdateSql() {
        return "update " + this.getTable() + " set [Name]=?, [Value]=? where [Name]=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        Map.Entry entry = (Map.Entry)this.m_addIterator.next();
        DatabaseObject.setParam(preparedStatement, 1, (String)entry.getKey(), this.getNameColLength());
        DatabaseObject.setParam(preparedStatement, 3, (String)entry.getKey(), this.getNameColLength());
        DatabaseObject.setParam(preparedStatement, 2, (String)entry.getValue(), this.getValueColLength());
    }

    private void validateSettings() throws SQLException {
        String[] stringArray = this.getPropertyNames();
        if (stringArray.length == this.m_settings.size()) {
            int n = 0;
            while (n < stringArray.length) {
                if (!this.m_settings.containsKey(stringArray[n])) {
                    throw new SQLException("Failed to find a setting for: " + stringArray[n]);
                }
                ++n;
            }
        }
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        this.validateSettings();
        DatabaseUtil.executeUpdate(connection, this.getClearSql());
        this.m_addIterator = this.m_settings.entrySet().iterator();
        while (this.m_addIterator.hasNext()) {
            super.add(connection, false);
        }
    }

    public void add(Connection connection) throws SQLException {
        this.add(connection, false);
    }

    public void update(Connection connection) throws SQLException {
        this.add(connection, false);
    }

    public Object getProperty(String string) {
        Object v = this.m_settings.get(string);
        m_log.debug((Object)("Getting setting: " + string + " Value: " + v));
        return this.m_settings.get(string);
    }

    public void setProperty(String string, String string2) {
        m_log.debug((Object)("Setting setting: " + string + " Value: " + string2));
        this.m_settings.put(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

