/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.policy.db;

import com.mcafee.epo.common.policy.db.PolicySettingValues;
import com.mcafee.epo.common.policy.db.PolicySettings;
import com.mcafee.epo.common.policy.db.PolicySlot;
import com.mcafee.epo.core.db.EpoBranchNode;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PolicyObject
extends DatabaseObject {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$common$policy$db$PolicyObject == null ? (class$com$mcafee$epo$common$policy$db$PolicyObject = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicyObject")) : class$com$mcafee$epo$common$policy$db$PolicyObject).getName());
    public static final int NUM_COLUMNS = 5;
    public static final int NUM_PROPERTIES = 6;
    public static final int MAX_LEN_NAME = 128;
    private static final String STR_GLOBAL_ADMIN = "All ePO Administrators";
    private static final int COLUMN_POLICY_OBJECT_ID = 1;
    private static final int COLUMN_NAME = 2;
    private static final int COLUMN_TYPE_ID = 3;
    private static final int COLUMN_OWNER_ID = 4;
    private static final int COLUMN_EDITFLAGS = 5;
    public static final String[] PROPERTY_NAMES = new String[]{"", "PolicyObjectID", "Name", "TypeID", "OwnerID", "EditFlags", "OwnerName"};
    private int m_nPolicyID = 0;
    private int m_nPolicyTypeID = 0;
    private String m_strPolicyName = "";
    private int m_nOwnerID = 0;
    private String m_strOwnerName = "";
    private int m_nEditFlag = 0;
    static /* synthetic */ Class class$com$mcafee$epo$common$policy$db$PolicyObject;
    static /* synthetic */ Class class$com$mcafee$epo$common$policy$db$PolicySettingValues;
    static /* synthetic */ Class class$com$mcafee$epo$common$policy$db$PolicySlot;

    public String getUniqueQuerySql() {
        return "select * from EPOPolicyObjects where PolicyObjectID = ?";
    }

    public String getUniqueIdSql() {
        return "select * from EPOPolicyObjects where PolicyObjectID = ?";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 1, this.m_nPolicyID);
    }

    public String getInsertSql() {
        return "EPOPolicy_AddPolicyObject ?,?,?,?,?,?";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
    }

    public String getUpdateSql() {
        return "EPOPolicy_UpdatePolicyObject ?,?,?,?,?,?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 2, this.m_nPolicyID);
        DatabaseObject.setParam(preparedStatement, 3, this.m_strPolicyName, 128);
        DatabaseObject.setParam(preparedStatement, 4, this.m_nPolicyTypeID);
        DatabaseObject.setParam(preparedStatement, 5, this.m_nOwnerID);
        DatabaseObject.setParam(preparedStatement, 6, this.m_nEditFlag);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setPolicyObjectID(n);
    }

    public int getNumColumns() {
        return 5;
    }

    public int getNumProperties() {
        return 6;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public int getPolicyObjectID() {
        return this.m_nPolicyID;
    }

    public void setPolicyObjectID(int n) {
        this.m_nPolicyID = n;
    }

    public int getTypeID() {
        return this.m_nPolicyTypeID;
    }

    public void setTypeID(int n) {
        this.m_nPolicyTypeID = n;
    }

    public String getName() {
        return this.m_strPolicyName;
    }

    public void setName(String string) {
        this.m_strPolicyName = string;
    }

    public int getOwnerID() {
        return this.m_nOwnerID;
    }

    public void setOwnerID(int n) {
        this.m_nOwnerID = n;
    }

    public int getEditFlags() {
        return this.m_nEditFlag;
    }

    public void setEditFlags(int n) {
        this.m_nEditFlag = n;
    }

    public String getOwnerName() {
        return this.m_strOwnerName;
    }

    public void setOwnerName(String string) {
        this.m_strOwnerName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOwnerName(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            if (this.m_nOwnerID > 0) {
                preparedStatement = connection.prepareStatement("select UserName from UserTable where AutoID=?");
                preparedStatement.setInt(1, this.m_nOwnerID);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.setOwnerName(resultSet.getString(1));
                }
            } else {
                this.setOwnerName(STR_GLOBAL_ADMIN);
            }
            Object var5_4 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public boolean isEditable(EpoUser epoUser) {
        boolean bl = false;
        if (epoUser != null) {
            long l = epoUser.getAutoId();
            if (l == (long)this.m_nOwnerID) {
                bl = true;
            } else if (epoUser.isGlobalAdmin()) {
                bl = true;
            }
            if ((this.m_nEditFlag & 1) > 0) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection connection, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(this.getInsertSql());
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            DatabaseObject.setParam(callableStatement, 2, this.m_strPolicyName, 128);
            DatabaseObject.setParam((PreparedStatement)callableStatement, 3, this.m_nPolicyTypeID);
            DatabaseObject.setParam((PreparedStatement)callableStatement, 4, this.m_nOwnerID);
            DatabaseObject.setParam((PreparedStatement)callableStatement, 5, this.m_nEditFlag);
            callableStatement.registerOutParameter(6, 4);
            callableStatement.execute();
            this.setPolicyObjectID(callableStatement.getInt(6));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(this.getUpdateSql());
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            this.prepareUpdate(callableStatement);
            callableStatement.execute();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    public void add(Connection connection) throws SQLException {
        throw new SQLException("Use add(connection, userid) instead.");
    }

    public void update(Connection connection) throws SQLException {
        throw new SQLException("Use update(connection, userid) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PolicySettings[] getPolicySettings(Connection connection, Integer n, String string) throws SQLException {
        Vector<PolicySettings> vector = new Vector<PolicySettings>();
        PolicySettings[] policySettingsArray = new PolicySettings[]{};
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall("EPOPolicy_GetPolicyObjectSettings ?,?,?");
            callableStatement.setInt(1, this.m_nPolicyID);
            if (n != null) {
                callableStatement.setInt(2, (int)n);
            } else {
                callableStatement.setNull(2, 4);
            }
            if (callableStatement != null) {
                callableStatement.setString(3, string);
            } else {
                callableStatement.setNull(3, 12);
            }
            ResultSet resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(PolicySettings.getById(connection, resultSet.getInt(1)));
            }
            policySettingsArray = vector.toArray(policySettingsArray);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
        return policySettingsArray;
    }

    public void assignPolicyToNodeByProduct(Connection connection, int n, EpoBranchNode epoBranchNode, String string, boolean bl, boolean bl2) throws SQLException {
        PolicySlot.updatePolicyAssignmentByProduct(connection, n, this.m_nPolicyID, (int)epoBranchNode.getAutoId(), epoBranchNode.getType(), string, bl, bl2);
        connection.commit();
    }

    public void assignPolicyToNode(Connection connection, int n, EpoBranchNode epoBranchNode, int n2, boolean bl, boolean bl2) throws SQLException {
        PolicySlot.updatePolicyAssignment(connection, n, (int)epoBranchNode.getAutoId(), epoBranchNode.getType(), this.m_nPolicyID, n2, bl, bl2);
        connection.commit();
    }

    public PolicySettingValues[] getAllSettingValues(Connection connection) throws SQLException {
        PolicySettingValues[] policySettingValuesArray = new PolicySettingValues[]{};
        Vector vector = DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetPolicyObjectSettingValues " + this.m_nPolicyID, class$com$mcafee$epo$common$policy$db$PolicySettingValues == null ? (class$com$mcafee$epo$common$policy$db$PolicySettingValues = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicySettingValues")) : class$com$mcafee$epo$common$policy$db$PolicySettingValues);
        if (vector.size() > 0) {
            policySettingValuesArray = vector.toArray(policySettingValuesArray);
        }
        return policySettingValuesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSettings(Connection connection, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall("EPOPolicy_GetPolicyObjectSettingsIDList " + this.m_nPolicyID);
            ResultSet resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                callableStatement = connection.prepareCall("EPOPolicy_DeletePolicySettings " + n + ",?,1");
                do {
                    callableStatement.setInt(1, resultSet.getInt(1));
                    callableStatement.execute();
                } while (resultSet.next());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    public static final PolicyObject getById(Connection connection, int n) throws SQLException {
        PolicyObject policyObject = (PolicyObject)DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetPolicyObjectByID " + n, class$com$mcafee$epo$common$policy$db$PolicyObject == null ? (class$com$mcafee$epo$common$policy$db$PolicyObject = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicyObject")) : class$com$mcafee$epo$common$policy$db$PolicyObject).get(0);
        policyObject.setOwnerName(connection);
        return policyObject;
    }

    public static final void deleteFromDatabase(Connection connection, int n, int n2) throws SQLException {
        DatabaseUtil.executeUpdate(connection, "execute EPOPolicy_DeletePolicyObject " + n + "," + n2);
    }

    public PolicySlot[] getPolicyAssignments(Connection connection) throws SQLException {
        String string = "execute EPOPolicy_GetPolicyAssignments " + this.m_nPolicyID;
        Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$common$policy$db$PolicySlot == null ? (class$com$mcafee$epo$common$policy$db$PolicySlot = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicySlot")) : class$com$mcafee$epo$common$policy$db$PolicySlot);
        PolicySlot[] policySlotArray = new PolicySlot[]{};
        policySlotArray = vector.toArray(policySlotArray);
        return policySlotArray;
    }

    public static final PolicySettingValues[] getAllSettingsForObject(Connection connection, PolicyObject policyObject) throws SQLException {
        return PolicyObject.getAllSettingsForObject(connection, policyObject.getPolicyObjectID());
    }

    public static final PolicySettingValues[] getAllSettingsForObject(Connection connection, int n) throws SQLException {
        PolicySettingValues[] policySettingValuesArray = new PolicySettingValues[]{};
        Vector vector = DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetPolicyObjectSettingValues " + n, class$com$mcafee$epo$common$policy$db$PolicySettingValues == null ? (class$com$mcafee$epo$common$policy$db$PolicySettingValues = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicySettingValues")) : class$com$mcafee$epo$common$policy$db$PolicySettingValues);
        if (vector.size() > 0) {
            policySettingValuesArray = vector.toArray(policySettingValuesArray);
        }
        return policySettingValuesArray;
    }

    public static final PolicyObject[] getNodePolicyByType(Connection connection, String string, String string2, String string3, EpoBranchNode epoBranchNode) throws SQLException {
        PolicyObject[] policyObjectArray = new PolicyObject[]{};
        return DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetNodePolicyByType " + string + "," + string2 + "," + string3 + "," + epoBranchNode.getId() + "," + epoBranchNode.getType(), class$com$mcafee$epo$common$policy$db$PolicyObject == null ? (class$com$mcafee$epo$common$policy$db$PolicyObject = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicyObject")) : class$com$mcafee$epo$common$policy$db$PolicyObject).toArray(policyObjectArray);
    }

    public static final PolicyObject[] getNodePolicyByCategory(Connection connection, String string, String string2, EpoBranchNode epoBranchNode) throws SQLException {
        PolicyObject[] policyObjectArray = new PolicyObject[]{};
        return DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetNodePolicyByCategory " + string + "," + string2 + "," + epoBranchNode.getId() + "," + epoBranchNode.getType(), class$com$mcafee$epo$common$policy$db$PolicyObject == null ? (class$com$mcafee$epo$common$policy$db$PolicyObject = PolicyObject.class$("com.mcafee.epo.common.policy.db.PolicyObject")) : class$com$mcafee$epo$common$policy$db$PolicyObject).toArray(policyObjectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

