/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.policy.db;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class PolicySettingValues
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_POLICY_ID = 2;
    public static final int COL_SECTION_NAME = 3;
    public static final int COL_SETTING_NAME = 4;
    public static final int COL_SETTING_VALUE = 5;
    public static final int COL_TIMESTAMP = 6;
    public static final int COL_LAST_UPDATE = 7;
    public static final String[] PROPERTY_NAMES = new String[]{"", "PolicySettingValuesID", "PolicySettingsID", "SectionName", "SettingName", "SettingValue", "TheTimestamp", "LastUpdate"};
    public static final int MAX_LEN_SECTION_NAME = 256;
    public static final int MAX_LEN_SETTING_NAME = 128;
    public static final int MAX_LEN_SETTING_VALUE = 1024;
    public static final int NUM_COLUMNS = 7;
    public static final int NUM_PROPERTIES = PROPERTY_NAMES.length;
    private int m_policySettingValuesId = -1;
    private int m_policySettingsId = -1;
    private String m_sectionName = null;
    private String m_settingName = null;
    private String m_settingValue = null;
    private byte[] m_theTimestamp = null;
    private Timestamp m_lastUpdate = null;

    public String getInsertSql() {
        return "EPOPolicy_SetPolicySettingValue ?,?,?,?,?";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 2, this.m_policySettingsId);
        DatabaseObject.setParam(preparedStatement, 3, this.m_sectionName, 256);
        DatabaseObject.setParam(preparedStatement, 4, this.m_settingName, 128);
        DatabaseObject.setParam(preparedStatement, 5, this.m_settingValue, 1024);
    }

    public String getUpdateSql() {
        return this.getInsertSql();
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection connection, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(this.getInsertSql());
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            this.prepareInsert(callableStatement);
            callableStatement.execute();
            this.m_policySettingValuesId = DatabaseUtil.getLastInsertedId(connection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    public void update(Connection connection, int n) throws SQLException {
        this.add(connection, n);
    }

    public void add(Connection connection) throws SQLException {
        throw new SQLException("Use add(connection, userid) instead.");
    }

    public void update(Connection connection) throws SQLException {
        throw new SQLException("Use update(connection, userid) instead.");
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_policySettingValuesId = n;
    }

    public int getPolicySettingValuesId() {
        return this.m_policySettingValuesId;
    }

    public void setPolicySettingValuesId(int n) {
        this.m_policySettingValuesId = n;
    }

    public int getPolicySettingsId() {
        return this.m_policySettingsId;
    }

    public void setPolicySettingsId(int n) {
        this.m_policySettingsId = n;
    }

    public String getSectionName() {
        return this.m_sectionName;
    }

    public void setSectionName(String string) {
        this.m_sectionName = string;
    }

    public String getSettingName() {
        return this.m_settingName;
    }

    public void setSettingName(String string) {
        this.m_settingName = string;
    }

    public String getSettingValue() {
        return this.m_settingValue;
    }

    public void setSettingValue(String string) {
        this.m_settingValue = string;
    }

    public byte[] getTheTimestamp() {
        return this.m_theTimestamp;
    }

    public void setTheTimestamp(byte[] byArray) {
        this.m_theTimestamp = byArray;
    }

    public Timestamp getLastUpdate() {
        return this.m_lastUpdate;
    }

    public void setLastUpdate(Timestamp timestamp) {
        this.m_lastUpdate = timestamp;
    }

    public void setLastUpdateToNow() {
        this.m_lastUpdate = new Timestamp(System.currentTimeMillis());
    }
}

