/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.util.console;

import com.mcafee.epo.common.server.ServerNative;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class AtlasSSLClient {
    private static final String LOGIN_URI = "/webui/login.do";
    private static final String BEGIN_UPLOAD_URI = "/webui/beginupload.do";
    private static final String UPLOAD_FILE_URI = "/webui/uploadfile.do";
    private static final String END_UPLOAD_URI = "/webui/endupload.do";
    private static final String SESSION_ID = "JSESSIONID";
    private static final String DEFAULT_PROTOCOL = "https";
    private String m_sessionId = null;
    private String m_epoServerName;
    private int m_serverPort;
    private String m_protocol;
    private boolean m_triedOnce = false;

    public String getSessionId() {
        return this.m_sessionId;
    }

    public AtlasSSLClient(String string, int n) {
        this.m_epoServerName = string;
        this.m_serverPort = n;
        this.m_protocol = DEFAULT_PROTOCOL;
    }

    public AtlasSSLClient(String string, String string2, int n) {
        this.m_epoServerName = string2;
        this.m_serverPort = n;
        this.m_protocol = string;
    }

    private static final SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        X509TrustManager x509TrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sSLContext.init(null, new X509TrustManager[]{x509TrustManager}, new SecureRandom());
        return sSLContext;
    }

    private StringBuffer doPost(String string, HashMap hashMap, String string2, String string3) throws IOException, NoSuchAlgorithmException, KeyManagementException, LoginRequiredException {
        String string4;
        Object object;
        URL uRL = new URL(this.m_protocol, this.m_epoServerName, this.m_serverPort, string);
        StringBuffer stringBuffer = new StringBuffer(1024);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (uRL.getProtocol().equalsIgnoreCase(DEFAULT_PROTOCOL)) {
            object = (HttpsURLConnection)httpURLConnection;
            ((HttpsURLConnection)object).setSSLSocketFactory(AtlasSSLClient.createSSLContext().getSocketFactory());
            ((HttpsURLConnection)object).setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        httpURLConnection.setRequestMethod("POST");
        if (string3 != null) {
            httpURLConnection.setRequestProperty("Content-type", string3);
        } else {
            httpURLConnection.setRequestProperty("Content-type", "application/octet-stream");
        }
        httpURLConnection.setRequestProperty("user-agent", "McUpload 1.0");
        if (hashMap != null) {
            object = hashMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                httpURLConnection.setRequestProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (this.m_sessionId != null) {
            httpURLConnection.setRequestProperty("Cookie", "JSESSIONID=" + this.m_sessionId);
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.connect();
        object = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
        ((Writer)object).write(string2.toString());
        ((OutputStreamWriter)object).flush();
        ((OutputStreamWriter)object).close();
        int n = httpURLConnection.getResponseCode();
        if (n == 401) {
            throw new LoginRequiredException();
        }
        int n2 = 1;
        while (httpURLConnection.getHeaderFieldKey(n2) != null) {
            stringBuffer.append(httpURLConnection.getHeaderField(n2)).append("\r\n");
            ++n2;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string4 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string4).append("\r\n");
        }
        bufferedReader.close();
        return stringBuffer;
    }

    private void doLogin(String string, String string2, int n) throws IOException, NoSuchAlgorithmException, KeyManagementException, LoginRequiredException {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("name=").append(URLEncoder.encode(string, "UTF-8"));
        stringBuffer.append("&password=").append(URLEncoder.encode(string2, "UTF-8"));
        if (n == 2) {
            stringBuffer.append("&hashed=true");
        }
        stringBuffer.append("&LanguageId=0409");
        StringBuffer stringBuffer2 = this.doPost(LOGIN_URI, null, stringBuffer.toString(), "application/x-www-form-urlencoded");
        int n2 = stringBuffer2.indexOf(SESSION_ID);
        if (n2 != -1) {
            String string3 = stringBuffer2.substring(n2 + SESSION_ID.length() + 1);
            int n3 = string3.indexOf(";");
            if (n3 == -1) {
                n3 = string3.length();
            }
            this.m_sessionId = string3.substring(0, n3).trim();
            if ((n2 = stringBuffer2.indexOf(SESSION_ID, n2 + this.m_sessionId.length())) != -1) {
                throw new ProtocolException("Login failed, and redirected to logout.");
            }
        }
        if (this.m_sessionId == null) {
            throw new ProtocolException("Could not find login session cookie, unable to continue.");
        }
    }

    public void postFiles(String string, String string2, int n, Map map) throws IOException, LoginRequiredException, NoSuchAlgorithmException, KeyManagementException {
        if (this.m_sessionId == null) {
            this.doLogin(string, string2, n);
        }
        try {
            this.doPost(BEGIN_UPLOAD_URI, null, "", null);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                hashMap.put("filename", string3);
                hashMap.put("filetime", Long.toString(System.currentTimeMillis()));
                this.doPost(UPLOAD_FILE_URI, hashMap, string4, null);
            }
            this.doPost(END_UPLOAD_URI, null, "", null);
        }
        catch (LoginRequiredException loginRequiredException) {
            if (!this.m_triedOnce) {
                this.m_sessionId = null;
                this.m_triedOnce = true;
                this.postFiles(string, string2, n, map);
            }
            this.m_triedOnce = false;
            throw loginRequiredException;
        }
    }

    public void postFile(String string, String string2, int n, String string3, String string4) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string3, string4);
        this.postFiles(string, string2, n, hashMap);
    }

    public void genericPost(String string, String string2, int n, String string3, String string4, String string5) throws NoSuchAlgorithmException, KeyManagementException, LoginRequiredException, IOException {
        if (this.m_sessionId == null) {
            this.doLogin(string, string2, n);
        }
        this.doPost(string3, null, string4, string5);
    }

    public void postUsingNative(String string, String string2, int n, String string3, String string4) throws Exception {
        this.postUsingNativeWithHeaders(string, string2, n, string3, new String(""), string4);
    }

    public void postUsingNativeWithHeaders(String string, String string2, int n, String string3, String string4, String string5) throws Exception {
        try {
            ServerNative.postAndResponse(this.m_epoServerName, this.m_serverPort, string, string2, string3, new String(""), string5, true, true);
        }
        catch (Exception exception) {
            if (!this.m_triedOnce) {
                this.m_sessionId = null;
                this.m_triedOnce = true;
                ServerNative.postAndResponse(this.m_epoServerName, this.m_serverPort, string, string2, string3, string4, string5, true, true);
            }
            this.m_triedOnce = false;
            throw exception;
        }
    }

    public static void main(String[] stringArray) {
        AtlasSSLClient atlasSSLClient = new AtlasSSLClient("localhost", 8444);
        try {
            String string = "ga";
            String string2 = "bYYoTT4/ggHd8JAGYlgfXV9HF4s=";
            atlasSSLClient.genericPost(string, string2, 2, "/webui/pushagent.do", "garbage", null);
            System.out.println("Push Agent test Success!!");
            atlasSSLClient.postFile(string, string2, 2, "SLHTest/testfile.txt", "This is a test.");
            System.out.println("Post file test Successful!");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SLHTest/testfile1.txt", "This is a first test!");
            hashMap.put("SLHTest/testfile2.txt", "This is also a test!");
            hashMap.put("SLHTest/testfile3.txt", "This is also a third test!");
            atlasSSLClient.postFiles(string, string2, 2, hashMap);
            System.out.println("Multiple file post sucessful!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class LoginRequiredException
    extends Exception {
        private LoginRequiredException() {
        }
    }
}

