/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.client;

import com.mcafee.epo.core.util.CertUtil;
import com.mcafee.epo.core.util.StringUtil;
import java.io.FileWriter;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CreateCertClient {
    public static final String DN_CA = "CN=ePO_{ServerName}CA, OU=ePO, O=McAfee";
    public static final String DN_SENSOR = "CN=RogueSystemSensor, OU=ePO, O=McAfee";
    public static final String DN_SERVER = "CN={ServerName}, OU=ePO, O=McAfee";
    private int m_validityInDays = 7300;
    private String m_keystoreDir = ".";

    public static void main(String[] stringArray) throws Exception {
        CreateCertClient createCertClient = new CreateCertClient(stringArray);
        createCertClient.run();
    }

    public CreateCertClient(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].intern();
            if (++n >= stringArray.length) {
                CreateCertClient.showUsageAndExit();
            }
            String string2 = stringArray[n];
            ++n;
            if (string == "--validity") {
                this.m_validityInDays = Integer.parseInt(string2);
                continue;
            }
            if (string == "--dir") {
                this.m_keystoreDir = string2;
                continue;
            }
            CreateCertClient.showUsageAndExit();
        }
    }

    public static final String getDN_CA() {
        return StringUtil.substitute(DN_CA, (StringUtil.Map)new HostNameParam());
    }

    public static final String getDN_Server() {
        return StringUtil.substitute(DN_SERVER, (StringUtil.Map)new HostNameParam());
    }

    public void run() throws Exception {
        String string = CreateCertClient.getDN_CA();
        KeyPair keyPair = CertUtil.generateKeyPair();
        X509Certificate x509Certificate = CertUtil.generateSelfSignedCert(string, keyPair, this.m_validityInDays);
        KeyPair keyPair2 = CertUtil.generateKeyPair();
        X509Certificate x509Certificate2 = CertUtil.generateSignedCert(DN_SENSOR, keyPair2, keyPair, x509Certificate, this.m_validityInDays);
        String string2 = CreateCertClient.getDN_Server();
        KeyPair keyPair3 = CertUtil.generateKeyPair();
        X509Certificate x509Certificate3 = CertUtil.generateSignedCert(string2, keyPair3, keyPair, x509Certificate, this.m_validityInDays);
        FileWriter fileWriter = new FileWriter(this.m_keystoreDir + "/root.pem", false);
        fileWriter.write(CertUtil.makePEM(x509Certificate));
        fileWriter.close();
        fileWriter = new FileWriter(this.m_keystoreDir + "/sensor.pem", false);
        fileWriter.write(CertUtil.makePEM(x509Certificate2));
        fileWriter.close();
        fileWriter = new FileWriter(this.m_keystoreDir + "/key.pem", false);
        fileWriter.write(CertUtil.makePEM(keyPair2.getPrivate()));
        fileWriter.close();
        CertUtil.writeToKeystore(x509Certificate, keyPair, new Certificate[]{x509Certificate}, this.m_keystoreDir + "/ca.keystore");
        CertUtil.writeToKeystore(x509Certificate, keyPair3, new Certificate[]{x509Certificate3, x509Certificate}, this.m_keystoreDir + "/server.keystore");
        CertUtil.writeToKeystore(x509Certificate, keyPair2, new Certificate[]{x509Certificate2, x509Certificate}, this.m_keystoreDir + "/sensor.keystore");
    }

    private static void showUsageAndExit() {
        System.out.println("Usage: CreateCerts --dir <dir-name> --validity <validity-in-days>");
        System.out.println("  where:");
        System.out.println("    dir-name   : directory in which keystore and PEMs will be created. Default is cwd.");
        System.out.println("    validity   : How long the certs should remain valid, in days");
        System.exit(-1);
    }

    private static void fail(String string) {
        System.out.println(string);
        System.exit(-1);
    }

    private static class HostNameParam
    implements StringUtil.Map {
        private HostNameParam() {
        }

        public String get(String string) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                return "ePOServer";
            }
        }
    }
}

