/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.condition;

import com.mcafee.epo.core.condition.EvalContext;
import com.mcafee.epo.core.condition.EvaluationException;
import com.mcafee.epo.core.condition.Sexp;
import com.mcafee.epo.core.condition.SexpBool;
import com.mcafee.epo.core.condition.SexpList;

public class SexpAnd
extends SexpList {
    public static final String TYPE = "and";

    public String type() {
        return TYPE;
    }

    public Sexp eval(EvalContext evalContext) throws EvaluationException {
        if (this.m_children.size() < 2) {
            throw new EvaluationException("'and' needs at least two parameters!");
        }
        int n = 0;
        while (n < this.m_children.size()) {
            Sexp sexp = this.evalChild(n, evalContext);
            if (!(sexp instanceof SexpBool)) {
                throw new EvaluationException("'and' got non-boolean parameter:" + sexp);
            }
            if (sexp == SexpBool.FALSE) {
                return SexpBool.FALSE;
            }
            ++n;
        }
        return SexpBool.TRUE;
    }
}

