/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.condition;

import com.mcafee.epo.core.condition.SerializationException;
import com.mcafee.epo.core.condition.Sexp;
import com.mcafee.epo.core.condition.SexpAnd;
import com.mcafee.epo.core.condition.SexpBool;
import com.mcafee.epo.core.condition.SexpContains;
import com.mcafee.epo.core.condition.SexpEndsWith;
import com.mcafee.epo.core.condition.SexpEquals;
import com.mcafee.epo.core.condition.SexpIpInRange;
import com.mcafee.epo.core.condition.SexpIpNotInRange;
import com.mcafee.epo.core.condition.SexpIsNull;
import com.mcafee.epo.core.condition.SexpList;
import com.mcafee.epo.core.condition.SexpLong;
import com.mcafee.epo.core.condition.SexpNewerThan;
import com.mcafee.epo.core.condition.SexpNotContains;
import com.mcafee.epo.core.condition.SexpNotEquals;
import com.mcafee.epo.core.condition.SexpOlderThan;
import com.mcafee.epo.core.condition.SexpOr;
import com.mcafee.epo.core.condition.SexpProp;
import com.mcafee.epo.core.condition.SexpStartsWith;
import com.mcafee.epo.core.condition.SexpString;
import com.mcafee.epo.core.condition.Tokenizer;

public class SexpSerializer {
    public static final String write(Sexp sexp) {
        StringBuffer stringBuffer = new StringBuffer();
        sexp.write(stringBuffer);
        return stringBuffer.toString();
    }

    public static final Sexp read(String string) throws SerializationException {
        Tokenizer tokenizer = new Tokenizer(string);
        tokenizer.next();
        return SexpSerializer.readImpl(tokenizer);
    }

    private static final Sexp readImpl(Tokenizer tokenizer) throws SerializationException {
        int n = tokenizer.lastTokenType();
        switch (n) {
            case 3: {
                return SexpSerializer.readLiteral(tokenizer);
            }
            case 1: {
                return SexpSerializer.readList(tokenizer);
            }
            case 4: {
                return new SexpString(tokenizer.lastToken());
            }
            case 0: {
                throw new SerializationException("Unexpected end of stream");
            }
            case 2: {
                throw new SerializationException("Unexpected close-parenthesis");
            }
        }
        return null;
    }

    private static final Sexp readList(Tokenizer tokenizer) throws SerializationException {
        int n = tokenizer.next();
        if (n != 3) {
            throw new SerializationException("String must always follow open-parenthesis");
        }
        SexpList sexpList = SexpSerializer.createSexp(tokenizer.lastToken().intern());
        n = tokenizer.next();
        while (n != 2) {
            if (n == 0) {
                throw new SerializationException("Unexpected end of stream");
            }
            sexpList.addChild(SexpSerializer.readImpl(tokenizer));
            n = tokenizer.next();
        }
        return sexpList;
    }

    private static final Sexp readLiteral(Tokenizer tokenizer) throws SerializationException {
        String string = tokenizer.lastToken().intern();
        if (string == "t") {
            return SexpBool.TRUE;
        }
        if (string == "f") {
            return SexpBool.FALSE;
        }
        if (string.length() > 0 && (Character.isDigit(string.charAt(0)) || string.charAt(0) == '-')) {
            try {
                return new SexpLong(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SerializationException("Invalid number format:" + string);
            }
        }
        return new SexpProp(string);
    }

    private static final SexpList createSexp(String string) throws SerializationException {
        if (string == "and") {
            return new SexpAnd();
        }
        if (string == "or") {
            return new SexpOr();
        }
        if (string == "eq") {
            return new SexpEquals();
        }
        if (string == "ne") {
            return new SexpNotEquals();
        }
        if (string == "isNull") {
            return new SexpIsNull();
        }
        if (string == "contains") {
            return new SexpContains();
        }
        if (string == "doesntContain") {
            return new SexpNotContains();
        }
        if (string == "startsWith") {
            return new SexpStartsWith();
        }
        if (string == "endsWith") {
            return new SexpEndsWith();
        }
        if (string == "olderThan") {
            return new SexpOlderThan();
        }
        if (string == "newerThan") {
            return new SexpNewerThan();
        }
        if (string == "ipInRange") {
            return new SexpIpInRange();
        }
        if (string == "ipNotInRange") {
            return new SexpIpNotInRange();
        }
        throw new SerializationException("Unknown operation:" + string);
    }
}

