/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.condition;

import com.mcafee.epo.core.condition.SerializationException;

public class Tokenizer {
    public static final int TOKEN_INVALID = -1;
    public static final int TOKEN_END = 0;
    public static final int TOKEN_OPEN_PAREN = 1;
    public static final int TOKEN_CLOSED_PAREN = 2;
    public static final int TOKEN_STRING = 3;
    public static final int TOKEN_QUOTED_STRING = 4;
    private final String STR_OPEN_PAREN = "(";
    private final String STR_CLOSED_PAREN = ")";
    private char[] m_string;
    int m_nextChar = 0;
    boolean m_done = false;
    String m_lastToken = "";
    int m_lastTokenType = -1;
    StringBuffer m_buf = new StringBuffer();

    public Tokenizer(String string) {
        this.m_string = new char[string.length()];
        string.getChars(0, string.length(), this.m_string, 0);
        this.m_nextChar = 0;
        this.m_done = false;
    }

    public int next() throws SerializationException {
        this.skipSpace();
        char c = this.nextChar();
        if (this.done()) {
            return this.m_lastTokenType;
        }
        if (c == '(') {
            this.m_lastToken = "(";
            this.m_lastTokenType = 1;
            return this.m_lastTokenType;
        }
        if (c == ')') {
            this.m_lastToken = ")";
            this.m_lastTokenType = 2;
            return this.m_lastTokenType;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (c == '\"') {
            bl = true;
            bl2 = true;
            c = this.nextChar();
        } else {
            bl = false;
            bl2 = false;
        }
        this.m_buf.setLength(0);
        while (!this.done()) {
            if (bl && c == '\"') {
                bl2 = false;
                break;
            }
            if (!bl && this.isSpace(c) || c == '(' || c == ')') {
                this.putCharBack();
                break;
            }
            if (c == '\\') {
                c = this.nextChar();
                if (this.done()) {
                    throw new SerializationException("Expression can't end with backslash:" + new String(this.m_string));
                }
            }
            this.m_buf.append(c);
            c = this.nextChar();
        }
        if (bl2) {
            throw new SerializationException("Unbalanced quotes in expression:" + new String(this.m_string));
        }
        this.m_lastToken = this.m_buf.toString();
        this.m_lastTokenType = bl ? 4 : 3;
        this.m_buf.setLength(0);
        return this.m_lastTokenType;
    }

    public String lastToken() {
        return this.m_lastToken;
    }

    public int lastTokenType() {
        return this.m_lastTokenType;
    }

    public final boolean done() {
        return this.m_done;
    }

    private void skipSpace() {
        char c = ' ';
        while (this.isSpace(c)) {
            c = this.nextChar();
            if (!this.done()) continue;
            return;
        }
        this.putCharBack();
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private final char nextChar() {
        if (this.m_nextChar >= this.m_string.length) {
            this.setEndOfString();
            return '\u0000';
        }
        char c = this.m_string[this.m_nextChar];
        ++this.m_nextChar;
        return c;
    }

    private final void setEndOfString() {
        this.m_done = true;
        this.m_lastTokenType = 0;
        this.m_lastToken = "";
    }

    private final void putCharBack() {
        if (this.m_nextChar > 0 && !this.done()) {
            --this.m_nextChar;
        }
    }
}

