/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db;

import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.util.resource.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EpoBranchNode
extends DatabaseObject {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode));
    public static final int COL_ID = 1;
    public static final int COL_NODE_NAME = 2;
    public static final int COL_TYPE = 3;
    public static final int COL_PARENT_ID = 4;
    public static final int COL_POLICY_TIMESTAMP = 5;
    public static final int COL_THE_TIMESTAMP = 6;
    public static final int COL_THE_HIDDEN_TIMESTAMP = 7;
    public static final int COL_TASK_TIMESTAMP = 8;
    public static final int NUM_COLS = 8;
    public static final int NUM_PROPS = 8;
    public static String[] PROP_NAMES = new String[]{"", "AutoId", "NodeName", "Type", "ParentId", "PolicyTimestamp", "TheTimestamp", "TheHiddenTimestamp", "TaskTimestamp"};
    public static final String TABLE_NAME = "BranchNode";
    public static final String UNIQUE_SQL = "select * from BranchNode where AutoId=?";
    private static final String ROOT_NODE_ID_QUERY = "select AutoId from BranchNode where " + PROP_NAMES[3] + "=" + 7;
    private static final String ROOT_NODE_QUERY = "select * from BranchNode where " + PROP_NAMES[3] + "=" + 7;
    private long m_id = -1L;
    private String m_nodeName = "";
    private int m_type = 3;
    private long m_parentId = -1L;
    static /* synthetic */ Class class$com$mcafee$epo$core$db$EpoBranchNode;

    public static final String getAncestryAsString(Connection connection, long l) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList linkedList = EpoBranchNode.getAncestry(connection, l);
        Iterator iterator = linkedList.iterator();
        if (linkedList.size() > 1) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            EpoBranchNode epoBranchNode = (EpoBranchNode)iterator.next();
            stringBuffer.append(epoBranchNode.getNodeName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\\");
        }
        return stringBuffer.toString();
    }

    public static final LinkedList getAncestry(Connection connection, long l) throws SQLException {
        m_log.debug((Object)("Finding ancestry for node: " + l));
        LinkedList<EpoBranchNode> linkedList = new LinkedList<EpoBranchNode>();
        String string = EpoBranchNode.getAncestryNodeIds(connection, l);
        if (string != null) {
            String[] stringArray = string.split("/");
            int n = 0;
            while (n < stringArray.length) {
                EpoBranchNode epoBranchNode = EpoBranchNode.getById(connection, Long.parseLong(stringArray[n]));
                if (epoBranchNode != null) {
                    linkedList.add(epoBranchNode);
                } else {
                    m_log.debug((Object)("Could not find EpoBranchNode for Site Id = " + stringArray[n]));
                }
                ++n;
            }
        }
        return linkedList.size() < 1 ? null : linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAncestryNodeIds(Connection connection, long l) throws SQLException {
        String string = "DECLARE @NodePath nvarchar(1000); DECLARE @ParentID int; Set @ParentID = " + l + " DECLARE @cur CURSOR; SET @cur = CURSOR FORWARD_ONLY FOR " + " SELECT StartAutoID FROM BranchNodeEnum WHERE EndAutoID = @ParentID AND StartAutoID != 1;" + " OPEN @cur; FETCH NEXT FROM @cur INTO @ParentID; " + " WHILE (@@FETCH_STATUS = 0) " + " BEGIN " + " IF (@NodePath IS NULL) SET @NodePath = CONVERT(nvarchar,@ParentID); " + " ELSE SET @NodePath = @NodePath + '/' + CONVERT(nvarchar,@ParentID); " + " FETCH NEXT FROM @cur INTO @ParentID; " + " END " + " CLOSE @cur; DEALLOCATE @cur; " + " SELECT @NodePath AS NodePath; ";
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string2 = null;
        try {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            string2 = resultSet.getString(1);
            Object var8_6 = null;
            if (statement == null) return string2 == null ? Long.toString(l) : string2 + "/" + Long.toString(l);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return string2 == null ? Long.toString(l) : string2 + "/" + Long.toString(l);
    }

    public static final EpoBranchNode getById(Connection connection, long l) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(UNIQUE_SQL);
        preparedStatement.setLong(1, l);
        Vector vector = DatabaseObject.getByQuery(connection, preparedStatement, class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode, 1, 1);
        if (vector.size() < 1) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (EpoBranchNode)vector.firstElement();
    }

    public static final EpoBranchNode[] getSiteList(Connection connection) throws SQLException {
        EpoBranchNode[] epoBranchNodeArray = new EpoBranchNode[]{};
        String string = "select * from BranchNode where " + PROP_NAMES[3] + "=" + 6;
        Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode);
        if (vector != null) {
            epoBranchNodeArray = vector.toArray(epoBranchNodeArray);
        }
        return epoBranchNodeArray;
    }

    private static final String makeFindParentSql(int n, String string) {
        return "select * from BranchNode where " + PROP_NAMES[3] + "=" + n + " AND " + PROP_NAMES[4] + "=(" + string + ")";
    }

    public static final EpoBranchNode getGlobalRoot(Connection connection) throws SQLException {
        Vector vector = DatabaseObject.getByQuery(connection, ROOT_NODE_QUERY, class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (EpoBranchNode)vector.firstElement();
    }

    public static final EpoBranchNode getDirectoryRoot(Connection connection) throws SQLException {
        String string = EpoBranchNode.makeFindParentSql(4, ROOT_NODE_ID_QUERY);
        Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (EpoBranchNode)vector.firstElement();
    }

    public static final EpoBranchNode getNodeForUser(Connection connection, EpoUser epoUser) throws SQLException {
        if (!epoUser.isSiteAccount()) {
            return EpoBranchNode.getDirectoryRoot(connection);
        }
        return EpoBranchNode.getById(connection, epoUser.getRootNodeId());
    }

    public static final EpoBranchNode getGlobalLostAndFound(Connection connection) throws SQLException {
        EpoBranchNode epoBranchNode = EpoBranchNode.getDirectoryRoot(connection);
        if (epoBranchNode != null) {
            String string = "select * from BranchNode where " + PROP_NAMES[3] + "=" + 5 + " AND " + PROP_NAMES[4] + "=" + epoBranchNode.getAutoId();
            Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$core$db$EpoBranchNode == null ? (class$com$mcafee$epo$core$db$EpoBranchNode = EpoBranchNode.class$("com.mcafee.epo.core.db.EpoBranchNode")) : class$com$mcafee$epo$core$db$EpoBranchNode);
            if (vector.size() == 0) {
                return null;
            }
            if (vector.size() > 1) {
                throw new SQLException(Resource.getString("db_morethan_one"));
            }
            return (EpoBranchNode)vector.firstElement();
        }
        return null;
    }

    public int getNumColumns() {
        return 8;
    }

    public int getNumProperties() {
        return 8;
    }

    public String getPropertyName(int n) {
        return PROP_NAMES[n];
    }

    public String getInsertSql() {
        return "insert into BranchNode values(?,?,?, 0x0, @@DBTS, null, 0x0)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.m_nodeName);
        preparedStatement.setInt(2, this.m_type);
        preparedStatement.setLong(3, this.m_parentId);
    }

    public String getUpdateSql() {
        return "update BranchNode set NodeName=?, Type=?, ParentId=?, TheTimestamp=@@DBTS where AutoId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        preparedStatement.setLong(4, this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_id = n;
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_nodeName = resultSet.getString(2);
        if (resultSet.getMetaData().getColumnCount() > 2) {
            this.m_type = resultSet.getInt(3);
            this.m_parentId = resultSet.getLong(4);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            Long l = (Long)object;
            return l == this.m_id;
        }
        return super.equals(object);
    }

    public void setId(long l) {
        this.m_id = l;
    }

    public long getId() {
        return this.m_id;
    }

    public long getAutoId() {
        return this.m_id;
    }

    public void setAutoId(long l) {
        this.m_id = l;
    }

    public void setNodeName(String string) {
        this.m_nodeName = string;
    }

    public String getNodeName() {
        String string = this.m_type == 4 ? "{Directory}" : this.m_nodeName;
        return string;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void setParentId(long l) {
        this.m_parentId = l;
    }

    public long getParentId() {
        return this.m_parentId;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

