/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db;

import com.mcafee.epo.core.db.EpoPassword;
import com.mcafee.epo.core.util.FileUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EpoServerIni {
    private String m_dbServer = "";
    private String m_dbInstance = "";
    private String m_dbName = "";
    private String m_userName = "";
    private String m_password = "";
    private String m_domain = "";
    private String m_appServerIP = "";

    public EpoServerIni(String string) throws IOException {
        String string2 = FileUtil.loadAsString(string);
        this.parseFile(string2);
    }

    public EpoServerIni(Reader reader) throws IOException {
        String string = FileUtil.loadAsString(reader);
        this.parseFile(string);
    }

    private void parseFile(String string) {
        boolean bl;
        HashMap hashMap = this.getProperties(string);
        this.m_dbServer = this.getString(hashMap, "DataSource");
        this.m_dbName = this.getString(hashMap, "Database");
        this.m_appServerIP = this.getString(hashMap, "ServerIPAddress");
        int n = this.m_dbServer.indexOf("\\");
        if (n != -1) {
            this.m_dbInstance = this.m_dbServer.substring(n + 1, this.m_dbServer.length());
            this.m_dbServer = this.m_dbServer.substring(0, n);
        }
        if (bl = this.getBoolean(hashMap, "UseNTAccount")) {
            this.m_userName = this.getString(hashMap, "NTUserName");
            n = this.m_userName.indexOf("\\");
            if (n != -1) {
                this.m_domain = this.m_userName.substring(0, n);
                this.m_userName = this.m_userName.substring(n + 1, this.m_userName.length());
            }
            this.m_password = this.getString(hashMap, "NTPassword");
        } else {
            this.m_domain = "";
            this.m_userName = this.getString(hashMap, "UserName");
            this.m_password = this.getString(hashMap, "Password");
        }
    }

    private HashMap getProperties(String string) {
        Pattern pattern = Pattern.compile("^([^=\\r\\n]+)=(.*)$", 8);
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            hashMap.put(matcher.group(1).trim(), matcher.group(2).trim());
        }
        return hashMap;
    }

    private String getString(Map map, String string) {
        String string2 = (String)map.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private boolean getBoolean(Map map, String string) {
        String string2 = this.getString(map, string);
        return string2.equals("1");
    }

    public String getDbServer() {
        return this.m_dbServer;
    }

    public String getDbInstance() {
        return this.m_dbInstance;
    }

    public String getDbName() {
        return this.m_dbName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getAppServerIP() {
        return this.m_appServerIP;
    }

    public String getDecryptedPassword() {
        try {
            return EpoPassword.decryptPassphrase(this.m_password, 2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getDomain() {
        return this.m_domain;
    }
}

