/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.db.base.DatabaseObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;

public abstract class DatabaseObjectImpl
extends DatabaseObject {
    public static final int COL_UNIQUE_ID = 1;
    public static final int COL_IDENTITY = 2;
    public static final int COL_CALCULATED = 4;
    public static final int COL_READ_ONLY = 8;
    public static final int COL_WRITE_ONLY = 16;
    public static final int COL_AUTO_VALUE = 8;
    private ClassInfo m_info = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class array$B;

    public DatabaseObjectImpl(ClassInfo classInfo) {
        this.m_info = classInfo;
    }

    public Column[] getColumns() {
        return this.m_info.m_columns;
    }

    public Column getColumn(int n) {
        return this.m_info.m_columns[n];
    }

    public boolean isUpdateColumn(int n) {
        return this.m_info.isUpdateColumn(n);
    }

    public ClassInfo getClassInfo() {
        return this.m_info;
    }

    public String getTableName() {
        return this.m_info.m_tableName;
    }

    public String getInsertSql() {
        return this.m_info.m_insertSql;
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        this.m_info.prepareInsert(this, preparedStatement);
    }

    public String getUpdateSql() {
        return this.m_info.m_updateSql;
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.m_info.prepareUpdate(this, preparedStatement);
    }

    public String getUniqueQuerySql() {
        if (this.m_info.m_uniqueQuerySql.length() == 0) {
            throw new UnsupportedOperationException("getUniqueQuerySql not implemented for class " + this.getClass().toString());
        }
        return this.m_info.m_uniqueQuerySql;
    }

    public String getUniqueIdSql() {
        if (this.m_info.m_uniqueIdSql.length() == 0) {
            throw new UnsupportedOperationException("getUniqueIdSql not implemented for class " + this.getClass().toString());
        }
        return this.m_info.m_uniqueIdSql;
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        this.m_info.prepareUniqueQuery(this, preparedStatement);
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_info.setUniqueID(this, n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_info.setValues(this, resultSet);
    }

    public int getNumColumns() {
        return this.m_info.m_numColumns;
    }

    public int getNumProperties() {
        return this.m_info.m_columns.length;
    }

    public String getPropertyName(int n) {
        this.validateIndex(n);
        return this.m_info.m_columns[n].m_propertyName;
    }

    public int getPropertyIndex(String string) {
        String string2 = string.intern();
        int n = 0;
        while (n < this.m_info.m_columns.length) {
            if (string2 == this.m_info.m_columns[n].m_propertyName) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Property " + string + " is not a known property of this database object.");
    }

    public void setProperty(String string, Object object) {
        int n = this.getPropertyIndex(string);
        this.setProperty(n, object);
    }

    private void validateIndex(int n) {
        if (n < 0 || n > this.m_info.m_columns.length) {
            throw new IllegalArgumentException("The database object does not have a defined property at index: " + n);
        }
    }

    public void setProperty(int n, Object object) {
        this.validateIndex(n);
        this.m_info.m_columns[n].callSetter(this, object);
    }

    public Object getProperty(int n) {
        this.validateIndex(n);
        return this.m_info.m_columns[n].callGetter(this);
    }

    public Object getProperty(String string) {
        return this.getProperty(this.getPropertyIndex(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ClassInfo {
        private String m_tableName = "";
        private int m_numColumns = 0;
        private boolean m_resultsByName = false;
        private int m_uniqueIDCol = -1;
        private Column[] m_identityCols = null;
        private Column[] m_updateCols = null;
        private Column[] m_columns = null;
        public String m_insertSql = "";
        public String m_updateSql = "";
        public String m_uniqueQuerySql = "";
        public String m_uniqueIdSql = "";

        public ClassInfo(Class clazz, String string, Column[] columnArray) {
            this(clazz, string, false, columnArray);
        }

        public ClassInfo(Class clazz, String string, boolean bl, Column[] columnArray) {
            this.m_tableName = string;
            this.m_columns = columnArray;
            this.m_resultsByName = bl;
            this.initColumns(clazz);
            this.generateSql();
        }

        public void setResultsByName(boolean bl) {
            this.m_resultsByName = bl;
        }

        private boolean isUpdateColumn(int n) {
            return !this.m_columns[n].isReadOnly();
        }

        private final void initColumns(Class clazz) {
            int n;
            try {
                n = 0;
                while (n < this.m_columns.length) {
                    this.m_columns[n].init(clazz);
                    ++n;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Internal error: NoSuchMethod while initializing DBO " + clazz + " " + noSuchMethodException);
            }
            n = 0;
            int n2 = 0;
            int n3 = 0;
            n = 0;
            while (n < this.m_columns.length) {
                if (!this.m_columns[n].isColumn()) break;
                if (this.m_columns[n].isUniqueID()) {
                    this.m_uniqueIDCol = n;
                }
                if (this.m_columns[n].isIdentity()) {
                    ++n2;
                }
                if (this.isUpdateColumn(n)) {
                    ++n3;
                }
                ++n;
            }
            this.m_numColumns = n;
            if (n3 <= 0) {
                throw new RuntimeException("Internal error: DBO " + clazz.getName() + " has no updatable columns!");
            }
            this.m_identityCols = new Column[n2];
            this.m_updateCols = new Column[n3];
            int n4 = 0;
            int n5 = 0;
            n = 0;
            while (n < this.m_numColumns) {
                if (this.m_columns[n].isIdentity()) {
                    this.m_identityCols[n4] = this.m_columns[n];
                    ++n4;
                }
                if (!this.m_columns[n].isReadOnly()) {
                    this.m_updateCols[n5] = this.m_columns[n];
                    ++n5;
                }
                ++n;
            }
        }

        private void generateSql() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into [").append(this.m_tableName).append("] (");
            boolean bl = true;
            int n = 0;
            while (n < this.m_updateCols.length) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(this.m_updateCols[n].getColumnName());
                ++n;
            }
            stringBuffer.append(") values (?");
            int n2 = 1;
            while (n2 < this.m_updateCols.length) {
                stringBuffer.append(",?");
                ++n2;
            }
            stringBuffer.append(");");
            this.m_insertSql = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            stringBuffer.append("update [").append(this.m_tableName).append("] set ");
            bl = true;
            int n3 = 0;
            while (n3 < this.m_updateCols.length) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(this.m_updateCols[n3].getColumnName()).append("=?");
                ++n3;
            }
            this.appendUpdateWhereClause(stringBuffer);
            this.m_updateSql = stringBuffer.toString();
            if (this.m_identityCols.length > 0) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.m_tableName).append(" where (");
                int n4 = 0;
                while (n4 < this.m_identityCols.length) {
                    if (n4 != 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(this.m_identityCols[n4].getColumnName()).append("=?");
                    ++n4;
                }
                stringBuffer.append(")");
                this.m_uniqueQuerySql = "select * from " + stringBuffer.toString();
                if (this.m_uniqueIDCol != -1) {
                    this.m_uniqueIdSql = "select " + this.m_columns[this.m_uniqueIDCol].getColumnName() + " from " + stringBuffer.toString();
                }
            }
        }

        protected void appendUpdateWhereClause(StringBuffer stringBuffer) {
            if (this.m_uniqueIDCol != -1) {
                stringBuffer.append(" where ").append(this.m_columns[this.m_uniqueIDCol].getColumnName()).append("=? ");
            } else {
                stringBuffer.append(" where (");
                int n = 0;
                while (n < this.m_identityCols.length) {
                    if (n != 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(this.m_identityCols[n].getColumnName()).append("=?");
                    ++n;
                }
                stringBuffer.append(")");
            }
        }

        public final void prepareInsert(Object object, PreparedStatement preparedStatement) throws SQLException {
            int n = 0;
            while (n < this.m_updateCols.length) {
                this.m_updateCols[n].setParam(object, preparedStatement, n + 1);
                ++n;
            }
        }

        public final void prepareUpdate(Object object, PreparedStatement preparedStatement) throws SQLException {
            this.prepareInsert(object, preparedStatement);
            this.prepareUpdateWhereClause(object, preparedStatement, this.m_updateCols.length);
        }

        protected void prepareUpdateWhereClause(Object object, PreparedStatement preparedStatement, int n) throws SQLException {
            if (this.m_uniqueIDCol != -1) {
                this.m_columns[this.m_uniqueIDCol].setParam(object, preparedStatement, n + 1);
            } else {
                int n2 = 0;
                while (n2 < this.m_identityCols.length) {
                    this.m_identityCols[n2].setParam(object, preparedStatement, n + n2 + 1);
                    ++n2;
                }
            }
        }

        public void prepareUniqueQuery(Object object, PreparedStatement preparedStatement) throws SQLException {
            int n = 0;
            while (n < this.m_identityCols.length) {
                this.m_identityCols[n].setParam(object, preparedStatement, n + 1);
                ++n;
            }
        }

        public void setUniqueID(Object object, int n) throws SQLException {
            if (this.m_uniqueIDCol != -1) {
                this.m_columns[this.m_uniqueIDCol].setValue(object, new Integer(n));
            }
        }

        public final void setValues(Object object, ResultSet resultSet) throws SQLException {
            int n = resultSet.getMetaData().getColumnCount();
            if (n > this.m_numColumns) {
                n = this.m_numColumns;
            }
            if (this.m_resultsByName) {
                HashMap<String, Column> hashMap = new HashMap<String, Column>(this.m_columns.length);
                int n2 = 0;
                while (n2 < this.m_columns.length) {
                    hashMap.put(this.m_columns[n2].getColumnName(), this.m_columns[n2]);
                    ++n2;
                }
                int n3 = 1;
                while (n3 <= n) {
                    String string = resultSet.getMetaData().getColumnName(n3);
                    Column column = (Column)hashMap.get(string);
                    if (!column.isWriteOnly()) {
                        column.getParam(object, resultSet, n3);
                    }
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    if (!this.m_columns[n4].isWriteOnly()) {
                        this.m_columns[n4].getParam(object, resultSet, n4 + 1);
                    }
                    ++n4;
                }
            }
        }
    }

    public static class UniqueIdentifierColumn
    extends Column {
        public UniqueIdentifierColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public UniqueIdentifierColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return class$java$lang$String == null ? (class$java$lang$String = DatabaseObjectImpl.class$("java.lang.String")) : class$java$lang$String;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 12);
            } else {
                preparedStatement.setString(n, (String)object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }
    }

    public static class ClobColumn
    extends Column {
        public ClobColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public ClobColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return class$java$lang$String == null ? (class$java$lang$String = DatabaseObjectImpl.class$("java.lang.String")) : class$java$lang$String;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 2005);
            } else {
                preparedStatement.setString(n, (String)object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            Clob clob = resultSet.getClob(n);
            if (clob == null) {
                return null;
            }
            return clob.getSubString(1L, (int)clob.length());
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            Clob clob = resultSet.getClob(string);
            if (clob == null) {
                return null;
            }
            return clob.getSubString(1L, (int)clob.length());
        }
    }

    public static class BinaryColumn
    extends Column {
        public BinaryColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public BinaryColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return array$B == null ? (array$B = DatabaseObjectImpl.class$("[B")) : array$B;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, -2);
            } else {
                preparedStatement.setBytes(n, (byte[])object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBytes(string);
        }
    }

    public static class TimestampColumn
    extends Column {
        public TimestampColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public TimestampColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DatabaseObjectImpl.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 93);
            } else {
                preparedStatement.setTimestamp(n, (Timestamp)object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getTimestamp(n);
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getTimestamp(string);
        }
    }

    public static class BooleanColumn
    extends Column {
        private boolean m_allowsNulls = false;

        public BooleanColumn(String string, String string2, int n, boolean bl) {
            super(string, string2, n);
            this.m_allowsNulls = bl;
        }

        public BooleanColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public BooleanColumn(String string, int n) {
            this(string, string, n);
        }

        public BooleanColumn(String string, int n, boolean bl) {
            this(string, string, n);
            this.m_allowsNulls = bl;
        }

        protected Class getJavaType() {
            if (this.m_allowsNulls) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabaseObjectImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return Boolean.TYPE;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 16);
            } else {
                preparedStatement.setBoolean(n, (Boolean)object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            boolean bl = resultSet.getBoolean(string);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }
    }

    public static class LongColumn
    extends Column {
        public LongColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public LongColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return Long.TYPE;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 4);
            } else {
                preparedStatement.setLong(n, (Long)object);
            }
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            long l = resultSet.getLong(n);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Long(l);
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            long l = resultSet.getLong(string);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Long(l);
        }
    }

    public static class StringColumn
    extends Column {
        private int m_maxLength = 0;

        public StringColumn(String string, String string2, int n, int n2) {
            super(string, string2, n);
            this.m_maxLength = n2;
        }

        public StringColumn(String string, int n, int n2) {
            this(string, string, n, n2);
        }

        protected Class getJavaType() {
            return class$java$lang$String == null ? (class$java$lang$String = DatabaseObjectImpl.class$("java.lang.String")) : class$java$lang$String;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            String string = (String)object;
            if (string != null && string.length() > this.m_maxLength) {
                string = string.substring(0, this.m_maxLength);
            }
            preparedStatement.setString(n, string);
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            String string = resultSet.getString(n);
            if (resultSet.wasNull()) {
                return null;
            }
            return string;
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            String string2 = resultSet.getString(string);
            if (resultSet.wasNull()) {
                return null;
            }
            return string2;
        }
    }

    public static class IntegerColumn
    extends Column {
        public IntegerColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public IntegerColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = DatabaseObjectImpl.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 4);
            } else {
                preparedStatement.setInt(n, (Integer)object);
            }
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            int n = resultSet.getInt(string);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Integer(n);
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
    }

    public static class IntColumn
    extends Column {
        public IntColumn(String string, String string2, int n) {
            super(string, string2, n);
        }

        public IntColumn(String string, int n) {
            this(string, string, n);
        }

        protected Class getJavaType() {
            return Integer.TYPE;
        }

        protected void setParam(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            if (object == null) {
                preparedStatement.setNull(n, 4);
            } else {
                preparedStatement.setInt(n, (Integer)object);
            }
        }

        protected Object getParam(ResultSet resultSet, String string) throws SQLException {
            int n = resultSet.getInt(string);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Integer(n);
        }

        protected Object getParam(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            if (resultSet.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
    }

    public static abstract class Column {
        private String m_columnName = "";
        private String m_propertyName = "";
        private int m_flags = 0;
        private Method m_getter = null;
        private Method m_setter = null;

        public Column(String string, String string2, int n) {
            this.m_columnName = string;
            this.m_propertyName = string2;
            this.m_flags = n;
        }

        public final Object getValue(Object object) {
            return this.callGetter(object);
        }

        public final void setValue(Object object, Object object2) {
            this.callSetter(object, object2);
        }

        public final void setParam(Object object, PreparedStatement preparedStatement, int n) throws SQLException {
            this.setParam(preparedStatement, n, this.callGetter(object));
        }

        public final void getParam(Object object, ResultSet resultSet) throws SQLException {
            Object object2 = this.getParam(resultSet, this.m_columnName);
            this.callSetter(object, object2);
        }

        public final void getParam(Object object, ResultSet resultSet, int n) throws SQLException {
            Object object2 = this.getParam(resultSet, n);
            this.callSetter(object, object2);
        }

        private final Object callGetter(Object object) {
            try {
                return this.m_getter.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Internal Error: DBO getter threw exception for property " + this.m_propertyName, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Internal Error: DBO getter threw exception for property " + this.m_propertyName, invocationTargetException);
            }
        }

        private final void callSetter(Object object, Object object2) {
            Class clazz = this.getJavaType();
            if (clazz.isPrimitive() && object2 == null) {
                return;
            }
            try {
                this.m_setter.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Internal Error: DBO getter threw exception " + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Internal Error: DBO getter threw exception " + invocationTargetException);
            }
        }

        public final void init(Class clazz) throws NoSuchMethodException {
            String string = "get" + this.m_propertyName;
            this.m_getter = clazz.getMethod(string, null);
            if (this.isColumn() && !this.isWriteOnly()) {
                Class[] classArray;
                string = "set" + this.m_propertyName;
                Class clazz2 = this.getJavaType();
                if (clazz2 == null) {
                    classArray = null;
                } else {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = clazz2;
                }
                Class[] classArray3 = classArray;
                this.m_setter = clazz.getMethod(string, classArray3);
            }
        }

        protected abstract Class getJavaType();

        protected abstract void setParam(PreparedStatement var1, int var2, Object var3) throws SQLException;

        protected abstract Object getParam(ResultSet var1, int var2) throws SQLException;

        protected abstract Object getParam(ResultSet var1, String var2) throws SQLException;

        public final boolean isColumn() {
            return (this.m_flags & 4) == 0;
        }

        public final boolean isUniqueID() {
            return (this.m_flags & 1) != 0;
        }

        public final boolean isIdentity() {
            return (this.m_flags & 2) != 0;
        }

        public final boolean isReadOnly() {
            return (this.m_flags & 8) != 0;
        }

        public final boolean isWriteOnly() {
            return (this.m_flags & 0x10) != 0;
        }

        public final String getColumnName() {
            return this.m_columnName;
        }

        public final String getPropertyName() {
            return this.m_propertyName;
        }
    }
}

