/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.spipe;

import com.mcafee.epo.core.spipe.MemoryBuffer;
import com.mcafee.epo.core.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

public final class EpoCrypto {
    public static final PrivateKey loadEpoPrivateKey(String string) throws IOException, GeneralSecurityException {
        return EpoCrypto.loadEpoPrivateKey(FileUtil.loadAsBuffer(string));
    }

    public static final PrivateKey loadEpoPrivateKey(InputStream inputStream) throws IOException, GeneralSecurityException {
        return EpoCrypto.loadEpoPrivateKey(FileUtil.loadAsBuffer(inputStream));
    }

    public static final PrivateKey loadEpoPrivateKey(byte[] byArray) throws IOException, GeneralSecurityException {
        return (PrivateKey)EpoCrypto.loadEpoKey(byArray, true);
    }

    public static final PublicKey loadEpoPublicKey(String string) throws IOException, GeneralSecurityException {
        return EpoCrypto.loadEpoPublicKey(FileUtil.loadAsBuffer(string));
    }

    public static final PublicKey loadEpoPublicKey(InputStream inputStream) throws IOException, GeneralSecurityException {
        return EpoCrypto.loadEpoPublicKey(FileUtil.loadAsBuffer(inputStream));
    }

    public static final PublicKey loadEpoPublicKey(byte[] byArray) throws IOException, GeneralSecurityException {
        return (PublicKey)EpoCrypto.loadEpoKey(byArray, false);
    }

    public static final byte[] pgpSigToJavaSig(byte[] byArray) throws IOException {
        return EpoCrypto.pgpSigToJavaSig(new MemoryBuffer(byArray), byArray.length);
    }

    public static final byte[] pgpSigToJavaSig(MemoryBuffer memoryBuffer, int n) throws IOException {
        int n2 = memoryBuffer.getPosition() + n;
        byte[] byArray = EpoCrypto.readPGPBigInt(memoryBuffer).toByteArray();
        byte[] byArray2 = EpoCrypto.readPGPBigInt(memoryBuffer).toByteArray();
        if (memoryBuffer.getPosition() != n2) {
            throw new IOException("PGP signature in SPIPE pkg was unexpected length.");
        }
        if (byArray.length >= 128 || byArray2.length >= 128) {
            throw new IOException("Unexpected length R,S in PGP signature.");
        }
        int n3 = byArray.length + byArray2.length + 4;
        if (n3 >= 128) {
            throw new IOException("Unexpected sequence length in PGP signature.");
        }
        byte[] byArray3 = new byte[n3 + 2];
        byArray3[0] = 48;
        byArray3[1] = (byte)n3;
        byArray3[2] = 2;
        byArray3[3] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        int n4 = byArray.length + 4;
        byArray3[n4] = 2;
        byArray3[n4 + 1] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, n4 + 2, byArray2.length);
        return byArray3;
    }

    public static final byte[] javaSigToPgpSig(byte[] byArray) throws IOException {
        byte by = byArray[3];
        int n = 4;
        if (by + 3 >= byArray.length) {
            throw new IOException("javaSigToPgpSig: Invalid length for R:" + by);
        }
        byte by2 = byArray[n + by + 1];
        int n2 = n + by + 2;
        if (by2 + n2 > byArray.length) {
            throw new IOException("javaSigToPgpSig: Invalid length for S:" + by);
        }
        if (byArray[0] != 48 || byArray[n - 2] != 2 || byArray[n2 - 2] != 2) {
            throw new IOException("javaSigToPgpSig: invalid signature format.");
        }
        if (by > 21 || by2 > 21) {
            throw new IOException("javaSigToPgpSig: invalid length for R,S");
        }
        byte[] byArray2 = new byte[by + by2 + 4];
        short s = (short)(by * 8);
        short s2 = (short)(by2 * 8);
        int n3 = 0;
        byArray2[n3 + 0] = (byte)(s >> 8 & 0xFF);
        byArray2[n3 + 1] = (byte)(s & 0xFF);
        System.arraycopy(byArray, n, byArray2, n3 += 2, by);
        byArray2[(n3 += by) + 0] = (byte)(s2 >> 8 & 0xFF);
        byArray2[n3 + 1] = (byte)(s2 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, n3 += 2, by2);
        return byArray2;
    }

    public static final Key loadEpoKey(byte[] byArray, boolean bl) throws IOException, GeneralSecurityException {
        MemoryBuffer memoryBuffer = new MemoryBuffer(byArray);
        BigInteger bigInteger = EpoCrypto.readPGPBigInt(memoryBuffer);
        BigInteger bigInteger2 = EpoCrypto.readPGPBigInt(memoryBuffer);
        BigInteger bigInteger3 = EpoCrypto.readPGPBigInt(memoryBuffer);
        BigInteger bigInteger4 = EpoCrypto.readPGPBigInt(memoryBuffer);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        if (!bl) {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            return keyFactory.generatePublic(dSAPublicKeySpec);
        }
        byte by = memoryBuffer.readInt8();
        if (by != 0) {
            throw new IOException("Unknown PGP protection algorithm:" + by);
        }
        BigInteger bigInteger5 = EpoCrypto.readPGPBigInt(memoryBuffer);
        if (memoryBuffer.getPosition() + 2 != memoryBuffer.getLength()) {
            throw new IOException("key file of unexpected size!");
        }
        DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger5, bigInteger, bigInteger2, bigInteger3);
        return keyFactory.generatePrivate(dSAPrivateKeySpec);
    }

    public static final BigInteger readPGPBigInt(MemoryBuffer memoryBuffer) throws IOException {
        return new BigInteger(1, EpoCrypto.readPGPBigIntAsBytes(memoryBuffer));
    }

    private static final byte[] readPGPBigIntAsBytes(MemoryBuffer memoryBuffer) throws IOException {
        short s = memoryBuffer.readInt16BE();
        int n = (s + 7) / 8;
        return memoryBuffer.readBytes(n);
    }
}

