/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.ui;

import com.mcafee.epo.common.server.ServerNative;
import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.util.resource.Resource;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class LoginAction
extends ActionBeanBase {
    public static final String LOGIN_ATTEMPTS = "loginattempts";
    public static final String SSPI_CONTINUE = "sspiContinue";
    public static final String DISPLAY_ERROR_MESSAGE = "LoginActionDisplayErrorMsg";
    private static final String SSPI_TOKEN = "sspitoken";
    private static final String SSPI_STAGE = "sspistage";
    private static final String SSPI_COOKIE = "sspicookie";
    private static final String CONTENT_TYPE_APPLICATION_DATA = "application/octet-stream";
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$ui$LoginAction == null ? (class$com$mcafee$epo$core$ui$LoginAction = LoginAction.class$("com.mcafee.epo.core.ui.LoginAction")) : class$com$mcafee$epo$core$ui$LoginAction));
    private String m_name = null;
    private String m_password = null;
    private String m_langId = null;
    private boolean m_passwordHashed = false;
    private String m_target = "";
    private boolean m_sspi = false;
    private String m_sspiToken = null;
    private long m_sspiStage = 0L;
    static /* synthetic */ Class class$com$mcafee$epo$core$ui$LoginAction;

    public abstract String loginSuccessful(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract String loginFailed(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract String loginError(HttpServletRequest var1, String var2);

    public void initBean(HttpServletRequest httpServletRequest) {
        String string;
        this.m_name = httpServletRequest.getParameter("name");
        this.m_password = httpServletRequest.getParameter("password");
        this.m_langId = httpServletRequest.getParameter("LanguageId");
        String string2 = httpServletRequest.getParameter("hashed");
        this.m_passwordHashed = string2 != null ? new Boolean(string2) : false;
        String string3 = httpServletRequest.getParameter("target");
        if (string3 != null) {
            this.m_target = string3;
        }
        this.m_sspi = (string = httpServletRequest.getParameter("sspi")) != null ? new Boolean(string) : false;
    }

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        if (!this.m_sspi && (this.m_password == null || this.m_name == null) || this.m_langId == null) {
            return this.loginError(httpServletRequest, Resource.getString("loginaction_unable_to_process"));
        }
        return null;
    }

    public Connection getDatabaseConnection() throws Exception {
        if (EpoCore.isInitialized()) {
            return EpoCore.getEpoDb().getConnection();
        }
        throw new Exception(Resource.getString("loginaction_no_db"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = null;
        boolean bl = false;
        Integer n = (Integer)httpServletRequest.getSession().getAttribute(LOGIN_ATTEMPTS);
        n = n == null ? new Integer(1) : new Integer(n + 1);
        m_log.debug((Object)("Login attempts: " + n));
        if (n > 3) {
            String string2 = Resource.formatString("loginaction_failed_too_many", new String[]{this.m_name, httpServletRequest.getRemoteAddr()});
            m_log.error((Object)string2);
            return this.loginError(httpServletRequest, string2);
        }
        HttpSession httpSession = httpServletRequest.getSession();
        String string3 = httpSession.getId();
        Vector vector = new Vector();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            m_log.debug((Object)("Removing attribute: " + (String)object));
            httpSession.removeAttribute((String)object);
        }
        object = null;
        try {
            block27: {
                try {
                    StringBuffer stringBuffer;
                    boolean bl2;
                    boolean bl3;
                    EpoUser epoUser;
                    block26: {
                        block29: {
                            block31: {
                                StringBuffer stringBuffer2;
                                block32: {
                                    block30: {
                                        object = this.getDatabaseConnection();
                                        epoUser = null;
                                        if (!this.m_sspi) {
                                            m_log.debug((Object)("Getting username " + this.m_name + " from the epo database."));
                                            epoUser = EpoUser.getByName((Connection)object, this.m_name);
                                            m_log.debug((Object)("Is password hashed: " + this.m_passwordHashed));
                                            if (this.m_passwordHashed) {
                                                this.m_password = this.m_password.replace(' ', '+');
                                            }
                                        }
                                        bl3 = false;
                                        bl2 = false;
                                        stringBuffer = new StringBuffer();
                                        stringBuffer2 = new StringBuffer();
                                        if (!this.m_sspi) break block29;
                                        m_log.debug((Object)"start SSPI authentication");
                                        this.m_sspiToken = httpServletRequest.getHeader(SSPI_TOKEN);
                                        String string4 = httpServletRequest.getHeader(SSPI_STAGE);
                                        this.m_sspiStage = new Integer(string4).longValue();
                                        if (this.m_sspiStage != 1L) break block30;
                                        int n2 = EpoUser.sspiValidate(this.m_sspiStage, string3, this.m_sspiToken, stringBuffer, stringBuffer2);
                                        if (n2 == 0) {
                                            bl3 = true;
                                            break block26;
                                        } else if (n2 == 2) {
                                            bl2 = true;
                                        }
                                        break block26;
                                    }
                                    if (this.m_sspiStage != 2L) break block26;
                                    int n3 = EpoUser.sspiValidate(this.m_sspiStage, string3, this.m_sspiToken, stringBuffer, stringBuffer2);
                                    if (n3 != 0) break block31;
                                    m_log.debug((Object)("SSPI authentication successful, remote user: " + stringBuffer2));
                                    epoUser = EpoUser.getByName((Connection)object, stringBuffer2.toString());
                                    if (epoUser == null) break block32;
                                    m_log.debug((Object)("Found user " + stringBuffer2 + " in epo database."));
                                    bl3 = true;
                                    epoUser.setIsSSPIUser(true);
                                    this.m_name = stringBuffer2.toString();
                                    break block26;
                                }
                                StringBuffer stringBuffer3 = new StringBuffer();
                                ServerNative.getCurrentUser(stringBuffer3);
                                if (stringBuffer3.toString().equalsIgnoreCase(stringBuffer2.toString())) {
                                    m_log.debug((Object)("User " + stringBuffer2 + " matches service user " + stringBuffer3));
                                    bl3 = true;
                                    epoUser = new EpoUser();
                                    epoUser.setIsSSPIUser(true);
                                    this.m_name = stringBuffer2.toString();
                                    break block26;
                                } else {
                                    String string5 = EpoCore.getEpoDb().userDomain();
                                    String string6 = string5 + "\\" + EpoCore.getEpoDb().userName();
                                    if (!string5.equals("") && string6.equalsIgnoreCase(stringBuffer2.toString())) {
                                        m_log.debug((Object)("User " + stringBuffer2 + " matches service DB user " + string6));
                                        bl3 = true;
                                        epoUser = new EpoUser();
                                        epoUser.setIsSSPIUser(true);
                                        this.m_name = stringBuffer2.toString();
                                        break block26;
                                    } else {
                                        m_log.debug((Object)("User " + stringBuffer2 + " not found in epo database."));
                                    }
                                }
                                break block26;
                            }
                            m_log.debug((Object)"SSPI authentication failed.");
                            break block26;
                        }
                        if (epoUser != null) {
                            bl3 = epoUser.getNTUser() ? epoUser.validateLogin(this.m_password) : (this.m_passwordHashed ? epoUser.validateLoginHashed(this.m_password) : epoUser.validateLogin(this.m_password));
                        }
                    }
                    if (bl3) {
                        UserUtil.saveEpoUser(epoUser, httpServletRequest);
                        m_log.debug((Object)("User " + this.m_name + " logged in successful"));
                        DatabaseUtil.close((Connection)object);
                        object = null;
                        this.m_user = epoUser;
                        string = this.loginSuccessful(httpServletRequest, httpServletResponse);
                        bl = true;
                        this.m_user = null;
                        break block27;
                    }
                    if (bl2) {
                        httpServletResponse.setHeader(SSPI_TOKEN, stringBuffer.toString());
                        string = SSPI_CONTINUE;
                        n = new Integer(n - 1);
                        break block27;
                    }
                    if (m_log.isDebugEnabled()) {
                        if (epoUser == null) {
                            m_log.debug((Object)"Failed to find the ePO user in the database.");
                        } else {
                            m_log.debug((Object)("Password validation failed for user: " + this.m_name));
                        }
                    }
                    UserUtil.clearEpoUser(httpServletRequest);
                    string = this.loginFailed(httpServletRequest, httpServletResponse);
                }
                catch (Exception exception) {
                    m_log.error((Object)"Login failed.", (Throwable)exception);
                    string = this.loginError(httpServletRequest, exception.getMessage());
                    Object var23_26 = null;
                    if (object != null) {
                        DatabaseUtil.close((Connection)object);
                    }
                }
            }
            Object var23_25 = null;
            if (object != null) {
                DatabaseUtil.close((Connection)object);
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            if (object != null) {
                DatabaseUtil.close((Connection)object);
            }
            throw throwable;
        }
        if (!bl) {
            httpServletRequest.getSession().setAttribute(LOGIN_ATTEMPTS, (Object)n);
        }
        return string;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public void setLanguageId(String string) {
        this.m_langId = string;
    }

    public String getLanguageId() {
        return this.m_langId;
    }

    public boolean getHashed() {
        return this.m_passwordHashed;
    }

    public void setHashed(boolean bl) {
        this.m_passwordHashed = bl;
    }

    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String string) {
        this.m_target = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

