/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util;

import com.mcafee.epo.core.util.DateParserException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateParser {
    private SimpleDateFormat m_format = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss.SSSZ");
    private ParsePosition m_parsePos = new ParsePosition(0);

    public Date convert(String string) throws DateParserException {
        string = DateParser.fixupDate(string);
        this.m_parsePos.setIndex(0);
        Date date = this.m_format.parse(string, this.m_parsePos);
        if (date == null) {
            throw new DateParserException(string);
        }
        return date;
    }

    public String convert(Date date, TimeZone timeZone) {
        this.m_format.setTimeZone(timeZone);
        String string = this.m_format.format(date);
        int n = string.length();
        return string.substring(0, n - 2) + ":" + string.substring(n - 2);
    }

    public String convert(Date date) {
        return this.convert(date, TimeZone.getDefault());
    }

    public static final String fixupDate(String string) {
        int n = string.length();
        if (n > 6 && string.charAt(n - 3) == ':' && (string.charAt(n - 6) == '-' || string.charAt(n - 6) == '+')) {
            return string.substring(0, n - 3) + string.substring(n - 2, n);
        }
        return string;
    }
}

