/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$core$util$FileUtil == null ? (class$com$mcafee$epo$core$util$FileUtil = FileUtil.class$("com.mcafee.epo.core.util.FileUtil")) : class$com$mcafee$epo$core$util$FileUtil).getName());
    static /* synthetic */ Class class$com$mcafee$epo$core$util$FileUtil;

    public static final String loadAsString(String string) throws IOException {
        return FileUtil.loadAsString(new FileReader(string));
    }

    public static final String loadAsString(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((n = bufferedReader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static final byte[] loadAsBuffer(String string) throws IOException {
        return FileUtil.loadAsBuffer(new FileInputStream(string));
    }

    public static final byte[] loadAsBuffer(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final boolean renameFile(File file, File file2) {
        if (!file.renameTo(file2)) {
            try {
                int n;
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
                file.delete();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static final boolean renameFile(String string, String string2) {
        return FileUtil.renameFile(new File(string), new File(string2));
    }

    public static final boolean deleteTree(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                bl = FileUtil.deleteTree(new File(file, stringArray[n]));
                if (!bl) {
                    return false;
                }
                ++n;
            }
        }
        if (file.exists()) {
            int n = 3;
            do {
                --n;
                bl = file.delete();
                if (bl) continue;
                m_log.error((Object)("Failed to delete " + file.getAbsolutePath()));
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!bl && n > 0);
            if (!bl && file.isDirectory()) {
                bl = true;
            }
        }
        return bl;
    }

    public static final void copyFile(File file, String string) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Failed to copy file, " + file);
        }
        File file2 = new File(string);
        if (file2.exists()) {
            if (file2.isDirectory()) {
                throw new IOException("Output file, " + string + " already exists and is a directory.");
            }
            file2.delete();
        }
        FileUtil.copyFile(new FileInputStream(file), new FileOutputStream(file2), file.length(), true);
    }

    public static final void copyFile(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        FileUtil.copyFile(inputStream, outputStream, l, true);
    }

    public static final void copyFile(InputStream inputStream, OutputStream outputStream, long l, boolean bl) throws IOException {
        long l2 = 0L;
        byte[] byArray = new byte[1024];
        while (l2 < l) {
            Arrays.fill(byArray, (byte)0);
            int n = inputStream.read(byArray);
            outputStream.write(byArray, 0, n);
            l2 += (long)n;
        }
        if (bl) {
            inputStream.close();
            outputStream.close();
        }
    }

    public static final File[] getFiles(File file, final String string) {
        File[] fileArray = string != null ? file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return Pattern.matches(string, file.getName());
            }
        }) : file.listFiles();
        return fileArray;
    }

    public static final void zipFiles(File file, File file2, int n) throws IOException {
        FileUtil.zipFiles(file, file2, null, n);
    }

    public static final void zipFiles(File file, File file2, String string, int n) throws IOException {
        if (file != null && file2 != null) {
            if (!file2.exists()) {
                file2.createNewFile();
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(n);
            FileUtil.doZip(file.getPath(), file, zipOutputStream, string);
            zipOutputStream.close();
        }
    }

    private static final void doZip(String string, File file, ZipOutputStream zipOutputStream, String string2) throws IOException {
        File[] fileArray = FileUtil.getFiles(file, string2);
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                FileUtil.doZip(string, fileArray[n], zipOutputStream, string2);
            } else {
                String string3 = fileArray[n].getPath().substring(string.length());
                ZipEntry zipEntry = new ZipEntry(string3);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(fileArray[n]);
                FileUtil.copyFile(fileInputStream, zipOutputStream, fileArray[n].length(), false);
                fileInputStream.close();
            }
            ++n;
        }
    }

    public static final void copyDir(File file, String string) throws IOException {
        FileUtil.copyDir(file, string, null);
    }

    public static final void copyDir(File file, String string, String string2) throws IOException {
        if (file != null && string != null) {
            File file2 = new File(string);
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    throw new IOException("Target directory exists and is not empty: " + string);
                }
            } else {
                file2.mkdirs();
            }
            File[] fileArray = FileUtil.getFiles(file, string2);
            int n = 0;
            while (n < fileArray.length) {
                String string3 = file2.getPath() + "/" + fileArray[n].getName();
                if (fileArray[n].isDirectory()) {
                    FileUtil.copyDir(fileArray[n], string3, string2);
                } else {
                    File file3 = new File(string3);
                    if (file3.exists()) {
                        file3.delete();
                    }
                    file3.createNewFile();
                    FileUtil.copyFile(new FileInputStream(fileArray[n]), new FileOutputStream(file3), fileArray[n].length());
                }
                ++n;
            }
        }
    }

    public static final File createTempDir(String string) {
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = string2 + "/" + string;
        File file = new File(string3);
        file.mkdir();
        return file;
    }

    public static final void delTree(File file) {
        FileUtil.delTree(file, null);
    }

    public static final void delTree(File file, String string) {
        if (file != null) {
            File[] fileArray = FileUtil.getFiles(file, string);
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    FileUtil.delTree(fileArray[n], null);
                } else {
                    fileArray[n].delete();
                }
                ++n;
            }
            if (string != null) {
                fileArray = FileUtil.getFiles(file, null);
                int n2 = 0;
                while (n2 < fileArray.length) {
                    if (fileArray[n2].isDirectory()) {
                        FileUtil.delTree(fileArray[n2], string);
                    }
                    ++n2;
                }
            }
            file.delete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

