/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util.thread;

import com.mcafee.epo.core.util.thread.FileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.TreeSet;

public class FileBiff
extends Thread {
    private static final long DEFAULT_DELAY = 5000L;
    private long m_delay = 5000L;
    private TreeSet m_watchers = new TreeSet();
    private boolean m_continue = true;
    private boolean m_isRunning = false;

    public FileBiff(long l) {
        this.m_delay = l;
        this.start();
    }

    public FileBiff() {
        this.start();
    }

    public void start() {
        if (!this.m_isRunning) {
            super.start();
            this.m_isRunning = true;
        }
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean bl) {
        block2: {
            this.m_continue = false;
            this.interrupt();
            if (!bl) break block2;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addChangeListener(String string, FileChangeListener fileChangeListener) throws FileNotFoundException {
        this.setupFileWatcher(string, this.m_delay, fileChangeListener);
    }

    public void addChangeListener(String string, long l, FileChangeListener fileChangeListener) throws FileNotFoundException {
        this.setupFileWatcher(string, l, fileChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(String string, FileChangeListener fileChangeListener) {
        TreeSet treeSet = this.m_watchers;
        synchronized (treeSet) {
            Iterator iterator = this.m_watchers.iterator();
            while (iterator.hasNext()) {
                FileWatcher fileWatcher = (FileWatcher)iterator.next();
                if (fileChangeListener != fileWatcher.getFileChangeListener() || fileWatcher.getAbsolutePath().indexOf(string) == -1) continue;
                this.m_watchers.remove(fileChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllChangeListeners() {
        TreeSet treeSet = this.m_watchers;
        synchronized (treeSet) {
            this.m_watchers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFileWatcher(String string, long l, FileChangeListener fileChangeListener) throws FileNotFoundException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string);
        }
        this.addFileWatcher(new FileWatcher(file, fileChangeListener, l));
        TreeSet treeSet = this.m_watchers;
        synchronized (treeSet) {
            this.m_watchers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkWatchersSize() {
        TreeSet treeSet = this.m_watchers;
        // MONITORENTER : treeSet
        while (this.m_watchers.size() == 0 && this.m_continue) {
            try {
                this.m_watchers.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : treeSet
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWatcher getNext() {
        FileWatcher fileWatcher = null;
        TreeSet treeSet = this.m_watchers;
        synchronized (treeSet) {
            if (this.m_watchers.size() > 0) {
                fileWatcher = (FileWatcher)this.m_watchers.first();
                this.m_watchers.remove(fileWatcher);
            }
        }
        return fileWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWatcher(FileWatcher fileWatcher) {
        TreeSet treeSet = this.m_watchers;
        synchronized (treeSet) {
            this.m_watchers.add(fileWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (this.m_continue) {
            this.checkWatchersSize();
            object = null;
            while ((object = this.getNext()) != null) {
                try {
                    long l = ((FileWatcher)object).getNextCheckTime() - System.currentTimeMillis();
                    if (l > 0L) {
                        Thread.sleep(l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_continue) continue;
                ((FileWatcher)object).doCheck();
                this.addFileWatcher((FileWatcher)object);
            }
        }
        object = this.m_watchers;
        synchronized (object) {
            this.m_watchers.clear();
        }
        FileBiff fileBiff = this;
        synchronized (fileBiff) {
            this.notify();
        }
        this.m_isRunning = false;
    }

    private class FileWatcher
    implements Comparable {
        private File m_file;
        private long m_nextTimeToCheck;
        private long m_delay;
        private long m_lastModifiedTime;
        FileChangeListener m_listener;

        public FileWatcher(File file, FileChangeListener fileChangeListener, long l) {
            this.m_listener = fileChangeListener;
            this.m_file = file;
            this.m_delay = l;
            this.m_nextTimeToCheck = System.currentTimeMillis() + l;
            this.m_lastModifiedTime = this.m_file.lastModified();
        }

        public long getNextCheckTime() {
            return this.m_nextTimeToCheck;
        }

        public FileChangeListener getFileChangeListener() {
            return this.m_listener;
        }

        public String getAbsolutePath() {
            return this.m_file.getAbsolutePath();
        }

        public boolean isModified() {
            boolean bl = false;
            long l = this.m_file.lastModified();
            if (this.m_lastModifiedTime != l) {
                this.m_lastModifiedTime = l;
                bl = true;
            }
            return bl;
        }

        public void doCheck() {
            if (this.isModified()) {
                this.m_listener.onFileChanged(this.m_file.getAbsolutePath());
            }
            this.m_nextTimeToCheck += this.m_delay;
        }

        public int compareTo(Object object) {
            return (int)(this.m_nextTimeToCheck - ((FileWatcher)object).m_nextTimeToCheck);
        }
    }
}

