/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.db;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.notifications.util.Resource;
import com.mcafee.epo.utility.hashtable.FormattedHashtable;
import com.mcafee.epo.utility.hashtable.FormattedTimeHashtable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class NotificationLog
extends DatabaseObject {
    private static final int JTDS_MAX_LEN = 3990;
    public static final String TABLE_NAME = "NotificationLog";
    public static final int COL_ID = 1;
    public static final int COL_NOTIFICATION_TYPE = 2;
    public static final int COL_NOTIFICATION_DETAILS = 3;
    public static final int COL_NOTIFICATION_RECIPIENTS = 4;
    public static final int COL_STATUS = 5;
    public static final int COL_TIME_NOTIFICATION_SENT = 6;
    public static final int COL_PRIORITY = 7;
    public static final int COL_NOTIFICATION_RULE_ID = 8;
    public static final int COL_NOTIFICATION_RULE_NAME = 9;
    public static final int COL_SITE_ID = 10;
    public static final int COL_SITE_NODE_NAME = 11;
    public static final int COL_BRANCH_NODE_PATH = 12;
    public static final int COL_RECEIVED_PRODUCT_FAMILIES = 13;
    public static final int COL_RECEIVED_EVENT_CATEGORIES = 14;
    public static final int COL_FIRST_EVENT_TIME = 15;
    public static final int COL_RECEIVED_NUM_COMPUTERS = 16;
    public static final int COL_RECEIVED_NUM_EVENTS = 17;
    public static final int COL_CONFIGURED_PRODUCT_FAMILY = 18;
    public static final int COL_CONFIGURED_EVENT_CATEGORY = 19;
    public static final int COL_THREAT_TEXT = 20;
    public static final int COL_THREAT_TEXT_OPERATOR = 21;
    public static final int COL_RECEIVED_THREAT_NAME = 22;
    public static final int COL_SOURCE_COMPUTER = 23;
    public static final int COL_AFFECTED_COMPUTER_IP = 24;
    public static final int COL_AFFECTED_COMPUTER_NAME = 25;
    public static final int COL_AFFECTED_OBJECT = 26;
    public static final int COL_ADDITIONAL_INFORMATION = 27;
    public static final int COL_MESSAGE_SUBJECT = 28;
    public static final int COL_MESSAGE_BODY = 29;
    public static final int COL_NOTIFICATION_OUTPUT = 30;
    public static final int COL_EVENT_IDS = 31;
    public static final int COL_EVENT_DESCRIPTIONS = 32;
    public static final int PROP_CONFIGURED_THREAT_NAME = 33;
    public static final int NUM_COLUMNS = 32;
    public static final int NUM_STUNTED_COLUMNS = 17;
    public static final int MAX_LEN_NOTIFICATION_TYPE = 25;
    public static final int MAX_LEN_NOTIFICATION_DETAILS = 255;
    public static final int MAX_LEN_NOTIFICATION_RECIPIENTS = 255;
    public static final int MAX_LEN_NOTIFICATION_RULENAME = 50;
    public static final int MAX_LEN_BRANCH_NODE_PATH = 512;
    public static final int MAX_LEN_SITE_NODE_NAME = 255;
    public static final int MAX_LEN_RPF = 1024;
    public static final int MAX_LEN_REC = 3000;
    public static final int MAX_LEN_CPF = 1024;
    public static final int MAX_LEN_CEC = 3000;
    public static final int MAX_LEN_SUBJECT = 255;
    public static final int MAX_LEN_THREAT_TEXT = 128;
    public static final int MAX_LEN_THREAT_OPERATOR = 64;
    public static final String[] PROPERTY_NAMES = new String[]{"", "NotificationLogId", "NotificationType", "NotificationDetails", "NotificationRecipients", "Status", "TimeNotificationSent", "Priority", "NotificationRuleId", "NotificationRuleName", "SiteId", "SiteNodeName", "BranchNodePath", "ReceivedProductFamilies", "ReceivedEventCategories", "FirstEventTime", "ReceivedNumComputers", "ReceivedNumEvents", "ConfiguredProductFamilies", "ConfiguredEventCategories", "ThreatText", "ThreatTextOperator", "ReceivedThreatNames", "SourceComputers", "AffectedComputerIPs", "AffectedComputerNames", "AffectedObjects", "AdditionalInformation", "MessageSubject", "MessageBody", "ActionOutput", "EventIDs", "EventDescriptions", "ConfiguredThreatName"};
    public static final int NUM_PROPERTIES = PROPERTY_NAMES.length;
    protected static final String UNIQUE_SQL = "select * from NotificationLog where NotificationLogId=?";
    private long m_id = -1L;
    private String m_type = null;
    private String m_notDetails = null;
    private String m_notRecipients = null;
    private int m_status = -1;
    private Timestamp m_timestamp = new Timestamp(System.currentTimeMillis());
    private int m_priority = 0;
    private long m_ruleId = -1L;
    private String m_ruleName = null;
    private long m_siteId = -1L;
    private String m_siteName = null;
    private String m_branchNodePath = null;
    private Collection m_recProdFam = null;
    private Collection m_recEventCat = null;
    private Timestamp m_firstEvent = null;
    private int m_recNumComputers = 0;
    private int m_recNumEvents = 0;
    private Collection m_conProdFam = null;
    private Collection m_conEventCat = null;
    private String m_threatText = null;
    private String m_threatOp = null;
    private Collection m_recThreats = null;
    private Collection m_sourceComp = null;
    private Collection m_affectedIPs = null;
    private Collection m_affectedName = null;
    private Collection m_affectedObj = null;
    private Collection m_addnlInfo = null;
    private String m_msgSubject = null;
    private String m_msgBody = null;
    private String m_output = null;
    private Collection m_eventIds = null;
    private Collection m_eventDesc = null;
    static /* synthetic */ Class class$com$mcafee$epo$notifications$db$NotificationLog;

    public static final Vector getNotificationLogsByQuery(Connection connection, PreparedStatement preparedStatement, Class clazz, int n, int n2) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (PreparedStatement)preparedStatement, (Class)clazz, (int)n, (int)n2);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationLog getById(Connection connection, long l) throws SQLException {
        PreparedStatement preparedStatement;
        Vector vector;
        block4: {
            NotificationLog notificationLog;
            vector = null;
            preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(UNIQUE_SQL);
                preparedStatement.setLong(1, l);
                vector = DatabaseObject.getByQuery((Connection)connection, (PreparedStatement)preparedStatement, (Class)(class$com$mcafee$epo$notifications$db$NotificationLog == null ? (class$com$mcafee$epo$notifications$db$NotificationLog = NotificationLog.class$("com.mcafee.epo.notifications.db.NotificationLog")) : class$com$mcafee$epo$notifications$db$NotificationLog), (int)1, (int)1);
                if (vector.size() >= 1) break block4;
                notificationLog = null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DatabaseUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            DatabaseUtil.close((Statement)preparedStatement);
            return notificationLog;
        }
        if (vector.size() > 1) {
            throw new SQLException("getById() returned >1 row!");
        }
        Object var7_7 = null;
        DatabaseUtil.close((Statement)preparedStatement);
        NotificationLog notificationLog = (NotificationLog)((Object)vector.firstElement());
        return notificationLog;
    }

    public long getNotificationLogId() {
        return this.m_id;
    }

    public void setNotificationLogId(long l) {
        this.m_id = l;
    }

    public long getId() {
        return this.m_id;
    }

    public String getNotificationType() {
        return this.m_type;
    }

    public void setNotificationType(String string) {
        this.m_type = string;
    }

    public String getNotificationDetails() {
        return this.m_notDetails;
    }

    public void setNotificationDetails(String string) {
        this.m_notDetails = string;
    }

    public String getNotificationRecipients() {
        return this.m_notRecipients;
    }

    public void setNotificationRecipients(String string) {
        this.m_notRecipients = string;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public Timestamp getTimeNotificationSent() {
        return this.m_timestamp;
    }

    public void setTimeNotificationSent(Timestamp timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setTimeNotificationSent(long l) {
        this.m_timestamp = new Timestamp(l);
    }

    public void setTimeNotificationSent(FormattedTimeHashtable formattedTimeHashtable) {
        this.m_timestamp = new Timestamp((Long)formattedTimeHashtable.toSimpleObject());
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int n) {
        this.m_priority = n;
    }

    public long getNotificationRuleId() {
        return this.m_ruleId;
    }

    public void setNotificationRuleId(long l) {
        this.m_ruleId = l;
    }

    public void setNotificationRuleId(FormattedHashtable formattedHashtable) {
        this.m_ruleId = (Long)formattedHashtable.toSimpleObject();
    }

    public String getNotificationRuleName() {
        return this.m_ruleName;
    }

    public void setNotificationRuleName(String string) {
        this.m_ruleName = string;
    }

    public void setNotificationRuleName(FormattedHashtable formattedHashtable) {
        this.m_ruleName = (String)formattedHashtable.toSimpleObject();
    }

    public long getSiteId() {
        return this.m_siteId;
    }

    public void setSiteId(long l) {
        this.m_siteId = l;
    }

    public String getSiteNodeName() {
        return this.m_siteName;
    }

    public void setSiteNodeName(String string) {
        this.m_siteName = string;
    }

    public void setSiteNodeName(FormattedHashtable formattedHashtable) {
        this.setSiteNodeName((String)formattedHashtable.toSimpleObject());
    }

    public String getBranchNodePath() {
        return this.m_branchNodePath;
    }

    public void setBranchNodePath(String string) {
        this.m_branchNodePath = string;
    }

    public void setBranchNodePath(FormattedHashtable formattedHashtable) {
        this.setBranchNodePath((String)formattedHashtable.toSimpleObject());
    }

    public Collection getReceivedProductFamilies() {
        return this.m_recProdFam;
    }

    public void setReceivedProductFamilies(Collection collection) {
        this.m_recProdFam = collection;
    }

    public void setReceivedProductFamilies(Hashtable hashtable) {
        this.setReceivedProductFamilies(hashtable.keySet());
    }

    public void setReceivedProductFamilies(FormattedHashtable formattedHashtable) {
        this.setReceivedProductFamilies(formattedHashtable.keySet());
    }

    public void setReceivedProductFamilies(String string) {
        this.setReceivedProductFamilies(this.splitIntoList(string, ":"));
    }

    public void addReceivedProductFamily(String string) {
        if (this.m_recProdFam == null) {
            this.m_recProdFam = new Vector();
        }
        this.m_recProdFam.add(string);
    }

    public void clearReceivedProductFamilies() {
        if (this.m_recProdFam != null) {
            this.m_recProdFam.clear();
        }
    }

    public Collection getReceivedEventCategories() {
        return this.m_recEventCat;
    }

    public void setReceivedEventCategories(Collection collection) {
        this.m_recEventCat = collection;
    }

    public void setReceivedEventCategories(Hashtable hashtable) {
        this.setReceivedEventCategories(hashtable.keySet());
    }

    public void setReceivedEventCategories(FormattedHashtable formattedHashtable) {
        this.setReceivedEventCategories(formattedHashtable.keySet());
    }

    public void setReceivedEventCategories(String string) {
        this.setReceivedEventCategories(this.splitIntoList(string, ":"));
    }

    public void addReceivedEventCategory(String string) {
        if (this.m_recEventCat == null) {
            this.m_recEventCat = new Vector();
        }
        this.m_recEventCat.add(string);
    }

    public void clearReceivedEventCategories() {
        if (this.m_recEventCat != null) {
            this.m_recEventCat.clear();
        }
    }

    public Timestamp getFirstEventTime() {
        return this.m_firstEvent;
    }

    public void setFirstEventTime(Timestamp timestamp) {
        this.m_firstEvent = timestamp;
    }

    public void setFirstEventTime(long l) {
        this.m_firstEvent = new Timestamp(l);
    }

    public void setFirstEventTime(Long l) {
        this.m_firstEvent = new Timestamp(l);
    }

    public void setFirstEventTime(FormattedHashtable formattedHashtable) {
        this.setFirstEventTime((Long)formattedHashtable.toSimpleObject());
    }

    public void setFirstEventTime(FormattedTimeHashtable formattedTimeHashtable) {
        this.setFirstEventTime((Long)formattedTimeHashtable.toSimpleObject());
    }

    public int getReceivedNumComputers() {
        return this.m_recNumComputers;
    }

    public void setReceivedNumComputers(int n) {
        this.m_recNumComputers = n;
    }

    public void setReceivedNumComputers(FormattedHashtable formattedHashtable) {
        this.setReceivedNumComputers(Integer.parseInt(formattedHashtable.toString()));
    }

    public int getReceivedNumEvents() {
        return this.m_recNumEvents;
    }

    public void setReceivedNumEvents(int n) {
        this.m_recNumEvents = n;
    }

    public void setReceivedNumEvents(FormattedHashtable formattedHashtable) {
        this.setReceivedNumEvents(Integer.parseInt(formattedHashtable.toString()));
    }

    public Collection getConfiguredProductFamilies() {
        return this.m_conProdFam;
    }

    public void setConfiguredProductFamilies(Collection collection) {
        this.m_conProdFam = collection;
    }

    public void setConfiguredProductFamilies(String string) {
        this.setConfiguredProductFamilies(this.splitIntoList(string, ":"));
    }

    public Collection getConfiguredEventCategories() {
        return this.m_conEventCat;
    }

    public void setConfiguredEventCategories(Collection collection) {
        this.m_conEventCat = collection;
    }

    public void setConfiguredEventCategories(String string) {
        this.setConfiguredEventCategories(this.splitIntoList(string, ":"));
    }

    public String getThreatText() {
        return this.m_threatText;
    }

    public void setThreatText(String string) {
        this.m_threatText = string;
    }

    public String getThreatTextOperator() {
        return this.m_threatOp;
    }

    public void setThreatTextOperator(String string) {
        this.m_threatOp = string;
    }

    public String getConfiguredThreatName() {
        return this.getConfiguredThreatName(null);
    }

    public String getConfiguredThreatName(String string) {
        String string2 = null;
        if (this.m_threatOp != null) {
            string2 = Resource.getDataString(this.m_threatOp, string);
        }
        if (this.m_threatText != null) {
            string2 = string2 + " " + this.m_threatText;
        }
        return string2;
    }

    public Collection getReceivedThreatNames() {
        return this.m_recThreats;
    }

    public void setReceivedThreatNames(Collection collection) {
        this.m_recThreats = collection;
    }

    public void setReceivedThreatNames(FormattedHashtable formattedHashtable) {
        this.setReceivedThreatNames(formattedHashtable.keySet());
    }

    public void setReceivedThreatNames(String string) {
        this.setReceivedThreatNames(this.splitIntoList(string, ";"));
    }

    public void addThreatName(String string) {
        if (this.m_recThreats == null) {
            this.m_recThreats = new Vector();
        }
        this.m_recThreats.add(string);
    }

    public void clearThreatNames() {
        if (this.m_recThreats != null) {
            this.m_recThreats.clear();
        }
    }

    public Collection getSourceComputers() {
        return this.m_sourceComp;
    }

    public void setSourceComputers(Collection collection) {
        this.m_sourceComp = collection;
    }

    public void setSourceComputers(Hashtable hashtable) {
        this.setSourceComputers(hashtable.keySet());
    }

    public void setSourceComputers(FormattedHashtable formattedHashtable) {
        this.setSourceComputers(formattedHashtable.keySet());
    }

    public void setSourceComputers(String string) {
        this.setSourceComputers(this.splitIntoList(string, ";"));
    }

    public void addSourceComputer(String string) {
        if (this.m_sourceComp == null) {
            this.m_sourceComp = new Vector();
        }
        this.m_sourceComp.add(string);
    }

    public void clearSourceComputers() {
        if (this.m_sourceComp != null) {
            this.m_sourceComp.clear();
        }
    }

    public Collection getAffectedComputerIPs() {
        return this.m_affectedIPs;
    }

    public void setAffectedComputerIPs(Collection collection) {
        this.m_affectedIPs = collection;
    }

    public void setAffectedComputerIPs(Hashtable hashtable) {
        this.setAffectedComputerIPs(hashtable.keySet());
    }

    public void setAffectedComputerIPs(FormattedHashtable formattedHashtable) {
        this.setAffectedComputerIPs(formattedHashtable.keySet());
    }

    public void setAffectedComputerIPs(String string) {
        this.setAffectedComputerIPs(this.splitIntoList(string, ";"));
    }

    public void addAffectedComputerIP(String string) {
        if (this.m_affectedIPs == null) {
            this.m_affectedIPs = new Vector();
        }
        this.m_affectedIPs.add(string);
    }

    public void clearAffectedComputerIPs() {
        if (this.m_affectedIPs != null) {
            this.m_affectedIPs.clear();
        }
    }

    public Collection getAffectedComputerNames() {
        return this.m_affectedName;
    }

    public void setAffectedComputerNames(Collection collection) {
        this.m_affectedName = collection;
    }

    public void setAffectedComputerNames(FormattedHashtable formattedHashtable) {
        this.setAffectedComputerNames(formattedHashtable.keySet());
    }

    public void setAffectedComputerNames(String string) {
        this.setAffectedComputerNames(this.splitIntoList(string, ";"));
    }

    public void addAffectedComputerNames(String string) {
        if (this.m_affectedName == null) {
            this.m_affectedName = new Vector();
        }
        this.m_affectedName.add(string);
    }

    public void clearAffectedComputerNames() {
        if (this.m_affectedName != null) {
            this.m_affectedName.clear();
        }
    }

    public Collection getAffectedObjects() {
        return this.m_affectedObj;
    }

    public void setAffectedObjects(Collection collection) {
        this.m_affectedObj = collection;
    }

    public void setAffectedObjects(FormattedHashtable formattedHashtable) {
        this.setAffectedObjects(formattedHashtable.keySet());
    }

    public void setAffectedObjects(String string) {
        this.setAffectedObjects(this.splitIntoList(string, ";"));
    }

    public void addAffectedObjects(String string) {
        if (this.m_affectedObj == null) {
            this.m_affectedObj = new Vector();
        }
        this.m_affectedObj.add(string);
    }

    public void clearAffectedObjects() {
        if (this.m_affectedObj != null) {
            this.m_affectedObj.clear();
        }
    }

    public Collection getAdditionalInformation() {
        return this.m_addnlInfo;
    }

    public void setAdditionalInformation(Collection collection) {
        this.m_addnlInfo = collection;
    }

    public void setAdditionalInformation(FormattedHashtable formattedHashtable) {
        this.setAdditionalInformation(formattedHashtable.keySet());
    }

    public void setAdditionalInformation(String string) {
        this.setAdditionalInformation(this.splitIntoList(string, ";"));
    }

    public void addAdditionalInformation(String string) {
        if (this.m_addnlInfo == null) {
            this.m_addnlInfo = new Vector();
        }
        this.m_addnlInfo.add(string);
    }

    public void clearAdditionalInformation() {
        if (this.m_addnlInfo != null) {
            this.m_addnlInfo.clear();
        }
    }

    public String getMessageSubject() {
        return this.m_msgSubject;
    }

    public void setMessageSubject(String string) {
        this.m_msgSubject = string;
    }

    public String getMessageBody() {
        return this.m_msgBody;
    }

    public void setMessageBody(String string) {
        this.m_msgBody = string;
    }

    public String getActionOutput() {
        return this.m_output;
    }

    public void setActionOutput(String string) {
        this.m_output = string;
    }

    public Collection getEventIDs() {
        return this.m_eventIds;
    }

    public void setEventIDs(Collection collection) {
        this.m_eventIds = collection;
    }

    public void setEventIDs(Hashtable hashtable) {
        this.setEventIDs(hashtable.keySet());
    }

    public void setEventIDs(FormattedHashtable formattedHashtable) {
        this.setEventIDs(formattedHashtable.keySet());
    }

    public void setEventIDs(String string) {
        this.setEventIDs(this.splitIntoList(string, ";"));
    }

    public void addEventID(String string) {
        if (this.m_eventIds == null) {
            this.m_eventIds = new Vector();
        }
        this.m_eventIds.add(string);
    }

    public void clearEventIDs() {
        if (this.m_eventIds != null) {
            this.m_eventIds.clear();
        }
    }

    public Collection getEventDescriptions() {
        return this.m_eventDesc;
    }

    public void setEventDescriptions(Collection collection) {
        this.m_eventDesc = collection;
    }

    public void setEventDescriptions(FormattedHashtable formattedHashtable) {
        this.setEventDescriptions(formattedHashtable.keySet());
    }

    public void setEventDescriptions(String string) {
        this.setEventDescriptions(this.splitIntoList(string, ";"));
    }

    public void addEventDescriptions(String string) {
        if (this.m_eventDesc == null) {
            this.m_eventDesc = new Vector();
        }
        this.m_eventDesc.add(string);
    }

    public void clearEventDescriptions() {
        if (this.m_eventDesc != null) {
            this.m_eventDesc.clear();
        }
    }

    private List splitIntoList(String string, String string2) {
        ArrayList<String> arrayList = null;
        if (string != null) {
            String string3;
            String[] stringArray = string.split(string2);
            arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            Vector<String> vector = new Vector<String>();
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string3 = iterator.next();
                if (string3.length() != 0) continue;
                vector.add(string3);
            }
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                string3 = iterator.next();
                arrayList.remove(string3);
            }
        }
        return arrayList;
    }

    public String parseIntoString(Collection collection, String string, boolean bl) {
        if (collection != null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (stringBuffer.length() + string2.length() > 3990) {
                    stringBuffer.append("...");
                    break;
                }
                if (!bl2 || bl) {
                    stringBuffer.append(string);
                } else {
                    bl2 = false;
                }
                stringBuffer.append(string2);
            }
            if (bl) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String getInsertSql() {
        return "insert into NotificationLog values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (String)this.getNotificationType(), (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (String)this.getNotificationDetails(), (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (String)this.getNotificationRecipients(), (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (int)this.getStatus());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (Timestamp)this.getTimeNotificationSent());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (int)this.getPriority());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (long)this.getNotificationRuleId());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (String)this.getNotificationRuleName(), (int)50);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)9, (long)this.getSiteId());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)10, (String)this.getSiteNodeName(), (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)11, (String)this.getBranchNodePath(), (int)512);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)12, (String)this.parseIntoString(this.getReceivedProductFamilies(), ":", true), (int)1024);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)13, (String)this.parseIntoString(this.getReceivedEventCategories(), ":", true), (int)3000);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)14, (Timestamp)this.getFirstEventTime());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)15, (int)this.getReceivedNumComputers());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)16, (int)this.getReceivedNumEvents());
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)17, (String)this.parseIntoString(this.getConfiguredProductFamilies(), ":", true), (int)1024);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)18, (String)this.parseIntoString(this.getConfiguredEventCategories(), ":", true), (int)3000);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)19, (String)this.getThreatText(), (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)20, (String)this.getThreatTextOperator(), (int)64);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)21, (String)this.parseIntoString(this.getReceivedThreatNames(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)22, (String)this.parseIntoString(this.getSourceComputers(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)23, (String)this.parseIntoString(this.getAffectedComputerIPs(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)24, (String)this.parseIntoString(this.getAffectedComputerNames(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)25, (String)this.parseIntoString(this.getAffectedObjects(), ";", false));
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)26, (String)this.parseIntoString(this.getAdditionalInformation(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)27, (String)this.getMessageSubject(), (int)255);
        if (this.getMessageBody() != null && this.getMessageBody().length() != 0) {
            DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)28, (byte[])this.getMessageBody().getBytes());
        } else {
            DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)28, (byte[])null);
        }
        if (this.getActionOutput() != null && this.getActionOutput().length() != 0) {
            DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)29, (byte[])this.getActionOutput().getBytes());
        } else {
            DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)29, (byte[])null);
        }
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)30, (String)this.parseIntoString(this.getEventIDs(), ";", false), (int)3990);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)31, (String)this.parseIntoString(this.getEventDescriptions(), ";", false), (int)3990);
    }

    public String getUpdateSql() {
        String string = "update NotificationLog set " + PROPERTY_NAMES[2] + "=?, " + PROPERTY_NAMES[3] + "=?, " + PROPERTY_NAMES[4] + "=?, " + PROPERTY_NAMES[5] + "=?, " + PROPERTY_NAMES[6] + "=?, " + PROPERTY_NAMES[7] + "=?, " + PROPERTY_NAMES[8] + "=?, " + PROPERTY_NAMES[9] + "=?, " + PROPERTY_NAMES[10] + "=?, " + PROPERTY_NAMES[11] + "=?, " + PROPERTY_NAMES[12] + "=?, " + PROPERTY_NAMES[13] + "=?, " + PROPERTY_NAMES[14] + "=?, " + PROPERTY_NAMES[15] + "=?, " + PROPERTY_NAMES[16] + "=?, " + PROPERTY_NAMES[17] + "=?, " + PROPERTY_NAMES[18] + "=?, " + PROPERTY_NAMES[19] + "=?, " + PROPERTY_NAMES[20] + "=?, " + PROPERTY_NAMES[21] + "=?, " + PROPERTY_NAMES[22] + "=?, " + PROPERTY_NAMES[23] + "=?, " + PROPERTY_NAMES[24] + "=?, " + PROPERTY_NAMES[25] + "=?, " + PROPERTY_NAMES[26] + "=?, " + PROPERTY_NAMES[27] + "=?, " + PROPERTY_NAMES[28] + "=?, " + PROPERTY_NAMES[29] + "=?, " + PROPERTY_NAMES[30] + "=?, " + PROPERTY_NAMES[31] + "=?, " + PROPERTY_NAMES[32] + "=?  " + "where " + PROPERTY_NAMES[1] + "=?";
        return string;
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)32, (long)this.getNotificationLogId());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setNotificationLogId(n);
    }

    public int getNumProperties() {
        return PROPERTY_NAMES.length;
    }

    public int getNumColumns() {
        return 32;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_type = resultSet.getString(2);
        this.m_notDetails = resultSet.getString(3);
        this.m_notRecipients = resultSet.getString(4);
        this.m_status = resultSet.getInt(5);
        this.m_timestamp = resultSet.getTimestamp(6);
        this.m_priority = resultSet.getInt(7);
        this.m_ruleId = resultSet.getLong(8);
        this.m_ruleName = resultSet.getString(9);
        this.m_siteId = resultSet.getLong(10);
        this.m_siteName = resultSet.getString(11);
        this.m_branchNodePath = resultSet.getString(12);
        this.setReceivedProductFamilies(resultSet.getString(13));
        this.setReceivedEventCategories(resultSet.getString(14));
        this.m_firstEvent = resultSet.getTimestamp(15);
        this.m_recNumComputers = resultSet.getInt(16);
        this.m_recNumEvents = resultSet.getInt(17);
        if (resultSet.getMetaData().getColumnCount() > 17) {
            this.setConfiguredProductFamilies(resultSet.getString(18));
            this.setConfiguredEventCategories(resultSet.getString(19));
            this.m_threatText = resultSet.getString(20);
            this.m_threatOp = resultSet.getString(21);
            this.setReceivedThreatNames(resultSet.getString(22));
            this.setSourceComputers(resultSet.getString(23));
            this.setAffectedComputerIPs(resultSet.getString(24));
            this.setAffectedComputerNames(resultSet.getString(25));
            this.setAffectedObjects(resultSet.getString(26));
            this.setAdditionalInformation(resultSet.getString(27));
            this.m_msgSubject = resultSet.getString(28);
            byte[] byArray = resultSet.getBytes(29);
            if (byArray != null) {
                this.m_msgBody = new String(byArray);
            }
            if ((byArray = resultSet.getBytes(30)) != null) {
                this.m_output = new String(byArray);
            }
            this.setEventIDs(resultSet.getString(31));
            this.setEventDescriptions(resultSet.getString(32));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("NotificationLog data: \n");
        stringBuffer.append("Type: ").append(this.getNotificationType()).append("\n");
        stringBuffer.append("Details: ").append(this.getNotificationDetails()).append("\n");
        stringBuffer.append("Recipients: ").append(this.getNotificationRecipients()).append("\n");
        stringBuffer.append("Status: ").append(this.getStatus()).append("\n");
        stringBuffer.append("Timestamp: ").append(this.getTimeNotificationSent()).append("\n");
        stringBuffer.append("Priority: ").append(this.getPriority()).append("\n");
        stringBuffer.append("RuleID: ").append(this.getNotificationRuleId()).append("\n");
        stringBuffer.append("RuleName: ").append(this.getNotificationRuleName()).append("\n");
        stringBuffer.append("SiteID: ").append(this.getSiteId()).append("\n");
        stringBuffer.append("SiteName: ").append(this.getSiteNodeName()).append("\n");
        stringBuffer.append("BNP: ").append(this.getBranchNodePath()).append("\n");
        stringBuffer.append("RPF: ").append(this.parseIntoString(this.getReceivedProductFamilies(), ":", true)).append("\n");
        stringBuffer.append("REC: ").append(this.parseIntoString(this.getReceivedEventCategories(), ":", true)).append("\n");
        stringBuffer.append("FET: ").append(this.getFirstEventTime()).append("\n");
        stringBuffer.append("RNC: ").append(this.getReceivedNumComputers()).append("\n");
        stringBuffer.append("RNE: ").append(this.getReceivedNumEvents()).append("\n");
        stringBuffer.append("CPF: ").append(this.parseIntoString(this.getConfiguredProductFamilies(), ":", true)).append("\n");
        stringBuffer.append("CEC: ").append(this.parseIntoString(this.getConfiguredEventCategories(), ":", true)).append("\n");
        stringBuffer.append("ThreatText: ").append(this.getThreatText()).append("\n");
        stringBuffer.append("TTO: ").append(this.getThreatTextOperator()).append("\n");
        stringBuffer.append("RTN: ").append(this.parseIntoString(this.getReceivedThreatNames(), ";", false)).append("\n");
        stringBuffer.append("Source: ").append(this.parseIntoString(this.getSourceComputers(), ";", false)).append("\n");
        stringBuffer.append("ACI: ").append(this.parseIntoString(this.getAffectedComputerIPs(), ";", false)).append("\n");
        stringBuffer.append("ACN: ").append(this.parseIntoString(this.getAffectedComputerNames(), ";", false)).append("\n");
        stringBuffer.append("AO: ").append(this.parseIntoString(this.getAffectedObjects(), ";", false)).append("\n");
        stringBuffer.append("AI: ").append(this.parseIntoString(this.getAdditionalInformation(), ";", false)).append("\n");
        stringBuffer.append("Subject: ").append(this.getMessageSubject()).append("\n");
        stringBuffer.append("Body: ").append(this.getMessageBody()).append("\n");
        stringBuffer.append("Output: ").append(this.getActionOutput()).append("\n");
        stringBuffer.append("EIDs: ").append(this.parseIntoString(this.getEventIDs(), ";", false)).append("\n");
        stringBuffer.append("Descriptions: ").append(this.parseIntoString(this.getEventDescriptions(), ";", false)).append("\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

