/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ruleEngine.rules.actions;

import com.mcafee.epo.common.db.destination.Contact;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.db.AlertingConfig;
import com.mcafee.epo.notifications.db.NotificationLog;
import com.mcafee.epo.notifications.ruleEngine.MessageAdaptorInterface;
import com.mcafee.epo.notifications.ruleEngine.rules.MessageAdaptorMap;
import com.mcafee.epo.notifications.ruleEngine.rules.UserNotificationRule;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetBase;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.util.Resource;
import com.mcafee.epo.utility.MailClient;
import com.mcafee.epo.utility.MailClientException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SMTPAction
extends NotificationTargetBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ruleEngine$rules$actions$SMTPAction == null ? (class$com$mcafee$epo$notifications$ruleEngine$rules$actions$SMTPAction = SMTPAction.class$("com.mcafee.epo.notifications.ruleEngine.rules.actions.SMTPAction")) : class$com$mcafee$epo$notifications$ruleEngine$rules$actions$SMTPAction));
    static final String RECIPIENTS_TAG = "Recipients";
    static final String SUBJECT_TAG = "Subject";
    static final String BODY_TAG = "Body";
    static final String MESSAGE_TYPE_TAG = "MessageType";
    static final String[] MESSAGE_TYPES = new String[]{"smtpaction_email", "smtpaction_sms", "smtpaction_pager"};
    public static final int MAX_LEN_RECIPIENTS = 2048;
    public static final String RECIPIENT_LIST_SEPARATOR = ";";
    public static final String TYPE = "smtp";
    public static final String[] SETTING_NAMES = new String[]{"Recipients", "Subject", "Body", "MessageType"};
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ruleEngine$rules$actions$SMTPAction;

    public SMTPAction() {
        super(TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] parseRecipientList(String string) {
        String[] stringArray;
        m_log.debug((Object)("Parsing the recipient list from the " + string + " property."));
        Vector<Object> vector = new Vector<Object>();
        Connection connection = null;
        try {
            block13: {
                try {
                    if (Server.getDb() != null) {
                        m_log.debug((Object)"Server was not null.");
                        connection = Server.getDb().getConnection();
                        stringArray = (String[])this.getSetting(RECIPIENTS_TAG);
                        if (stringArray != null) {
                            String[] stringArray2 = stringArray.split(RECIPIENT_LIST_SEPARATOR);
                            int n = 0;
                            while (n < stringArray2.length) {
                                m_log.debug((Object)("Checking: " + stringArray2[n]));
                                stringArray2[n] = stringArray2[n].trim();
                                if (stringArray2[n].charAt(0) == '@') {
                                    m_log.debug((Object)"Contains an '@'");
                                    try {
                                        int n2 = Integer.parseInt(stringArray2[n].substring(1));
                                        m_log.debug((Object)("Getting contact for ID: " + n2));
                                        Contact contact = Contact.getById((Connection)connection, (long)n2);
                                        m_log.debug((Object)("Contact is: " + contact));
                                        m_log.debug((Object)("Adding recipient: " + contact.getProperty(string)));
                                        if (contact != null) {
                                            vector.add(contact.getProperty(string));
                                        }
                                    }
                                    catch (Exception exception) {
                                        m_log.error((Object)Resource.getString("smtpaction_failed_to_parse_recipients"), (Throwable)exception);
                                    }
                                } else {
                                    vector.add(stringArray2[n]);
                                }
                                ++n;
                            }
                            break block13;
                        }
                        m_log.debug((Object)"No recipients were found, returning.");
                        break block13;
                    }
                    m_log.debug((Object)"Server was null, skipping.");
                }
                catch (SQLException sQLException) {
                    m_log.debug((Object)"Failed to get the connection from the server DB..", (Throwable)sQLException);
                    Object var10_12 = null;
                    DatabaseUtil.close((Connection)connection);
                }
            }
            Object var10_11 = null;
            DatabaseUtil.close((Connection)connection);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        stringArray = new String[]{};
        return vector.toArray(stringArray);
    }

    private String[] parseRecipientListValues(String string) {
        String[] stringArray;
        m_log.debug((Object)("Parsing the recipient list from the " + string + " property."));
        Vector<String> vector = new Vector<String>();
        m_log.debug((Object)"Server was not null.");
        String string2 = (String)this.getSetting(RECIPIENTS_TAG);
        if (string2 != null) {
            stringArray = string2.split(RECIPIENT_LIST_SEPARATOR);
            int n = 0;
            while (n < stringArray.length) {
                m_log.debug((Object)("Checking: " + stringArray[n]));
                vector.add(stringArray[n]);
                ++n;
            }
        } else {
            m_log.debug((Object)"No recipients were found, returning.");
        }
        stringArray = new String[]{};
        return vector.toArray(stringArray);
    }

    public static final String makeRecipientsFromArray(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(RECIPIENT_LIST_SEPARATOR).append(" ");
            }
            m_log.debug((Object)("Adding: " + stringArray[n] + " to the list of recipients"));
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int invoke(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable, NotificationLog notificationLog, StringBuffer stringBuffer) {
        String string;
        Object object;
        String string2;
        int n = 0;
        String[] stringArray = this.parseRecipientList("EmailAddress");
        Vector<String> vector = new Vector<String>();
        MessageAdaptorMap messageAdaptorMap = new MessageAdaptorMap(messageAdaptorInterface, hashtable);
        Object object2 = messageAdaptorInterface.getValue(UserNotificationRule.RULE_OBJECT_TAG);
        if (object2 == null) {
            object2 = hashtable.get(UserNotificationRule.RULE_OBJECT_TAG);
        }
        if ((string2 = messageAdaptorMap.get("ConfiguredEventCategories")) == null || string2.equals("")) {
            object = Resource.getString("AlertUserRulepropdisplay_any", this.getLanguage());
            hashtable.put("ConfiguredEventCategories", object);
        }
        if ((string2 = messageAdaptorMap.get("ConfiguredProductFamilies")) == null || string2.equals("")) {
            object = Resource.getString("AlertUserRulepropdisplay_any", this.getLanguage());
            hashtable.put("ConfiguredProductFamilies", object);
        }
        m_log.debug((Object)("Setting the recipients: " + stringArray));
        vector.addAll(Arrays.asList(stringArray));
        object = new MailClient();
        ((MailClient)object).addProgressListener(this);
        String string3 = Resource.getString("propdisplay_not_available", this.getLanguage());
        AlertingConfig alertingConfig = Server.getConfiguration();
        m_log.debug((Object)("Sending to server: " + alertingConfig.getSmtpServer()));
        m_log.debug((Object)("From addr: " + alertingConfig.getSmtpFromAddr()));
        ((MailClient)object).setSender(alertingConfig.getSmtpFromAddr());
        ((MailClient)object).setMailServer(alertingConfig.getSmtpServer());
        ((MailClient)object).setRecipients(StringUtil.substitute(vector, (StringUtil.Map)messageAdaptorMap, (String)string3));
        String string4 = this.getSubject();
        if (string4 != null) {
            string4 = StringUtil.substitute((String)string4, (StringUtil.Map)messageAdaptorMap, (String)string3);
            m_log.debug((Object)("Setting mail subject: " + string4));
            if (string4 != null) {
                ((MailClient)object).setSubject(string4);
            }
            this.setLogMessageSubject(notificationLog, string4);
        }
        if ((string = this.getBody()) != null) {
            string = StringUtil.substitute((String)string, (StringUtil.Map)messageAdaptorMap, (String)string3);
            m_log.debug((Object)("Setting the mail body: " + string));
            ((MailClient)object).setBody(string);
            this.setLogMessageBody(notificationLog, string);
        }
        if (object2 != null && object2 instanceof UserNotificationRule) {
            ((MailClient)object).setPriority("" + ((UserNotificationRule)object2).getPriority());
        }
        try {
            m_log.debug((Object)"Sending email.");
            ((MailClient)object).send();
            m_log.debug((Object)"Done sending email.");
        }
        catch (MailClientException mailClientException) {
            String string5 = Resource.formatString("smtpaction_send_failed", mailClientException.getMessage());
            String string6 = Resource.formatString("smtpaction_send_failed", mailClientException.getMessage(), this.getLanguage());
            m_log.error((Object)string5, (Throwable)mailClientException);
            stringBuffer.append(string6);
            n = 1;
        }
        catch (ConnectException connectException) {
            String string7 = Resource.formatString("smtpaction_connect_failed", connectException.getMessage());
            String string8 = Resource.formatString("smtpaction_connect_failed", connectException.getMessage(), this.getLanguage());
            m_log.error((Object)string7, (Throwable)connectException);
            stringBuffer.append(string8);
            n = 2;
        }
        catch (UnknownHostException unknownHostException) {
            String string9 = Resource.formatString("smtpaction_unknown_host", unknownHostException.getMessage());
            String string10 = Resource.formatString("smtpaction_unknown_host", unknownHostException.getMessage(), this.getLanguage());
            m_log.error((Object)string9, (Throwable)unknownHostException);
            stringBuffer.append(string10);
            n = 3;
        }
        catch (IOException iOException) {
            String string11 = Resource.formatString("smtpaction_io_failed", iOException.getMessage());
            String string12 = Resource.formatString("smtpaction_io_failed", iOException.getMessage(), this.getLanguage());
            m_log.error((Object)string11, (Throwable)iOException);
            stringBuffer.append(string12);
            n = 4;
        }
        return n;
    }

    public String getBody() {
        return (String)this.getSetting(BODY_TAG);
    }

    public String getRecipients() {
        return SMTPAction.makeRecipientsFromArray(this.parseRecipientList("Name"));
    }

    public String getRecipientValues() {
        return SMTPAction.makeRecipientsFromArray(this.parseRecipientListValues("Name"));
    }

    public String getSubject() {
        return (String)this.getSetting(SUBJECT_TAG);
    }

    public String getMessageType() {
        return (String)this.getSetting(MESSAGE_TYPE_TAG);
    }

    public void setBody(String string) {
        this.setSetting(BODY_TAG, string);
    }

    public void setRecipients(String string) {
        this.setSetting(RECIPIENTS_TAG, string);
    }

    public void setSubject(String string) {
        this.setSetting(SUBJECT_TAG, string);
    }

    public void setMessageType(String string) {
        this.setSetting(MESSAGE_TYPE_TAG, string);
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeForDisplay(String string) {
        return Resource.getString("common_email", string);
    }

    public int getNumSettings() {
        return SETTING_NAMES.length;
    }

    public String getSettingName(int n) {
        return SETTING_NAMES[n];
    }

    public String[] getSettingNames() {
        return SETTING_NAMES;
    }

    public String getUnLocalizedDetail() {
        return MESSAGE_TYPES[Integer.parseInt(this.getMessageType())];
    }

    public void validate() {
        this.m_validateError = null;
        if (this.getMessageType() == null) {
            this.m_validateError = "smtpaction_missing_message_type";
        } else if (Integer.parseInt(this.getMessageType()) != 2 && this.getSubject() == null) {
            this.m_validateError = "smtpaction_missing_subject";
        } else if (Integer.parseInt(this.getMessageType()) != 1 && this.getBody() == null) {
            this.m_validateError = "smtpaction_missing_body";
        } else if (this.getRecipients() == null) {
            this.m_validateError = "smtpaction_missing_recipients";
        }
    }

    public void calculateProperties(Connection connection) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

