/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ruleEngine.service;

import com.mcafee.epo.notifications.ruleEngine.service.AlertingServlet;
import com.mcafee.epo.notifications.ruleEngine.service.RuleEngineSingleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RuleEngineHttpService
extends AlertingServlet {
    final String DEFAULT_NAME = "RuleEngineHttpService";

    public RuleEngineHttpService() {
        this.setServletName("RuleEngineHttpService");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!this.isLocal(httpServletRequest) && !httpServletRequest.isSecure()) {
            httpServletResponse.sendError(406);
            return;
        }
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        int n = httpServletRequest.getIntHeader("content-length");
        if (n > this.m_maxEventSize) {
            printWriter.println("<P>Too big!  This is " + n + " and Maximum event size is " + this.m_maxEventSize + ".</P>");
            return;
        }
        BufferedReader bufferedReader = httpServletRequest.getReader();
        bufferedReader.readLine();
        printWriter.println("Event uploaded!<br/>");
        String string = "<Uninitialized>";
        do {
            try {
                String string2 = "-------------------";
                string = this.parseParameters(string2, bufferedReader);
                if (string == null) continue;
                RuleEngineSingleton.getService().processMessage(string, (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                printWriter.println("Event processed");
            }
            catch (Exception exception) {
                printWriter.println("Error while processing event.  Text follows:");
                printWriter.println("<br/><pre>===========================================<br/>");
                printWriter.println(string);
                printWriter.println("<br/>===========================================</pre>");
                printWriter.println("<br/>Stack trace:");
                exception.printStackTrace(printWriter);
                break;
            }
        } while (string != null);
    }

    private String parseParameters(String string, BufferedReader bufferedReader) throws IOException {
        boolean bl = true;
        String string2 = bufferedReader.readLine();
        while (string2 != null && string2.length() > 0) {
            bl = false;
            string2 = bufferedReader.readLine();
        }
        if (bl) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = bufferedReader.read();
        block1: while (n != -1) {
            if ((char)n != '\n') {
                stringBuffer.append((char)n);
                n = bufferedReader.read();
                continue;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            n = bufferedReader.read();
            while (n != -1) {
                if ((char)n != '\n') {
                    stringBuffer2.append((char)n);
                    if (string.startsWith(stringBuffer2.toString())) {
                        if (string.equals(stringBuffer2.toString())) {
                            bufferedReader.readLine();
                            return stringBuffer.toString();
                        }
                        n = bufferedReader.read();
                        continue;
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(stringBuffer2);
                    n = bufferedReader.read();
                    continue block1;
                }
                stringBuffer.append("\n");
                n = bufferedReader.read();
            }
        }
        return stringBuffer.toString();
    }
}

