/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui;

import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.common.ui.tables.InvalidTableException;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.db.AlertUserRule;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetBase;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetFactoryException;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public class UserRuleBean
extends AlertUserRule
implements HttpSessionBindingListener {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ui$UserRuleBean == null ? (class$com$mcafee$epo$notifications$ui$UserRuleBean = UserRuleBean.class$("com.mcafee.epo.notifications.ui.UserRuleBean")) : class$com$mcafee$epo$notifications$ui$UserRuleBean));
    public static final int LAST_PAGE_NUMBER = 5;
    public static final String WIZARD_PAGE_ID_PREFIX = "wizardPage";
    public static final String[] NOTIFICATION_TABLE_HEADER_KEYS = new String[]{"createrule_page4_notification_type", "createrule_page4_detail", "createrule_page4_recipients"};
    protected static final String SQL_SELECT_BY_NAME = "select * from AlertUserRule where Name=?";
    private String m_pageNumber = "1";
    private String m_productSelection = "";
    private String m_categorySelection = "";
    private boolean m_goingForward = true;
    private boolean m_editMode = false;
    private int m_lastPageNumberCompleted = 1;
    private long m_unsavedNotificationId = -1L;
    private Vector m_deletedNotificationTargets = new Vector();
    private String m_lang = null;
    private static HashMap m_sessionBindings = new HashMap();
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ui$UserRuleBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserRuleBean getById(Connection connection, long l) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        PreparedStatement preparedStatement;
        Vector vector;
        block4: {
            UserRuleBean userRuleBean;
            vector = null;
            preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("select * from AlertUserRule where AlertUserRuleId=?");
                preparedStatement.setLong(1, l);
                vector = AlertUserRule.getByQuery(connection, preparedStatement, class$com$mcafee$epo$notifications$ui$UserRuleBean == null ? (class$com$mcafee$epo$notifications$ui$UserRuleBean = UserRuleBean.class$("com.mcafee.epo.notifications.ui.UserRuleBean")) : class$com$mcafee$epo$notifications$ui$UserRuleBean, 1, 1, Server.getNotificationTargetFactory());
                if (vector.size() >= 1) break block4;
                userRuleBean = null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DatabaseUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            DatabaseUtil.close((Statement)preparedStatement);
            return userRuleBean;
        }
        if (vector.size() > 1) {
            throw new SQLException("getById() returned >1 row!");
        }
        Object var7_7 = null;
        DatabaseUtil.close((Statement)preparedStatement);
        UserRuleBean userRuleBean = (UserRuleBean)((Object)vector.firstElement());
        userRuleBean.m_editMode = true;
        return userRuleBean;
    }

    public static UserRuleBean getUserRuleByName(Connection connection, String string) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        Vector vector = AlertUserRule.getUserRuleByName(connection, string, class$com$mcafee$epo$notifications$ui$UserRuleBean == null ? (class$com$mcafee$epo$notifications$ui$UserRuleBean = UserRuleBean.class$("com.mcafee.epo.notifications.ui.UserRuleBean")) : class$com$mcafee$epo$notifications$ui$UserRuleBean, Server.getNotificationTargetFactory());
        if (vector.size() < 1) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        UserRuleBean userRuleBean = (UserRuleBean)((Object)vector.firstElement());
        userRuleBean.m_editMode = true;
        return userRuleBean;
    }

    public int getPageNumberAsInt() {
        return Integer.parseInt(this.m_pageNumber);
    }

    public int getNumNotifications() {
        Vector vector = this.getNotificationTargets();
        return vector == null ? 0 : vector.size();
    }

    public String getNotificationTargetsTable(HttpServletRequest httpServletRequest) throws InvalidParameterException {
        Object object;
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setHasCheckbox(false);
        htmlTable.setId("notificationList");
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        int n = 0;
        while (n < NOTIFICATION_TABLE_HEADER_KEYS.length) {
            htmlTableHeader.addCell(Resource.getString(NOTIFICATION_TABLE_HEADER_KEYS[n], this.m_lang));
            ++n;
        }
        htmlTableHeader.addCell(StringUtil.safeHtml((String)Resource.getString("common_test", this.m_lang), (boolean)false));
        htmlTableHeader.addCell(StringUtil.safeHtml((String)Resource.getString("common_delete", this.m_lang), (boolean)false));
        Vector vector = this.getNotificationTargets();
        if (vector != null && vector.size() > 0) {
            object = new NotificationTargetBase[1];
            object = vector.toArray((T[])object);
            HtmlTableRow htmlTableRow = null;
            HtmlTableCell htmlTableCell = null;
            int n2 = 0;
            while (n2 < ((NotificationTargetBase[])object).length) {
                htmlTableRow = htmlTable.addRow();
                htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)object[n2].getTypeForDisplay(this.m_lang)));
                htmlTableCell.setOnClick(this.getRowOnClick(object[n2]));
                htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)object[n2].getDetail(this.m_lang)));
                htmlTableCell.setOnClick(this.getRowOnClick(object[n2]));
                htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)object[n2].getRecipients()));
                htmlTableCell.setOnClick(this.getRowOnClick(object[n2]));
                String string = StringUtil.safeHtml((String)Resource.getString("common_test", this.m_lang), (boolean)false);
                htmlTableCell = htmlTableRow.addCell("<input type=\"button\" name=\"" + string + "\" value=\"" + string + "\" onclick=\"testTarget(" + n2 + ")\" class='clsBtn'>");
                htmlTableCell.setStyle("cursor: default");
                htmlTableCell.setAlign("center");
                EpoUser epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
                if (!epoUser.isReviewer() && epoUser.isAdminForThisSite(this.getSiteId())) {
                    htmlTableCell = htmlTableRow.addCell("<img src='images/xbutton.gif' ALT='" + StringUtil.safeHtml((String)Resource.getString("common_delete_row", this.m_lang), (boolean)false) + "' />");
                    htmlTableCell.setOnClick("deleteTarget(" + object[n2].getNotificationTargetId() + ", \"" + object[n2].getType() + "\" )");
                    htmlTableCell.setAlign("center");
                } else {
                    htmlTableCell = htmlTableRow.addCell("<img src='images/xbutton_disabled.gif' ALT='" + StringUtil.safeHtml((String)Resource.getString("common_disabled", this.m_lang), (boolean)false) + "' />");
                    htmlTableCell.setStyle("cursor: default");
                    htmlTableCell.setAlign("center");
                }
                ++n2;
            }
        }
        object = "Error";
        try {
            object = htmlTable.getHtml(this.m_lang);
        }
        catch (InvalidTableException invalidTableException) {
            Server.logError(invalidTableException.getMessage());
        }
        return object;
    }

    private final String getRowOnClick(NotificationTargetBase notificationTargetBase) {
        return "editTarget(" + notificationTargetBase.getNotificationTargetId() + ", \"" + notificationTargetBase.getType() + "\" )";
    }

    public NotificationTargetBase getNotificationById(long l) {
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            NotificationTargetBase notificationTargetBase = (NotificationTargetBase)iterator.next();
            if (notificationTargetBase.getNotificationTargetId() != l) continue;
            return notificationTargetBase;
        }
        return null;
    }

    public void deleteNotificationTargetById(long l) {
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            NotificationTargetBase notificationTargetBase = (NotificationTargetBase)iterator.next();
            if (notificationTargetBase.getNotificationTargetId() != l) continue;
            if (l > -1L) {
                this.m_deletedNotificationTargets.add(notificationTargetBase);
            }
            iterator.remove();
            break;
        }
    }

    public void update(Connection connection) throws SQLException {
        Iterator iterator = this.m_deletedNotificationTargets.iterator();
        while (iterator.hasNext()) {
            NotificationTargetBase notificationTargetBase = (NotificationTargetBase)iterator.next();
            NotificationTargetBase.deleteNotificationTarget(connection, notificationTargetBase);
        }
        this.m_deletedNotificationTargets.removeAllElements();
        super.update(connection);
    }

    public String getCategorySummary() {
        if (this.m_anyCategory.booleanValue()) {
            return Resource.getString("common_any_eventcategory", this.m_lang);
        }
        if (this.m_categorySelection.length() < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.m_categorySelection.split(":");
        if (stringArray != null) {
            stringBuffer.append(Resource.getDataString(stringArray[0], this.m_lang));
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(", ").append(Resource.getDataString(stringArray[n], this.m_lang));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getProductSummary() {
        if (this.m_anyAlertFamily.booleanValue()) {
            return Resource.getString("common_any_productfamily", this.m_lang);
        }
        if (this.m_productSelection.length() < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.m_productSelection.split(":");
        if (stringArray != null) {
            stringBuffer.append(Resource.getDataString(stringArray[0], this.m_lang));
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(", ").append(Resource.getDataString(stringArray[n], this.m_lang));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getThreatSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getThreatExp();
        if (string != null && string.compareTo("any") != 0) {
            stringBuffer.append(Resource.getDataString(this.getThreatExp(), this.m_lang)).append(" ").append(this.getThreatText());
        } else {
            stringBuffer.append(Resource.getString("common_any_threatname", this.m_lang));
        }
        return stringBuffer.toString();
    }

    public String getThresholdSummary() {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (!this.getAggByComputer().booleanValue() && !this.getAggByEvents().booleanValue()) {
            stringBuffer.append(Resource.getString("createrule_page3_for_every_event", this.m_lang));
        } else {
            stringBuffer.append(Resource.formatString("createrule_for_multiple_event_within", StringUtil.getTimeInMinHourDay((Long)this.getAggregationTime(), (String)this.m_lang), this.m_lang));
        }
        stringBuffer.append(" ");
        boolean bl = false;
        if (this.getAggByComputer().booleanValue()) {
            bl = true;
            stringBuffer.append(Resource.formatString("createrule_number_computers_exceeds", this.getNumAggComputers().toString(), this.m_lang)).append(" ");
        }
        if (this.getAggByEvents().booleanValue()) {
            if (bl) {
                stringBuffer.append(Resource.getString("common_and", this.m_lang)).append(" ");
            }
            stringBuffer.append(Resource.formatString("createrule_number_events_exceeds", this.getNumAggEvents().toString(), this.m_lang)).append(" ");
        }
        if (this.getThrottle()) {
            stringBuffer.append(Resource.formatString("createrule_send_notification_template", StringUtil.getTimeInMinHourDay((long)this.getThrottleTime(), (String)this.m_lang), this.m_lang));
        } else {
            stringBuffer.append(Resource.getString("createrule_send_notification", this.m_lang));
        }
        return stringBuffer.toString();
    }

    public String getNotificationSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getNotificationTargets();
        if (vector != null && vector.size() > 0) {
            Iterator iterator = vector.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                NotificationTargetBase notificationTargetBase = (NotificationTargetBase)iterator.next();
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(notificationTargetBase.toString(this.m_lang));
            }
        }
        return stringBuffer.toString();
    }

    public String getPageNumber() {
        return this.m_pageNumber;
    }

    public void setPageNumber(String string) {
        this.m_goingForward = Integer.parseInt(string) > Integer.parseInt(this.m_pageNumber);
        this.m_pageNumber = string;
        int n = Integer.parseInt(string);
        if (n > this.m_lastPageNumberCompleted) {
            this.m_lastPageNumberCompleted = n;
        }
    }

    public String getCategorySelection() {
        return this.m_categorySelection;
    }

    public void setCategorySelection(String string) {
        this.m_categorySelection = string;
    }

    public String getProductSelection() {
        return this.m_productSelection;
    }

    public void setProductSelection(String string) {
        this.m_productSelection = string;
    }

    public void setLastPageNumberCompleted(int n) {
        this.m_lastPageNumberCompleted = n;
    }

    public int getLastPageNumberCompleted() {
        return this.m_lastPageNumberCompleted;
    }

    public boolean goingForward() {
        return this.m_goingForward;
    }

    public boolean editMode() {
        return this.m_editMode;
    }

    public long getNextUnsavedNotificationId() {
        --this.m_unsavedNotificationId;
        return this.m_unsavedNotificationId;
    }

    public void setLanguageId(String string) {
        this.m_lang = string;
    }

    public String getLanguageId() {
        return this.m_lang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        String string = httpSession.getId();
        m_log.debug((Object)("Binding UserRuleBean:" + (Object)((Object)this) + " to session: " + string));
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            m_sessionBindings.put(string, httpSessionBindingEvent.getValue());
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserRuleBean getFromInternalSessionMap(String string) {
        m_log.debug((Object)"Getting the UserRuleBean from internal session mappings.");
        UserRuleBean userRuleBean = null;
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            userRuleBean = (UserRuleBean)((Object)m_sessionBindings.get(string));
            if (userRuleBean != null) {
                m_log.debug((Object)("Found UserRuleBean " + (Object)((Object)userRuleBean) + " in internal session " + string));
            } else {
                m_log.debug((Object)("Couldn't find user rule bean for session " + string));
            }
        }
        return userRuleBean;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

