/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui.tags;

import com.mcafee.epo.common.ui.tags.TagSupport;
import com.mcafee.epo.common.ui.util.PageState;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.db.AlertFamily;
import com.mcafee.epo.notifications.db.AlertUserRule;
import com.mcafee.epo.notifications.db.EventCategory;
import com.mcafee.epo.notifications.db.NotificationLog;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetFactory;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;

public class SummaryIterator
extends TagSupport {
    public static final String SUMMARY_ATTRIBUTE = "summary";
    public static final int SUMMARY_GROUP_BY_PRODUCT = 0;
    public static final int SUMMARY_GROUP_BY_CATEGORY = 1;
    public static final int SUMMARY_GROUP_BY_PRIORITY = 2;
    public static final int SUMMARY_GROUP_BY_RULE = 3;
    private static final Logger m_log;
    private Connection m_con;
    private SummaryRow[] m_rows;
    private int m_index;
    private String m_pageState;
    private String m_lang = null;
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ui$tags$SummaryIterator;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$notifications$db$AlertUserRule;

    public SummaryIterator() {
        m_log.debug((Object)"Creating a new summary iterator.");
    }

    private void execute() throws JspException {
        try {
            m_log.debug((Object)"Setting up next summary row.");
            this.setNextSummaryRow();
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("summaryiterator_setnextsummaryrow_failed"), (Throwable)exception);
            throw new JspException((Throwable)exception);
        }
    }

    public int mcStartTag() throws Exception {
        m_log.debug((Object)"in mcStartTag()");
        this.m_lang = UserUtil.getLanguageForUser((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()));
        if (this.m_lang == null) {
            throw new NullPointerException("Language was null.");
        }
        m_log.debug((Object)("This tag will display with language: " + this.m_lang));
        this.m_index = 0;
        if (!$assertionsDisabled && this.m_con == null) {
            throw new AssertionError();
        }
        try {
            try {
                String string = "NotificationLog";
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                String string2 = null;
                TreeMap<Object, Item> treeMap = new TreeMap<Object, Item>(Collator.getInstance(new Locale(this.m_lang)));
                PageState pageState = (PageState)this.pageContext.getAttribute(this.m_pageState, 3);
                n = pageState.getTimeFilter();
                n2 = pageState.getSiteFilter();
                n3 = pageState.getGroupBy();
                m_log.debug((Object)"Got the basics, figuring out the group-by");
                if (n3 == 0) {
                    string2 = NotificationLog.PROPERTY_NAMES[13];
                    m_log.debug((Object)"Selecting all AlertFamily from DB");
                    AlertFamily[] alertFamilyArray = AlertFamily.getAll(this.m_con);
                    int n4 = alertFamilyArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String string3 = alertFamilyArray[n5].getName();
                        String string4 = alertFamilyArray[n5].getTranslatedValue(this.m_lang);
                        m_log.debug((Object)("Setting up groupByMap with key: " + string3));
                        if (null == string4 || "" == string4) {
                            string4 = Resource.getDataString(string3, this.m_lang);
                        }
                        treeMap.put(string3, new Item(string4, "like", string3));
                        ++n5;
                    }
                } else if (n3 == 1) {
                    string2 = NotificationLog.PROPERTY_NAMES[14];
                    m_log.debug((Object)"Selecting all EventCategory from DB");
                    EventCategory[] eventCategoryArray = EventCategory.getAll(this.m_con);
                    int n6 = eventCategoryArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String string5 = eventCategoryArray[n7].getName();
                        String string6 = eventCategoryArray[n7].getTranslatedValue(this.m_lang);
                        m_log.debug((Object)("Setting up groupByMap with key: " + string5));
                        if (null == string6 || "" == string6) {
                            string6 = Resource.getDataString(string5, this.m_lang);
                        }
                        treeMap.put(string5, new Item(string6, "like", string5));
                        ++n7;
                    }
                } else if (n3 == 3) {
                    string2 = NotificationLog.PROPERTY_NAMES[8];
                    m_log.debug((Object)"Selecting all AlertUserRule from DB");
                    Vector vector = AlertUserRule.getAllUserRules(this.m_con, class$com$mcafee$epo$notifications$db$AlertUserRule == null ? (class$com$mcafee$epo$notifications$db$AlertUserRule = SummaryIterator.class$("com.mcafee.epo.notifications.db.AlertUserRule")) : class$com$mcafee$epo$notifications$db$AlertUserRule, new NotificationTargetFactory(this.m_con));
                    int n8 = vector.size();
                    int n9 = 0;
                    while (n9 < n8) {
                        AlertUserRule alertUserRule = (AlertUserRule)((Object)vector.elementAt(n9));
                        m_log.debug((Object)("Setting up groupByMap with key: " + alertUserRule.getRuleName()));
                        treeMap.put(alertUserRule.getRuleName(), new Item(alertUserRule.getRuleName(), "=", Long.toString(alertUserRule.getId())));
                        ++n9;
                    }
                } else if (n3 == 2) {
                    string2 = NotificationLog.PROPERTY_NAMES[7];
                    m_log.debug((Object)"Creating list of all Priority values");
                    treeMap.put("0", new Item(Resource.getString("common_priority_2", this.m_lang), "=", Integer.toString(2)));
                    treeMap.put("1", new Item(Resource.getString("common_priority_1", this.m_lang), "=", Integer.toString(1)));
                    treeMap.put("2", new Item(Resource.getString("common_priority_0", this.m_lang), "=", Integer.toString(0)));
                } else {
                    m_log.error((Object)Resource.getString("summaryiterator_unexpected_group_by_value"));
                    throw new JspException(Resource.getString("summaryiterator_unexpected_group_by_value", this.m_lang));
                }
                this.fillRows(string, n, n2, treeMap, string2);
            }
            catch (Exception exception) {
                m_log.error((Object)Resource.getString("tablerow_dbquery_failed"), (Throwable)exception);
                throw exception;
            }
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            DatabaseUtil.close((Connection)this.m_con);
            throw throwable;
        }
        DatabaseUtil.close((Connection)this.m_con);
        if (this.m_rows != null && this.m_rows.length > 0) {
            this.execute();
            return 1;
        }
        return 0;
    }

    protected void fillRows(String string, int n, int n2, Map map, String string2) throws SQLException {
        if (map != null && map.size() > 0) {
            int n3 = map.size();
            Iterator iterator = map.keySet().iterator();
            this.m_rows = new SummaryRow[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.m_rows[n4] = new SummaryRow();
                ++n4;
            }
            String string3 = "";
            Stack<String> stack = new Stack<String>();
            int n5 = 0;
            while (n5 < n3) {
                Object object;
                String string4;
                stack.clear();
                String string5 = (String)iterator.next();
                Item item = (Item)map.get(string5);
                this.m_rows[n5].setItem(item.label);
                string3 = "where " + string2 + " " + item.comparritor;
                if (item.comparritor.equals("like")) {
                    string3 = string3 + " '%" + item.value + "%'";
                    string4 = "contains";
                } else {
                    string3 = string3 + " " + item.value;
                    string4 = "eq";
                }
                stack.add(new String(" ( " + string4 + " " + string2 + " \"" + item.value + "\" ) "));
                if (n != 0) {
                    object = new Timestamp(System.currentTimeMillis() - (long)n);
                    string3 = string3 + " and (" + NotificationLog.PROPERTY_NAMES[6] + " is null or " + NotificationLog.PROPERTY_NAMES[6] + " > '" + object + "')";
                }
                if (n2 != 0) {
                    string3 = string3 + " and " + NotificationLog.PROPERTY_NAMES[10] + "=" + n2;
                    stack.add(new String("( eq " + NotificationLog.PROPERTY_NAMES[10] + " " + n2 + " ) "));
                }
                object = "( and " + (String)stack.pop() + " ";
                while (stack.size() > 0) {
                    object = (String)object + " " + (String)stack.pop();
                }
                object = (String)object + " ) ";
                m_log.debug((Object)("For index: " + n5 + ", querying DB table " + string + " with whereClause: " + string3));
                m_log.debug((Object)("SExp clause is: " + (String)object));
                this.m_rows[n5].setCount(DatabaseUtil.countRows((Connection)this.m_con, (String)string, (String)string3));
                this.m_rows[n5].setGroupSexp((String)object);
                ++n5;
            }
        } else {
            m_log.debug((Object)"Nothing to group by.");
            this.m_rows = null;
        }
    }

    public int mcAfterBody() throws JspException {
        ++this.m_index;
        int n = 0;
        if (this.m_index < this.m_rows.length) {
            n = 2;
            this.execute();
        }
        return n;
    }

    public int mcEndTag() throws JspException {
        return 6;
    }

    private void setNextSummaryRow() throws Exception {
        SummaryRow summaryRow = null;
        if (this.m_index < this.m_rows.length) {
            summaryRow = this.m_rows[this.m_index];
        }
        m_log.debug((Object)("Setting the name: " + summaryRow.getItem()));
        this.pageContext.setAttribute("name", (Object)StringUtil.safeHtml((String)summaryRow.getItem()), 2);
        m_log.debug((Object)("Setting the count; " + summaryRow.getCount()));
        this.pageContext.setAttribute("count", (Object)summaryRow.getCount(), 2);
        m_log.debug((Object)("setting the SExp: " + summaryRow.getGroupSexp()));
        this.pageContext.setAttribute("groupbysexp", (Object)summaryRow.getGroupSexp(), 2);
    }

    public Connection getConnection() {
        return this.m_con;
    }

    public void setConnection(Connection connection) {
        this.m_con = connection;
    }

    public String getpagestate() {
        return this.m_pageState;
    }

    public void setpagestate(String string) {
        this.m_pageState = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$notifications$ui$tags$SummaryIterator == null ? (class$com$mcafee$epo$notifications$ui$tags$SummaryIterator = SummaryIterator.class$("com.mcafee.epo.notifications.ui.tags.SummaryIterator")) : class$com$mcafee$epo$notifications$ui$tags$SummaryIterator).desiredAssertionStatus();
        m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ui$tags$SummaryIterator == null ? (class$com$mcafee$epo$notifications$ui$tags$SummaryIterator = SummaryIterator.class$("com.mcafee.epo.notifications.ui.tags.SummaryIterator")) : class$com$mcafee$epo$notifications$ui$tags$SummaryIterator));
    }

    public class SummaryRow {
        private String m_item = null;
        private String m_timeFilter = null;
        private String m_siteFilter = null;
        private String m_groupSexp = null;
        private Long m_count = new Long(0L);

        public String getItem() {
            return this.m_item;
        }

        public void setItem(String string) {
            this.m_item = string;
        }

        public String getTimeFilter() {
            return this.m_timeFilter;
        }

        public void setTimeFilter(String string) {
            this.m_timeFilter = string;
        }

        public String getSiteFilter() {
            return this.m_siteFilter;
        }

        public void setSiteFilter(String string) {
            this.m_siteFilter = string;
        }

        public String getGroupSexp() {
            return this.m_groupSexp;
        }

        public void setGroupSexp(String string) {
            this.m_groupSexp = string;
        }

        public Long getCount() {
            return this.m_count;
        }

        public void setCount(long l) {
            this.m_count = new Long(l);
        }

        public void setCount(Long l) {
            this.m_count = l;
        }
    }

    private class Item {
        String label = null;
        String value = null;
        String comparritor = null;

        Item(String string, String string2, String string3) {
            this.label = new String(string);
            this.comparritor = string2;
            this.value = string3;
        }
    }
}

