/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui.util;

import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.db.AlertFamily;
import com.mcafee.epo.notifications.db.EventCategory;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Locale;
import java.util.TreeMap;

public class EventFilterUtil {
    private boolean m_sInitialized = false;
    private StringBuffer m_flategories = new StringBuffer(1024);
    private StringBuffer m_catDisplayNames = new StringBuffer(1024);
    private StringBuffer m_showCategories = new StringBuffer(1024);
    private StringBuffer m_hasThreats = new StringBuffer(1024);
    private StringBuffer m_productSelect = new StringBuffer(1024);
    private String language = null;

    public String getFlategoriesArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_flategories.toString();
    }

    public String getCategoryDisplayNamesArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_catDisplayNames.toString();
    }

    public String getShowCategoryArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_showCategories.toString();
    }

    public String getHasThreatsArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_hasThreats.toString();
    }

    public String getProductSelectOptions() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_productSelect.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SQLException {
        if (this.m_sInitialized) {
            return;
        }
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            AlertFamily[] alertFamilyArray = AlertFamily.getAll(connection);
            EventCategory[] eventCategoryArray = EventCategory.getAll(connection);
            this.createProductControls(connection, alertFamilyArray);
            this.createCategoryControls(eventCategoryArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        this.m_sInitialized = true;
    }

    private void createProductControls(Connection connection, AlertFamily[] alertFamilyArray) throws SQLException {
        Object object;
        TreeMap<Object, AlertFamily> treeMap = new TreeMap<Object, AlertFamily>(Collator.getInstance(new Locale(this.language)));
        int n = 0;
        while (n < alertFamilyArray.length) {
            object = alertFamilyArray[n].getTranslatedValue(this.language);
            if (null == object || "" == object) {
                object = Resource.getDataString(alertFamilyArray[n].getName(), this.language);
            }
            treeMap.put(object, alertFamilyArray[n]);
            ++n;
        }
        object = treeMap.keySet().iterator();
        this.m_flategories.append("new Array();\n");
        while (object.hasNext()) {
            String string = (String)object.next();
            AlertFamily alertFamily = (AlertFamily)((Object)treeMap.get(string));
            this.m_flategories.append("flategories[\"").append(alertFamily.getName()).append("\"] = new Array(");
            String[] stringArray = EventCategory.getCategoriesForAlert(connection, alertFamily.getId());
            if (stringArray.length > 0) {
                this.m_flategories.append("\"").append(stringArray[0]).append("\"");
            }
            int n2 = 1;
            while (n2 < stringArray.length) {
                this.m_flategories.append(",\"").append(stringArray[n2]).append("\"");
                ++n2;
            }
            this.m_flategories.append(");\n");
            this.m_productSelect.append("<OPTION value=\"").append(alertFamily.getName()).append("\">").append(string).append("</OPTION>\n");
        }
    }

    private void createCategoryControls(EventCategory[] eventCategoryArray) {
        Object object;
        TreeMap<Object, EventCategory> treeMap = new TreeMap<Object, EventCategory>(Collator.getInstance(new Locale(this.language)));
        int n = 0;
        while (n < eventCategoryArray.length) {
            object = eventCategoryArray[n].getTranslatedValue(this.language);
            if (null == object || "" == object) {
                object = Resource.getDataString(eventCategoryArray[n].getName(), this.language);
            }
            treeMap.put(object, eventCategoryArray[n]);
            ++n;
        }
        object = treeMap.keySet().iterator();
        this.m_catDisplayNames.append("new Array();\n");
        this.m_showCategories.append("new Array();\n");
        this.m_hasThreats.append("new Array();\n");
        while (object.hasNext()) {
            String string = (String)object.next();
            EventCategory eventCategory = (EventCategory)((Object)treeMap.get(string));
            this.m_catDisplayNames.append("names['").append(eventCategory.getName()).append("'] = '").append(StringUtil.safeHtml((String)string, (boolean)false)).append("';\n");
            this.m_showCategories.append("show['").append(eventCategory.getName()).append("'] = ").append("false").append(";\n");
            this.m_hasThreats.append("has_threats['").append(eventCategory.getName()).append("'] = ").append(eventCategory.getAssociateThreat()).append(";\n");
        }
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }
}

