/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui.util;

import com.mcafee.epo.common.ui.util.OrderedKeyValueList;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.ui.MissingParameterException;
import com.mcafee.epo.notifications.db.AlertingConfig;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.util.Resource;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionUtil {
    public static final boolean isInteger(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        boolean bl = false;
        if (Pattern.matches("^-?\\d*$", string)) {
            bl = true;
        }
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isLong(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        boolean bl = false;
        if (Pattern.matches("^-?\\d*$", string)) {
            bl = true;
        }
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isLongNE(String string, long l) {
        if (!SessionUtil.isLong(string)) {
            return false;
        }
        return Long.parseLong(string) != l;
    }

    public static final boolean isIntegerNE(String string, int n) {
        if (!SessionUtil.isInteger(string)) {
            return false;
        }
        return Integer.parseInt(string) != n;
    }

    public static final boolean isLongGT(String string, long l) {
        if (!SessionUtil.isLong(string)) {
            return false;
        }
        return Long.parseLong(string) > l;
    }

    public static final boolean isIntegerGT(String string, int n) {
        if (!SessionUtil.isInteger(string)) {
            return false;
        }
        return Integer.parseInt(string) > n;
    }

    public static final boolean isLongLE(String string, long l) {
        if (!SessionUtil.isLong(string)) {
            return false;
        }
        return Long.parseLong(string) <= l;
    }

    public static final boolean isIntegerLE(String string, int n) {
        if (!SessionUtil.isInteger(string)) {
            return false;
        }
        return Integer.parseInt(string) <= n;
    }

    public static final boolean isNonEmptyString(String string) {
        return string != null && string.length() >= 1;
    }

    public static final boolean atLeastOneStartsWith(HttpServletRequest httpServletRequest, String string) {
        boolean bl = false;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = null;
        while (!bl && enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            bl = true;
        }
        return bl;
    }

    public static final boolean isTrueOrFalse(String string) {
        return string.compareTo("true") == 0 || string.compareTo("false") == 0;
    }

    public static final boolean atLeastOneIntStartsWith(HttpServletRequest httpServletRequest, String string) {
        boolean bl = false;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            matcher = pattern.matcher(string2);
            if (!matcher.find() || !SessionUtil.isInteger(string2.substring(matcher.end(), string2.length()))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final OrderedKeyValueList getOrderedKVList(String string, HttpServletRequest httpServletRequest) throws Exception {
        String string2 = null;
        OrderedKeyValueList orderedKeyValueList = new OrderedKeyValueList();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) != 0) continue;
            orderedKeyValueList.add(string2.substring(string.length()), httpServletRequest.getParameter(string2));
        }
        return orderedKeyValueList;
    }

    public static final void setScrollY(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("scrollY");
        if (string != null && string.length() > 0) {
            httpServletRequest.setAttribute("scrollY", (Object)string);
        }
    }

    public static final boolean isGlobalAdmin(HttpServletRequest httpServletRequest, String string) {
        EpoUser epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        String string2 = epoUser.getLanguageId();
        if (epoUser.isReviewer() || epoUser.isSiteAccount()) {
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_permissions_error", string2), Resource.getString("commands_global_admin_only", string2), string);
            return false;
        }
        return true;
    }

    public static final boolean canEdit(HttpServletRequest httpServletRequest, String string) {
        EpoUser epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        if (!SessionUtil.canEdit(epoUser)) {
            String string2 = epoUser.getLanguageId();
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_permissions_error", string2), Resource.getString("commands_global_admin_or_permitted_site_only", string2), string);
            return false;
        }
        return true;
    }

    public static final boolean canEdit(HttpServletRequest httpServletRequest) {
        return SessionUtil.canEdit(UserUtil.getEpoUser((HttpServletRequest)httpServletRequest));
    }

    public static final boolean canEdit(EpoUser epoUser) {
        AlertingConfig alertingConfig = Server.getConfiguration();
        if (!epoUser.isReviewer() && !epoUser.isSiteAccount()) {
            return true;
        }
        return !epoUser.isReviewer() && epoUser.isSiteAccount() && alertingConfig.getAllowSiteToEditTargets() != false;
    }

    public static final void setActionTakenPageAttr(HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        SessionUtil.setActionTakenPageAttr(httpServletRequest, string, string2, string3, null);
    }

    public static final void setActionTakenPageAttr(HttpServletRequest httpServletRequest, String string, String string2, String string3, LinkedList linkedList) {
        httpServletRequest.setAttribute("actiontakentitle", (Object)string);
        httpServletRequest.setAttribute("actiontakendesc", (Object)string2);
        httpServletRequest.setAttribute("returnaction", (Object)string3);
        httpServletRequest.setAttribute("returnRequestParams", (Object)linkedList);
    }

    public static final String infoPage(HttpServletRequest httpServletRequest, String string, String string2) {
        httpServletRequest.setAttribute("infotext", (Object)string2);
        httpServletRequest.setAttribute("infotitle", (Object)string);
        return "info.jsp";
    }

    public static final Object getSessionAttribute(HttpServletRequest httpServletRequest, String string) throws MissingParameterException {
        Object object = SessionUtil.getSession(httpServletRequest).getAttribute(string);
        if (object == null) {
            throw new MissingParameterException(Resource.formatString("sessionutil_template_missing_session_param", string, UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest)));
        }
        return object;
    }

    public static final void setSessionAttribute(HttpServletRequest httpServletRequest, String string, Object object) throws MissingParameterException {
        SessionUtil.getSession(httpServletRequest).setAttribute(string, object);
    }

    public static final void removeSessionAttribute(HttpServletRequest httpServletRequest, String string) throws MissingParameterException {
        SessionUtil.getSession(httpServletRequest).removeAttribute(string);
    }

    public static final boolean sessionAttributeExists(HttpServletRequest httpServletRequest, String string) throws MissingParameterException {
        return SessionUtil.getSession(httpServletRequest).getAttribute(string) != null;
    }

    public static final String getRequestParameter(HttpServletRequest httpServletRequest, String string) throws MissingParameterException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            throw new MissingParameterException(Resource.formatString("sessionutil_template_mssiing_request_param", string, UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest)));
        }
        return string2;
    }

    public static final int getRequestParameterInt(HttpServletRequest httpServletRequest, String string) throws MissingParameterException, InvalidParameterException {
        try {
            return Integer.parseInt(SessionUtil.getRequestParameter(httpServletRequest, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidParameterException(string);
        }
    }

    public static Map getPropMap() {
        return null;
    }

    private static HttpSession getSession(HttpServletRequest httpServletRequest) throws MissingParameterException {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new MissingParameterException(Resource.getString("sessionutil_session", UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest)));
        }
        return httpSession;
    }
}

