var g_bNoSource = false;
var GLOBAL_ADMIN		= 1;
var SITE_ADMIN			= 3;

// the current Task	ID (will be	zero if	it is a	new	task)
var		g_nTaskID;

var		g_szCurrent	= "Current";
var 		g_szPrevious	= "Previous";
var		g_szEvaluation	= "Evaluation";


function fnLoadSettings()
{
	g_nTaskID = window.external.Task_GetID();
		
	if ( g_nTaskID	== 0 )
	{
		// Creating	a new task
		fnLoadSourceSites("");
		radioID_BranchCurrent.checked = true;
	}
	else
	{	
		// Load	task settings.
		fnLoadSourceSites(window.external.Task_GetValue("Mirror",	"MirrorSiteName"));
		
		if ( window.external.Task_GetValue("Mirror", "MoveToPrevBranch") == "1" )
			bID_MoveToPrevious.checked = true;
		else
			bID_MoveToPrevious.checked = false;
	
		if ( window.external.Task_GetValue("Mirror", "LegacySupport") == "1" )
			bID_EnableLegacy.checked = true;
		else
			bID_EnableLegacy.checked = false;

		switch( window.external.Task_GetValue("Mirror", "TargetBranch") )
		{
			case g_szPrevious:	radioID_BranchPrevious.checked = true;
			break;

			case g_szEvaluation:	radioID_BranchEval.checked = true;
			break;

			case g_szCurrent: 
			default:		radioID_BranchCurrent.checked = true;
			break;
		}

		fnBranchSelectOnClick();
	}
		
}
		
function fnLoadSourceSites(szSourceSite)
	{

		var xmldomSiteList = new ActiveXObject("Microsoft.XMLDOM");
		var bOK = false;
		var dwLength = 0;
		var xmldomDocEl = null;
		var bFoundHTTPSite = false;

		bOK = xmldomSiteList.loadXML(window.external.GetSiteMgrXML());
			
		if(bOK)
		{
			xmldomDocEl = xmldomSiteList.documentElement;
			bOK = (xmldomDocEl != null);
		}
		
		if(bOK)
		{
			childnodesSiteList = xmldomDocEl.firstChild.childNodes;
			dwLength = childnodesSiteList.length;
				
			for(var i=0; i<dwLength; i++)
			{
				if(childnodesSiteList.item(i).nodeName == "ProxyConfigList")
					continue;

				if(childnodesSiteList.item(i).getAttribute("Type").toLowerCase() == "mirror" ||
				childnodesSiteList.item(i).getAttribute("Type").toLowerCase() == "fallback")
				{
					var elOption = document.createElement("OPTION");
					var szSiteName = childnodesSiteList.item(i).getAttribute("Name");
					elOption.text = szSiteName;
					
					if(!bFoundHTTPSite && szSiteName.toLowerCase() == "naihttp" && childnodesSiteList.item(i).nodeName == "HttpSite")
					{
						elOption.selected = "true";
						bFoundHTTPSite = true;
					}
					else if(!bFoundHTTPSite && childnodesSiteList.item(i).getAttribute("Type").toLowerCase() == "fallback")
						elOption.selected = "true";
					
					selectID_SourceSite.add(elOption);
				}
			}
				
			dwLength = selectID_SourceSite.length;
			for(var j=0; j<dwLength; j++)
			{
				if(selectID_SourceSite.options[j].text == szSourceSite)
				{
					selectID_SourceSite.selectedIndex = j;
				}
			}
		}
	}

///////////////////////////////////////////////////
///	Write new task settings
///
function SaveSettings()
{
	window.external.Task_SetValue("Mirror",	"MirrorSiteName", selectID_SourceSite.options[selectID_SourceSite.selectedIndex].text);

	if ( bID_MoveToPrevious.checked )
		var MoveBranch = "1";
	else
		var MoveBranch = "0";


	if ( bID_EnableLegacy.checked )
		var LegacySupport = "1";
	else
		var LegacySupport = "0";

	window.external.Task_SetValue("Mirror",	"MoveToPrevBranch", MoveBranch);
	window.external.Task_SetValue("Mirror",	"LegacySupport", LegacySupport);

	var szTargetBranch = "";

	if ( radioID_BranchCurrent.checked )
		szTargetBranch = g_szCurrent;

	if ( radioID_BranchPrevious.checked )
		szTargetBranch = g_szPrevious;

	if ( radioID_BranchEval.checked )
		szTargetBranch = g_szEvaluation;

	window.external.Task_SetValue("Mirror", "TargetBranch", szTargetBranch);
}

///////////////////////////////////////////////////
///	Validate that all required fields have been	set
///
function Validate()
{
	var bValid = true;

	if(g_bNoSource)
	{
		bValid = false;
		alert(nrc_sz_errNoSourceRepositories);
	}
	
	return bValid;
}

///////////////////////////////////////////////////
///	Write the task to database 
///
function OnSave()
{
	// Validate Settings
	if(!Validate())
	{
		return;
	}
				
	SaveSettings();	

	// Save the Task to server
	window.external.Task_Save();
}

function OnBack()
{
	window.external.Task_Back();
}

function OnCancel()
{
	window.external.DisplayHome();
}
		
		
function fnLoadResources()
{
	if ( g_nTaskID	!= 0 )
		labelID_Title.innerHTML				= nrc_sz_ModifyTask;
	else
		labelID_Title.innerHTML				= nrc_sz_NewTask;
				
	btnBack.szCaption					= nrc_sz_Back;
	btnCancel.szCaption					= nrc_sz_Cancel;
	btnSave.szCaption					= nrc_sz_Finish;
			
	labelID_Heading.innerHTML			= nrc_sz_Heading;
	labelID_SourceSiteInfo.innerHTML	= nrc_sz_SourceSiteInfo;	
	labelID_SourceSite.innerHTML		= nrc_sz_SourceSite;	
	labelID_MoveToPrevious.innerHTML	= nrc_sz_MoveToPrevious;
	labelID_EnableLegacy.innerHTML		= nrc_sz_EnableLegacy;

	labelID_BranchCurrent.innerHTML		= nrc_sz_Current;
	labelID_BranchPrevious.innerHTML	= nrc_sz_Previous;
	labelID_BranchEval.innerHTML		= nrc_sz_Eval;
	labelID_BranchInfo.innerHTML		= nrc_sz_BranchInfo;
}
		
		
function fnInitialize()
{
	g_iCurrentUserRole 	= window.external.GetUserRole();
	
	if ( g_iCurrentUserRole != GLOBAL_ADMIN ) 
	{
		btnSave.bDisabled 		= true;
	}


	fnLoadSettings();
	fnLoadResources();

	if (selectID_SourceSite.length == 0)
	{
		selectID_SourceSite.disabled = true;
		selectID_SourceSite.options[0] = new Option(nrc_sz_NoRepositories, "");
		alert(nrc_sz_errNoSourceRepositories);		
		g_bNoSource = true;
	}
}

function fnBranchSelectOnClick()
{
	bState = !radioID_BranchCurrent.checked;

	bID_EnableLegacy.disabled 	= bState;
	labelID_EnableLegacy.disabled	= bState;
	bID_MoveToPrevious.disabled	= bState;
	labelID_MoveToPrevious.disabled	= bState;

	if (bState == true)
	{
		bID_MoveToPrevious.checked = false;
		bID_EnableLegacy.checked = false;
	}
}