-------------------------------
-- epo3.5 patch5 bz244131: alter memeory fields to store more than 2**32


-- ============================================================================
-- BEGIN EPOPolicySlot modification to enforce types at the slot level.

-- Alter policy slot table, adding policy type code, allowing nulls temporarily
ALTER TABLE EPOPolicySlot
	ADD TypeID int NULL;
GO

-- set default slot type id values
UPDATE EPOPolicySlot SET EPOPolicySlot.TypeID = EPOPOlicyObjects.TypeID
	FROM EPOPolicyObjects INNER JOIN EPOPolicyAssignment
	ON EPOPolicyObjects.PolicyObjectID = EPOPOlicyAssignment.PolicyObjectID
	WHERE EPOPolicySlot.SlotID = EPOPolicyAssignment.SlotID

-- remove potential bogus slots that were not being used
DELETE FROM EPOPolicySlot
	WHERE TypeID IS NULL;

-- reenable non-null constraint for typeid
ALTER TABLE EPOPolicySlot
	ALTER COLUMN TypeID int NOT NULL;
GO

-- update slot creation code to require a typeid
ALTER  PROCEDURE dbo.EPOPolicy_AddPolicySlot
(
	@UserID int,
	@ProductCode nvarchar(128),
	@TypeID int,
	@SlotID int output
)
AS
	-- squelch client-rowcount messages
	SET NOCOUNT ON;

	-- init output parameters
	SET @SlotID = NULL;

	-- add new record
	INSERT INTO EPOPolicySlot (ProductCode, TypeID)
	VALUES (@ProductCode, @TypeID);

	-- remember last inserted record
	SET @SlotID = SCOPE_IDENTITY();

	-- return error condition
	RETURN @@ERROR;
GO


-- update policy assignment retrieval to use slot-based type info
ALTER PROCEDURE dbo.EPOPolicy_GetNodePolicyAssignmentsEx
(
	@NodeID int,
	@NodeType smallint,
	@ProductCode nvarchar(128) = NULL
)
AS
	-- squelch client callbacks
	SET NOCOUNT ON;

	-- get parent identifier
	DECLARE @ParentID int;
	DECLARE @ParentType smallint;
	SET @ParentType = NULL;
	SET @ParentID = NULL;

	-- walk node inheritance tree, returning a recordset for each
	IF (@NodeType IN (1, 2, 24))
	BEGIN
		SELECT @ParentID = ParentID FROM LeafNode WHERE AutoID = @NodeID;
	END
	ELSE
	BEGIN
		-- else this is a branch node, so use the node id itself
		SELECT @ParentID = ParentID FROM BranchNode WHERE AutoID = @NodeID;
	END

	-- if this is not the global root.
	IF ((NOT @ParentID IS NULL) AND (@ParentID <> 0))
	BEGIN
		-- regardless, the type comes from the parent node directly
		SELECT @ParentType = Type FROM BranchNode WHERE AutoID = @ParentID;

		-- execute recursively on the parent of the current node.
		EXEC EPOPolicy_GetNodePolicyAssignmentsEx @ParentID, @ParentType, @ProductCode;
	END

	-- if the product code is null, then find all assignments
	-- for this node, otherwise find all for that product code.
	IF (@ProductCode IS NULL)
	BEGIN
		-- now run the query
		SELECT EPOPolicyAssignment.AssignmentID AS AssignmentID,
		EPOPolicyAssignment.NodeID AS NodeID,
		EPOPolicyAssignment.NodeType AS NodeType,
		EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
		EPOPolicySlot.TypeID AS PolicyTypeID,
		EPOPolicyAssignment.SlotID AS SlotID,
		EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
		EPOPolicyAssignment.Hidden AS Hidden,
		EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
		EPOPolicySlot.ProductCode AS ProductCode
		FROM (EPOPolicySlot INNER JOIN EPOPOlicyAssignment ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
		WHERE ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType))
		ORDER BY EPOPolicySlot.TypeID ASC, EPOPolicyAssignment.SlotID ASC;
	END
	ELSE
	BEGIN
		-- this monster is to filter based on product code, which is
		--  derived from the policy objects in the assignment table,
		--  based on their types as related to the product code in the
		--  product-to-types table (whew).
		SELECT EPOPolicyAssignment.AssignmentID AS AssignmentID,
		EPOPolicyAssignment.NodeID AS NodeID,
		EPOPolicyAssignment.NodeType AS NodeType,
		EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
		EPOPolicySlot.TypeID AS PolicyTypeID,
		EPOPolicyAssignment.SlotID AS SlotID,
		EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
		EPOPolicyAssignment.Hidden AS Hidden,
		EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
		@ProductCode AS ProductCode
		FROM (EPOPolicyAssignment INNER JOIN EPOPolicySlot ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
		WHERE (EPOPolicySlot.ProductCode = @ProductCode)
		AND ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType))
		ORDER BY EPOPolicySlot.TypeID ASC, EPOPolicyAssignment.SlotID ASC;
	END
	RETURN @@ERROR;
GO

ALTER PROCEDURE dbo.EPOPolicy_GetNodePolicyAssignmentBySlotID
(
	@NodeID int,
	@NodeType smallint,
	@SlotID int
)
AS
	-- squelch client-callbacks
	SET NOCOUNT ON;

	SELECT EPOPolicyAssignment.NodeID AS NodeID,
	EPOPolicyAssignment.NodeType AS NodeType,
	EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
	EPOPolicySlot.TypeID AS PolicyTypeID,
	EPOPolicyAssignment.SlotID AS SlotID,
	EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
	EPOPolicyAssignment.Hidden AS Hidden,
	EPOPolicyAssignment.TheTimestamp AS TheTimestamp,
	EPOPolicySlot.ProductCode AS ProductCode
	FROM (EPOPolicySlot INNER JOIN EPOPOlicyAssignment ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
	WHERE ((EPOPolicyAssignment.NodeID = @NodeID) AND (EPOPolicyAssignment.NodeType = @NodeType)
	AND EPOPolicyAssignment.SlotID = @SlotID)

GO

ALTER PROCEDURE dbo.EPOPolicy_GetNodeBrokenInheritancePolicyAssignments
(
	@NodeID int,
	@NodeType smallint,
	@SlotID int
)
AS
	SET NOCOUNT ON;

	-- return all leaf node and child branch node policy assignments with the same SlotID
	SELECT EPOPolicyAssignment.NodeID AS NodeID,
	EPOPolicyAssignment.NodeType AS NodeType,
	EPOPolicyAssignment.PolicyObjectID AS PolicyObjectID,
	EPOPolicySlot.TypeID AS PolicyTypeID,
	@SlotID AS SlotID,
	EPOPolicyAssignment.ForceInheritance AS ForceInheritance,
	EPOPolicyAssignment.Hidden AS Hidden,
	EPOPolicyAssignment.TheTimestamp AS TheTimestamp
	FROM (EPOPolicyAssignment INNER JOIN EPOPolicySlot
	ON EPOPolicyAssignment.SlotID = EPOPolicySlot.SlotID)
	WHERE ( (EPOPolicyAssignment.SlotID = @SlotID)
		AND
		(
			(	-- child branch nodes
				EPOPolicyAssignment.NodeType NOT IN (1,2,24)
				AND EPOPolicyAssignment.NodeID IN (SELECT EndAutoID FROM BranchNodeEnum WHERE StartAutoID=@NodeID)
			)

			OR
			(	-- leaf nodes
				EPOPolicyAssignment.NodeType IN (1, 2, 24)
				AND EPOPolicyAssignment.NodeID IN (SELECT AutoID FROM LeafNode WHERE (ParentID=@NodeID) OR (ParentID in
					(SELECT EndAutoID FROM BranchNodeEnum WHERE StartAutoID=@NodeID)))
			)
		)
	)
	ORDER BY EPOPolicyAssignment.NodeID ASC

		-- ideally the output should be ordered by node depth
	RETURN @@ERROR;
GO

-- END EPOPolicySlot modification to enforce types at the slot level.
-- ============================================================================


-- Alter columns to make into bigint (values > 4G)
ALTER TABLE [dbo].[ComputerProperties] DROP
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] ,
	CONSTRAINT [DF_ComputerProperties_FreeMemory]
GO

-- using numeric instead of bigint for sql 7 compatibility
ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
TotalPhysicalMemory nvarchar(64) null
go 

ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
FreeMemory nvarchar(64) null
go

ALTER TABLE [dbo].[ComputerProperties] ADD
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] DEFAULT ('0') FOR [TotalPhysicalMemory],
	CONSTRAINT [DF_ComputerProperties_FreeMemory] DEFAULT ('0') FOR [FreeMemory]
GO

--end

----------------------------------------------------------------
-- epo3.5p5 bz239604: add new default policies directly to DB to avoid user having to check in a 
--	nap file in order to get the fix.
begin

declare @id int

select @id = autoid 
from policy
where
parenttype =7
and productcode = 'EPOAGENT3000'

if not exists (select parentid from policysettings
where sectionname = 'BranchSelection' and parentid = @id)
begin

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'NumberOfItems', '4')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_0', 'VSCANDAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_0', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_1', 'VSCANENG1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_1', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_2', 'EXTRADAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_2', 'Current')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'SoftwareID_3', 'SUPERDAT1000')

insert PolicySettings
(parentid, Sectionname, settingname, value)
values(@id, 'BranchSelection', 'BranchType_3', 'Current')

end
end
GO
--end



-- bz246340 epo3.5 patch5
---------------------------------------------------------
ALTER PROCEDURE dbo.AVISP_FilterUpgradeEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




	-- initiator types
	Declare @InitiatorType1 varchar(50)	
	Declare @InitiatorType2 varchar(50)	
	Declare @InitiatorType3 varchar(50)	
	Declare @InitiatorType4 varchar(50)	
	Declare @InitiatorType5 varchar(50)	

		Set @InitiatorType1 ='Automatic'	
		Set @InitiatorType2 ='Task'	
		Set @InitiatorType3 ='Remediation'	
		Set @InitiatorType4 ='On Demand'	
		Set @InitiatorType5 ='Rollback'	

	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		-- initiator type
		Select 	@InitiatorType1 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type1'
		Select 	@InitiatorType2 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type2'
		Select 	@InitiatorType3 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type3'
		Select 	@InitiatorType4 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type4'
		Select 	@InitiatorType5 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type5'
	End


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(AVIView_Software.SoftwareName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE AVIView_Software.SoftwareVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
   		,cast(ReportFullPathNodeID.FullPathShortName as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,ProductEvents.Type as Type
		,Version as Version
		,ProductEvents.Sitename as Sitename
		,InitiatorID as InitiatorID
--		,InitiatorType as InitiatorType
		,case 
			when InitiatorType= 'Automatic' then @InitiatorType1
			when InitiatorType= 'Task' then @InitiatorType2
			when InitiatorType= 'Remediation' then @InitiatorType3
			when InitiatorType= 'OnDemand' then @InitiatorType4
			when InitiatorType= 'OnDemandRollback' then @InitiatorType5
			when InitiatorType= 'DeploymentTask' then @InitiatorType2
			when InitiatorType= 'UpdateTask' then @InitiatorType2
			when InitiatorType= 'RemediationRollback' then @InitiatorType5
			else InitiatorType
		end as InitiatorType
		,Error as ErrorID

-- postepo3 33379 - join to ReportUpdateEventDesc and return error desc if its available 
--		,cast(Error as nvarchar(128)) as ErrorDesc
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM
		ProductEvents 
		Join leafnode on (ProductEvents.NodeID = leafnode.autoID			/* regular join tieing events to nodes */
			and ProductEvents.NodeID = @NodeID	)
		Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID)
		Join aviview_software on (ProductEvents.productcode = aviview_software.productcode)
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
--	FROM ProductEvents, ReportComputerSummary, ReportUpdateEventDesc
	WHERE 
  	(
   		@FilterID = 0 OR
    		leafnode.parentid = @FilterID OR
  		leafnode.parentid in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	and ProductEvents.Type > ''



	UNION


 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
			as EventDateTime
    		,CAST(Events.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(UserName AS varchar(32)) AS UserName
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
    		,TVDEventID
    		,CAST(FileName As varchar(255)) As FileName 
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion 
    		,CAST(DATVersion as varchar(16)) As DATVersion 
    		,ScanTime
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END
    		,TVDSeverity
   		,VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END
    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
   		,cast('' as varchar(256)) AS NodeName
   		,'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		,cast(EventFilterDescFast.name as nvarchar(256)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		-- bz246340 epo3.5 patch5: must use @szFullLang (4 digit lang code) instead of @szLang (2 digit)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szFullLang) 

  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
	and Events.NodeID = @NodeID	



RETURN @@rowcount
END

GO


-- bz240142 epo3.5 patch5 
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_UpdateProdPropFromEvents]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [EPOSP_UpdateProdPropFromEvents]
GO

-- Patch3 Update
CREATE PROCEDURE dbo.EPOSP_UpdateProdPropFromEvents
 @AgentGUID  uniqueidentifier,			-- matches leafnode.agentGUID
 @MACAddress NVARCHAR(50) = NULL,
 @ProductCode nvarchar(50),	-- matches productproperties.productcode
 @Type nvarchar(50),
 @Version nvarchar(50),
 -- epo3.5 >patch4 bz240142: Check error parm and dont update if update event fails
 @Error int = 0

AS
BEGIN
	SET XACT_ABORT ON
	SET NOCOUNT ON

	DECLARE @LeafNodeID INT
	DECLARE @ProdPropID INT
	DECLARE @c CHAR

	SELECT TOP 1 @LeafNodeID = AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID

	if ((@LeafNodeID IS NULL) AND (@MACAddress IS NOT NULL)  AND (@MACAddress<>''))
	BEGIN
		SET @c=LEFT(@MACAddress,1)
		if ( ((@c>='0') AND (@c<='9')) OR ((@c>='A') AND (@c<='F')) OR ((@c>='a') AND (@c<='f')) )
		BEGIN
			SELECT TOP 1 @LeafNodeID = l.Autoid from leafnode as l inner join computerproperties as c on l.autoid=c.parentid where c.netaddress=@MACAddress
		END
	END

 	-- epo3.5 patch5 bz240142: Check error parm and dont update if update event fails
	IF (@LeafNodeID IS NOT NULL and (@Error = 0 or @Error = 1) )
	BEGIN
		SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode

		IF (@ProdPropID IS NULL)
		BEGIN
			--Create prodprop entry
			INSERT INTO ProductProperties 
				(ParentID,ProductCode)
			VALUES
				(@LeafNodeID, @ProductCode)

			SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode
		END

		IF (@ProdPropID IS NOT NULL)
		BEGIN
			if upper(@type) = 'INSTALL'
			begin
				UPDATE ProductProperties 
					SET ProductVersion=@Version 
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szProductVer',
					'General',
					@Version
			end
			if upper(@type) = 'HOTFIX'
			begin
				UPDATE ProductProperties 
					set Hotfix=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szHotfixVersion',
					'General',
					@Version
			end
			if upper(@type) = 'SERVICEPACK'
			begin
				UPDATE ProductProperties 
					set Servicepack=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szServicePackVersion',
					'General',
					@Version
			end
			if upper(@type) = 'DAT'
			begin
				UPDATE ProductProperties 
					set DATVer=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szDATVersion',
					'General',
					@Version
			end
			if upper(@type) = 'ENGINE'
			begin
				UPDATE ProductProperties 
					set EngineVer=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szEngineVersion',
					'General',
					@Version
			end
			if upper(@type) = 'EXTRADAT'
			begin
				UPDATE ProductProperties 
					set ExtraDatNames=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szExtraDATNames',
					'General',
					@Version
			end
		END
	END
END
 

GO

----------------------------------------------------------------------------------------------------
-- BEGIN: BZ 254016 - add Notifications support for Host Intrusion Prevention events
----------------------------------------------------------------------------------------------------
if not exists( select * from AlertFamily where [Name] = 'HIP' )
BEGIN
    declare @hip int;
    insert into AlertFamily ([Name]) values('HIP');
    select @hip = @@IDENTITY;

    insert into [AlertAliasMapping] values(@hip, 'Aliases.EnterceptAgentEvent.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'EnterceptAgentEvent', '');
    insert into [AlertAliasMapping] values(@hip, 'Aliases.FirewallKevlarQuarentineCheck.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'FirewallKevlarQuarentineCheck', '');
    insert into [AlertAliasMapping] values(@hip, 'Aliases.FirewallKevlarBlockedApplication.xml.properties', 'com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture', 'FirewallKevlarBlockedApplicationEvent', '');

    declare @application_blocked int;
    declare @host_intrusion_detected_and_handled int;
    declare @network_intrusion_detected_and_handled int;
    declare @computer_quarantine_mode int;   -- must retrieve via select statement
    declare @unknown_category int;           -- must retrieve via select statement

    insert into EventCategory ([Name], [AssociateThreat]) values('APPLICATION_BLOCKED', 1);
    select @application_blocked = @@IDENTITY;
    insert into EventCategory ([Name], [AssociateThreat]) values('HOST_INTRUSION_DETECTED_AND_HANDLED', 1);
    select @host_intrusion_detected_and_handled = @@IDENTITY;
    insert into EventCategory ([Name], [AssociateThreat]) values('NETWORK_INTRUSION_DETECTED_AND_HANDLED', 1);
    select @network_intrusion_detected_and_handled = @@IDENTITY;
    select @unknown_category = [EventCategoryId] from [EventCategory] where [Name] = 'UNKNOWN_CATEGORY';
    select @computer_quarantine_mode = [EventCategoryId] from [EventCategory] where [Name] = 'COMPUTER_QUARANTINE_MODE';

    insert into AFToCatMapping values(@hip, @unknown_category);
    insert into AFToCatMapping values(@hip, @application_blocked);
    insert into AFToCatMapping values(@hip, @computer_quarantine_mode);
    insert into AFToCatMapping values(@hip, @host_intrusion_detected_and_handled);
    insert into AFToCatMapping values(@hip, @network_intrusion_detected_and_handled);

    declare @unknown_product int;  -- pre-existing
    select @unknown_product = [AlertFamilyId] from [AlertFamily] where [Name] = 'UNKNOWN_PRODUCT';
    insert into AFToCatMapping values(@unknown_product, @application_blocked);
    insert into AFToCatMapping values(@unknown_product, @host_intrusion_detected_and_handled);
    insert into AFToCatMapping values(@unknown_product, @network_intrusion_detected_and_handled);

    IF exists(select [EventID] from [EventFilter] where EventID=18000)
        update [EventFilter] set [EventCategory]=@host_intrusion_detected_and_handled, HideInFilterTab=0 where EventID=18000;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18000, 0x4000001, null, null, @host_intrusion_detected_and_handled, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18001)
        update [EventFilter] set [EventCategory]=@network_intrusion_detected_and_handled, HideInFilterTab=0 where EventID=18001;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18001, 0x4000001, null, null, @network_intrusion_detected_and_handled, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18002)
        update [EventFilter] set EventCategory=@application_blocked, HideInFilterTab=0 where EventID=18002;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18002, 0x4000001, null, null, @application_blocked, 0);

    IF exists(select [EventID] from [EventFilter] where EventID=18003)
        update [EventFilter] set EventCategory=@computer_quarantine_mode, HideInFilterTab=0 where EventID=18003;
    ELSE
        insert into [EventFilter] (EventID, Flag, TheTimestamp, TheHiddenTimestamp, EventCategory, HideInFilterTab) values(18003, 0x4000001, null, null, @computer_quarantine_mode, 0);
END
GO
----------------------------------------------------------------------------------------------------
-- END: BZ 254016 - add Notifications support for Host Intrusion Prevention events
----------------------------------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- ePO 3.5 patch 5
-- BEGIN: fix for BZ 236173:  Fix involves changing certain columns
-- from char and varchar types to nchar and nvarchar types,
-- respectively.  As explained in the MSDN documentation for the
-- ALTER TABLE command, ALTER COLUMN cannot be used to change the column
-- types.  Tables must be recreated with the new column types.
------------------------------------------------------------------------
------------------------------------------------------------------------

IF EXISTS (select systypes.name
      from sysobjects, syscolumns, systypes
      where sysobjects.xtype = 'U' and
      sysobjects.name = 'Hosts' and
      sysobjects.id = syscolumns.id and
      syscolumns.name = 'MAC' and
      syscolumns.xtype = systypes.xtype and
      systypes.name = 'char' )
BEGIN
    ------------------------------------------------------------------------
    -- changes to the Hosts table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Hosts
        DROP CONSTRAINT FK_Hosts_Networks


    CREATE TABLE dbo.Tmp_Hosts
        (
        HostID int NOT NULL IDENTITY (1, 1),
        MAC nchar(12) NOT NULL,
        OUI nchar(6) NULL,
        NetworkAddress nvarchar(50) NOT NULL,
        NetworkProtocolID int NOT NULL,
        NetbiosName nvarchar(16) NOT NULL,
        DnsName nvarchar(255) NOT NULL,
        LastDetectTime datetime NULL,
        NetworkID int NULL,
        [Exception] bit NOT NULL,
        EpoIndex int NULL,
        Comments nvarchar(255) NOT NULL,
        OSPlatform nvarchar(25) NOT NULL,
        OSFamily nvarchar(128) NOT NULL,
        OSVersion nvarchar(128) NOT NULL,
        NetBiosComment nvarchar(100) NOT NULL,
        Deleted bit NOT NULL,
        FirstDetectTime datetime NULL,
        Users nvarchar(128) NOT NULL,
        [Domain] nvarchar(16) NOT NULL,
        SID nvarchar(48) NOT NULL,
        FirstRogueTime datetime NULL,
        RogueType int NOT NULL,
        LastAgentCom datetime NULL,
        IpAddressNum int NOT NULL,
        FriendlyName nvarchar(255) NOT NULL,
        MarkedForAction bit NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Hosts ON

    IF EXISTS(SELECT * FROM dbo.Hosts)
         EXEC('INSERT INTO dbo.Tmp_Hosts (HostID, MAC, OUI, NetworkAddress, NetworkProtocolID, NetbiosName, DnsName, LastDetectTime, NetworkID, [Exception], EpoIndex, Comments, OSPlatform, OSFamily, OSVersion, NetBiosComment, Deleted, FirstDetectTime, Users, [Domain], SID, FirstRogueTime, RogueType, LastAgentCom, IpAddressNum, FriendlyName, MarkedForAction)
            SELECT HostID, MAC, OUI, NetworkAddress, NetworkProtocolID, NetbiosName, DnsName, LastDetectTime, NetworkID, [Exception], EpoIndex, Comments, OSPlatform, OSFamily, OSVersion, NetBiosComment, Deleted, FirstDetectTime, Users, [Domain], SID, FirstRogueTime, RogueType, LastAgentCom, IpAddressNum, FriendlyName, MarkedForAction FROM dbo.Hosts TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Hosts OFF

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Hosts

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Hosts

    DROP TABLE dbo.Hosts

    EXECUTE sp_rename N'dbo.Tmp_Hosts', N'Hosts', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Hosts_MAC ON dbo.Hosts
        (
        MAC
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OUI ON dbo.Hosts
        (
        OUI
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_NetbiosName ON dbo.Hosts
        (
        NetbiosName
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_DnsName ON dbo.Hosts
        (
        DnsName
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_LastDetectTime ON dbo.Hosts
        (
        LastDetectTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Comments ON dbo.Hosts
        (
        Comments
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSPlatform ON dbo.Hosts
        (
        OSPlatform
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSFamily ON dbo.Hosts
        (
        OSFamily
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_OSVersion ON dbo.Hosts
        (
        OSVersion
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_NetBiosComment ON dbo.Hosts
        (
        NetBiosComment
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FirstDetectTime ON dbo.Hosts
        (
        FirstDetectTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Users ON dbo.Hosts
        (
        Users
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_Domain ON dbo.Hosts
        (
        [Domain]
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FirstRogueTime ON dbo.Hosts
        (
        FirstRogueTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_RogueType ON dbo.Hosts
        (
        RogueType
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_LastAgentCom ON dbo.Hosts
        (
        LastAgentCom
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_IpAddressNum ON dbo.Hosts
        (
        IpAddressNum
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Hosts_FriendlyName ON dbo.Hosts
        (
        FriendlyName
        ) ON [PRIMARY]

    ALTER TABLE dbo.Hosts ADD CONSTRAINT
        PK_Hosts PRIMARY KEY NONCLUSTERED
        (
        HostID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Hosts WITH NOCHECK ADD CONSTRAINT
        FK_Hosts_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )

    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Hosts FOREIGN KEY
        (
        SourceHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Hosts FOREIGN KEY
        (
        TargetHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )


    ------------------------------------------------------------------------
    -- changes to the OUIs table as a result of Bugzilla 236173
    ------------------------------------------------------------------------

    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    CREATE TABLE dbo.Tmp_OUIs
        (
        OrgName nvarchar(255) NOT NULL,
        OUI nchar(6) NOT NULL
        )  ON [PRIMARY]

    IF EXISTS(SELECT * FROM dbo.OUIs)
         EXEC('INSERT INTO dbo.Tmp_OUIs (OrgName, OUI)
            SELECT OrgName, OUI FROM dbo.OUIs TABLOCKX')

    DROP TABLE dbo.OUIs

    EXECUTE sp_rename N'dbo.Tmp_OUIs', N'OUIs', 'OBJECT'

    ALTER TABLE dbo.OUIs ADD CONSTRAINT
        PK_OUI PRIMARY KEY CLUSTERED
        (
        OUI
        ) ON [PRIMARY]


    ------------------------------------------------------------------------
    -- changes to the Networks table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Networks
        DROP CONSTRAINT DF_Networks_Covered

    CREATE TABLE dbo.Tmp_Networks
        (
        NetworkID int NOT NULL IDENTITY (1, 1),
        NetworkName nvarchar(255) NOT NULL,
        SubnetMask nvarchar(25) NOT NULL,
        NetworkAddress nvarchar(25) NOT NULL,
        Covered int NOT NULL,
        NetworkAddressNum int NOT NULL
        )  ON [PRIMARY]

    ALTER TABLE dbo.Tmp_Networks ADD CONSTRAINT
        DF_Networks_Covered DEFAULT (1) FOR Covered

    SET IDENTITY_INSERT dbo.Tmp_Networks ON

    IF EXISTS(SELECT * FROM dbo.Networks)
         EXEC('INSERT INTO dbo.Tmp_Networks (NetworkID, NetworkName, SubnetMask, NetworkAddress, Covered, NetworkAddressNum)
            SELECT NetworkID, NetworkName, SubnetMask, NetworkAddress, Covered, NetworkAddressNum FROM dbo.Networks TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Networks OFF

    ALTER TABLE dbo.Sensors
        DROP CONSTRAINT FK_Sensors_Networks

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Networks

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Networks

    ALTER TABLE dbo.Hosts
        DROP CONSTRAINT FK_Hosts_Networks

    DROP TABLE dbo.Networks

    EXECUTE sp_rename N'dbo.Tmp_Networks', N'Networks', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Networks ON dbo.Networks
        (
        NetworkAddress,
        SubnetMask
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Networks_NetworkAddressNum ON dbo.Networks
        (
        NetworkAddressNum
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_Networks_NetworkName ON dbo.Networks
        (
        NetworkName
        ) ON [PRIMARY]

    ALTER TABLE dbo.Networks ADD CONSTRAINT
        PK_Networks PRIMARY KEY NONCLUSTERED
        (
        NetworkID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Hosts WITH NOCHECK ADD CONSTRAINT
        FK_Hosts_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Networks FOREIGN KEY
        (
        SourceNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Networks FOREIGN KEY
        (
        TargetNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.Sensors WITH NOCHECK ADD CONSTRAINT
        FK_Sensors_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ------------------------------------------------------------------------
    -- changes to the Sensors table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Sensors
        DROP CONSTRAINT FK_Sensors_Networks


    CREATE TABLE dbo.Tmp_Sensors
        (
        SensorID int NOT NULL IDENTITY (1, 1),
        NetworkID int NOT NULL,
        MAC nchar(12) NOT NULL,
        SensorName nvarchar(255) NOT NULL,
        IPAddress varchar(50) NOT NULL,
        OSPlatform nvarchar(25) NOT NULL,
        OSFamily nvarchar(25) NOT NULL,
        OSVersion nvarchar(25) NOT NULL,
        LastCommunicationTime datetime NOT NULL,
        [Domain] nvarchar(16) NOT NULL,
        SID nvarchar(48) NOT NULL,
        AgentGUID nchar(36) NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Sensors ON

    IF EXISTS(SELECT * FROM dbo.Sensors)
         EXEC('INSERT INTO dbo.Tmp_Sensors (SensorID, NetworkID, MAC, SensorName, IPAddress, OSPlatform, OSFamily, OSVersion, LastCommunicationTime, [Domain], SID, AgentGUID)
            SELECT SensorID, NetworkID, MAC, SensorName, IPAddress, OSPlatform, OSFamily, OSVersion, LastCommunicationTime, [Domain], SID, AgentGUID FROM dbo.Sensors TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Sensors OFF

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Sensors

    ALTER TABLE dbo.EventLog
        DROP CONSTRAINT FK_EventLog_Sensors

    DROP TABLE dbo.Sensors

    EXECUTE sp_rename N'dbo.Tmp_Sensors', N'Sensors', 'OBJECT'

    CREATE UNIQUE CLUSTERED INDEX IX_Sensors ON dbo.Sensors
        (
        MAC
        ) ON [PRIMARY]

    ALTER TABLE dbo.Sensors ADD CONSTRAINT
        PK_Sensors PRIMARY KEY NONCLUSTERED
        (
        SensorID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Sensors WITH NOCHECK ADD CONSTRAINT
        FK_Sensors_Networks FOREIGN KEY
        (
        NetworkID
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )


    ALTER TABLE dbo.EventLog WITH NOCHECK ADD CONSTRAINT
        FK_EventLog_Sensors FOREIGN KEY
        (
        SourceSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Sensors FOREIGN KEY
        (
        TargetSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )


    ------------------------------------------------------------------------
    -- changes to the Actions table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.Actions
        DROP CONSTRAINT FK_Actions_Responses


    CREATE TABLE dbo.Tmp_Actions
        (
        ActionID int NOT NULL IDENTITY (1, 1),
        ResponseID int NOT NULL,
        Type nvarchar(50) NOT NULL
        )  ON [PRIMARY]

    SET IDENTITY_INSERT dbo.Tmp_Actions ON

    IF EXISTS(SELECT * FROM dbo.Actions)
         EXEC('INSERT INTO dbo.Tmp_Actions (ActionID, ResponseID, Type)
            SELECT ActionID, ResponseID, Type FROM dbo.Actions TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_Actions OFF

    ALTER TABLE dbo.ActionSettings
        DROP CONSTRAINT FK_ActionSettings

    DROP TABLE dbo.Actions

    EXECUTE sp_rename N'dbo.Tmp_Actions', N'Actions', 'OBJECT'

    ALTER TABLE dbo.Actions ADD CONSTRAINT
        PK_Actions PRIMARY KEY CLUSTERED
        (
        ActionID
        ) ON [PRIMARY]


    ALTER TABLE dbo.Actions WITH NOCHECK ADD CONSTRAINT
        FK_Actions_Responses FOREIGN KEY
        (
        ResponseID
        ) REFERENCES dbo.Responses
        (
        ResponseID
        )


    ALTER TABLE dbo.ActionSettings WITH NOCHECK ADD CONSTRAINT
        FK_ActionSettings FOREIGN KEY
        (
        ActionID
        ) REFERENCES dbo.Actions
        (
        ActionID
        )


    ------------------------------------------------------------------------
    -- changes to the ActionStatus table as a result of Bugzilla 236173
    ------------------------------------------------------------------------
    SET QUOTED_IDENTIFIER ON
    SET ARITHABORT ON
    SET NUMERIC_ROUNDABORT OFF
    SET CONCAT_NULL_YIELDS_NULL ON
    SET ANSI_NULLS ON
    SET ANSI_PADDING ON
    SET ANSI_WARNINGS ON

    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Sensors


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Networks


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT FK_ActionStatus_Hosts


    ALTER TABLE dbo.ActionStatus
        DROP CONSTRAINT DF_ActionStatus_Status

    CREATE TABLE dbo.Tmp_ActionStatus
        (
        ActionStatusID int NOT NULL IDENTITY (1, 1),
        EventLogId int NOT NULL,
        TargetHostId int NULL,
        TargetNetworkId int NULL,
        TargetSensorId int NULL,
        Type nvarchar(128) NOT NULL,
        Status int NULL,
        StartTime datetime NULL,
        EndTime datetime NULL,
        Endkey nvarchar(128) NULL,
        Archive bit NULL,
        ActionOutput image NULL,
        ActionDetail nvarchar(512) NULL
        )  ON [PRIMARY]
         TEXTIMAGE_ON [PRIMARY]

    ALTER TABLE dbo.Tmp_ActionStatus ADD CONSTRAINT
        DF_ActionStatus_Status DEFAULT ((-1)) FOR Status

    SET IDENTITY_INSERT dbo.Tmp_ActionStatus ON

    IF EXISTS(SELECT * FROM dbo.ActionStatus)
         EXEC('INSERT INTO dbo.Tmp_ActionStatus (ActionStatusID, EventLogId, TargetHostId, TargetNetworkId, TargetSensorId, Type, Status, StartTime, EndTime, Endkey, Archive, ActionOutput, ActionDetail)
            SELECT ActionStatusID, EventLogId, TargetHostId, TargetNetworkId, TargetSensorId, Type, Status, StartTime, EndTime, Endkey, Archive, ActionOutput, ActionDetail FROM dbo.ActionStatus TABLOCKX')

    SET IDENTITY_INSERT dbo.Tmp_ActionStatus OFF

    DROP TABLE dbo.ActionStatus

    EXECUTE sp_rename N'dbo.Tmp_ActionStatus', N'ActionStatus', 'OBJECT'

    CREATE CLUSTERED INDEX IX_ActionStatus ON dbo.ActionStatus
        (
        Endkey
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_Type ON dbo.ActionStatus
        (
        Type
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_Status ON dbo.ActionStatus
        (
        Status
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_StartTime ON dbo.ActionStatus
        (
        StartTime
        ) ON [PRIMARY]

    CREATE NONCLUSTERED INDEX IX_ActionStatus_EndTime ON dbo.ActionStatus
        (
        EndTime
        ) ON [PRIMARY]

    ALTER TABLE dbo.ActionStatus ADD CONSTRAINT
        PK_ActionStatus PRIMARY KEY NONCLUSTERED
        (
        ActionStatusID
        ) ON [PRIMARY]


    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Hosts FOREIGN KEY
        (
        TargetHostId
        ) REFERENCES dbo.Hosts
        (
        HostID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Networks FOREIGN KEY
        (
        TargetNetworkId
        ) REFERENCES dbo.Networks
        (
        NetworkID
        )

    ALTER TABLE dbo.ActionStatus WITH NOCHECK ADD CONSTRAINT
        FK_ActionStatus_Sensors FOREIGN KEY
        (
        TargetSensorId
        ) REFERENCES dbo.Sensors
        (
        SensorID
        )
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 236173
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 239762
------------------------------------------------------------------------
------------------------------------------------------------------------
IF NOT EXISTS( select * from [AlertFamily] where [Name] = 'VSNETAPP' )
BEGIN
    declare @vsnetapp int;

    insert into AlertFamily ([Name]) values('VSNETAPP');
    select @vsnetapp = @@IDENTITY;

    insert into [AlertAliasMapping] values(@vsnetapp, 'Aliases.Default.ini.properties', 'com.nai.Mead.RuleEngine.Messages.IniFixture', 'VirusScanNetApp','')

    declare @access_protection_violation_blocked int;
    declare @access_protection_violation_not_blocked int;
    declare @heuristic_detection_not_removed int;
    declare @heuristic_detection_removed int;
    declare @normal_operation int;
    declare @on_access_disabled int;
    declare @scan_canceled int;
    declare @software_failure_or_error int;
    declare @unknown_category int;
    declare @unwanted_program_not_removed int;
    declare @unwanted_program_removed int;
    declare @update_failed int;
    declare @update_succeeded int;
    declare @virus_detected_not_removed int;
    declare @virus_detected_removed int;

    select @access_protection_violation_blocked     = EventCategoryId from [EventCategory] where [Name]='ACCESS_PROTECTION_VIOLATION_BLOCKED' and [AssociateThreat]=0;
    select @access_protection_violation_not_blocked = EventCategoryId from [EventCategory] where [Name]='ACCESS_PROTECTION_VIOLATION_NOT_BLOCKED' and [AssociateThreat]=0;
    select @heuristic_detection_not_removed         = EventCategoryId from [EventCategory] where [Name]='HEURISTIC_DETECTION_NOT_REMOVED' and [AssociateThreat]=1;
    select @heuristic_detection_removed             = EventCategoryId from [EventCategory] where [Name]='HEURISTIC_DETECTION_REMOVED' and [AssociateThreat]=1;
    select @normal_operation                        = EventCategoryId from [EventCategory] where [Name]='NORMAL_OPERATION' and [AssociateThreat]=0;
    select @normal_operation                        = EventCategoryId from [EventCategory] where [Name]='NORMAL_OPERATION' and [AssociateThreat]=1;
    select @on_access_disabled                      = EventCategoryId from [EventCategory] where [Name]='ON_ACCESS_DISABLED' and [AssociateThreat]=0;
    select @scan_canceled                           = EventCategoryId from [EventCategory] where [Name]='SCAN_CANCELED' and [AssociateThreat]=0;
    select @software_failure_or_error               = EventCategoryId from [EventCategory] where [Name]='SOFTWARE_FAILURE_OR_ERROR' and [AssociateThreat]=0;
    select @unknown_category                        = EventCategoryId from [EventCategory] where [Name]='UNKNOWN_CATEGORY' and [AssociateThreat]=0;
    select @unwanted_program_not_removed            = EventCategoryId from [EventCategory] where [Name]='UNWANTED_PROGRAM_NOT_REMOVED' and [AssociateThreat]=1;
    select @unwanted_program_removed                = EventCategoryId from [EventCategory] where [Name]='UNWANTED_PROGRAM_REMOVED' and [AssociateThreat]=1;
    select @update_failed                           = EventCategoryId from [EventCategory] where [Name]='UPDATE_FAILED' and [AssociateThreat]=0;
    select @update_succeeded                        = EventCategoryId from [EventCategory] where [Name]='UPDATE_SUCCEEDED' and [AssociateThreat]=0;
    select @virus_detected_not_removed              = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_NOT_REMOVED' and [AssociateThreat]=0;
    select @virus_detected_not_removed              = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_NOT_REMOVED' and [AssociateThreat]=1;
    select @virus_detected_removed                  = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_REMOVED' and [AssociateThreat]=0;
    select @virus_detected_removed                  = EventCategoryId from [EventCategory] where [Name]='VIRUS_DETECTED_REMOVED' and [AssociateThreat]=1;

    insert into AFToCatMapping values(@vsnetapp, @access_protection_violation_blocked);
    insert into AFToCatMapping values(@vsnetapp, @access_protection_violation_not_blocked);
    insert into AFToCatMapping values(@vsnetapp, @heuristic_detection_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @heuristic_detection_removed);
    insert into AFToCatMapping values(@vsnetapp, @normal_operation);
    insert into AFToCatMapping values(@vsnetapp, @on_access_disabled);
    insert into AFToCatMapping values(@vsnetapp, @scan_canceled);
    insert into AFToCatMapping values(@vsnetapp, @software_failure_or_error);
    insert into AFToCatMapping values(@vsnetapp, @unknown_category);
    insert into AFToCatMapping values(@vsnetapp, @unwanted_program_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @unwanted_program_removed);
    insert into AFToCatMapping values(@vsnetapp, @update_failed);
    insert into AFToCatMapping values(@vsnetapp, @update_succeeded);
    insert into AFToCatMapping values(@vsnetapp, @virus_detected_not_removed);
    insert into AFToCatMapping values(@vsnetapp, @virus_detected_removed);
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 239762
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 250439
------------------------------------------------------------------------
------------------------------------------------------------------------
IF NOT EXISTS( select * from [AlertAliasMapping] where [FirstMarker] = 'VirusScan PDA' )
BEGIN
    declare @vspda int;
    select @vspda = [AlertFamilyId] from [AlertFamily] where [Name] = 'VSPDA'

    insert into [AlertAliasMapping] values(@vspda,
        'Aliases.Default.ini.properties', 'com.nai.Mead.RuleEngine.Messages.IniFixture', 'VirusScan PDA','')
END
GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 250439
------------------------------------------------------------------------
------------------------------------------------------------------------


------------------------------------------------------------------------
------------------------------------------------------------------------
-- BEGIN: fix for BZ 248853: 32-bit subnets should not be considered valid
------------------------------------------------------------------------
--   Validate an Address (i.e. IP Address).  Returns 1=valid, 0=invalid.
------------------------------------------------------------------------
------------------------------------------------------------------------

if exists (select * from sysobjects where id = object_id(N'[dbo].[sp_IsValidAddress]'))
drop procedure [dbo].[sp_IsValidAddress]

GO

CREATE PROCEDURE dbo.sp_IsValidAddress
(
 @Address NVARCHAR(255),
 @out INT OUTPUT
)
AS
BEGIN

IF (@Address IS NULL)
BEGIN
	SET @out=0
	RETURN
END

IF (LEN(@Address)<7)
BEGIN
	SET @out=0
	RETURN
END


IF (@Address='0.0.0.0')
BEGIN
	SET @out=0
	RETURN
END

-- BZ 248853: 32-bit subnets should not be considered valid
IF (@Address='255.255.255.255')
BEGIN
	SET @out=0
	RETURN
END

-- validate addr
DECLARE @iter INT
DECLARE @i INT
DECLARE @j INT

SET @iter=0
SET @i=1
WHILE (@iter<3)
BEGIN
	SET @j=CHARINDEX('.',@Address,@i)
	if (@j=0)
	BEGIN
		SET @out=0
		RETURN
	END

	SET @i=@j+1
	SET @iter = @iter+1
END -- end while

SET @out=1
RETURN

END -- end fn

GO

------------------------------------------------------------------------
------------------------------------------------------------------------
-- END: fix for BZ 248853
------------------------------------------------------------------------
------------------------------------------------------------------------

--------------------------------------------------------------
-- ePO 3.6 patch 2 BZ256598/BZ266002:
-- Duplicated MAC address causing agent overwrite each other
--------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VirtualMacVendor]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[VirtualMacVendor]
GO

CREATE TABLE [dbo].[VirtualMacVendor] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[VendorID] [nvarchar] (8) NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[VirtualMacVendor] WITH NOCHECK ADD 
	CONSTRAINT [PK_VirtualMacVendor] PRIMARY KEY  CLUSTERED 
	(
		[AutoID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[VirtualMacVendor] ADD 
	CONSTRAINT [IX_VirtualMacVendor] UNIQUE  NONCLUSTERED 
	(
		[VendorID]
	)  ON [PRIMARY] 
GO

ALTER PROCEDURE dbo.EPOSP_FindByMAC
( @szMac NVARCHAR (100))
AS
BEGIN

	DECLARE @nResult INT
	DECLARE @szMacVendor nvarchar(6)
	
	IF @szMac IS NULL
	BEGIN
		SELECT nResult=0
		RETURN
	END
	
	IF @szMac = ''
	BEGIN
		SELECT nResult=0
		RETURN
	END
	
	IF @szMac = 'N/A'
	BEGIN
		SELECT nResult=0
		RETURN
	END

	SELECT @szMacVendor=LEFT(@szMac, 6)

	-- ignore dial-up/VPN virtual adapter MAC
	IF @szMacVendor in (SELECT VendorID FROM VirtualMacVendor)
	BEGIN
		SELECT nResult=0
		RETURN
	END

	SELECT top 1 @nResult = c.parentid 
		FROM computerproperties as c
		WHERE (c.NetAddress=@szMac)
	IF (@nResult IS NULL)
	BEGIN
		SET @nResult = 0
	END
	
	SELECT @nResult AS nResult

END
GO

IF NOT EXISTS (SELECT * FROM VirtualMacVendor WHERE VendorID='444553')
	INSERT INTO VirtualMacVendor (VendorID) VALUES ('444553')

IF NOT EXISTS (SELECT * FROM VirtualMacVendor WHERE VendorID='005345')
	INSERT INTO VirtualMacVendor (VendorID) VALUES ('005345')

GO

--------------------------------------------------------------
-- Bug fix 254404 (ePO 3.6 p2)
--------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_Delete_PolicySettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SP_Delete_PolicySettings]
GO

--------------------------------------------------------------
-- end of bug fix 254404
--------------------------------------------------------------







--------------------------------------------------------------
-- Bug fix 254297 (ePO 3.6 p2)
--------------------------------------------------------------

-- Infection custom group report
-- vs7.5 Add support for spyware types and bufefr overflow events


ALTER  PROCEDURE dbo.AVISP_FilterVAlertGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)=''	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

  /* get list of filtered node id's */
  DECLARE @FilterOverride int;
  SET @FilterOverride = CONVERT(int, @iNameSpaceNode);

  -- used for determining whether to perform subselect search
  DECLARE @bUseFilter bit;
  SET @bUseFilter = 0;

  -- drop prior content table 
  IF OBJECT_ID(N'tempdb..#MultiSiteUserNodes') IS NOT NULL
	DROP TABLE #MultiSiteUserNodes;

  -- create new content table
  CREATE TABLE #MultiSiteUserNodes(NodeID int);
  INSERT INTO #MultiSiteUserNodes (NodeID)
	EXEC AVIDALSP_GetNodeIDFilterMultiSite @szEpoUserName, @FilterOverride, @bUseFilter OUTPUT

  -- bring content into in-memory table only.
  DECLARE @tblNodes TABLE(NodeID int);
  INSERT INTO @tblNodes(NodeID) SELECT NodeID FROM #MultiSiteUserNodes;
  DROP TABLE #MultiSiteUserNodes;
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @ret int
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0409'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


--------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpTop10s' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10s

	IF EXISTS (select * from sysobjects where name = 'tmpTop10Virus' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10Virus


	--------------------------------------------------
	-- Fetch Infect After date variables or date datafilter using > operator
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDAnsi char(30)	
	Declare @YYYYMMDDdate datetime
	Declare @DFYYYYMMDDdate datetime
	Declare @dfweek char(20) -- yyyy-ww format, returned to make use of index
	Declare @dfmonth char(20)	-- yyyy-ww format, returned to make use of index
	Declare @today datetime
	set @today = getdate()

	execute dbo.AVISP_GetDateConversion1 
		@InfectAfterYYYYMMDD, 	
		@InfectAfterRule, 
		@DataFilter,
		@YYYYMMDDdate output,	-- input parm date
		@DFYYYYMMDDdate output,	-- date filter date (using > operator)
		@dfweek output,
		@dfmonth output	

	-- use date filter date if it was returned
	if @DFYYYYMMDDdate > ''
		set @YYYYMMDDdate = @DFYYYYMMDDdate

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')
	set @YYYYMMDDAnsi = convert(char(30), @YYYYMMDDdate, 102)

	if @InfectAfterRule = 'all' 
		and ( @InfectAfterYYYYMMDD = '' or @InfectAfterYYYYMMDD is null ) 
		and @DFYYYYMMDDdate = ''
	begin
		set @YYYYMMDDdate = null
		set @YYYYMMDD = ''
		set @YYYYMMDDAnsi = ''
		set @dfweek = ''
		set @dfmonth= ''
	end

--select @YYYYMMDDdate
	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- Check if VirusType table needs translating and redo it if language differs
	EXECUTE AVISP_TranslateVirusType @szFullLang


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)		
   	Declare @Uncategorized varchar(50)		
	Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)
	Declare @Blocked varchar(50)
	Declare @BufrOvflDetected varchar(200)
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	

   	Declare @Resolved varchar(50)			
   	Declare @Unresolved varchar(50)	
   	Declare @Virus varchar(50)	



	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
		Set @Blocked = 'Blocked'
		if @EventType = 'BufrOvfl'
			Select 	@BufrOvflDetected = Name from EventFilterDesc 
				Where Language = '0409' and EventID='1093'	
		-- epo3.5 new string translation
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'	
		Set @Professional = 'Professional'
   		Set @Resolved = 'Resolved'	Set @Unresolved = 'Unresolved'	
   		Set @Virus = 'Virus'		Set @Uncategorized = 'Uncategorized'

	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Resolved = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Resolved'
		Select 	@UnResolved = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unresolved'
		Select 	@Uncategorized = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'VirusType' and TextID = 'Uncategorized'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
		-- vs7.5
		Select 	@Blocked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Blocked'
		if @EventType = 'BufrOvfl'
			Select 	@BufrOvflDetected = Name from EventFilterDesc 
				Where Language = @szFullLang and EventID='1093'
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
		Select 	@Virus = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Virustype' and TextID = 'Virus'

	End
	

	
--------------------------------------------------------------------------------------------------
-- Read Data Filter and Group Selections to see which query option to pick for fastest performance
--	must group on fields that are part of the Group selections or Data filter 

	-- merge group fields into one to simplify processing
	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	-- Check for key fields that affect which query to run
	-- base fields: virusname, productname, productversion
	Declare @Virusname int
	Set @Virusname = CHARINDEX( 'Virusname', @GroupFields)	
	if @Virusname = 0 	Set @Virusname = CHARINDEX( 'Virusname', @DataFilter)	

	Declare @Prodname int
	Set @Prodname = CHARINDEX( 'ProductName', @GroupFields)	
	Set @Prodname = CHARINDEX( 'ProductNameVersion', @GroupFields)	
	Set @Prodname = CHARINDEX( 'FullProductName', @GroupFields)	
	if @Prodname = 0 	Set @Prodname = CHARINDEX( 'ProductName', @DataFilter)	

	Declare @ProdVer int
	Set @ProdVer = CHARINDEX( 'ProductVersion', @GroupFields)	
	Set @ProdVer = CHARINDEX( 'ProductNameVersion', @GroupFields)	
	Set @ProdVer = CHARINDEX( 'FullProductName', @GroupFields)	
	if @ProdVer = 0 	Set @ProdVer = CHARINDEX( 'ProductVersion', @DataFilter)	

	Declare @Nodename int
	Set @Nodename = CHARINDEX( 'NodeName', @GroupFields)	
	if @Nodename = 0 	Set @Nodename = CHARINDEX( 'NodeName', @DataFilter)	

	Declare @Domainname int
	Set @Domainname = CHARINDEX( 'Domainname', @GroupFields)	
	if @Domainname = 0 	Set @Domainname = CHARINDEX( 'Domainname', @DataFilter)	

	Declare @OSType int
	Set @OSType = CHARINDEX( 'OSType', @GroupFields)	
	if @OSType = 0 	Set @OSType = CHARINDEX( 'OSType', @DataFilter)	

	Declare @OSPlatform int
	Set @OSPlatform = CHARINDEX( 'OSPlatform', @GroupFields)	
	if @OSPlatform = 0 	Set @OSPlatform = CHARINDEX( 'OSPlatform', @DataFilter)	

	Declare @Virustype int
	Set @Virustype = CHARINDEX( 'Virustype', @GroupFields)	
	if @Virustype = 0 	Set @Virustype = CHARINDEX( 'Virustype', @DataFilter)	

	Declare @VirusSubtype int
	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @GroupFields)	
	if @VirusSubtype = 0 	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @DataFilter)	
        if @VirusSubtype > 0    Set @Virustype=1

	Declare @ActionTaken int
	Set @ActionTaken = CHARINDEX( 'Action', @GroupFields)	
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'ActionTaken', @DataFilter)	
	-- special case code: infection history reports do a chart on action, so make sure a query returning action
	--	is performed
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSVIRUSDETAIL', @szOptionalReportParms)
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSINFECTHIST', @szOptionalReportParms)


	Declare @TVDEventID int
	Set @TVDEventID = CHARINDEX( 'TVDEventID', @GroupFields)	
	if @TVDEventID = 0 	Set @TVDEventID = CHARINDEX( 'TVDEventID', @DataFilter)	

	Declare @TVDSeverity int
	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @GroupFields)	
	if @TVDSeverity = 0 	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @DataFilter)	

	Declare @EventDesc int
	Declare @Source int	-- vs7.5
	Set @EventDesc = 0
	Set @Source = 0

	if @EventType = 'All' or @EventType = 'NotInfection'
	Begin
		Set @EventDesc = CHARINDEX( 'EventDesc', @GroupFields)	
		if @EventDesc = 0 	Set @EventDesc = CHARINDEX( 'EventDesc', @DataFilter)	
	End
	Else
	Begin
		Set @Source = CHARINDEX( 'EventDesc', @GroupFields)	
		if @Source = 0 	Set @Source = CHARINDEX( 'EventDesc', @DataFilter)	
	End

--	Set @Source = CHARINDEX( 'Source', @GroupFields)	
--	if @Source = 0 	Set @Source = CHARINDEX( 'Source', @Source)	

	Declare @Year int
	Set @Year = CHARINDEX( 'Year', @GroupFields)	
	if @Year = 0 	Set @Year = CHARINDEX( 'Year', @DataFilter)	

	Declare @Quarter int
	Set @Quarter = CHARINDEX( 'Quarter', @GroupFields)	
	if @Quarter = 0 	Set @Quarter = CHARINDEX( 'Quarter', @DataFilter)	

	Declare @Week int
	Set @Week = CHARINDEX( 'Week', @GroupFields)	
	if @Week = 0 	Set @Week = CHARINDEX( 'Week', @DataFilter)	

	Declare @Month int
	Set @Month = CHARINDEX( 'Month', @GroupFields)	
	if @Month = 0 	Set @Month = CHARINDEX( 'Month', @DataFilter)	

	Declare @DATVer int
	Set @DATVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @DATVer = 0 	Set @DATVer = CHARINDEX( 'DATVersion', @DataFilter)	

	Declare @ENGVer int
	Set @ENGVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @ENGVer = 0 	Set @ENGVer = CHARINDEX( 'EngineVersion', @DataFilter)	

	Declare @TaskName int
	Set @TaskName = CHARINDEX( 'TVDTaskName', @GroupFields)	
	if @TaskName = 0 	Set @TaskName = CHARINDEX( 'TVDTaskName', @DataFilter)	

	-- sum these fields into categories

	Declare @Time int
	Set @Time = @Year + @Month + @Quarter + @Week
	if @YYYYMMDDdate is not null and @YYYYMMDDdate != '' 
		Set @Time = 1

	Declare @EventInfo int
	Set @EventInfo = @EventDesc + @TVDEventID + @TVDSeverity + @TaskName + @DATVer + @ENGVer
	if @EventType = 'all' or @EventType = 'notinfection'
		Set @EventInfo = 1

	Declare @VirustypeAction int
	Set @VirustypeAction = @Virustype + @ActionTaken + @VirusSubtype + @Source

	Declare @LeafInfo int
	Set @LeafInfo = @Nodename + @Domainname + @OSType + @OSPlatform 

	-- epo3.5 look for not FAST fields, it filtering on them set Drilldown=Drilldown (not Fast)
	Declare @FileName int
--	Set @FileName = CHARINDEX( 'FileName', @GroupFields)	
--	if @FileName = 0 	
	Set @FileName = CHARINDEX( 'FileName', @DataFilter)	
	if @Filename > 0 and @szDrilldown1 = 'FAST'	Set @szDrilldown1 = 'Drilldown'

	Declare @HostName int
--	Set @HostName = CHARINDEX( 'HostName', @GroupFields)	
--	if @HostName = 0 	
	Set @HostName = CHARINDEX( 'HostName', @DataFilter)	
	if @HostName > 0 and @szDrilldown1 = 'FAST'	Set @szDrilldown1 = 'Drilldown'

	Declare @HostIPAddress int
	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @GroupFields)	
	if @HostIPAddress = 0 	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @DataFilter)	
	if @HostIPAddress > 0 and @szDrilldown1 = 'FAST'	Set @szDrilldown1 = 'Drilldown'

	Declare @UserName int
--	Set @UserName = CHARINDEX( 'UserName', @GroupFields)	
--	if @UserName = 0 	
	Set @UserName = CHARINDEX( 'UserName', @DataFilter)	
	if @UserName > 0 and @szDrilldown1 = 'FAST'	Set @szDrilldown1 = 'Drilldown'

	-- epo3.5 only set this to drilldown if the GetDateConversion1 routine did not return a value
	Declare @EventDateTime int
	Set @EventDateTime = CHARINDEX( 'EventDateTime', @GroupFields)	
	if @EventDateTime = 0 	Set @EventDateTime = CHARINDEX( 'EventDateTime', @DataFilter)	
	if @EventDateTime > 0 and @szDrilldown1 = 'FAST' and @DFYYYYMMDDdate = ''
		Set @szDrilldown1 = 'Drilldown'

-- test
--select @szDrilldown1 as Drilldown, @EventType as Eventtype
--	, @DataFilter as Datafilter, @GroupFields as Groupfields
--	, @Time as 'Timegroups', @EventInfo as Eventinfo, @VirustypeAction as VTaction, @Leafinfo as Leafinfo
--	, @Top10 as Top10



--------------------------------------------------------
--------------------------------------------------------
  -- lookup top 10 items if applicable
  -- look for top 10 (T10) suffix in eventtype
  -- Only do this if no data filter has been set

	Declare @Top10 varchar(20)
	Set @Top10 = ''
	Create table dbo.tmpTop10s 
	(
		Value varchar(255)
	)
	Create table dbo.tmpTop10Virus 
	(
		VirusName varchar(255)
	)
--		,Virustype varchar(255)
--		,Virussubtype varchar(255)
--	)


	if substring(@EventType, 1, 5) = 'T10Vr'  
	begin
		Set @Top10 = 'T10Vr'
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	
		-- epo3.5 skip the top10 lookup, its faster for virus to just do one scan

	end
	else if substring(@EventType, 1, 5) = 'T10Fl'  
	begin
		Set @Top10 = 'T10Fl'
		Set @EventType = Replace( @EventType, 'T10Fl', '')

		if @DataFilter = 'none'	or @YYYYMMDDdate is null  -- Do only if no data filter or time range
		begin

		Truncate Table ReportTop10Items


		Insert ReportTop10Items (ItemName)
		Select Top 10 right(FileName, 15)
		From
			Events 
			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
			@bUseFilter = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  		)
		  	AND    	
			(
			@EventType = 'All'  or
			( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
			( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) or 
			( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) or
			( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) or	
			( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
				or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )

			) 
				
		Group by right(FileName,15)
		order by count(*) desc		


		end
	end
	else if substring(@EventType, 1, 5) = 'T10Ur'  
	begin
		Set @Top10 = 'T10Ur'
		Set @EventType = Replace( @EventType, 'T10Ur', '')

		-- epo3.5 dont do top 10 lookup, one pass is faster

	end
	else if substring(@EventType, 1, 5) = 'T10Cp'  
	begin
		Set @Top10 = 'T10Cp'
		Set @EventType = Replace( @EventType, 'T10Cp', '')

		-- epo3.5 dont do top 10 lookup, one pass is faster
	end

-- test
--select * from ReportTop10Items

--- End of Top 10 temp table filter
----------------------------------------------------


-- test display parms
/*
select
@szDrilldown1 as '@szDrilldown1'
,@EventType as '@EventType'
,@DataFilter as '@DataFilter'
,@Time as '@Time'
,@Virustype as '@Virustype'
,@ActionTaken as '@ActionTaken'
,@source as '@source'
,@Leafinfo as '@Leafinfo'
,@EventInfo as '@EventInfo'
,@Top10 as '@Top10'
,@YYYYMMDDdate as '@YYYYMMDDdate'
,@YYYYMMDD as '@YYYYMMDD'
,@szFullLang as '@szFullLang'
*/

-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-- The actual query to run is selected based off the data filter, grouping fields, layout option and
--	Event type of this report. Trying to do the minimum work possible to improve performance.


   --------------------------------------------------------------------------------------------
   -- Start of section using EventDayResolution table which increases time grouping performance
   --  stores the three primary grouping fields: virusname, productname, productversion

   -------------------------------------------------------------------------------
   -- 1.0 Fast group summary fetch (subreport fetches detailed rows)
   -- no joins:  base fields: virusname, product productversion
   
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
--	and @YYYYMMDDdate is null
   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when ProductName + ' ' + ProductVersion > '' then cast((ProductName + ' ' + ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '0' as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END

		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,'' as ActionTaken 
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID 
--			and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR 
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null or ActionTaken=0) ) 
		or ( @EventType = 'Infection' and VirusName > '' and ActionTaken >0  ) 
--		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and  ReportActionDesc.ResolutionID > 0 )
--		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and  ReportActionDesc.ResolutionID < 0 )
--		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and  ReportActionDesc.ResolutionID =1 )
--		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and  ReportActionDesc.ResolutionID =2 )
--		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and  ReportActionDesc.ResolutionID =3 )
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		ActionTaken
		,VirusName
		,ProductName
		,ProductVersion
--		,ReportActionDesc.ActionName

   end


   -------------------------------------------------------------------------------
   -- @ActionTaken >= 0
   -- 1.1 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on Base + action not timefilter
   -- Joins action tables
   else   
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken >= 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'a' as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN EventDayResolution.VirusName > '' THEN EventDayResolution.VirusName
	   		ELSE '---' 
	   		END

		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(EventDayResolution.ActionTaken AS varchar(30)) 
 	    		END
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID 
			and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null) ) 
		or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
		or ( @EventType = 'Infection-Res' and EventDayResolution.VirusName > ''  and  ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and EventDayResolution.VirusName > ''    and  ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and EventDayResolution.VirusName > ''   and  ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and EventDayResolution.VirusName > ''  and  ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and EventDayResolution.VirusName > ''  and  ReportActionDesc.ResolutionID =3 )
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		ReportActionDesc.ActionName
		,EventDayResolution.ActionTaken
		,EventDayResolution.VirusName
		,EventDayResolution.ProductName
		,EventDayResolution.ProductVersion

   end


		

   -------------------------------------------------------------------------------
   -- @Time > 0 and @ProdName=0 and @ProdVer=0 and @Virusname=0  (time only)
   -- 1.2 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time parms alone
   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time > 0 
		and @Virustype = 0 and @ActionTaken = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 and @ProdName=0 and @ProdVer=0 and @Virusname=0)
	and @Top10 = ''		-- not a top 10 query
	and (@YYYYMMDD = '' or @dfmonth > '') -- no > time filter

   begin


 	SELECT  
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST('' As varchar(64)) AS ProductName
    		,''  AS ProductVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  '' as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 't' as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		, '' as VirusName 
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
   		, '0' as ActionTaken 
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID 
--			and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
 	)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)
-- not needed since EventDayResolution is always infections
--	  	AND  
--		(
--		@EventType = 'All' 
--		or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null) ) 
--		or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and EventDayResolution.ActionTaken > 0  ) 
--		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)

	Group By
		EventDayResolution.YearMonth
		,EventDayResolution.YearWeek


   end

   -------------------------------------------------------------------------------
   -- @Time > 0
   -- 1.2 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time parms alone
   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time > 0 
		and @Virustype = 0 and @ActionTaken = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
	and (@YYYYMMDD = '' or @dfmonth > '') -- no > time filter

   begin


 	SELECT  
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion  AS ProductVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'tt' as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		, VirusName 
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
   		, '0' as ActionTaken 
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID 
--			and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null) ) 
		or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and EventDayResolution.ActionTaken > 0  ) 
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)

	Group By
		EventDayResolution.YearWeek
		,EventDayResolution.YearMonth
		,EventDayResolution.Virusname
		,EventDayResolution.productname
		,EventDayResolution.productversion

   end

   -------------------------------------------------------------------------------
   -- @Time >= 0 and @ActionTaken >= 0 and @ProdVer=0 
   -- 1.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on base + time + action
   -- Joins action tables

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 
		and @Virustype= 0 and @ActionTaken >= 0 and @ProdName=0 and @ProdVer=0 and @Virustype = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
		,'' as ProductName
		,'' as ProductVersion
--    		,CAST(ProductName As varchar(64)) AS ProductName
--    		,ProductVersion =
--  			CASE 
--	   		WHEN ProductVersion > '' THEN  ProductVersion
--	   		ELSE '---' 
--	   		END

    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3' as varchar(10)) as Language
		,'' as FullProductName
--	        ,  case
--		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
--		when ProductName > '' then cast((ProductName) as varchar(50))
--		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'att' as varchar(32)) as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN EventDayResolution.VirusName > '' THEN EventDayResolution.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(EventDayResolution.ActionTaken AS varchar(30)) 
 	    		END
		,'' as TVDEventID
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
	  	AND  
		(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null))  
			or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and EventDayResolution.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and EventDayResolution.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)

	Group By
		ReportActionDesc.ActionName
		,EventDayResolution.ActionTaken
		,EventDayResolution.VirusName
		,EventDayResolution.YearWeek
		,EventDayResolution.YearMonth
--		,EventDayResolution.ProductName
--		,EventDayResolution.ProductVersion

   end


   -------------------------------------------------------------------------------
   -- @Time >= 0 and @ActionTaken >= 0 
   -- 1.6. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on base + time + action
   -- Joins action tables

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 
		and @Virustype= 0 and @ActionTaken >= 0 and @Virustype = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
--		,'' as ProductName
--		,'' as ProductVersion
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END

    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3' as varchar(10)) as Language
--		,'' as FullProductName
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'attp' as varchar(32)) as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN EventDayResolution.VirusName > '' THEN EventDayResolution.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(EventDayResolution.ActionTaken AS varchar(30)) 
 	    		END
		,'' as TVDEventID
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	EventDayResolution
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
	  	AND  
		(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null))  
			or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and EventDayResolution.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and EventDayResolution.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)

	Group By
		ReportActionDesc.ActionName
		,EventDayResolution.ActionTaken
		,EventDayResolution.VirusName
		,EventDayResolution.ProductName
		,EventDayResolution.ProductVersion
		,EventDayResolution.YearMonth
		,EventDayResolution.YearWeek

   end



   -------------------------------------------------------------------------------
   -- @Time >= 0 and @Leafinfo > 0
   -- 1.8. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + leaf + time
   -- Joins leafnode

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken = 0 and @source = 0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END

    		,CAST('' as varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.6' as varchar(10)) as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
		, CAST('' as varchar(50)) as EngineDat

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'tl' as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN EventDayResolution.VirusName > '' THEN EventDayResolution.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype

		,'0' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
		, '' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join EventDayResolution on(LeafNode.autoID = EventDayResolution.NodeID)
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND  
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null or EventDayResolution.ActionTaken = 0))  
			or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and EventDayResolution.ActionTaken > 0  ) 
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)

	Group By
		EventDayResolution.YearWeek
		,EventDayResolution.YearMonth
		,EventDayResolution.VirusName
		,EventDayResolution.ProductName
		,EventDayResolution.ProductVersion
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		

   end

   -------------------------------------------------------------------------------
   -- @Time >= 0 and @ActionTaken >= 0 and @Leafinfo > 0
   -- 1.8. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + leaf + time
   -- Joins leafnode

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @source = 0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		substring(EventDayResolution.YearMonth,1,4) as 'Year'
		,EventDayResolution.YearMonth as 'Month' -- yyyy-mm
		,EventDayResolution.YearWeek as 'Week' -- yyyy-ww
		,case
			when substring(EventDayResolution.YearMonth,6,2) < '04'
				then substring(EventDayResolution.YearMonth,1,4) + '-1'
			when substring(EventDayResolution.YearMonth,6,2) < '07'
				then substring(EventDayResolution.YearMonth,1,4) + '-2'
			when substring(EventDayResolution.YearMonth,6,2) < '10'
				then substring(EventDayResolution.YearMonth,1,4) + '-3'
			else substring(EventDayResolution.YearMonth,1,4) + '-4'
		end as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END

    		,CAST('' as varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.6' as varchar(10)) as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
		, CAST('' as varchar(50)) as EngineDat

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'atl' as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN EventDayResolution.VirusName > '' THEN EventDayResolution.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(EventDayResolution.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
		, '' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	EventDayResolution 
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) 
	on(LeafNode.autoID = EventDayResolution.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND  
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (EventDayResolution.VirusName = '' or EventDayResolution.VirusName is null))  
			or ( @EventType = 'Infection' and EventDayResolution.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and EventDayResolution.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and EventDayResolution.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and EventDayResolution.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
		) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	and		-- current month, week, year, quarter
	( @dfmonth = ''
		or
		(
		EventDayResolution.yearweek >= @dfweek
		and
		EventDayResolution.yearmonth >= @dfmonth
		)
	)

	Group By
		ReportActionDesc.ActionName
		,EventDayResolution.ActionTaken
		,EventDayResolution.VirusName
		,EventDayResolution.ProductName
		,EventDayResolution.ProductVersion
		,EventDayResolution.YearMonth
		,EventDayResolution.YearWeek
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		

   end

   -- End of section using EventDayResolution table which increases time grouping performance
   --------------------------------------------------------------------------------------------


   -------------------------------------------------------------------------------
   -- @EventInfo > 0
   -- Must stay based on events since EventsDayResolution just stores infection data
   -- 1.9. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on eventinfo
   -- Joins : eventfilterdesc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	( 
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time = 0 and @Virustype = 0 and @ActionTaken = 0 and @Leafinfo = 0 and 
		@EventInfo > 0 and @TaskName = 0 and @DATVer = 0 and @ENGVer = 0 
		and @ProdName=0 and @ProdVer=0 and @Virusname=0)
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		'' as 'year'	-- yyyy
		,'' as 'month'	-- yyyy-mm
		,'' as 'Week'		-- yyyy-ww
		,'' as 'quarter'	-- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST('' As varchar(64)) AS ProductName
    		,'' as ProductVersion 
    		,CAST('' As varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4.5' as varchar(10)) as Language
	        ,  '' as FullProductName
	        ,  '' as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
		,'' as NodeName
		,'' as Domainname
		,'' as OSType
		,'' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'e' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
		, '' as VirusName
		,'' as VirusType
		, '' as VirusSubtype
		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
		-- epo3.5 patch1: make sure severity will be shown and its value as text (PR149968)
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--		,'' as TVDSeverity
		, '' as TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	Events
	Left Outer Join EventFilterDescFast on(Events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
 
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null or ActionTaken = 0))  
			or ( @EventType = 'Infection' and VirusName > '' and ActionTaken > 0  )  
	) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)

	Group By
		EventFilterDescFast.Name 
		, EventFilterDescFast.Severity
    		, TVDEventID				-- newest groups fields
		, Events.TVDSeverity


   end

   -------------------------------------------------------------------------------
   -- @ActionTaken >= 0 and @source > 0
   -- 1.8 Fast group summary fetch (subreport fetches detailed rows) (source)
   -- No grouping on time fields (good performance boost). Base + source
   -- No joins 
  else
   if lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken >= 0 and @source > 0
		 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
   begin


 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,'' AS ProductName
    		,'' As ProductVersion

    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' ExtraDATNames
		,'' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, '' as LastContact

		, '' as HostName
		, '' as UserName
--		,  Events.UserName
		, '' HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 's' as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang )
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null) ) or 
		( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
--		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
--			or ( @EventType = 'WSVirus' AND (TVDEventID=1503 or TVDEventID=1500 or TVDEventID=1515)  )
	) 
	and source > ''
--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 

--	and ( @YYYYMMDDdate is null or @YYYYMMDDdate = ''  or Events.EventDateTime >=  @YYYYMMDDdate)

	Group By
		Events.Source
		,Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName

   end



   -------------------------------------------------------------------------------
   -- @Time >= 0 and @ActionTaken >= 0 and @Source >= 0 and @Leafinfo > 0 
   -- 3.9. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + action + source + time + leaf
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Source >= 0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST('' As varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion

		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.9' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
		, CAST('' as varchar(50)) as EngineDat

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'astl' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
		,'' as TVDSeverity
		, '' as TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND  
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null))  
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  )  
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
	) 
--		and TVDEventid != 1506 and TVDEventid != 4600  -- exclude webshield events
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)




	Group By
		Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		, Events.Source

   end



   -------------------------------------------------------------------------------
   -- 4. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + action _ virustype + source + time + leaf
   -- Joins virustype, action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and (@Virustype > 0 or @EventType = 'Programs') and @ActionTaken >= 0 and @Leafinfo >= 0 and @EventInfo = 0 )
-- postepo3 - if fast and data filter, then use this unless grouping by eventdesc
		or ( @DataFilter <> 'none' and @EventInfo = 0 ) -- if data filter do this
	)
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST('' As varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion

		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
		, CAST('' as varchar(50)) as EngineDat

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'avstl' as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else Events.Virustype
			end as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
-- postepo3 - return eventid & severutt here so this can handle data filtering
		,'' as TVDEventID
		,'' as TVDSeverity
		, '' as TVDTaskName
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND  
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null))  
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  )  
			or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
	) 
--		and TVDEventid != 1506 and TVDEventid != 4600  -- exclude webshield events
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		, Events.Source

   end


   -------------------------------------------------------------------------------
   -- 4.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time, eventinfo
   -- Joins all: eventfilterdesc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	( 
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Leafinfo = 0 and @EventInfo > 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
		,'' as NodeName
		,'' as Domainname
		,'' as OSType
		,'' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'ate' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--		,'' as ActionTaken
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null))  
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  )  
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
	) 
--		and TVDEventid != 1506 and TVDEventid != 4600  -- exclude webshield events
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity
    		, TVDEventID				-- newest groups fields
		,EngineVersion
		,DATVersion
    		, TVDSeverity
		, TVDTaskName

   end

   -------------------------------------------------------------------------------
   -- 5. Fast group catchall (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	(
		(  @EventType = 'NotInfection' or @EventType = 'All' or @EventType = 'Programs'
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo >= 0 and @EventInfo >= 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '5f' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'Fall' as varchar(32)) as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else Events.Virustype
			end as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				-- epo3.5: if ebentid not found use event.serverity code and translate it
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 

	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
	Left Outer Join (
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
  		LeafNode.ParentID in (SELECT NodeID FROM @tblNodes)
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null))  
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  )  
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
	) 
--		and TVDEventid != 1506 and TVDEventid != 4600  -- exclude webshield events
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity
		, Source
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
    		, TVDEventID				-- newest groups fields
		,EngineVersion
		,DATVersion
    		, TVDSeverity
		, TVDTaskName

   end

   --------------------------------------------------
   -- LAYOUT=DRILLDOWNSECTION
   --------------------------------------------------

   -----------------------------------------------------------------------------------
   -- 5.9.9 slow 1 row per event fetch
   -- Buffer overflow fetch (all layout options)
   -- joins: leaf


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' 
	or lower(@szDrilldown1) = 'fast')
	and @EventType = 'BufrOvfl'
--	and 
--	(
--		( @Time = 0 and @VirusType = 0 and @EventInfo = 0 )
--	)
--	and @DataFilter <> 'Inactive'			do this regardless of other considerations
--	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  lower(Events.UserName) as UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
--		,  Events.ProcessName as FileName
		, case
			when ModuleName > '' and APIName > ''
				then ModuleName + ' | ' + APIName
			when ModuleName > ''
				then ModuleName 
 			else APIName
 			end as FileName

		, cast( 'bf' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, Events.NodeID
		-- End of Group summary difference fields

		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.ProcessName > '' THEN Events.ProcessName
	   		ELSE '---' 
	   		END
	  	, CASE 
	   		WHEN Events.DetectionName > '' THEN Events.DetectionName
	   		ELSE '---' 
	   		END as VirusType
		, Events.ProcessName as VirusSubtype	-- vs7.5

   		, @Blocked as ActionTaken
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID

		,@Warning as TVDSeverity
		, TVDTaskName

		, @BufrOvflDetected as EventDesc

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	Events 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@bUseFilter = 0 OR
  		LeafNode.ParentID in (SELECT NodeID FROM @tblNodes)
  	)
  	AND    	
	(
		( @EventType = 'BufrOvfl' and Events.DetectionName > '' AND Events.TVDEventID in (1093)  ) 

	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


   end


   -------------------------------------------------------
   -- @Time >= 0 and year=quarter=month=week=0 (date filter) and @VirusType = 0 and @EventInfo = 0
   -- 6.0.1. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)
   -- joins: action, leaf, virus type


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		( @Time >= 0 and @year=0 and @quarter=0 and @month=0 and @week=0 
			and @VirusType = 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language

-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  lower(Events.UserName) as UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRal' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, Events.NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END

		, '' as Virustype
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDSeverity
		, TVDTaskName

		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > ''  AND (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


   end



   -------------------------------------------------------
   -- @EventInfo = 0
   -- 6.0.3. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)
   -- joins: action, leaf


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		(@EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
--	and @Top10 = ''		-- epo3.5 allow top 10 queries to use this

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language

-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  lower(Events.UserName) as UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRavl' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, Events.NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else Events.VirusType
			end as VirusType

--		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDSeverity
		, TVDTaskName

		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


   end


   --------------------------------------------------
   -- all
   -- 6. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable'
   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language

-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  lower(Events.UserName) as UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRall' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, Events.NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else Events.Virustype
			end as VirusType

		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

    		,cast( TVDEventID as varchar(10)) as TVDEventID

    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case
		    when (@EventType = 'All' or @EventType = 'NotInfection') then
			case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end 
		    else
			case
			when Events.Source > '' then Events.Source
			else '---'
			end 
		    end as EventDesc
--		,TVDEventID as EventDesc
		
		-- new vs7.5 fields
--		, Source as Source
--		, '' as FileComponent
 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
			or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


   end

   ------------------------------------------------------------------------
   ------------------------------------------------------------------------
   ------------------------------------------------------------------------
   -- top10section 


   ------------------------------------------------------------------------
   -- postepo3
   -- 7.0 Fast (group summary) Fetch, top 10 virus with no data filter
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' 
	and  @DataFilter = 'none' 
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END

    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7.5tv' as varchar(10)) as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
  		, '' as NodeName 

		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'T10Vva' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join tmpTop10Virus on (Events.VirusName = tmpTop10Virus.VirusName )
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
	AND (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)

--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
-- Turn this on if create input allowing user to set date range > x
--		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)

	Group By

		ActionTaken
		,VirusName
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName




   end

   ------------------------------------------------------------------------
   -- postepo3
   -- 7.2 Fast (group summary) Fetch, top 10 virus with date filter
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' 
	and ( @DataFilter = 'none' or (@DataFilter != 'none' and @DFYYYYMMDDdate > '') )
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END

    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7.5tv' as varchar(10)) as Language
	        ,  case
		when ProductName + ' ' +ProductVersion > '' then cast((ProductName + ' ' +ProductVersion) as varchar(50))
		when ProductName > '' then cast((ProductName) as varchar(50))
		when ProductVersion > '' then cast((ProductVersion) as varchar(50))
		else '---'
		end as FullProductName

		, '' as EngineDat

		-- computer info fields
  		, '' as NodeName 

		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'T10Vva' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join tmpTop10Virus on (Events.VirusName = tmpTop10Virus.VirusName )
	Left Outer Join ReportActionDesc on (EventDayResolution.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
	AND (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
-- Turn this on if create input allowing user to set date range > x
		and ( @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)

	Group By

		ActionTaken
		,VirusName
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName

   end


   ------------------------------------------------------------------------
   -- 7.5 Fast (group summary) Fetch, top 10 virus
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and 
	(@DataFilter <> 'none' or @YYYYMMDDdate is not null)
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'T10Vvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else @Virus
			end as VirusType


		, '' as VirusSubtype

   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
		, TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)

	-- BugFix 254297: Must check for valid virusname, sometimes it is just missing
	AND (Events.VirusName > '')

	AND (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)

	Group By
		Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
--		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,EngineVersion
		,DATVersion
		, TVDTaskName



   end


   ------------------------------------------------------------------------
   -- 8. Fast (group summary) Fetch, top 10 files, with data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and (@DataFilter <> 'none' or @YYYYMMDDdate is not null)
         and 
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( 'T10Fvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else @Virus
			end as VirusType


		, '' as VirusSubtype

   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
		, TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)




	Group By
		Events.Filename
		,Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
--		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,EngineVersion
		,DATVersion
		, TVDTaskName


--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 8.5 Fast (group summary) Fetch, top 10 files, with no data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename

   else if lower(@szDrilldown1) = 'fast' and @DataFilter = 'none' and
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8.5tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
		, '' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( 'T10Fa' as varchar(32)) as  ProductCode
		, 0 as NodeID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 

	) 

	Group By

		Events.Filename
		,Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName


--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 9.0 Fast (group summary) Fetch, top 10  Users, with no data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter = 'none'
	and @ProdName = '' and @ProdVer = ''
	and (@YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '')
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr

		-- product info fields
    		,'' AS ProductName
    		,'' as ProductVersion 
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9.5tu' as varchar(10)) as Language
	        ,  '' as FullProductName

		, '' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		epo3.5 user lower function to avoid case sensitive grouping issues in crystal
		,  lower(UserName) as UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Ua' as varchar(32)) as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,'' as ActionTaken 

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )	
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
--			or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null ) --or ActionTaken =0)) 
			or ( @EventType = 'Infection' and VirusName > '' ) --and ActionTaken > 0  ) 
			or ( @EventType = 'InfectionUr' and VirusName > '' ) --and ActionTaken > 0  ) 
--			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
--			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
--			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
--			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
--			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
--			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
--			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
--			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)


	Group By
		UserName
		,VirusName
--		,Events.ActionTaken
--		,ProductName
--		,ProductVersion
--		,ReportActionDesc.ActionName


--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 9.2 Fast (group summary) Fetch, top 10  Users, with data filter on time, uses time range
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' 
	and ( @DataFilter = 'none' or (@DataFilter != 'none' and @DFYYYYMMDDdate > '') )
	and @ProdName = '' and @ProdVer = ''
--	and (@YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '')
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr

		-- product info fields
    		,'' AS ProductName
    		,'' as ProductVersion 
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9.5tu' as varchar(10)) as Language
	        ,  '' as FullProductName

		, '' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		epo3.5 user lower function to avoid case sensitive grouping issues in crystal
		,  lower(UserName) as UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Ua' as varchar(32)) as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		,'' as ActionTaken 

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )	
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
--			or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null ) --or ActionTaken =0)) 
			or ( @EventType = 'Infection' and VirusName > '' ) --and ActionTaken > 0  ) 
			or ( @EventType = 'InfectionUr' and VirusName > '' ) --and ActionTaken > 0  ) 
--			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
--			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
--			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
--			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
--			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
--			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
--			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
--			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)


	Group By
		UserName
		,VirusName
--		,Events.ActionTaken
--		,ProductName
--		,ProductVersion
--		,ReportActionDesc.ActionName


--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9.5 slower: Fast (group summary) Fetch, top 10  Users, with data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first


   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' 
	and (@DataFilter <> 'none')

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  lower(Events.UserName) as UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Uvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else @Virus
			end as VirusType

		, '' as VirusSubtype


   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
		,'' as TVDEventID

		,'' as TVDSeverity
		, TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
			or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)




	Group By
		lower(Events.UserName)
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		,Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
--		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,EngineVersion
		,DATVersion
		, TVDTaskName
--		, EventFilterDescFast.Name 


--	Order by
--		'Count' desc

   end




   ------------------------------------------------------------------------
   -- 10 Fast (group summary) Fetch, top 10 Computers, with no data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter = 'none'
	and @ProdName = '' and @ProdVer = ''
	and (@YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '')
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr

		-- product info fields
    		,'' AS ProductName
    		,'' as ProductVersion 
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'A.5tm' as varchar(10)) as Language
	        ,  '' as FullProductName
		,'' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10ca' as varchar(32)) as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		, '' as ActionTaken 

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
--			or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null ) --or ActionTaken = 0)) 
			or ( @EventType = 'InfectionCP' and VirusName > '' ) --and ActionTaken > 0  ) 
			or ( @EventType = 'Infection' and VirusName > '' ) --and ActionTaken > 0  ) 
--			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
--			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
--			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
--			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
--			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
--			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
--			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
--			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)


	Group By
		HostName
		,VirusName
--		,Events.ActionTaken
--		,ProductName
--		,ProductVersion
--		,ReportActionDesc.ActionName



--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 10.2 Fast (group summary) Fetch, top 10 Computers, with data filter on time , uses time range
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' 
	and ( @DataFilter = 'none' or (@DataFilter != 'none' and @DFYYYYMMDDdate > '') )
	and @ProdName = '' and @ProdVer = ''
--	and (@YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '')
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr

		-- product info fields
    		,'' AS ProductName
    		,'' as ProductVersion 
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'A.5tm' as varchar(10)) as Language
	        ,  '' as FullProductName
		,'' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, @today as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10ca' as varchar(32)) as  ProductCode
		, 0 as NodeID

		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
   		, '' as ActionTaken 

		,'' as TVDEventID

		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	EventDayResolution
--	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang )

  	WHERE 
  	(	-- check for directory filter
   		@bUseFilter = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in (SELECT NodeID FROM @tblNodes) )
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
--			or ( @EventType = 'NotInfection' and (VirusName = '' or VirusName is null ) --or ActionTaken = 0)) 
			or ( @EventType = 'InfectionCP' and VirusName > '' ) --and ActionTaken > 0  ) 
			or ( @EventType = 'Infection' and VirusName > '' ) --and ActionTaken > 0  ) 
--			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
--			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
--			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
--			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
--			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
--			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
--			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
--			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
--		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
		and ( @YYYYMMDDAnsi is null or @YYYYMMDDAnsi = '' or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)


	Group By
		HostName
		,VirusName
--		,Events.ActionTaken
--		,ProductName
--		,ProductVersion
--		,ReportActionDesc.ActionName



--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10.5 Slower: Fast (group summary) Fetch, top 10 Computers, with data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' 
	and 	(@DataFilter <> 'none' )
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'Atm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Cvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else @Virus
			end as VirusType

		, '' as VirusSubtype

   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

		,'' as TVDEventID

		,'' as TVDSeverity
		, TVDTaskName

		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) 
	on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
		@bUseFilter = 0 OR
		LeafNode.ParentID IN (SELECT NodeID FROM @tblNodes)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
			@EventType = 'All'  
			or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
			or ( @EventType = 'Infection' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
			or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
			or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
			or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
			or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'InfectionFl' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 
			or ( @EventType = 'InfectionUr' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)  ) 	
			or ( @EventType = 'InfectionCP' and Events.VirusName > '' and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0) ) 
	) 
		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)


	Group By
		Events.HostName
		,DateName(Year, EventDateTime) 
		,Substring(convert(char,EventDateTime,120),1,7)  -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)  -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)  -- yyyy-q
		,Events.VirusName
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,ReportActionDesc.ActionName
--		, Events.VirusType
		, VirusType.VirusTypeTranslated
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,EngineVersion
		,DATVersion
		, TVDTaskName
--		, EventFilterDescFast.Name 


--	Order by
--		'Count' desc

   end



	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		
	Drop Table dbo.tmpTop10s
	Drop Table dbo.tmpTop10Virus


RETURN @ret
END

GO

-- end avisp_filtervalertgroups
--------------------------------------------------------------
-- end Bug fix 254297 (ePO 3.6 p2)
--------------------------------------------------------------



-----------------------------------------------------------------------------------------
-- BEGIN BranchNodeEnum and ReportFullPathNodeID rework
-----------------------------------------------------------------------------------------


-- INSERT trigger for new nodes coming into BranchNodeEnum
ALTER TRIGGER TR_EPO_AddTo_BranchNode on BranchNode
FOR INSERT
AS
BEGIN
	-- don't bother with any of this if there are no source records
	DECLARE @count int;
	SELECT @count = COUNT(*) FROM inserted;
	IF (@count = 0)
		RETURN;

	-- all or none, no partial updates allowed.
	BEGIN TRANSACTION;

	-- build local cursor to walk the inserted row set
	DECLARE @AutoID int;
	DECLARE @cur CURSOR;
	SET @cur = CURSOR FOR SELECT AutoID FROM inserted;
	OPEN @cur;
	FETCH NEXT FROM @cur INTO @AutoID;
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		-- insert this into the BranchNodeEnum table.
		EXECUTE AVIDALSP_AddTo_BranchNode_Enum @AutoID;
		FETCH NEXT FROM @cur INTO @AutoID;
	END;
	CLOSE @cur;
	DEALLOCATE @cur;

	-- users marked as "any-new-site you're admin" need to be added.
	INSERT INTO EPOSiteUserPermissions 
		SELECT UserTable.AutoID, inserted.AutoID, WriteAccess 
		FROM UserTable, inserted 
		WHERE (inserted.Type = 6) AND ((UserTable.Flags & 1) <> 0);

	-- close the transaction
	COMMIT TRANSACTION;	
END
GO



-- UPDATE trigger used for keeping branchnodeenum up-to-date. 
ALTER TRIGGER TR_EPO_Move_BranchNode ON BranchNode
FOR UPDATE
AS
BEGIN
	-- don't bother with any of this if there are no source records
	DECLARE @count int;
	SELECT @count = COUNT(*) FROM inserted;
	IF (@count = 0)
		RETURN;

	-- everything here should be transactioned.
	BEGIN TRANSACTION;

	-- create cursor to enumerate updated rows
	DECLARE @cur CURSOR
	SET @cur = CURSOR FOR SELECT AutoID, ParentID, NodeName FROM inserted;
	OPEN @cur

	-- pull in first set of rows.
	DECLARE @AutoID int, @ParentID int, @NodeName nvarchar(255);
	FETCH NEXT FROM @cur INTO @AutoID, @ParentID, @NodeName;

	-- walk all rows in the new values
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- flagged if the node paths need to be rebuilt
		DECLARE @RebuildNodePaths bit;
		SET @RebuildNodePaths = 0;
	
		-- retrieve old values
		DECLARE @OldParentID int, @OldNodeName nvarchar(255);
		SELECT @OldParentID = ParentID, @OldNodeName = NodeName
		FROM deleted WHERE AutoID = @AutoID;

		-- if parents don't match, move within BranchNodeEnum and set
		--  flag for report-path rebuild.
		IF ((NOT (@OldParentID IS NULL)) AND @OldParentID <> @ParentID)
		BEGIN
			-- rebuild the branchnodeenum data for this id.
			-- note: this invokes AVIDALSP_CalculateAllNodeIDPaths internally
			EXEC AVIDALSP_MoveWithin_BranchNode_Enum @AutoID;
		END

		-- else if node names don't match, report-path rebuilding still
		--  needs to take place.
		ELSE IF (@OldNodeName <> @NodeName)
		BEGIN
			EXEC AVIDALSP_CalculateAllNodeIDPaths @AutoID, @AutoID, DEFAULT, 'NoResultSet';
		END;

		-- next record
		FETCH NEXT FROM @cur INTO @AutoID, @ParentID, @NodeName;
	END

	-- close the cursor and deallocate
	CLOSE @cur;
	DEALLOCATE @cur;

	-- commit this transaction
	COMMIT TRANSACTION;
END
GO


-- modification to insert a new node using the appropriate nodepath calculation
--  invocation afterward. also protected with transactioning.
ALTER PROCEDURE dbo.AVIDALSP_AddTo_BranchNode_Enum
(
 	@NewNodeID int
)
AS 
BEGIN
	-- new node info needed for BranchNodeEnum records
	DECLARE @NewNodeParentID int
	DECLARE @NewNodeCreated binary(8)
	SELECT @NewNodeParentID = ParentID, @NewNodeCreated = TheTimestamp
        FROM BranchNode WHERE AutoID = @NewNodeID;

	-- transaction begins here, since this is multi-step
	BEGIN TRANSACTION;

	-- potentially, a shrunken database may reuse node id's. therefore
	-- all references to this node should be squelched from the table
	DELETE FROM BranchNodeEnum
	WHERE StartAutoID = @NewNodeID OR EndAutoID = @NewNodeID;

	-- add path updates for all lineage, including the parent itself (the UNION)
	INSERT INTO BranchNodeEnum (StartAutoID, EndAutoID, PathLength, dtEndCreated)
		(SELECT Enum.StartAutoID, @NewNodeID, Enum.PathLength+1, @NewNodeCreated
		 FROM BranchNodeEnum AS Enum 
		 WHERE Enum.EndAutoID = @NewNodeParentID
		 UNION SELECT @NewNodeParentID, @NewNodeID, 1, @NewNodeCreated);

	-- legacy code did this. this condition should never happen.
	DELETE FROM BranchNodeEnum WHERE StartAutoID = 0;

	-- update report paths
	EXECUTE AVIDALSP_CalculateAllNodeIDPaths @NewNodeID, @NewNodeID, DEFAULT, 'NoResultSet';

	-- commit everything above.
	COMMIT TRANSACTION;
END
GO


-- procedure to rebuild appropriate branchnode enumeration data when one or more nodes
--  are rehomed to a different parent, or renamed, or anything else. 
ALTER PROCEDURE dbo.AVIDALSP_MoveWithin_BranchNode_Enum
(
	@MovedNodeID int	-- node for rebuild
)
AS
BEGIN
	-- squelch client callbacks
	SET NOCOUNT ON;

	-- requires a transaction. though shalt not mess with the enum table
	--   unless we can finish what we started.
	BEGIN TRANSACTION;

	-- retrieve new parent node information
	DECLARE @ParentID int;
	DECLARE @tsCreated varbinary(8);
	SELECT @ParentID = ParentID, @tsCreated = TheTimestamp
	FROM BranchNode WHERE AutoID = @MovedNodeID;

	-- build table containing old parent lines.
	DECLARE @tblOldParents TABLE(StartAutoID int, PathLength int);
	INSERT INTO @tblOldParents
		SELECT StartAutoID, PathLength
		FROM BranchNodeEnum
		WHERE EndAutoID = @MovedNodeID;

	-- build table containing new parent paths  also add the new parent
	--  of the moved node to this table; path length = 1
	DECLARE @tblNewParents TABLE(StartAutoID int, PathLength int);
	INSERT INTO @tblNewParents
		SELECT StartAutoID, PathLength = (PathLength+1)
		FROM BranchNodeEnum
		WHERE EndAutoID = @ParentID
		UNION SELECT @ParentID, 1;

	-- gather all lineage records for child records that will need to 
	--  have their parent-child records rebuilt. also add the moved node 
	--  itself to this table; path length = 0
	DECLARE @tblChildren TABLE(EndAutoID int, PathLength int, dtEndCreated varbinary(8));
	INSERT INTO @tblChildren
		SELECT EndAutoID, PathLength, dtEndCreated
		FROM BranchNodeEnum
		WHERE StartAutoID = @MovedNodeID
		UNION SELECT @MovedNodeID, 0, @tsCreated;

	-- delete old lineage records for all old parent records that do NOT
	--  include our moved nodes themselves where they are parents.
	DELETE FROM BranchNodeEnum
	WHERE EndAutoID IN (SELECT EndAutoID FROM @tblChildren)
	AND StartAutoID NOT IN (SELECT EndAutoID FROM @tblChildren);

	-- insert new records based on cross-product of the new parents and the 
	--  new descendents. note: the descendent records for their own relationships
	--  to themselves and their moved parent are NOT updated, as they do not change 
	--  when their parent is moved. only records relating them to parents above the
	--  moved parent are rewritten
	INSERT INTO BranchNodeEnum (StartAutoID, EndAutoID, PathLength, dtEndCreated) 
	        SELECT A.StartAutoID, B.EndAutoID, A.PathLength + B.PathLength, B.dtEndCreated
		FROM @tblNewParents AS A, @tblChildren AS B
		WHERE A.StartAutoID <> B.EndAutoID;

	-- have no idea how this could happen, but it was in the legacy code. so...
	DELETE FROM BranchNodeEnum WHERE StartAutoID = 0;

	-- rebuild nodepath entries as needed
	EXEC AVIDALSP_CalculateAllNodeIDPaths @MovedNodeID, @MovedNodeID, DEFAULT, 'NoResultSet'	

	-- commit the monster above, which will be an updated BranchNodeEnum table.
	COMMIT TRANSACTION;
END
GO


-- invoked from the SP_Delete_BranchNode proc, which is invoked from dal.dll.
--  this procedure  removes entries from the BranchNodeEnum table as well
--  as  entries from ReportFullPathNode and ReportFullPathNodeID. 
--
--  Note: this needs to be rolled into the delete-trigger of the BranchNode table.
--
ALTER  PROCEDURE dbo.AVIDALSP_DeleteFrom_BranchNode_Enum
(
	@DeletedNodeID int
)
AS 
BEGIN
	-- squelch client-callbacks
	SET NOCOUNT ON;

	-- transactioned to ensure pristine completeness
	BEGIN TRANSACTION;

	-- needs to be done BEFORE we actually remove entries from
	--  the BranchNodeEnum table, since this procedure relies on
	--  its content and will not work unless the node info is there.
	EXECUTE AVIDALSP_CalculateANodeIDPathRemove @DeletedNodeID, 'NoResultSet'

	-- delete all nodes that start or end with the specified node
	DELETE FROM BranchNodeEnum 
	WHERE (StartAutoID IN
		(SELECT EndAutoID FROM BranchNodeEnum
		 WHERE StartAutoID = @DeletedNodeID
		 UNION SELECT @DeletedNodeID ))
	OR (EndAutoID IN
		(SELECT EndAutoID FROM BranchNodeEnum
		 WHERE StartAutoID = @DeletedNodeID
		 UNION SELECT @DeletedNodeID ));

	-- again, no idea how this is being invoked. legacy code.
	DELETE FROM BranchNodeEnum WHERE StartAutoID = 0

	-- finished transaction
	COMMIT TRANSACTION;
     
END
GO


-- updated to perform fast-build of single branch, or entire tree. supports 
--  concurrency with multiple clients invoking simultaneously.
ALTER  PROCEDURE AVIDALSP_CalculateAllNodeIDPaths
(
    @iNameSpaceName int = 0,			-- specifies a starting point
    @iNameSpaceNode int = 0,			-- specified further filtering
    @szEpoUserName nvarchar(100) = N'',		-- not used, but legacy code had it here.,
    @GenerateOutputTable nvarchar(50) = N''  	-- NoResultSet means just generate the table
)
AS
BEGIN
	-- squelch client callbacks for row updates
	SET NOCOUNT ON;

	-- use whichever was specified.
	DECLARE @NodeID int;
	SET @NodeID = @iNameSpaceName;
	IF NOT (@iNameSpaceNode IS NULL) AND (@iNameSpaceNode <> 0)
		SET @NodeID = @iNameSpaceNode;

	-- local variables
	DECLARE @PathLength int;
	DECLARE @NodeName nvarchar(255);

	-- need the directory node for pathing later.
	DECLARE @DirNodeID int;
	DECLARE @DirNodeName nvarchar(255);
	SELECT @DirNodeID = AutoID, @DirNodeName = NodeName
	FROM BranchNode WHERE (Type = 4);

	-- need global root id later
	DECLARE @GlobalRootID int;
	SELECT @GlobalRootID = AutoID
	FROM BranchNode WHERE (Type = 7);
	
	-- if no base node is specified, this will update all records
	IF (@NodeID IS NULL OR @NodeID = 0)
	BEGIN
		-- use directory as default
		SET @NodeID = @DirNodeID;
		SET @NodeName = @DirNodeName;
	END
	ELSE
	BEGIN
		-- a specific node was handed to us. get name only
		SELECT @NodeName = NodeName
		FROM BranchNode	WHERE AutoID = @NodeID;
	END

	-- only continue if we have a valid node identifier
	IF (@NodeID IS NULL OR @NodeID = 0)
		RETURN -1;

	-- find base node info
	DECLARE @NodeParent int, @NodeType int;
	SELECT @NodeParent = ParentID, @NodeType = [Type] FROM BranchNode
	WHERE AutoID = @NodeID;

	-- retrieve the path length between the filter node and the directory. zero if the same
	SELECT @PathLength = PathLength
	FROM BranchNodeEnum
	WHERE StartAutoID = @DirNodeID AND EndAutoID = @NodeID;
	IF (@PathLength IS NULL)
		SET @PathLength = 0;

	-- temp table containing modified ReportFullPathNodeID records
	DECLARE @tblNodes TABLE
	(
		PathLength int,				-- path length to the directory
		FullPathName nvarchar(450),		-- full path to the node
		FullPathShortName nvarchar(450),	-- path from the site to the group
		FullPathNodeID nvarchar(450),		-- node ID path for policy  compilation
		LowestNodeID int UNIQUE,		-- node identifier for this group
		Site int,				-- site identifier for this group
		ParentID int,				-- regressing parent (used during path-building)
		Type int,				-- node type (see daldef.h)
		NodeName nvarchar(255),			-- name of this group
		SiteName nvarchar(255)			-- name of the site for this group
	);

	-- =====================================================================================
	-- step #1 : insert all initial nodes including the specified root
	INSERT INTO @tblNodes (PathLength, FullPathName, FullPathShortName, FullPathNodeID,
		LowestNodeID, Site,ParentID, Type, NodeName, SiteName)
	VALUES (@PathLength, @NodeName, @NodeName, CONVERT(nvarchar(32), @NodeID), 
		@NodeID, 0, @NodeParent, @NodeType, @NodeName, '');

	INSERT INTO @tblNodes (PathLength, FullPathName, FullPathShortName, 
		FullPathNodeID, LowestNodeID, Site,ParentID, Type, NodeName, SiteName)

		SELECT BranchNodeEnum.PathLength + @PathLength, BranchNode.NodeName, BranchNode.NodeName, 
			CONVERT(nvarchar(32), BranchNode.AutoID), Branchnode.AutoID, 0, 
			BranchNode.ParentID, BranchNode.Type, BranchNode.NodeName, ''
		FROM BranchNode INNER JOIN BranchNodeEnum
		ON BranchNode.AutoID = BranchNodeEnum.EndAutoID
		WHERE BranchNodeEnum.StartAutoID = @NodeID
		ORDER BY BranchNodeEnum.PathLength ASC

	-- =====================================================================================
	-- step #2 : build paths to the directory node for all specified entries.
	--  this alogorithm is a reverse-order breadth traversing rebuild. the full
	--  paths for each node are build a level at a time. long paths are built
	--  up to the length of shorter paths, then those are built to even shorter,
	--  until eventually the last pass hits at the directory, updating everything.
	DECLARE @start int;
	SELECT @start = MAX(PathLength) FROM @tblNodes;
	WHILE (@start > 0)
	BEGIN
		-- all nodes with @start for a path length or greater need their
		--  parent path element and node id appended to the appropriate field.
		UPDATE @tblNodes
		SET FullPathShortName = BranchNode.NodeName + '\' + A.FullPathShortName, 
		    FullPathName = BranchNode.NodeName + '\' + A.FullPathName,
		    FullPathNodeID = CONVERT(nvarchar(32), BranchNode.AutoID) + '\' + FullPathNodeID,
		    ParentID = BranchNode.ParentID
		FROM BranchNode INNER JOIN @tblNodes AS A
		ON BranchNode.AutoID = A.ParentID
		WHERE A.PathLength >= @start;

		-- move one step closer down the path.
		SET @start = @start - 1;
	END

	-- squelch directory from short paths
	DECLARE @DirNodeNameLen int;
	SET @DirNodeNameLen = LEN(@DirNodeName + '\');
	UPDATE @tblNodes
	SET FullPathShortName = RIGHT(FullPathShortName, (LEN(FullPathShortName) - @DirNodeNameLen))
	WHERE LowestNodeID <> @DirNodeID;

	-- add global root to node paths
	UPDATE @tblNodes
	SET FullPathNodeID = CONVERT(nvarchar(32), @GlobalRootID) + '\' + FullPathNodeID;

	-- add parent node identifiers
	UPDATE @tblNodes SET ParentID = BranchNode.ParentID
	FROM @tblNodes AS A INNER JOIN BranchNode
	ON A.LowestNodeID = BranchNode.AutoID;

	-- =====================================================================================
	-- step #3 : add site name and site id information.
	UPDATE @tblNodes SET SiteName = BranchNode.NodeName, Site = BranchNode.AutoID
	FROM BranchNode INNER JOIN BranchNodeEnum
	ON BranchNode.AutoID = BranchNodeEnum.StartAutoID
	INNER JOIN @tblNodes AS A
	ON BranchNodeEnum.EndAutoID = A.LowestNodeID
	WHERE BranchNode.Type = 6;

	-- sets all site-nodes to have themselves as their own site.
	UPDATE @tblNodes SET SiteName = BranchNode.NodeName, Site = BranchNode.AutoID
	FROM BranchNode INNER JOIN @tblNodes AS A
	ON BranchNode.AutoID = A.LowestNodeID
	WHERE BranchNode.Type = 6;

	-- update zero-pathlengths to NULL (legacy simulation)
	UPDATE @tblNodes SET PathLength = NULL 
	WHERE PathLength = 0;


	-- from here on out we use transactions to update all this stuff.
	BEGIN TRANSACTION;

	-- =====================================================================================
	-- step #4 : remove old entries that are being replaced.

	DELETE FROM ReportFullPathNode
	WHERE LowestNodeID IN (SELECT LowestNodeID FROM @tblNodes);
	DELETE FROM ReportFullPathNodeID
	WHERE LowestNodeID IN (SELECT LowestNodeID FROM @tblNodes);


	-- =====================================================================================
	-- step #5 : insert new entries

	-- baby table first (used for directory searching)
	INSERT INTO ReportFullPathNode (PathLength, FullPathName, LowestNodeID)
		SELECT PathLength, FullPathName, LowestNodeID FROM @tblNodes;

	-- mega table next. used for reporting and legacy policy compilation
	INSERT INTO ReportFullPathNodeID(PathLength, FullPathName, FullPathShortName,
		FullPathNodeID, LowestNodeID, Site, ParentID, Type, NodeName, SiteName)
		(SELECT PathLength, FullPathName, FullPathShortName, FullPathNodeID, 
			LowestNodeID, Site, ParentID, Type, NodeName, SiteName	FROM @tblNodes);

	
	-- =====================================================================================
	-- step #6 : optional statistics generated only when asked.
	IF (@GenerateOutputTable = N'GenerateStats')
	BEGIN
		-- step #6.1 : refresh all computer counts
		DECLARE @tblComputerCounts TABLE(autoid int, nodes int);
		INSERT INTO @tblComputerCounts
			SELECT StartAutoID, COUNT(*)
			FROM BranchNodeEnum INNER JOIN LeafNode
			ON BranchNodeEnum.EndAutoID = LeafNode.ParentID
			WHERE (LeafNode.Type <> 24)
			GROUP BY StartAutoID;
		UPDATE ReportFullPathNodeID SET Computers = A.nodes
		FROM @tblComputerCounts AS A INNER JOIN ReportFullPathNodeID
		ON A.autoid = ReportFullPathNodeID.LowestNodeID;

		-- step #6.2 : refresh all subdirectory counts.
		DECLARE @tblSubdirCounts TABLE(autoid int, subdirs int);
		INSERT INTO @tblSubdirCounts
			SELECT StartAutoID, COUNT(EndAutoID) AS subdirs
			FROM BranchNodeEnum GROUP BY StartAutoID;
		UPDATE ReportFullPathNodeID SET Subdirectories = subdirs
		FROM @tblSubdirCounts AS A INNER JOIN ReportFullPathNodeID
		ON A.autoid = ReportFullPathNodeID.LowestNodeID;
	END

	-- commit this mess once all is well.
	COMMIT TRANSACTION;

	-- report results unless requested not to. note: this means calling this
	--  with the GenerateStats option will ALWAYS return a result set, which
	--  i'm not entirely convinced was the original intention.
	IF (@GenerateOutputTable <> N'NoResultSet')
	BEGIN
		SELECT * FROM ReportFullPathNodeID
		ORDER BY FullPathShortName ASC;
	END
END
GO


-- much more efficient removal algorithm that does not rely on temp
--  tables to perform node cleanup. note: this requires the content
--  of BranchNodeEnum contain the parent-child paths for the given
--  node and all of it's children. therefore it needs to be called
--  BEFORE the BranchNodeEnum table is nuked of relavent information.
ALTER PROCEDURE dbo.AVIDALSP_CalculateANodeIDPathRemove
(
    @iNameSpaceName  int,
    @GenerateOutputTable varchar(50) = ''  -- NoResultSet means just generate the table
)
AS
BEGIN
	-- squelch client calllbacks
	SET NOCOUNT ON;

	-- start the transaction for this pair of deletes.
	BEGIN TRANSACTION;

	-- delete self + children from the baby table
	DELETE FROM ReportFullPathNode
	WHERE LowestNodeID IN
		(SELECT EndAutoID FROM BranchNodeEnum
		 WHERE StartAutoID = @iNameSpaceName
		 UNION SELECT @iNameSpaceName);

	-- delete self + children from the full table
	DELETE FROM ReportFullPathNodeID
	WHERE LowestNodeID IN
		(SELECT EndAutoID FROM BranchNodeEnum
		 WHERE StartAutoID = @iNameSpaceName
		 UNION SELECT @iNameSpaceName);

	-- commit the transaction
	COMMIT TRANSACTION;

	-- return results unless told to do otherwise. this should ALWAYS
	--  return an empty result set. therefore I don't know why it's here!!!
	IF (@GenerateOutputTable <> N'NoResultSet')
	BEGIN
		SELECT * FROM ReportFullPathNodeID
		WHERE FullPathName IS NOT NULL
		AND @iNameSpaceName = LowestNodeID
		ORDER BY FullPathName ASC;
	END;
END
GO


-- more efficient deletion procedure called from dal.dll
ALTER   PROCEDURE SP_Delete_BranchNode
(
	@UserID INT,		-- user id deleting this node
	@AutoID INT		-- victim to delete (and all children, leafs)
)
AS
BEGIN
	-- squelch client callbacks
	SET NOCOUNT ON;

	-- wrap in transaction
	BEGIN TRANSACTION

	-- retrieve username from user database if the action is not a system action
	IF (@UserID <> 0)
	BEGIN
		-- retrieve all leafnodes that have this branchnode as a parent
		DECLARE @tblDeadAgents TABLE(AutoID int, NodeName nvarchar(255));
		INSERT INTO @tblDeadAgents
			SELECT AutoID, NodeName FROM LeafNode
			WHERE ParentID IN 
				(SELECT EndAutoID FROM BranchNodeEnum 
				 WHERE StartAutoID=@AutoID UNION SELECT @AutoID);
	
		-- delete all these leafnodes
		DELETE FROM LeafNode WHERE AutoID IN
			(SELECT AutoID FROM @tblDeadAgents);

		-- needed for named user association
		DECLARE @UserName nvarchar(255);
		SELECT @UserName = UserName FROM UserTable 
		WHERE AutoID = @UserID;

		-- bulk audit this operation
		INSERT INTO EPOAuditEvents (UserID, UserName, Type, Param1)
			(SELECT @UserID, @UserName, 'DeleteLeafNode', NodeName FROM @tblDeadAgents);

	END
	ELSE	
	BEGIN	-- else this is a sysop and we ignore this for auditing
		DELETE FROM LeafNode WHERE ParentID IN
			(SELECT EndAutoID FROM BranchNodeEnum 
			 WHERE StartAutoID=@AutoID UNION SELECT @AutoID);
	END

	-- retrieve user name prior to delete (won't be there when we'e done)
	DECLARE @NodeName nvarchar(128);
	SELECT @NodeName = NodeName FROM BranchNode WHERE AutoID = @AutoID;

	-- delete descendent branches as well.
	DELETE BranchNode WHERE AutoID IN 
		(SELECT EndAutoID FROM BranchNodeEnum WHERE StartAutoID=@AutoID
		 UNION SELECT @AutoID);
	
	-- nuke content from the enum table
	EXECUTE AVIDALSP_DeleteFrom_BranchNode_Enum @AutoID

	-- audit trail
	EXEC EPOAudit_AddEvent @UserID, 'DeleteBranchNode', @NodeName, default, default, default;

	-- commit the transaction
	COMMIT TRANSACTION
END;
GO

-- rebuild BranchNodeEnum to ensure content is in sync with BranchNode.
--  note: this implicitly calls AVIDALSP_CalculateAllNodeIDPaths to rebuild
--  the ReportFullPathNode and ReportFullPathNodeID tables.
EXECUTE AVIDALSP_Generate_BranchNode_Enum;
GO

-- touch all policy settings collections. will force a redownload of all policy
--  for all the agents, which will hopefully be randomized.
UPDATE EPOPolicySettings SET TheTimestamp = @@dbts;


-- this procedure is no longer needed nor used, and should be removed from EnumProcedures.sql
--  at some future time. for now, we simply drop it from the database.
if exists (select * from sysobjects 
	where id = object_id(N'[dbo].[AVIDALSP_CalculateANodeIDPath]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_CalculateANodeIDPath]
GO


-- =====================================================================================
-- Bugzilla Defect #258568.2

ALTER  PROCEDURE EPOPolicy_GetLegacySupportedPolicies
AS
BEGIN
	-- squelch client callbacks
	SET NOCOUNT ON;

	-- find only policies in the legacy policy table whose
	--  product code matches an installed named policy type
	-- and has at most only policy in 3.6 defined @ globalroot.
	SELECT * FROM Policy
	WHERE (Policy.ParentType <> 7)
	AND ProductCode IN (
		SELECT ProductCode
		FROM EPOPolicyProductToTypes
		WHERE ProductCode NOT IN
			(SELECT DISTINCT EPOPolicyProductToTypes.ProductCode
			 FROM EPOPolicyProductToTypes INNER JOIN EPOPolicyObjects
			 ON EPOPolicyProductToTypes.TypeID = EPOPolicyObjects.TypeID
			 INNER JOIN EPOPolicyAssignment
			 ON EPOPolicyObjects.PolicyObjectID = EPOPolicyAssignment.PolicyObjectID
			 WHERE (EPOPolicyAssignment.NodeType <> 7))
		)
	AND Policy.AutoID IN (SELECT ParentID FROM PolicySettings)
	ORDER BY Policy.ProductCode ASC;

	-- defualt return value
	RETURN @@ERROR;
END
GO
