<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating appliance configuration
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="proxy">ftp</xsl:param>

<xsl:template match="/">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='network']">
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
	        <xsl:call-template name="proxystate">
                    <xsl:with-param name="proxy"><xsl:value-of select="$proxy"/></xsl:with-param>
	        </xsl:call-template>
             
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>/bin/echo s.</xsl:text><xsl:value-of select="$proxy"/><xsl:text> OFF&#10;</xsl:text>
               <xsl:text>exit 0&#10;</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="proxystate">
    <xsl:param name="proxy"/>
    <xsl:text>LISTENPORTS=&#10;</xsl:text>
    <xsl:for-each select="List[@name='BindPorts']/Attr">
        <xsl:text>LISTENPORTS=</xsl:text><xsl:value-of select="@value"/><xsl:text>&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>PROXY=</xsl:text><xsl:value-of select="$proxy"/>
    wsTIMEOUT=30
    TESTFILE=/tmp/$$
    wget http://127.0.0.1:${LISTENPORTS} -T ${wsTIMEOUT} -q -O-  | tr "\r" " "> $TESTFILE 2>/dev/null

    NAME=`grep ^Name: $TESTFILE| awk ' { print $2 } '`
    if [ "${NAME}" != "${PROXY}" ]
    then
        echo s.${PROXY}.state NOTOK
        rm -f $TESTFILE
        exit 0
    fi

    STATE=`grep ^Health: $TESTFILE| awk ' { print $2 } '`
    if [ "${STATE}" = "" ]
    then
          echo s.${PROXY}.state NOTOK
    fi 
    echo s.${PROXY}.state ${STATE}
    rm -f $TESTFILE
    exit 0
</xsl:template>

</xsl:stylesheet>

