#!/usr/bin/wsrunxslt /config/wsxmlconf/system.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet starting a proxy
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0"></xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start' or $param_0='restart' or $param_0='reload'">
	    <xsl:call-template name="adaptec_raid"/>
        </xsl:when>
     </xsl:choose>
     exit 0
</xsl:template>
<xsl:template name="adaptec_raid">

    <xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='raid-settings']">
       <xsl:call-template name="setup-raid"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="setup-raid">
       <xsl:call-template name="setup-default-raid-start"/>
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
       		<xsl:call-template name="setup-raid-email"/>
            </xsl:when>
         </xsl:choose>
       <xsl:call-template name="setup-default-raid-end"/>
</xsl:template>

<xsl:template name="setup-raid-email">
    <xsl:choose>
        <xsl:when test="Attr[@name='EmailAddress']/@value=''">
       		<xsl:call-template name="setup-no-email"/>
         </xsl:when>
        <xsl:otherwise>
       		<xsl:call-template name="setup-email-address"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="setup-email-address">
<xsl:text>
cat &lt;&lt;END &gt;&gt;/config/wsxmlconf/dptelog.ini
module=DPTMAIL

[Mail Broadcaster] ;Mail Broadcaster to a list of users
Threshold=1
Broadcast ASCII Events=TRUE
Broadcast Binary Events=TRUE
Broadcast All Events=TRUE
Broadcaster=Enabled
user=</xsl:text><xsl:value-of select="Attr[@name='EmailAddress']/@value"/>
<xsl:text>

END
</xsl:text>
</xsl:template>
<xsl:template name="setup-no-email">
</xsl:template>

<xsl:template name="setup-default-raid-start">
<xsl:text>
cat &lt;&lt;END &gt;/config/wsxmlconf/dptelog.ini
[Global Group]
File Warn Size=0 ;File size warning limit (0 for unlimited)
File Size Limit=1000 ;Max size in K of a log file (0 for umlimited)
File Warn Percent=FALSE ;Is the warning size a percentage of the limit
Timeout=300 ;Engine timeout in seconds
Enable Exception Handling=DISABLED ;Enables or disables self-handling of GPFs
Heartbeat=OFF ;Turns the heartbeat on and off
Broadcaster=ON ;Turns the Broadcaster on and off
Verbose=ON;

[Event Logger]
Poll Delay=1 min  ;Time between event pollings

[Broadcaster]
Broadcast Shelf Events=YES ;Broadcast RAID tower events (yes/no)
Broadcast Mid Temp Events=YES ;Broadcast all temperature events (yes/no)
module=DPTSYSLG
END
</xsl:text>
</xsl:template>

<xsl:template name="setup-default-raid-end">
<xsl:text>
cat &lt;&lt;END &gt;&gt;/config/wsxmlconf/dptelog.ini

[System Log Broadcaster] ;System Log File Broadcaster
Threshold=1
Broadcast ASCII Events=TRUE
Broadcast Binary Events=TRUE
Broadcast All Events=TRUE
log file=/var/log/dptelog.log
Broadcaster=Enabled

END
</xsl:text>
</xsl:template>

</xsl:stylesheet>

