#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for the timezone configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
        </xsl:when>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
        <xsl:when test="$param_0='restart'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="set_config">
    <xsl:text>
if [[ -f $NETAWSS/.profile.vars ]]; then 
 . $NETAWSS/.profile.vars 
else 
 . /var/NAIENV/.profile.vars 
fi 
    </xsl:text>
    <xsl:text>new_lang=</xsl:text><xsl:value-of select="//Settings[@name='language']/Attr[@name='OperationLanguage']/@value"/>
    <xsl:text>
[[ -n $new_lang &amp;&amp; -f /opt/NETAwss/locale/html/$new_lang/strings.js ]] || new_lang=en_US
if [[ ! $XMLCONFDIR/strings.js -ef /opt/NETAwss/locale/html/$new_lang/strings.js ]]; then
    rm -rf $XMLCONFDIR/strings.js
    ln -sf /opt/NETAwss/locale/html/$new_lang/strings.js $XMLCONFDIR/strings.js
fi
rm -rf $XMLCONFDIR/nai_lang.sh
echo "NAI_LANG=$new_lang" &gt; $XMLCONFDIR/nai_lang.sh
[[ "$NAI_LANG" == "$new_lang" ]] || $WSMGMT/merge-badwords
    </xsl:text>
</xsl:template>

</xsl:stylesheet>

