#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for setting up static routes
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">stop</xsl:param>

<xsl:template match="/">
     <xsl:choose>
	 <xsl:when test="$param_0='start' or $param_0='restart' or $param_0='reload'">
	     <xsl:text>rlist=( </xsl:text>
	     <xsl:call-template name="networks"/>
	     <xsl:text> )
	     conf=$(printf '%s\n' "${rlist[@]}")
	     if [[ ! -f /etc/sysconfig/static-routes || \
		    "$conf" != "$(&lt;/etc/sysconfig/static-routes)" ]]; then
		echo "$conf" &gt;/etc/sysconfig/static-routes
		[[ -f $WS_RESTART_LIST ]] &amp;&amp; echo network &gt;&gt; $WS_RESTART_LIST
	    fi&#10;</xsl:text>
	 </xsl:when>
      </xsl:choose>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="networks">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList[@name='StaticRoutes']">
        <xsl:call-template name="static-routes"/>
    </xsl:for-each>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/Attr[@name='IPDefaultRouter']">
    </xsl:for-each>
</xsl:template>

<xsl:template name="static-routes">
    <xsl:for-each select="NetObject[@type='STATICROUTE']">
        <xsl:call-template name="static-route"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="static-route">
     <xsl:text>'any net </xsl:text>
     <xsl:value-of select="Address/@value"/>
     <xsl:text> gw </xsl:text>
     <xsl:value-of select="Gateway/@value"/>
     <xsl:text> netmask </xsl:text>
     <xsl:value-of select="NetMask/@value"/>
     <xsl:text>'&#10;</xsl:text>
</xsl:template>

<xsl:template name="default-gw">
     <xsl:choose>
         <xsl:when test="@value!=''">
             <xsl:text>'any net default</xsl:text>
             <xsl:text> gw </xsl:text>
             <xsl:value-of select="@value"/>
             <xsl:text>'&#10;</xsl:text>
         </xsl:when>
     </xsl:choose>
</xsl:template>

</xsl:stylesheet>
