#!/usr/bin/wsrunxslt /config/wsxmlconf/system.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for ldap configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
<xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='syslog']">
	<xsl:call-template name="syslog"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="syslog">
<xsl:text>
(
TARGETS=&quot;kern user mail daemon auth syslog syslog lpr news uucp cron authpriv ftp local0 local1 local2 local3 local4 local5 local6 local7 &quot;
SYSLOG_OFFBOX=
DEFAULT_FILE=
TMPFILE=/tmp/syslog.$$
cat &gt;>${TMPFILE}
TMPTARGET=${TMPFILE}.tgt
find_defaults()
{	
    DEFAULT_FILE=`grep &quot;^LocalTarget &quot;  $TMPFILE | cut -f2 -d&quot; &quot;`
    SYSLOG_OFFBOX=`grep &quot;^OffBoxTarget &quot;  $TMPFILE | cut -f2 -d&quot; &quot;`
    SYSLOG_OFFBOX_ENB=`grep &quot;^OffBoxEnabled &quot;  $TMPFILE | cut -f2 -d&quot; &quot;`
    if [ &quot;${SYSLOG_OFFBOX_ENB}&quot; != &quot;1&quot; ]
    then
    	SYSLOG_OFFBOX=
    else
        if [ &quot;${SYSLOG_OFFBOX}&quot; != &quot;&quot; ]
        then
    	     SYSLOG_OFFBOX=@${SYSLOG_OFFBOX}
        fi
 
    fi
    if [ &quot;${DEFAULT_FILE}&quot; = &quot;&quot; ]
    then
          DEFAULT_FILE=/var/log/messages
    fi
}
find_target()
{
    # find out where this target is to go to
    TGT=
    offboard=`grep &quot;^${1} &quot;  $TMPFILE | cut -f2 -d&quot; &quot;`
    if [ &quot;${offboard}&quot; = &quot;1&quot; ]
    then
        TGT=${SYSLOG_OFFBOX}
    fi
    if [ &quot;T${TGT}&quot; = &quot;T&quot; ]
    then
        TGT=`grep &quot;^${1}File &quot;  $TMPFILE | cut -f2 -d&quot; &quot;`
    fi
    if [ &quot;T${TGT}&quot; = &quot;T&quot; ]
    then
        TGT=${DEFAULT_FILE}
    fi
    echo $TGT
}
identify_targets()
{
    &gt; ${TMPFILE}.tgt

    (
	    for  tgt in  ${TARGETS}
   		 do
             find_target $tgt
         done
    )  | sort -u > ${TMPTARGET}

}
generate_config()
{
     echo &quot;#syslog.conf generated by Appliance Configuration&quot;
     while read tgt
     do
        TGT=
        for sys in ${TARGETS}
        do
            tf=`find_target ${sys}`
            if [ &quot;${tf}&quot; = &quot;${tgt}&quot; ]
            then
                if [ &quot;${TGT}&quot; = &quot;&quot; ]
                then
                    TGT=&quot;${sys}.*&quot;
                else
                    TGT=&quot;${TGT};${sys}.*&quot;
                fi
            fi
        done
     echo $TGT		$tgt
     done &lt; ${TMPTARGET}
}
generate_log_rotate()
{
    /bin/rm -f /etc/logrotate.d/syslog
    cat &lt;&lt;END &gt; /etc/logrotate.d/syslog
# Copyright (C) 2004 Networks Associates Technology Inc. All rights reserved.
# Generated by Webshield configuration
END
    while read tgt
    do
        if [ &quot;${tgt}&quot; != &quot;${SYSLOG_OFFBOX}&quot; ]
	then
		echo -n "$tgt " &gt;&gt; /etc/logrotate.d/syslog
        fi
     done &lt; ${TMPTARGET}

    cat &lt;&lt;END &gt;&gt; /etc/logrotate.d/syslog
{
    sharedscripts
    postrotate
	/bin/kill -HUP \`cat /var/run/syslogd.pid 2&gt; /dev/null\` 2&gt; /dev/null || true
    endscript
}
END
}
find_defaults

identify_targets

generate_config &gt; /etc/syslog.conf
kill -HUP $(&lt;/var/run/syslogd.pid) 2&gt; /dev/null

generate_log_rotate

/bin/rm -rf ${TMPFILE}
/bin/rm -rf ${TMPTARGET}

exit 0
) &lt;&lt;-END
</xsl:text>
    <xsl:for-each select="Attr">
	<xsl:value-of select="@name"/>
        <xsl:text> </xsl:text>
	<xsl:value-of select="@value"/>
        <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
<xsl:text>
END
</xsl:text>
</xsl:template>
</xsl:stylesheet>

