#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for the timezone configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
        </xsl:when>
        <xsl:when test="$param_0='restart'">
	    <xsl:call-template name="reload_config"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
	    <xsl:call-template name="reload_config"/>
        </xsl:when>
     </xsl:choose>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="set_config">
	<xsl:for-each select="//GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='timezone']">
	<xsl:call-template name="timezone"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="timezone">
    <xsl:text>cp /usr/share/zoneinfo/</xsl:text>
    <xsl:value-of select="Attr[@name='TimeZone']/@value"/>
    <xsl:text> /etc/localtime&#10;</xsl:text>
</xsl:template>

<xsl:template name="reload_config">
	<xsl:for-each select="//GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='timezone']">
	<xsl:call-template name="reload_timezone"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="reload_timezone">
    <xsl:text>cmp -s /usr/share/zoneinfo/</xsl:text>
    <xsl:value-of select="Attr[@name='TimeZone']/@value"/>
    <xsl:text> /etc/localtime&#10;</xsl:text>
    <xsl:text>
if [ $? != 0 ]
then
</xsl:text>
    <xsl:text>cp /usr/share/zoneinfo/</xsl:text>
    <xsl:value-of select="Attr[@name='TimeZone']/@value"/>
    <xsl:text> /etc/localtime&#10;</xsl:text>
    <xsl:text>/etc/rc.d/init.d/crond restart</xsl:text>
<xsl:text>
fi
    </xsl:text>
</xsl:template>

</xsl:stylesheet>

