<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating cron entries
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
<xsl:text># Automatically generated by Webshield Appliance
# No mail, please
MAILTO=""
</xsl:text>
<xsl:for-each select="//Settings[@name='quarantine-settings']">
    <xsl:call-template  name="cron-entry">
       <xsl:with-param name="script">/opt/NETAwss/ui/wsadmin/scripts/ws_do_maint.py</xsl:with-param>
       <xsl:with-param name="hours"><xsl:value-of select='Attr[@name="Hours"]/@value'/></xsl:with-param>
       <xsl:with-param name="minutes"><xsl:value-of select='Attr[@name="Minutes"]/@value'/></xsl:with-param>
       <xsl:with-param name="weekdays">*</xsl:with-param>
       <xsl:with-param name="days">*</xsl:with-param>
       <xsl:with-param name="user">root</xsl:with-param>
    </xsl:call-template>
</xsl:for-each>

<xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='anti-virus-updates']">
    <xsl:call-template  name="content-scanner-update">
       <xsl:with-param name="script">kick-av-update</xsl:with-param>
    </xsl:call-template>
</xsl:for-each>

<xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='anti-spam-updates']">
    <xsl:call-template  name="content-scanner-update">
       <xsl:with-param name="script">kick-spam-update</xsl:with-param>
    </xsl:call-template>
</xsl:for-each>

<xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='memory-limits']">
    <xsl:call-template  name="cron-entry">
        <xsl:with-param name="minutes"><xsl:value-of select="Attr[@name='Minutes']/@value"/></xsl:with-param>
        <xsl:with-param name="hours"><xsl:value-of select="Attr[@name='Hours']/@value"/></xsl:with-param>
        <xsl:with-param name="days"><xsl:value-of select="Attr[@name='Days']/@value"/></xsl:with-param>
       <xsl:with-param name="weekdays"><xsl:value-of select="Attr[@name='WeekDays']/@value"/></xsl:with-param>
       <xsl:with-param name="script"><xsl:text>/usr/sbin/webshield ws_mem_check</xsl:text></xsl:with-param>
       <xsl:with-param name="user">root</xsl:with-param>
    </xsl:call-template>
</xsl:for-each>

</xsl:template>

<xsl:template name="content-scanner-update">
<xsl:param name="script"/>
<xsl:if test="Attr[@name='CONMode']/@value!='never'">
	<xsl:text>&#10;</xsl:text>
	<xsl:call-template name="generic-updater">
	    <xsl:with-param name="minutes"><xsl:value-of select="Attr[@name='CONMinutes']/@value"/></xsl:with-param>
	    <xsl:with-param name="hours"><xsl:value-of select="Attr[@name='CONHours']/@value"/></xsl:with-param>
	    <xsl:with-param name="days"><xsl:value-of select="Attr[@name='CONDays']/@value"/></xsl:with-param>
	    <xsl:with-param name="weekdays"><xsl:value-of select="Attr[@name='CONWeekDays']/@value"/></xsl:with-param>
	    <xsl:with-param name="script"><xsl:text>/usr/sbin/webshield </xsl:text>
	    <xsl:value-of select="$script"/>
	    <xsl:text> -dat</xsl:text>
	    </xsl:with-param>
	</xsl:call-template>
</xsl:if>

<xsl:if test="Attr[@name='ENGMode']/@value!='never'">
	<xsl:text>&#10;</xsl:text>
	<xsl:call-template name="generic-updater">
	    <xsl:with-param name="minutes"><xsl:value-of select="Attr[@name='ENGMinutes']/@value"/></xsl:with-param>
	    <xsl:with-param name="hours"><xsl:value-of select="Attr[@name='ENGHours']/@value"/></xsl:with-param>
	    <xsl:with-param name="days"><xsl:value-of select="Attr[@name='ENGDays']/@value"/></xsl:with-param>
	    <xsl:with-param name="weekdays"><xsl:value-of select="Attr[@name='ENGWeekDays']/@value"/></xsl:with-param>
	    <xsl:with-param name="script"><xsl:text>/usr/sbin/webshield </xsl:text>
	    <xsl:value-of select="$script"/>
	    <xsl:text> -eng -dat</xsl:text>
	    </xsl:with-param>
	</xsl:call-template>
</xsl:if>

</xsl:template>

<xsl:template name="generic-updater">
    <xsl:param name="minutes"/>
    <xsl:param name="hours"/>
    <xsl:param name="days"/>
    <xsl:param name="weekdays"/>
    <xsl:param name="srcpath"/>
    <xsl:call-template name="cron-entry">
        <xsl:with-param name="minutes"><xsl:value-of select="$minutes"/></xsl:with-param>
        <xsl:with-param name="hours"><xsl:value-of select="$hours"/></xsl:with-param>
        <xsl:with-param name="days"><xsl:value-of select="$days"/></xsl:with-param>
        <xsl:with-param name="weekdays"><xsl:value-of select="$weekdays"/></xsl:with-param>
        <xsl:with-param name="user">root</xsl:with-param>
        <xsl:with-param name="script">
        <xsl:value-of select="$script"/>
        <xsl:text> </xsl:text>
        <xsl:text>-srcpath &quot;</xsl:text><xsl:value-of select="Attr[@name='SourcePath']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-src &quot;</xsl:text><xsl:value-of select="Attr[@name='Server']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-port &quot;</xsl:text><xsl:value-of select="Attr[@name='Port']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-user &quot;</xsl:text><xsl:value-of select="Attr[@name='Username']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-pass &quot;</xsl:text><xsl:value-of select="Attr[@name='Password']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-proxy &quot;</xsl:text><xsl:value-of select="Attr[@name='ProxyName']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-pport &quot;</xsl:text><xsl:value-of select="Attr[@name='ProxyPort']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-puser &quot;</xsl:text><xsl:value-of select="Attr[@name='ProxyUsername']/@value"/><xsl:text>&quot; </xsl:text>
        <xsl:text>-ppass &quot;</xsl:text><xsl:value-of select="Attr[@name='ProxyPassword']/@value"/><xsl:text>&quot; </xsl:text>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template name="cron-entry">
    <xsl:param name="minutes"/>
    <xsl:param name="hours"/>
    <xsl:param name="days"/>
    <xsl:param name="user"/>
    <xsl:param name="script"/>
    <xsl:choose>
        <xsl:when test="Attr[@name='Enabled']/@value='1'">
            <xsl:value-of select="$minutes"/><xsl:text> </xsl:text>
            <xsl:value-of select="$hours"/><xsl:text> </xsl:text>
            <xsl:value-of select="$days"/><xsl:text> </xsl:text>
            <xsl:text>* </xsl:text>
            <xsl:value-of select="$weekdays"/><xsl:text> </xsl:text>
            <xsl:value-of select="$user"/><xsl:text> </xsl:text>
            <xsl:value-of select="$script"/>
            <xsl:text>&#10;</xsl:text>
        </xsl:when>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>
