#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from time import strftime, strptime, time, gmtime
from libwsa import _TR_, Trace, NewGetStatusOutput

libwsa.do_trace = False
formatXML = False
DATE = "/bin/date -u -s '%s'"

def Run():
	global formatXML

	# format of the ISO dates
	iso_datetime = "%Y%m%dT%H%M%S"
	date_datetime = "%Y-%m-%d %H:%M:%S"
	log_timeformat = "%Y-%m-%d %H:%M:%S GMT+00"
	try:
		args, params = libwsa.Init()

		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		# date
		datetime = ctxt.xpathEval("/command/arg[@name='datetime']/@value")
		if len(datetime) != 1:
			raise _TR_("WCT_BADDATETIME", "Invalid datetime parameter")
		datetime = datetime[0].content
		try:
			datetime = strptime(datetime, iso_datetime)
		except:
			raise _TR_("WCT_FMYDATETIME", "Unable to parse the datetime argument")
		# final format and keep strings for the logs
		new_datetime = strftime(log_timeformat, datetime)
		datetime = strftime(date_datetime, datetime)
		# get the current time for the logs
		old_datetime = strftime(log_timeformat, gmtime(time()))

		####################################
		# let's go
		####################################
		Trace("Launching '%s'" % (DATE % datetime))
		status, msg = NewGetStatusOutput(DATE % datetime)
		if status != 0:
			Trace("Date change failed: %s" % msg)
			raise _TR_("WCT_DATECMD", "Unable to set the date (%s)" % msg)
		# success so log it
		libwsa.Log("UI_DATE_CHANGED", "DateChanged", [("NEW_DATE", new_datetime), ("PREVIOUS_DATE", old_datetime)])
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSChangeTime" id="1">
    <arg name="datetime" value="20030327T100000"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="user-file" value="/config/wsxmlconf/wsadmin/users.xml"/>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
