#!/usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_

# args
#    vars : xml string
#    params : xml string

####################################
# parse the arguments
####################################
try:
	args, params = libwsa.Init()

	ctxt = args.xpathNewContext()
	file = ctxt.xpathEval("/command/arg[@name='file']/@value")
	if len(file) != 1:
		raise RuntimeError, _TR_("WSS_IMFMS", 'Invalid or missing "file" argument')
	file = file[0].content

	ctxt = params.xpathNewContext()
	path = ctxt.xpathEval("/params/param[@name='file-list']/file[@name='%s']/@path" % file)
	if len(path) != 1:
		raise RuntimeError, _TR_("WSS_PMS", 'Invalid or missing "path" argument')
	path = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), path[0].content)

	####################################
	# reply
	####################################
	# load the file
	try:
		doc = libxml2.parseFile(path)
	except:
		raise RuntimeError, "Invalid file: '%s'" % file
	# construct the reply
	reply = libxml2.newDoc("1.0")
	root = reply.newChild(None, "res", None)
	root.setProp("status", "0")
	elt = root.newChild(None, "output", None)
	elt.setProp("name", "file")
	content = doc.getRootElement()
	content.unlinkNode()
	elt.addChild(content)
	# we're done!
	print root.serialize()
	sys.exit(0)

except SystemExit:
	pass
except Exception, details:
	libwsa.PrintError(details)
	sys.exit(-1)
