#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, glob, zipfile, re
from tempfile import mkstemp
from time import strftime, strptime, gmtime
from calendar import timegm
from libwsa import _TR_

libwsa.do_trace = False
formatXML = False

def Run():
	global formatXML

	# format of the ISO dates
	iso_datetime = "%Y%m%dT%H%M%S"
	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the parameters
		####################################
		ctxt = params.xpathNewContext()
	
		# xml logs directory
		path = ctxt.xpathEval("/params/param[@name='path']/@value")
		if len(path) == 0:
			raise RuntimeError, _TR_("WSS_PMS", 'Invalid or missing "path" argument')
		path = path[0].content
	
		# regular expression used for matching a file (the first group is used for comparing file names)
		file_match = ctxt.xpathEval("/params/param[@name='file-match']/@value")
		if len(file_match) == 0:
			raise RuntimeError, _TR_("WSS_FMMS", 'Invalid or missing "file-match" parameter')
		try:
			file_match = re.compile(file_match[0].content)
		except Exception, details:
			raise _TR_("WSS_FMREE", "The file-match parameter is an invalid regular expression (%s)") % details
	
		# the group in 'file-match' used for comparing file names
		file_match_group = ctxt.xpathEval("/params/param[@name='file-match-group']/@value")
		if len(file_match_group) == 0:
			raise RuntimeError, _TR_("WSS_FGFM", 'Invalid or missing "file-match-group" parameter')
		try:
			file_match_group = int(file_match_group[0].content)
		except Exception, details:
			raise "The file-match-group parameter is not an integer"
		if file_match_group < 0:
			raise RuntimeError, "The file-match-group parameter must be positive"

		# the group in 'file-match' used as extra indexes
		file_xtra_group = ctxt.xpathEval("/params/param[@name='file-xtra-group']/@value")
		if len(file_xtra_group) == 0:
			raise RuntimeError, _TR_("WSS_FGFX", 'Invalid or missing "file-xtra-group" parameter')
		try:
			file_xtra_group = int(file_xtra_group[0].content)
		except Exception, details:
			raise "The file-match-group parameter is not an integer"
		if file_xtra_group < 0:
			raise RuntimeError, "The file-xtra-group parameter must be positive"

		# the group in 'file-match' used for determining if the file is final
		file_final_group = ctxt.xpathEval("/params/param[@name='file-final-group']/@value")
		if len(file_final_group) == 0:
			raise file_final_group, _TR_("WSS_FIGM", 'Invalid or missing "file-final-group" parameter')
		try:
			file_final_group = int(file_final_group[0].content)
		except Exception, details:
			raise "The file-final-group parameter is not an integer"
		if file_final_group < 0:
			raise RuntimeError, "The file-final-group parameter must be positive"

		# the strftime expression used for generating the "file-match-group" portion of a filename from a date
		file_match_from_date = ctxt.xpathEval("/params/param[@name='file-match-from-date']/@value")
		if len(file_match_from_date) == 0:
			raise RuntimeError, _TR_("WSS_FMDFM", 'Invalid or missing "file-match-from-date" parameter')
		file_match_from_date = file_match_from_date[0].content
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
	
		# the minimum date (default 1/1/1900)
		min_date = ctxt.xpathEval("/command/arg[@name='min-date']/@value")
		if len(min_date) == 0:
			min_date = "1900-01-01T00:00:00"
		else:
			min_date = min_date[0].content
		# the maximum date (default 1/1/3000)
		max_date = ctxt.xpathEval("/command/arg[@name='max-date']/@value")
		if len(max_date) == 0:
			max_date = "3000-01-01T00:00:00"
		else:
			max_date = max_date[0].content
		if max_date <= min_date:
			raise _TR_("WSS_IMID", "The min-date argument (%s) must be smaller than the max-date argument (%s)") % (min_date, max_date)
		try:
			min_date = strptime(min_date, iso_datetime)
		except:
			raise _TR_("WSS_IMID2", "Invalid min-date argument '%s'") % min_date
		try:
			max_date = strptime(max_date, iso_datetime)
		except:
			raise _TR_("WSS_IMAD", "Invalid max-date argument '%s'") % max_date
		try:
			min_date = strftime(file_match_from_date, min_date)
			max_date = strftime(file_match_from_date, max_date)
		except:
			raise RuntimeError, _TR_("WSS_IFMD", 'The file-match-from-date parameter is an invalid strftime format string')
	
		# the list of unwanted files
		unwanted = []
		l_unwanted = ctxt.xpathEval("/command/arg[@name='unwanted']/file/@date")
		for f in l_unwanted:
			try:
				# string => time
				ndate = strptime(f.content, iso_datetime)
				# time => sortable string
				ndate = strftime(file_match_from_date, ndate)
				if ndate >= min_date and ndate <= max_date:
					unwanted.append(ndate)
			except:
				pass
		####################################
		# build the list of matching files
		####################################
		wanted = []
	
		files = glob.glob(os.path.join(path, '*'));
		for f in files:
			if os.path.isfile(f) and (not os.path.islink(f)):
				m = file_match.search(f)
				# match the RE ?
				if m != None and len(m.groups()) >= file_match_group:
					cdate = m.groups()[file_match_group-1]
					# in the right range ?
					if cdate >= min_date and cdate <= max_date:
						# is it unwanted ?
						if not cdate in unwanted:
							try:
								# got a file
								# file name => struct tm
								cdate = strptime(cdate, file_match_from_date)
								if m.groups()[file_xtra_group-1] != None:
									# found "-12" => so add 12 s to the time
									# struct tm => time_t
									cdate = timegm(cdate)
									cdate += int(m.groups()[file_xtra_group-1])
									# time_t => struct tm
									cdate = gmtime(cdate)
								# struct tm => string
								cdate = strftime(iso_datetime, cdate)
								final = "0"
								if (len(m.groups()) >= file_final_group) and (m.groups()[file_final_group-1] != None):
									final = "1"
								wanted.append((f, cdate, final))
							except:
								pass
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		for p, d, f in wanted:
			elt = root.newChild(None, "output", None)
			elt.setProp("name", "file")
			elt.setProp("ref", p)
			elt.setProp("date", d)
			elt.setProp("final", f)
			# don't delete it
			elt.setProp("refdel", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetLogs" id="1">
	<arg name="min-date" value="20040510T000000"/>
	<arg name="max-date" value="20040511T000000"/>
	<arg name="unwanted">	
		<file date="20040308T040000"/>
		<file date="20040315T043000"/>
	</arg>
</command>
	"""
	params = \
	"""
<params>
	<!-- directory -->
	<param name="path" value="/logs/xmlchannel"/>
	<!-- regular expression used for matching a file (the first group is used for comparing file names)-->
	<param name="file-match" value="Log(\d{12})(-(\d+))?\.xml(\.gz)?"/>
	<!-- the group in 'file-match' used for comparing file names-->
	<param name="file-match-group" value="1"/>
	<!-- the group in 'file-match' used for the "extra" time -->
	<param name="file-xtra-group" value="3"/>
	<!-- the group in 'file-match' used for determining if the file is "final"-->
	<param name="file-final-group" value="4"/>
	<!-- the strftime expression used for generating the "file-match-group" portion of a filename from a date -->
	<param name="file-match-from-date" value="%Y%m%d%H%M"/>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
