#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

I_AV = 0
I_SPAM = 1

stdout = ""
stderr = ""

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		cmd = ''
		
		component =	ctxt.xpathEval("/command/arg[@name='component']/@value")
		if len(component) != 1:
				raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
		component = component[0].content
		doc = None
		if component == "av":
			type = I_AV
			doc = libxml2.newDoc("1.0")
			root = doc.newChild(None, "ExtraDat", None)
			if os.path.isfile("/opt/NETAwss/avengine/dat/extra.dat"):
				root.setProp("value", "1")
			else:
				root.setProp("value", "0")
		elif component == "spam":
			type = I_SPAM
			cmd = "/opt/NETAwss/mgmt/get_extra_rules"
			Trace("Launching '%s'" % cmd)
			res = libwsa.RunCmd(cmd, ScriptCallback)
			Trace("Done!")
			if res != 0:
				libwsa.PrintErrorBase(_TR_("WSGED_FAILED", 'Unable to get the list of extra rules'), stdout+"\n"+stderr)
				sys.exit(-1)
			try:
				doc = libxml2.parseDoc(stdout)
			except:
				raise RuntimeError, "Invalid xml string"
		else:
			raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
	
		# let's go
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "xdat")
		content = doc.getRootElement()
		content.unlinkNode()
		elt.addChild(content)
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd_n_a_1 = \
	"""
<command name="WSGetXtraDat" id="1">
	<arg name="component" value="av"/>
</command>
	"""
	cmd_n_a_2 = \
	"""
<command name="WSGetXtraDat" id="1">
	<arg name="component" value="spam"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	cmd = cmd_n_a_1
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()
	cmd = cmd_n_a_2
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
