#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, glob, zipfile, re, time
from tempfile import mkstemp
from calendar import timegm
from libwsa import _TR_

libwsa.do_trace = False
formatXML = False

def Run():
	global formatXML

	# format of the ISO dates
	iso_datetime = "%Y%m%dT%H%M%S"
	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the parameters
		####################################
		ctxt = params.xpathNewContext()
	
		# xml logs directory
		path = ctxt.xpathEval("/params/param[@name='path']/@value")
		if len(path) == 0:
			raise RuntimeError, _TR_("WSS_PMS", 'Invalid or missing "path" argument')
		path = path[0].content
	
		# regular expression used for matching a file (the first group is used for comparing file names)
		file_match = ctxt.xpathEval("/params/param[@name='file-match']/@value")
		if len(file_match) == 0:
			raise RuntimeError, _TR_("WSS_FMMS", 'Invalid or missing "file-match" parameter')
		try:
			file_match = re.compile(file_match[0].content)
		except Exception, details:
			raise _TR_("WSS_FMREE", "The file-match parameter is an invalid regular expression (%s)") % details
		
		# the group in 'file-match' used for comparing file names
		file_match_group = ctxt.xpathEval("/params/param[@name='file-match-group']/@value")
		if len(file_match_group) == 0:
			raise RuntimeError, _TR_("WSS_FGFM", 'Invalid or missing "file-match-group" parameter')
		try:
			file_match_group = int(file_match_group[0].content)
		except Exception, details:
			raise "The file-match-group parameter is not an integer"
		if file_match_group < 0:
			raise RuntimeError, "The file-match-group parameter must be positive"

		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
	
		# the list of unwanted files
		unwanted = []
		l_unwanted = ctxt.xpathEval("/command/arg[@name='unwanted']/file/@date")
		for f in l_unwanted:
			try:
				# string => time
				ndate = time.strptime(f.content, iso_datetime)
				# time => sortable string
				ndate = str(timegm(ndate))
				unwanted.append(ndate)
			except:
				pass

		####################################
		# build the list of matching files
		####################################
		wanted = []
	
		files = glob.glob(os.path.join(path, '*'));
		for f in files:
			if os.path.isfile(f) and (not os.path.islink(f)):
				m = file_match.search(f)
				# match the RE ?
				if m != None and len(m.groups()) >= file_match_group:
					cdate = m.groups()[file_match_group-1]
					# is it unwanted ?
					if not cdate in unwanted:
						try:
							# got a file
							cdate = time.gmtime(int(cdate))
							cdate = time.strftime(iso_datetime, cdate)
							wanted.append((f, cdate))
						except:
							pass
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		for p, d in wanted:
			elt = root.newChild(None, "output", None)
			elt.setProp("name", "file")
			elt.setProp("ref", p)
			elt.setProp("date", d)
			# don't delete it
			elt.setProp("refdel", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetPerfHistory" id="1">
	<arg name="unwanted">	
		<file date="2004-03-22T16:00:00"/>
		<file date="2004-03-22T16:03:00"/>
	</arg>
</command>
	"""
	cmd = \
	"""
<command name="WSGetPerfHistory" id="1"/>
	"""
	params = \
	"""
<params>
	<!-- directory -->
	<param name="path" value="/logs/realtime/historic"/>
	<!-- regular expression used for matching a file (the first group is used for comparing file names)-->
	<param name="file-match" value="(\d+)"/>
	<!-- the group in 'file-match' used for comparing file names-->
	<param name="file-match-group" value="1"/>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()


	
