#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_, Trace

libwsa.do_trace = False
formatXML = False

MGT = '/opt/NETAwss/mgmt'

# args
#    vars : xml string
#    params : xml string

def Run():
	try:
		####################################
		# parse the arguments
		####################################
		args, params = libwsa.Init()
	
		####################################
		# import the spam killer lib
		####################################
		sys.path.append(MGT)
		import spamkiller_eval_monitor as SKE
		
		sk_eval = SKE.Eval()
		status = "CE"
		if sk_eval.state == SKE.CanEvaluate:
			status = "CE"
		elif sk_eval.state == SKE.FullInstall:
			status = "FI"
		elif sk_eval.state == SKE.Evaluating:
			status = "EV"
		elif sk_eval.state == SKE.NotInstalled:
			status = "NI"
		numDays = 0
		try:
			numDays = int(sk_eval.getDaysRemaining())
		except:
			pass
		
		epo_ok = 1
		for f in [ '/opt/NETAepoagt/bin/naimas32', '/opt/NETAepoagt/lib/libnanettcp.so' ]:
			if not os.path.isfile(f):
				epo_ok = 0
				break

		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "spamkiller-status")
		elt.setProp("value", status)
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "ndays")
		elt.setProp("value", str(numDays))
		
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "epo-status")
		elt.setProp("value", str(epo_ok))		
		
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	
	except SystemExit:
		pass
	except Exception, details:
		libwsa.PrintError(details)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetSpamKillerStatus" id="1">
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
