#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from shutil import copyfile, rmtree
from libwsa import _TR_

# args
#    vars : xml string
#    params : xml string

from libwsa import Trace
libwsa.do_trace = False
formatXML = False

IDX_ID = 0
IDX_REF = 1
IDX_DEST = 2

def ScriptCallback(res):
	# write stdout and stderr on "our" stderr
	if res[0] != None:
		sys.stderr.write("stdout : " + res[0])
	if res[1] != None:
		sys.stderr.write("stderr : " + res[1])
	return True

def Run():
	try:
		####################################
		# parse the arguments
		####################################
		status = -1

		args, params = libwsa.Init()

		p_ctxt = params.xpathNewContext()
		a_ctxt = args.xpathNewContext()

		####################################
		# get the list of files
		####################################
		# files = [[id1, ref1, dest_path1], [id2, ref2, dest_path2], ...]
		files = [ [f.prop('value'), f.prop('ref'), None] for f in a_ctxt.xpathEval("/command/arg[@name='file']")]
		if len(files) == 0:
			raise RuntimeError, _TR_("WSS_FMS", 'No "file" argument(s)')
		####################################
		# loop through the files and copy them to their final destination
		####################################
		for f in files:
			if f[IDX_ID] is None or f[IDX_REF] is None:
				raise RuntimeError, _TR_("WSS_FIV", 'Invalid "file" argument(s)')
			dest = p_ctxt.xpathEval("/params/param[@name='file-list']/file[@name='%s']/@path" % f[IDX_ID])
			# get the destination path
			if len(dest) == 0:
				raise RuntimeError, _TR_("WSS_FUNK", 'Unknown "file" argument: %s') % f[IDX_ID]
			f[IDX_DEST] = dest[0].content
			# copy it to the final destination
			Trace("Copying '%s' into '%s'" % (f[IDX_REF], f[IDX_DEST]))
			copyfile(f[IDX_REF], f[IDX_DEST])
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSPutConfig" id="1">
	<arg name="file" value="test" ref="/tmp/test.xml"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="file-list">
		<file name="test" path="/tmp/test2.xml"/>
	</param>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
